/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.sline;

import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.sline.ConfiguradorIntegracaoOperadoraSLine;
import jalis.integracaooperadoras.sistemas.sline.model.SLineService;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class IntegracaoOperadoraSLine
extends AbstractIntegracaoOperadora {
    private static final String HINT_EXECUTANDO = "ENVIANDO RESULTADOS AO WEBSERVICE DA OPERADORA SIMUS";
    private String xmlConfiguracao;

    public IntegracaoOperadoraSLine(String xmlConfiguracao, int codigoConvenio) {
        this.xmlConfiguracao = xmlConfiguracao;
        this.codigoConvenio = codigoConvenio;
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        this.iniciarDadosErrosIntegracaoOperadora();
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoOperadora(this, HINT_EXECUTANDO);
        List<Object> retorno = new ArrayList();
        SLineService service = new SLineService();
        retorno = service.enviarResultado(String.valueOf(this.codigoConvenio), this.xmlConfiguracao);
        for (LogIntegracaoOperadora logIntegracaoOperadora : retorno) {
            if (logIntegracaoOperadora.getSituacao().equals("E")) continue;
            this.erros.errosEnvioResultado.add(new IntegracaoOperadoraException(new Exception(logIntegracaoOperadora.getRetorno()), logIntegracaoOperadora.getRetorno(), "ENVIO RESULTADO", logIntegracaoOperadora));
        }
        return this.erros;
    }

    private void iniciarDadosErrosIntegracaoOperadora() {
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraSLine configuradorSLine = ConfiguradorIntegracaoOperadoraSLine.novaInstancia(parent);
        configuradorSLine.setXML(xmlConfig);
        configuradorSLine.setVisible(true);
        if (configuradorSLine.getOK()) {
            return configuradorSLine.getXML();
        }
        return xmlConfig;
    }
}

