/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.sline;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.sline.TituloDocumento;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoOperadoraSLine
extends AbstractDialogoOKCancelar {
    private static final String MENSAGEM_CAMPOS_NAO_PREENCHIDOS = "Todos os campos s\u00e3o de preenchimento obrigat\u00f3rio!";
    private static final String TITULO = "Configurando integra\u00e7\u00e3o SLine";
    private static final String TAG_INTEGRACAO_SLINE = "integracaosline";
    public static final String TAG_INTEGRACAO_ENDERECO = "endereco";
    public static final String TAG_INTEGRACAO_CHAVE = "chave";
    public static final String TAG_INTEGRACAO_SENHA = "senha";
    public static final String TAG_INTEGRACAO_NUMERO_REGISTRO = "numeroRegistro";
    public static final String TAG_INTEGRACAO_TITULO_DOCUMENTO = "tituloDocumento";
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelLinkWebService = new JLabel("Link Web Service:");
    private JLabel labelChaveLaboratorio = new JLabel("Chave Laborat\u00f3rio:");
    private JLabel labelSenhaLaboratorio = new JLabel("Senha Laborat\u00f3rio:");
    private JLabel labelNumRegistroOperadora = new JLabel("N\u00ba Reg. Operadora:");
    private JLabel labelTituloDocumento = new JLabel("T\u00edtulo Documento");
    private JComboBox<TituloDocumento> comboTituloDocumento = new JComboBox<TituloDocumento>(TituloDocumento.values());
    private JLabel labelVEstacao = new JLabel();
    private TTextField txtEstacao = new TTextField(10, 1);
    private TTextField txtLinkWebService = new TTextField(310);
    private TTextField txtChaveLaboratorio = new TTextField(310);
    private TTextField txtSenhalaboratorio = new TTextField(310);
    private TTextField txtNumRegistroOperadora = new TTextField(50, 1);
    private JButton buttonEstacao = new JButton();
    private JPanel panelCentral = new JPanel();

    public static ConfiguradorIntegracaoOperadoraSLine novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraSLine((Dialog)pai);
        }
        return new ConfiguradorIntegracaoOperadoraSLine((Frame)pai);
    }

    public ConfiguradorIntegracaoOperadoraSLine(Dialog pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    public ConfiguradorIntegracaoOperadoraSLine(Frame pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    private void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(490, 200));
        this.setLayout(new BorderLayout());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.panelCentral.setLayout(new GridBagLayout());
        ScreenUtil.centralizar(this);
        this.dimensionarLabels();
        this.dimensionarTexts();
        this.dimensionarComboBox();
        this.dimensionarButtons();
        ScreenUtil.setBorda(new Component[]{this.labelVEstacao}, new TitledBorder(""));
        this.adicionarComponentes();
        this.adicionarListeners();
    }

    private void dimensionarLabels() {
        Dimension d = new Dimension(125, 20);
        this.labelChaveLaboratorio.setPreferredSize(d);
        this.labelChaveLaboratorio.setMaximumSize(d);
        this.labelChaveLaboratorio.setSize(d);
        this.labelChaveLaboratorio.setMinimumSize(d);
        this.labelEstacao.setPreferredSize(d);
        this.labelEstacao.setMaximumSize(d);
        this.labelEstacao.setSize(d);
        this.labelEstacao.setMinimumSize(d);
        this.labelLinkWebService.setPreferredSize(d);
        this.labelLinkWebService.setMaximumSize(d);
        this.labelLinkWebService.setSize(d);
        this.labelLinkWebService.setMinimumSize(d);
        this.labelNumRegistroOperadora.setPreferredSize(d);
        this.labelNumRegistroOperadora.setMaximumSize(d);
        this.labelNumRegistroOperadora.setSize(d);
        this.labelNumRegistroOperadora.setMinimumSize(d);
        this.labelSenhaLaboratorio.setPreferredSize(d);
        this.labelSenhaLaboratorio.setMaximumSize(d);
        this.labelSenhaLaboratorio.setSize(d);
        this.labelSenhaLaboratorio.setMinimumSize(d);
        this.labelTituloDocumento.setPreferredSize(d);
        this.labelTituloDocumento.setMaximumSize(d);
        this.labelTituloDocumento.setSize(d);
        this.labelTituloDocumento.setMinimumSize(d);
        Dimension dve = new Dimension(253, 20);
        this.labelVEstacao.setPreferredSize(dve);
        this.labelVEstacao.setMaximumSize(dve);
        this.labelVEstacao.setSize(dve);
        this.labelVEstacao.setMinimumSize(dve);
    }

    private void dimensionarTexts() {
        Dimension de = new Dimension(70, 20);
        this.txtEstacao.setPreferredSize(de);
        this.txtEstacao.setMinimumSize(de);
        this.txtEstacao.setSize(de);
        Dimension dt = new Dimension(345, 20);
        this.txtChaveLaboratorio.setSize(dt);
        this.txtChaveLaboratorio.setMinimumSize(dt);
        this.txtChaveLaboratorio.setPreferredSize(dt);
        this.txtLinkWebService.setSize(dt);
        this.txtLinkWebService.setMinimumSize(dt);
        this.txtLinkWebService.setPreferredSize(dt);
        this.txtNumRegistroOperadora.setSize(dt);
        this.txtNumRegistroOperadora.setMinimumSize(dt);
        this.txtNumRegistroOperadora.setPreferredSize(dt);
        this.txtSenhalaboratorio.setSize(dt);
        this.txtSenhalaboratorio.setMinimumSize(dt);
        this.txtSenhalaboratorio.setPreferredSize(dt);
    }

    private void dimensionarButtons() {
        Dimension db = new Dimension(20, 20);
        this.buttonEstacao.setPreferredSize(db);
        this.buttonEstacao.setMinimumSize(db);
        this.buttonEstacao.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstacao);
    }

    private void dimensionarComboBox() {
        Dimension dcb = new Dimension(345, 20);
        this.comboTituloDocumento.setPreferredSize(dcb);
        this.comboTituloDocumento.setMinimumSize(dcb);
        this.comboTituloDocumento.setMaximumSize(dcb);
        this.comboTituloDocumento.setSize(dcb);
    }

    private void adicionarComponentes() {
        Integer gridWidth = 7;
        Integer gridWidthI = 1;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = gridWidthI;
        c.gridheight = 1;
        c.insets = new Insets(0, 1, 1, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.panelCentral.add((Component)this.labelEstacao, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.txtEstacao, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.buttonEstacao, c);
        ++c.gridx;
        c.gridwidth = 5;
        this.panelCentral.add((Component)this.labelVEstacao, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelLinkWebService, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtLinkWebService, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelChaveLaboratorio, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtChaveLaboratorio, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelSenhaLaboratorio, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtSenhalaboratorio, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelNumRegistroOperadora, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtNumRegistroOperadora, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelTituloDocumento, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add(this.comboTituloDocumento, c);
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.getPanelBotoesDireita(), "South");
    }

    private void adicionarListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraSLine.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraSLine.this.pesquisarEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraSLine.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraSLine.this.buscarEstacao(ConfiguradorIntegracaoOperadoraSLine.this.txtEstacao.getText());
                }
            }
        };
        this.txtEstacao.addKeyListener(keyAdapter);
        this.txtEstacao.addFocusListener(focusAdapter);
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraSLine.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraSLine.this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraSLine.this.labelVEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraSLine.this.txtEstacao.clear();
                    ConfiguradorIntegracaoOperadoraSLine.this.labelVEstacao.setText("");
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                ScreenUtil.requisitarFoco(ConfiguradorIntegracaoOperadoraSLine.this.txtEstacao);
            }
        });
    }

    private void pesquisarEstacao() {
        this.txtEstacao.clear();
        this.labelVEstacao.setText("");
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.txtEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVEstacao.setText(estacaoVO.getDescricao());
        }
    }

    private void buscarEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.txtEstacao.clear();
            this.labelVEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Erro ao buscar esta\u00e7\u00e3o.", e.getStackTrace());
            this.txtEstacao.clear();
            this.labelVEstacao.setText("");
            ScreenUtil.requisitarFoco(this.txtEstacao);
        }
    }

    private boolean isSLine(String xml) {
        return StringUtil.getValor(xml, "protocolo").equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SLINE.getDescricao());
    }

    public void setXML(String xml) {
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora")) && this.isSLine(xml)) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.txtEstacao.setText(aux);
                this.buscarEstacao(aux);
            }
            this.txtSenhalaboratorio.setText(!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_SENHA)) ? aux : "");
            aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CHAVE);
            this.txtChaveLaboratorio.setText(!Funcoes.textoVazio(aux) ? aux : "");
            aux = StringUtil.getValor(xml, TAG_INTEGRACAO_ENDERECO);
            this.txtLinkWebService.setText(!Funcoes.textoVazio(aux) ? aux : "");
            aux = StringUtil.getValor(xml, TAG_INTEGRACAO_NUMERO_REGISTRO);
            this.txtNumRegistroOperadora.setText(!Funcoes.textoVazio(aux) ? aux : "");
            aux = StringUtil.getValor(xml, TAG_INTEGRACAO_TITULO_DOCUMENTO);
            if (!Funcoes.textoVazio(aux)) {
                this.comboTituloDocumento.setSelectedItem((Object)TituloDocumento.valueOfConteudoTag(aux));
            }
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("integracaooperadora");
            xml.abrir(TAG_INTEGRACAO_SLINE);
            xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SLINE.getDescricao());
            xml.escrever("estacao", this.txtEstacao.getText());
            xml.escrever(TAG_INTEGRACAO_ENDERECO, this.txtLinkWebService.getText().trim());
            xml.escrever(TAG_INTEGRACAO_CHAVE, this.txtChaveLaboratorio.getText().trim());
            xml.escrever(TAG_INTEGRACAO_SENHA, this.txtSenhalaboratorio.getText().trim());
            xml.escrever(TAG_INTEGRACAO_NUMERO_REGISTRO, this.txtNumRegistroOperadora.getText().trim());
            TituloDocumento tituloDocumento = (TituloDocumento)((Object)this.comboTituloDocumento.getSelectedItem());
            xml.escrever(TAG_INTEGRACAO_TITULO_DOCUMENTO, tituloDocumento.getConteudoTag());
            xml.fechar(TAG_INTEGRACAO_SLINE);
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "Erro ao criar o XML de configura\u00e7\u00e3o.", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    @Override
    protected boolean acaoOk() {
        boolean camposPreenchidos;
        boolean bl = camposPreenchidos = !Funcoes.textoVazio(this.txtEstacao) && !this.labelVEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado") && !Funcoes.textoVazio(this.txtChaveLaboratorio) && !Funcoes.textoVazio(this.txtLinkWebService) && !Funcoes.textoVazio(this.txtNumRegistroOperadora) && !Funcoes.textoVazio(this.txtSenhalaboratorio) && this.comboTituloDocumento.getSelectedIndex() > -1;
        if (!camposPreenchidos) {
            Funcoes.mensagem(this, MENSAGEM_CAMPOS_NAO_PREENCHIDOS, 2);
        }
        return camposPreenchidos;
    }
}

