/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.simus;

import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.simus.SimusDao;
import jalis.integracaooperadoras.sistemas.simus.models.ExameSimusVO;
import jalis.integracaooperadoras.sistemas.simus.models.OperacaoSimusVO;
import jalis.integracaooperadoras.sistemas.simus.models.PacienteSimusVO;
import jalis.integracaooperadoras.sistemas.simus.models.ResgatarSimusVO;
import jalis.integracaooperadoras.sistemas.simus.models.RetornoDocSimusVO;
import jalis.integracaooperadoras.sistemas.simus.models.RetornoSimusVO;
import jalis.integracaooperadoras.sistemas.simus.models.SimusVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SimusService {
    private static final String TAG_CODE = "code";
    private static final String TAG_MENSAGEM = "message";
    private static final String TAG_EXAMES = "exames";
    private static final String TAG_PACIENTES = "pacientes";
    private static final String TAG_EXAME_RESGATADO = "resgatado";
    private static final String TAG_ID = "id";
    private static final String TAG_EXAME_SIGTAP = "sigtap";
    private static final String TAG_EXAME_ID_PACIENTE = "id_paciente";
    private static final String TAG_ERROR = "error";
    private static final String TAG_PACIENTE_ID = "id";
    private static final String TAG_PACIENTE_NOME = "nome";
    private static final String TAG_PACIENTE_IBGE = "naturalidade_ibge";
    private static final String TAG_PACIENTE_NATURALDIADE = "naturalidade";
    private static final String TAG_PACIENTE_NOME_MAE = "mae";
    private static final String TAG_PACIENTE_NOME_PAI = "pai";
    private static final String TAG_PACIENTE_SEXO = "sexo";
    private static final String TAG_PACIENTE_CNS = "cns";
    private static final String TAG_PACIENTE_DATA_NASC = "data_nascimento";
    private static final String TAG_PACIENTE_RACA_COR = "raca_cor";
    private static final String TAG_PACIENTE_DOADOR_ORGAOS = "doador_orgaos";
    private static final String TAG_PACIENTE_DOADOR_SANGUE = "doador_sangue";
    private static final String TAG_PACIENTE_RG = "rg";
    private static final String TAG_PACIENTE_CPF = "cpf";
    private static final String TAG_PACIENTE_END_CEP = "endereco_cep";
    private static final String TAG_PACIENTE_END_CIDADE = "endereco_cidade";
    private static final String TAG_PACIENTE_END_BAIRRO = "endereco_bairro";
    private static final String TAG_PACIENTE_END_LOGRADOURO = "endereco_logradouro";
    private static final String TAG_PACIENTE_END_NUMERO = "endereco_numero";
    private static final String TAG_PACIENTE_END_COMPLEMENTO = "endereco_complemento";
    private static final String TAG_PACIENTE_REGIAO = "regiao";
    private static final String TAG_PACIENTE_TELEFONE = "telefones";
    private static final String TAG_URL = "url";
    private static final String TAG_DOOCUMENTOS = "docs";
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private final int tamanhoMaximoArquivo = 30;
    private SimusDao dao = new SimusDao();

    public ArrayList<LogIntegracaoOperadora> buscaLogs(String codigoFilial, String codigoConvenio) throws IntegracaoOperadoraException {
        ArrayList<LogIntegracaoOperadora> lista = new ArrayList();
        try {
            lista = this.dao.pesquisarLogsPorFilialEConvenio(codigoFilial, codigoConvenio);
        }
        catch (SQLException e) {
            throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel buscar os logs de integra\u00e7\u00e3o.\n" + e.getMessage(), "buscando logs de integra\u00e7\u00e3o", null);
        }
        return lista;
    }

    public List<LogIntegracaoOperadora> enviarResultado(String codigoConvenio, String xmlConfiguracao) throws IntegracaoOperadoraException {
        ArrayList<LogIntegracaoOperadora> listaLogs = this.buscaLogs(Variaveis.filialPadrao, String.valueOf(codigoConvenio));
        ArrayList<OperacaoSimusVO> listaOperacoes = new ArrayList<OperacaoSimusVO>();
        for (LogIntegracaoOperadora logIntegracaoOperadora : listaLogs) {
            if (logIntegracaoOperadora.getTipoOperacao() != AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO) continue;
            try {
                OperacaoSimusVO operacaoSimusVO = this.dao.buscarResultados(logIntegracaoOperadora);
                if (null != operacaoSimusVO && operacaoSimusVO.getCodigoRequisicao() > 0) {
                    listaOperacoes.add(operacaoSimusVO);
                    continue;
                }
                this.debug("Erro n\u00e3o configurado req:" + logIntegracaoOperadora.getCodigoRequisicao() + " exame " + logIntegracaoOperadora.getCodigoExame() + " mat " + logIntegracaoOperadora.getCodigoMaterial());
                logIntegracaoOperadora.setRetorno(String.format("Convenio n\u00e3o configurado ou log %d sem resultado para o exame", logIntegracaoOperadora.getCodigoLog()));
                logIntegracaoOperadora.setSituacao("N");
                this.dao.salvarErro(logIntegracaoOperadora, false);
            }
            catch (SQLException sqlEx) {
                StringBuilder mensagem = new StringBuilder("N\u00e3o foi poss\u00edvel atualizar o log.\n").append(sqlEx.getMessage());
                throw new IntegracaoOperadoraException(sqlEx, mensagem.toString(), "buscando logs de integra\u00e7\u00e3o", null);
            }
            catch (IntegracaoOperadoraException e) {
                logIntegracaoOperadora.setRetorno(e.getMensagemErro());
                logIntegracaoOperadora.setSituacao("N");
            }
        }
        this.debug("log e resultado: " + listaOperacoes.size());
        if (!listaOperacoes.isEmpty()) {
            SimusVO simusVO = new SimusVO();
            simusVO.setChaveIntegracao(StringUtil.getValor(xmlConfiguracao, "chave"));
            simusVO.setEnderecoWSResultado(StringUtil.getValor(xmlConfiguracao, "enderecoWBResultados"));
            File file = null;
            try {
                for (OperacaoSimusVO operacaoSimusVO : listaOperacoes) {
                    RetornoImpressaoResultados pdf = ImpressaoResultados.imprimirExames(null, null, String.valueOf(operacaoSimusVO.getCodigoFilial()), String.valueOf(operacaoSimusVO.getCodigoRequisicao()), true, true, null, new String[]{operacaoSimusVO.getCodigoExameJalis()}, new String[]{operacaoSimusVO.getCodigoMaterial()}, true, null, true, true, null, true, "", true, false);
                    this.debug("Gerou pdf - " + pdf.toString());
                    if (pdf.getResultadoPdfWeb().length / 1024 / 1024 >= 30) {
                        LogIntegracaoOperadora log = operacaoSimusVO.getLogIntegracao();
                        if (log == null) continue;
                        log.setSituacao("R");
                        log.setRetorno("Arquivo de resultado excede o tamanho m\u00e1ximo permitido pela operadora SIMUS.");
                        this.debug("Erro tamanho arquivo");
                        this.dao.salvarErro(log, false);
                        continue;
                    }
                    HashMap<String, String> mapParametros = new HashMap<String, String>();
                    mapParametros.put("key", simusVO.getChaveIntegracao());
                    mapParametros.put("exame", operacaoSimusVO.getCodigoExameSimus());
                    HashMap<String, File> mapFiles = new HashMap<String, File>();
                    file = File.createTempFile(String.valueOf(new Date().getTime()), ".pdf");
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(pdf.getResultadoPdfWeb());
                    fileOutputStream.close();
                    mapFiles.put("pdf", file);
                    this.debug("Envio: Req. " + operacaoSimusVO.getLogIntegracao().getCodigoRequisicao() + " exame " + operacaoSimusVO.getLogIntegracao().getCodigoExame() + " exame Simus " + operacaoSimusVO.getCodigoExameSimus());
                    HttpPost httopost = this.postForm(new URL(simusVO.getEnderecoWSResultado()).toString(), mapParametros, mapFiles, "");
                    CloseableHttpClient httpClient = HttpClients.createDefault();
                    CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httopost);
                    file.delete();
                    HttpEntity httpEntity = closeableHttpResponse.getEntity();
                    if (Funcoes.objectIsNull(httpEntity)) continue;
                    JSONObject jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8"));
                    this.debug("Resposta: HTTP cod " + closeableHttpResponse.getStatusLine().getStatusCode() + " - json: " + jsonObject.toString());
                    if (jsonObject.getInt(TAG_CODE) == 200) {
                        ArrayList<RetornoDocSimusVO> listaDocumentos = new ArrayList<RetornoDocSimusVO>();
                        JSONArray jsonArrayDocumentos = jsonObject.getJSONArray(TAG_DOOCUMENTOS);
                        for (int registro = 0; registro < jsonArrayDocumentos.length(); ++registro) {
                            RetornoDocSimusVO retornoDocSimusVO = new RetornoDocSimusVO();
                            retornoDocSimusVO.setId(jsonArrayDocumentos.getJSONObject(registro).getString("id"));
                            retornoDocSimusVO.setUrl(jsonArrayDocumentos.getJSONObject(registro).getString(TAG_URL));
                            retornoDocSimusVO.setError(jsonArrayDocumentos.getJSONObject(registro).getString(TAG_ERROR));
                            listaDocumentos.add(retornoDocSimusVO);
                        }
                        RetornoSimusVO retornoSimusVO = new RetornoSimusVO();
                        retornoSimusVO.setCode(jsonObject.getInt(TAG_CODE));
                        retornoSimusVO.setMessage(jsonObject.getString(TAG_MENSAGEM));
                        retornoSimusVO.setDocs(listaDocumentos);
                        retornoSimusVO.setOperacaoSimusVO(operacaoSimusVO);
                        retornoSimusVO.setLogIntegracao(operacaoSimusVO.getLogIntegracao());
                        this.dao.atualizarLogs(retornoSimusVO);
                        continue;
                    }
                    LogIntegracaoOperadora log = operacaoSimusVO.getLogIntegracao();
                    StringBuilder mensagemRetorno = new StringBuilder("( ").append(jsonObject.getInt(TAG_CODE)).append(" ) - ").append(jsonObject.getString(TAG_MENSAGEM));
                    if (!Funcoes.objectIsNull(log)) {
                        log.setSituacao("R");
                        if (jsonObject.getInt(TAG_CODE) == 400) {
                            mensagemRetorno.setLength(0);
                            if (simusVO.getChaveIntegracao().isEmpty()) {
                                mensagemRetorno.append("Chave de acesso da operadora n\u00e3o foi informado.\n");
                            }
                            if (operacaoSimusVO.getCodigoExameSimus().isEmpty()) {
                                mensagemRetorno.append("C\u00f3digo simus do exame n\u00e3o foi informado.\n");
                            }
                            mensagemRetorno.append(jsonObject.getString(TAG_MENSAGEM));
                        }
                        log.setRetorno(mensagemRetorno.toString());
                    }
                    this.dao.salvarErro(log, true);
                }
                ArrayList<LogIntegracaoOperadora> e = listaLogs;
                return e;
            }
            catch (JSONException e) {
                StringBuilder mensagem = new StringBuilder("N\u00e3o foi poss\u00edvel montar JSON de retorno.\n").append(e.getMessage());
                throw new IntegracaoOperadoraException((Exception)((Object)e), mensagem.toString(), "buscando logs de integra\u00e7\u00e3o", null);
            }
            catch (MalformedURLException e) {
                StringBuilder mensagem = new StringBuilder("URL de envio de Consulta inv\u00e1lida. Favor verificar.\n").append(e.getMessage());
                throw new IntegracaoOperadoraException(e, mensagem.toString(), "buscando logs de integra\u00e7\u00e3o", null);
            }
            catch (IOException e) {
                StringBuilder mensagem = new StringBuilder("N\u00e3o foi poss\u00edvel enviar resultados.\n").append(e.getMessage());
                throw new IntegracaoOperadoraException(e, mensagem.toString(), "buscando logs de integra\u00e7\u00e3o", null);
            }
            catch (SQLException e) {
                StringBuilder mensagem = new StringBuilder("N\u00e3o foi poss\u00edvel salvar o retorno.\n").append(e.getMessage());
                throw new IntegracaoOperadoraException(e, mensagem.toString(), "buscando logs de integra\u00e7\u00e3o", null);
            }
            catch (ParseException e) {
                StringBuilder mensagem = new StringBuilder("N\u00e3o foi poss\u00edvel processar o retorno.\n").append(e.getMessage());
                throw new IntegracaoOperadoraException((Exception)((Object)e), mensagem.toString(), "buscando logs de integra\u00e7\u00e3o", null);
            }
            finally {
                if (file != null && !Funcoes.objectIsNull(file) && file.exists()) {
                    file.delete();
                }
            }
        }
        return null;
    }

    private HttpPost postForm(String url, Map<String, String> params, Map<String, File> files, String charset) {
        if (charset.isEmpty()) {
            charset = "UTF-8";
        }
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (!params.isEmpty()) {
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                builder.addTextBody(key, params.get(key), ContentType.create((String)"text/plain", (Charset)Charset.forName(charset)));
            }
        }
        if (!files.isEmpty()) {
            for (String filename : files.keySet()) {
                builder.setMode(HttpMultipartMode.STRICT);
                builder.addBinaryBody(filename, files.get(filename), ContentType.DEFAULT_BINARY, files.get(filename).getName());
            }
        }
        httpPost.setEntity(builder.build());
        return httpPost;
    }

    public void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        if (!this.dao.getConvenioUtilizaIntegracaoOperadora(filial, convenio)) {
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("nomeintegracaooperadora", protocolo.getDescricao());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        this.dao.insereIntegracaoOperadora(protocolo, filial, convenio, codigoRequsicao, codigoPaciente, codigoExame, codigoMaterial, tipoOperacao, xml);
    }

    public ResgatarSimusVO resgatarExames(String codigoFilial, String codigoConvenio, String codigoExames, Component pai) {
        ResgatarSimusVO resgatarVO = null;
        SimusVO simusVO = this.dao.getConfiguracaoOperadora(codigoFilial, codigoConvenio);
        if (!Funcoes.objectIsNull(simusVO)) {
            try {
                URL url = new URL(simusVO.getEnderecoWSResgate() + "?key=" + simusVO.getChaveIntegracao() + "&exame=" + codigoExames);
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("charset", "utf-8");
                conn.setDoOutput(true);
                conn.setSSLSocketFactory(this.getSSLSocket().getSocketFactory());
                conn.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                conn.connect();
                if (conn.getResponseCode() == 200 || conn.getResponseCode() == 400) {
                    int registro;
                    InputStreamReader in = null;
                    in = conn.getResponseCode() == 200 ? new InputStreamReader(conn.getInputStream()) : new InputStreamReader(conn.getErrorStream());
                    BufferedReader br = new BufferedReader(in);
                    String identificador = br.readLine();
                    JSONObject jsonObject = new JSONObject(identificador);
                    JSONArray jsonArrayExames = new JSONArray();
                    JSONArray jsonArrayPacientes = new JSONArray();
                    ArrayList<ExameSimusVO> listaExames = new ArrayList<ExameSimusVO>();
                    ArrayList<PacienteSimusVO> listaPacientes = new ArrayList<PacienteSimusVO>();
                    if (jsonObject.names().toString().contains(new StringBuilder("\"").append(TAG_EXAMES).append("\""))) {
                        jsonArrayExames = jsonObject.getJSONArray(TAG_EXAMES);
                    }
                    if (jsonObject.names().toString().contains(new StringBuilder("\"").append(TAG_PACIENTES).append("\""))) {
                        jsonArrayPacientes = jsonObject.getJSONArray(TAG_PACIENTES);
                    }
                    for (registro = 0; registro < jsonArrayExames.length(); ++registro) {
                        ExameSimusVO exameVO = new ExameSimusVO();
                        exameVO.setResgatado(jsonArrayExames.getJSONObject(registro).getBoolean(TAG_EXAME_RESGATADO));
                        exameVO.setId(this.processaRetorno(jsonArrayExames.getJSONObject(registro).get("id")));
                        exameVO.setSigtap(this.processaRetorno(jsonArrayExames.getJSONObject(registro).get(TAG_EXAME_SIGTAP)));
                        int idPaciente = 0;
                        if (!Funcoes.objectIsNull(this.processaRetorno(jsonArrayExames.getJSONObject(registro).getInt(TAG_EXAME_ID_PACIENTE)))) {
                            idPaciente = Integer.parseInt(this.processaRetorno(jsonArrayExames.getJSONObject(registro).getInt(TAG_EXAME_ID_PACIENTE)));
                        }
                        exameVO.setIdPaciente(idPaciente);
                        exameVO.setErro(this.processaRetorno(jsonArrayExames.getJSONObject(registro).getString(TAG_ERROR)));
                        listaExames.add(exameVO);
                    }
                    for (registro = 0; registro < jsonArrayPacientes.length(); ++registro) {
                        JSONArray jsonArrayTelefones = jsonArrayPacientes.getJSONObject(registro).getJSONArray(TAG_PACIENTE_TELEFONE);
                        StringBuilder sbTelefones = new StringBuilder("");
                        for (int regTelefone = 0; regTelefone < jsonArrayTelefones.length(); ++regTelefone) {
                            if (!sbTelefones.toString().isEmpty()) {
                                sbTelefones.append(", ");
                            }
                            sbTelefones.append(jsonArrayTelefones.getString(regTelefone));
                        }
                        PacienteSimusVO pacienteVO = new PacienteSimusVO();
                        pacienteVO.setId(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get("id")));
                        pacienteVO.setNome(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_NOME)));
                        pacienteVO.setNaturalidadeIbge(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_IBGE)));
                        pacienteVO.setNaturalidade(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_NATURALDIADE)));
                        pacienteVO.setNomeMae(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_NOME_MAE)));
                        pacienteVO.setNomePai(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_NOME_PAI)));
                        pacienteVO.setSexo(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_SEXO)));
                        pacienteVO.setCns(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_CNS)));
                        pacienteVO.setDataNascimento(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_DATA_NASC)));
                        pacienteVO.setRacaCor(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_RACA_COR)));
                        pacienteVO.setDoadorOrgaos(jsonArrayPacientes.getJSONObject(registro).getBoolean(TAG_PACIENTE_DOADOR_ORGAOS));
                        pacienteVO.setDoadorSangue(jsonArrayPacientes.getJSONObject(registro).getBoolean(TAG_PACIENTE_DOADOR_SANGUE));
                        pacienteVO.setRg(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_RG)));
                        pacienteVO.setCpf(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_CPF)));
                        pacienteVO.setEnderecoCep(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_END_CEP)));
                        pacienteVO.setEnderecoCidade(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_END_CIDADE)));
                        pacienteVO.setEnderecoBairro(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_END_BAIRRO)));
                        pacienteVO.setEnderecoLogradouro(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_END_LOGRADOURO)));
                        pacienteVO.setEnderecoNumero(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_END_NUMERO)));
                        pacienteVO.setEnderecoComplemento(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_END_COMPLEMENTO)));
                        pacienteVO.setRegiao(this.processaRetorno(jsonArrayPacientes.getJSONObject(registro).get(TAG_PACIENTE_REGIAO)));
                        pacienteVO.setTelefones(sbTelefones.toString());
                        listaPacientes.add(pacienteVO);
                    }
                    resgatarVO = new ResgatarSimusVO();
                    resgatarVO.setCodigo(jsonObject.getInt(TAG_CODE));
                    resgatarVO.setMessage(jsonObject.getString(TAG_MENSAGEM));
                    resgatarVO.setListaExame(listaExames);
                    resgatarVO.setListaPaciente(listaPacientes);
                } else {
                    StringBuilder mensagemErro = new StringBuilder("( ");
                    mensagemErro.append(conn.getResponseCode()).append(" ) - ").append(conn.getResponseMessage());
                    Funcoes.mensagem(pai, mensagemErro.toString(), 2);
                }
            }
            catch (JSONException e) {
                StringBuilder mensagem = new StringBuilder("N\u00e3o foi poss\u00edvel montar JSON de resposta.\n").append(e.getMessage());
                Funcoes.mensagem(pai, mensagem.toString(), 2);
            }
            catch (MalformedURLException e) {
                StringBuilder mensagem = new StringBuilder("URL de envio de Consulta inv\u00e1lida. Favor verificar.\n").append(e.getMessage());
                Funcoes.mensagem(pai, mensagem.toString(), 2);
            }
            catch (IOException e) {
                StringBuilder mensagem = new StringBuilder("N\u00e3o foi poss\u00edvel comunica\u00e7\u00e3o com o sistema SIMUS.\n").append(e.getMessage());
                Funcoes.mensagem(pai, mensagem.toString(), 2);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                Funcoes.mensagem(pai, e.getMessage(), 2);
            }
        }
        return resgatarVO;
    }

    private SSLContext getSSLSocket() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = null;
        sslContext = SSLContext.getInstance("TLS");
        TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        sslContext.init(null, trustAllCertificates, new SecureRandom());
        return sslContext;
    }

    public String processaRetorno(Object objeto) {
        String retorno = null;
        if (!Funcoes.objectIsNull(objeto) && !objeto.toString().equals("null")) {
            return objeto.toString();
        }
        return retorno;
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }
}

