/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.simus;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.simus.models.OperacaoSimusVO;
import jalis.integracaooperadoras.sistemas.simus.models.RetornoDocSimusVO;
import jalis.integracaooperadoras.sistemas.simus.models.RetornoSimusVO;
import jalis.integracaooperadoras.sistemas.simus.models.SimusVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class SimusDao {
    public static final String PROCESSO_MONTA_LINHA = "montando linha de resultado";

    public ArrayList<LogIntegracaoOperadora> pesquisarLogsPorFilialEConvenio(String codigoFilial, String codigoConvenio) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,req_codigo as codigoRequisicao");
        buf.append("       ,exa_codigo as codigoExame");
        buf.append("       ,mco_codigo as codigoMaterial");
        buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
        buf.append("  from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("  and (eio_situacao is null or eio_situacao = '' )");
        buf.append("  and con_codigo = ").append(codigoConvenio);
        buf.append("  order by eio_codigo ");
        buf.append("  limit 100 ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
        if (!Funcoes.objectIsNull(rs) && rs.next()) {
            do {
                String operacao = rs.getString("operacao");
                LogIntegracaoOperadora log = new LogIntegracaoOperadora();
                log.setCodigoFilial(rs.getInt("codigoFilial"));
                log.setCodigoConvenio(rs.getInt("codigoConvenio"));
                log.setCodigoLog(rs.getInt("codigoLog"));
                log.setCodigoConvenio(rs.getInt("codigoConvenio"));
                log.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(rs.getString("tipoOperacao")));
                log.setRetorno(rs.getString("retorno"));
                log.setSituacao(rs.getString("situacao"));
                log.setCodigoRequisicao(rs.getInt("codigoRequisicao"));
                log.setCodigoExame(rs.getString("codigoExame"));
                log.setCodigoMaterial(rs.getInt("codigoMaterial"));
                log.setXmlLog(operacao);
                listaLogs.add(log);
            } while (rs.next());
        }
        Conexao.fecharStatement(st);
        return listaLogs;
    }

    public OperacaoSimusVO buscarResultados(LogIntegracaoOperadora logIntegracaoOperadora) throws IntegracaoOperadoraException {
        OperacaoSimusVO operacaoSimusVO = new OperacaoSimusVO();
        StringBuilder bui = new StringBuilder();
        bui.append("select");
        bui.append(" exr.exa_codigo as codigoexame,");
        bui.append(" exr.mco_codigo as material,");
        bui.append(" exr.exr_codautorizacao as codigoexamesimus");
        bui.append(" from examerequisicao exr ");
        bui.append(" left join requisicao req on exr.fil_codigo = req.fil_codigo  and exr.req_codigo = req.req_codigo ");
        bui.append(" left join convenios con on exr.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        bui.append(" where exr.fil_codigo = ").append(logIntegracaoOperadora.getCodigoFilial());
        bui.append(" and exr.req_codigo = ").append(logIntegracaoOperadora.getCodigoRequisicao());
        bui.append(" and exr.exa_codigo = '").append(logIntegracaoOperadora.getCodigoExame()).append("'");
        bui.append(" and exr.mco_codigo = ").append(logIntegracaoOperadora.getCodigoMaterial());
        bui.append(" and exr.exr_situacao in ( '").append("C").append("', '").append("I").append("', '").append("E").append("' )");
        bui.append(" and (req.req_excluida = false and exr.exr_excluido = false) ");
        bui.append(" and con.con_integracaooperadora ilike('%<protocolo>SIMUS</protocolo>%') ");
        Statement stResultado = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(stResultado, bui);
            if (rs.next()) {
                operacaoSimusVO.setCodigoFilial(logIntegracaoOperadora.getCodigoFilial());
                operacaoSimusVO.setCodigoRequisicao(logIntegracaoOperadora.getCodigoRequisicao());
                operacaoSimusVO.setCodigoExameJalis(logIntegracaoOperadora.getCodigoExame());
                operacaoSimusVO.setCodigoMaterial(rs.getString("material"));
                operacaoSimusVO.setCodigoExameSimus(rs.getString("codigoexamesimus"));
                operacaoSimusVO.setLogIntegracao(logIntegracaoOperadora);
            }
        }
        catch (SQLException e) {
            try {
                throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel buscar resultado", PROCESSO_MONTA_LINHA, logIntegracaoOperadora);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(stResultado);
                throw throwable;
            }
        }
        Conexao.fecharStatement(stResultado);
        return operacaoSimusVO;
    }

    public void atualizarLogs(RetornoSimusVO retornoSimus) throws IntegracaoOperadoraException, SQLException {
        LogIntegracaoOperadora log = retornoSimus.getLogIntegracao();
        if (!Funcoes.objectIsNull(log)) {
            StringBuilder mensagemRetorno = new StringBuilder(retornoSimus.getMessage());
            if (!retornoSimus.getDocs().isEmpty()) {
                for (RetornoDocSimusVO retornoDocSimusVO : retornoSimus.getDocs()) {
                    mensagemRetorno.append("\nid: ").append(retornoDocSimusVO.getId()).append("\nurl: ").append(retornoDocSimusVO.getUrl());
                }
            }
            log.setCodigoExame(retornoSimus.getOperacaoSimusVO().getCodigoExameJalis());
            log.setCodigoMaterial(Integer.valueOf(retornoSimus.getOperacaoSimusVO().getCodigoMaterial()));
            log.setRetorno(mensagemRetorno.toString());
            log.setSituacao(retornoSimus.getSituacao());
            this.salvarErro(log, true);
        }
    }

    public LogIntegracaoOperadora buscarLog(OperacaoSimusVO operacaoSimusVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,exa_codigo as codigoExame ");
        buf.append("       ,mco_codigo as codigoMaterial ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
        buf.append("   from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("    and fil_codigo = ").append(operacaoSimusVO.getCodigoFilial());
        buf.append("    and con_codigo = ").append(operacaoSimusVO.getCodigoConvenio());
        buf.append("   and eio_operacao ilike '%").append(operacaoSimusVO.getCodigoRequisicao()).append("%'");
        buf.append("   and eio_operacao ilike '%").append(operacaoSimusVO.getCodigoExameJalis()).append("%'");
        buf.append("   and eio_operacao ilike '%").append(operacaoSimusVO.getCodigoMaterial()).append("%'");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        LogIntegracaoOperadora log = null;
        while (rs.next()) {
            String codigoRequisicao = StringUtil.getValor(rs.getString("operacao"), "codreq");
            String codigoExame = StringUtil.getValor(rs.getString("operacao"), "codexa");
            String codigoMaterial = StringUtil.getValor(rs.getString("operacao"), "codmat");
            if (!String.valueOf(operacaoSimusVO.getCodigoRequisicao()).equals(codigoRequisicao)) continue;
            log = new LogIntegracaoOperadora();
            log.setCodigoFilial(rs.getInt("codigoFilial"));
            log.setCodigoConvenio(rs.getInt("codigoConvenio"));
            log.setCodigoLog(rs.getInt("codigoLog"));
            log.setCodigoRequisicao(Integer.valueOf(codigoRequisicao));
            if (!Funcoes.objectIsNull(operacaoSimusVO) && codigoExame.equals(operacaoSimusVO.getCodigoExameJalis()) && codigoMaterial.equals(operacaoSimusVO.getCodigoMaterial())) {
                log.setCodigoExame(codigoExame);
                log.setCodigoMaterial(Integer.valueOf(codigoMaterial));
            }
            log.setXmlLog(rs.getString("operacao"));
            log.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(rs.getString("tipoOperacao")));
        }
        return log;
    }

    public void salvarErro(LogIntegracaoOperadora logs, boolean exportado) throws IntegracaoOperadoraException, SQLException {
        StringBuilder sql = new StringBuilder();
        String filial = logs.getCodigoFilial().toString();
        sql.append("update exportaintegracaooperadora set eio_situacao = '").append(logs.getSituacao()).append("'");
        sql.append(", eio_retorno = '").append(logs.getRetorno()).append("'");
        sql.append(", eio_exportado = ").append(exportado);
        sql.append(", req_codigo = '").append(logs.getCodigoRequisicao()).append("'");
        if (!Funcoes.textoVazio(logs.getCodigoExame())) {
            sql.append(", exa_codigo = '").append(logs.getCodigoExame()).append("'");
        }
        if (!Funcoes.objectIsNull(logs.getCodigoMaterial())) {
            sql.append(", mco_codigo = '").append(logs.getCodigoMaterial()).append("'");
        }
        sql.append(" where eio_codigo in (");
        sql.append(logs.getCodigoLog());
        sql.append(") ");
        sql.append("and fil_codigo = ").append(filial);
        Statement st = Conexao.getStatement();
        Conexao.execute(filial, st, sql.toString());
        Conexao.arquivaSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimusVO getConfiguracaoOperadora(String codigoFilial, String codigoConvenio) {
        Statement st;
        SimusVO simusVO;
        block4: {
            simusVO = null;
            StringBuilder buf = new StringBuilder();
            buf.append(" select con_integracaooperadora as configuracao ");
            buf.append("   from convenios ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and con_codigo = ").append(codigoConvenio);
            st = Conexao.getStatement();
            try {
                String xml;
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next() || Funcoes.textoVazio(xml = rs.getString("configuracao")) || Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) break block4;
                simusVO = new SimusVO();
                simusVO.setCodigoEstacao(StringUtil.getInt(xml, "estacao"));
                simusVO.setChaveIntegracao(StringUtil.getValor(xml, "chave"));
                simusVO.setEnderecoWSResgate(StringUtil.getValor(xml, "enderecoWBResgate"));
                simusVO.setEnderecoWSResultado(StringUtil.getValor(xml, "enderecoWBResultados"));
            }
            catch (SQLException e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se o conv\u00eanio " + codigoConvenio + " utiliza integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return simusVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getConvenioUtilizaIntegracaoOperadora(String codigoFilial, String codigoConvenio) {
        boolean bl;
        Statement st;
        block5: {
            StringBuilder buf = new StringBuilder();
            buf.append(" select NULLIF(TRIM(con_integracaooperadora), '') IS NOT NULL as configurado ");
            buf.append("   from convenios ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and con_codigo = ").append(codigoConvenio);
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (!rs.next()) break block5;
            boolean bl2 = rs.getBoolean("configurado");
            Conexao.fecharStatement(st);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se o conv\u00eanio " + codigoConvenio + " utiliza integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, XMLStringBuilder xml) {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append("(fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(filial);
        buf.append(" ,").append(convenio);
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(filial)).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(codigoRequsicao);
        buf.append(" , ").append(codigoPaciente);
        buf.append(" , '").append(codigoExame).append("'");
        buf.append(" , ").append(codigoMaterial).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(filial, st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }
}

