/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.simus;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ResgatarExamesSimus
extends AbstractDialogoOKCancelar {
    private static final String TITULO = "Resgatar exames SIMUS";
    private JLabel labelCodigoExame = new JLabel("C\u00f3digo exame:");
    private TTextField txtCodigoExame = new TTextField(13, 1);
    private JButton buttonAdicionar = new JButton("OK");
    private JTable tableCodigoExame = new JTable();
    private ModeloGridTable modeloCodigoExame = new ModeloGridTable(new String[]{"Exames a resgatar"}, new int[]{0}, this.tableCodigoExame);
    private JScrollPane scrollCodigoExame = new JScrollPane(this.tableCodigoExame);
    private final int COLUNA_CODIGO = 0;
    private Integer linhaRegistro = null;

    public static ResgatarExamesSimus novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ResgatarExamesSimus((Dialog)pai, TITULO);
        }
        return new ResgatarExamesSimus((Frame)pai, TITULO);
    }

    public ResgatarExamesSimus(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ResgatarExamesSimus(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(280, 250));
        ScreenUtil.centralizar(this);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.getBotaoOK().setText("Resgatar");
        this.getBotaoOK().setMnemonic('R');
        this.labelCodigoExame.setMinimumSize(this.labelCodigoExame.getPreferredSize());
        this.labelCodigoExame.setMaximumSize(this.labelCodigoExame.getPreferredSize());
        this.buttonAdicionar.setPreferredSize(new Dimension(40, 20));
        this.buttonAdicionar.setMinimumSize(this.buttonAdicionar.getPreferredSize());
        this.buttonAdicionar.setMaximumSize(this.buttonAdicionar.getPreferredSize());
        this.buttonAdicionar.setMargin(new Insets(1, 1, 1, 1));
        this.txtCodigoExame.setPreferredSize(new Dimension(1, 20));
        this.tableCodigoExame.getTableHeader().setReorderingAllowed(false);
        this.tableCodigoExame.setSelectionMode(0);
        this.tableCodigoExame.setModel(this.modeloCodigoExame);
        this.montaListeners();
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelCodigoExame, c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtCodigoExame, c);
        c.fill = 0;
        ++c.gridx;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.buttonAdicionar, c);
        c.fill = 1;
        c.gridwidth = 3;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getPanelCentral().add((Component)this.scrollCodigoExame, c);
    }

    private void montaListeners() {
        this.tableCodigoExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linha;
                int resp;
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja excluir o registro selecionado?", 4)) == 0) {
                    ResgatarExamesSimus.this.modeloCodigoExame.removeLine(row);
                }
                if (e.getKeyCode() == 32 && (linha = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    String codigoExame = (String)ResgatarExamesSimus.this.modeloCodigoExame.getValueAt(linha, 0);
                    ResgatarExamesSimus.this.txtCodigoExame.setText(codigoExame);
                    ScreenUtil.requisitarFoco(ResgatarExamesSimus.this.txtCodigoExame);
                    ResgatarExamesSimus.this.linhaRegistro = linha;
                }
            }
        });
        this.tableCodigoExame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int linha = ResgatarExamesSimus.this.tableCodigoExame.getSelectedRow();
                if (e.getClickCount() == 2 && linha >= 0) {
                    String codigoExame = (String)ResgatarExamesSimus.this.modeloCodigoExame.getValueAt(linha, 0);
                    ResgatarExamesSimus.this.txtCodigoExame.setText(codigoExame);
                    ScreenUtil.requisitarFoco(ResgatarExamesSimus.this.txtCodigoExame);
                    ResgatarExamesSimus.this.linhaRegistro = linha;
                }
            }
        });
        this.buttonAdicionar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResgatarExamesSimus.this.manipulaRegistro();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                ScreenUtil.requisitarFoco(ResgatarExamesSimus.this.txtCodigoExame);
            }
        });
    }

    public void manipulaRegistro() {
        String codigoExame = this.txtCodigoExame.getText().trim();
        if (!Funcoes.textoVazio(codigoExame)) {
            if (Funcoes.objectIsNull(this.linhaRegistro)) {
                if (this.modeloCodigoExame.localizar(0, codigoExame) < 0) {
                    this.modeloCodigoExame.addLine(new Object[]{codigoExame});
                }
            } else {
                if (this.modeloCodigoExame.localizar(0, codigoExame) >= 0 && this.modeloCodigoExame.localizar(0, codigoExame) != this.linhaRegistro.intValue()) {
                    Funcoes.mensagem(this, "C\u00f3digo informado j\u00e1 esta presente na lista de exames a resgatar.", 2);
                    ScreenUtil.requisitarFoco(this.txtCodigoExame);
                    return;
                }
                this.modeloCodigoExame.setValueAt(codigoExame, this.linhaRegistro, 0);
                this.linhaRegistro = null;
            }
        }
        this.txtCodigoExame.clear();
        ScreenUtil.requisitarFoco(this.txtCodigoExame);
    }

    public String getExames() {
        StringBuilder retornoExames = new StringBuilder();
        for (int linha = 0; linha < this.modeloCodigoExame.getRowCount(); ++linha) {
            if (!retornoExames.toString().isEmpty()) {
                retornoExames.append(",");
            }
            retornoExames.append(this.modeloCodigoExame.getValueAt(linha, 0));
        }
        return retornoExames.toString();
    }
}

