/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.simus;

import jalis.comum.ConexaoTemporaria;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.simus.ConfiguradorIntegracaoOperadoraSimus;
import jalis.integracaooperadoras.sistemas.simus.SimusService;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import java.awt.Window;
import java.sql.SQLException;
import java.util.List;

public class IntegracaoOperadoraSimus
extends AbstractIntegracaoOperadora {
    private static final String HINT_EXECUTANDO = "ENVIANDO RESULTADOS AO WEBSERVICE DA OPERADORA SIMUS";
    private String xmlConfiguracao;

    public IntegracaoOperadoraSimus(String xmlConfiguracao, int codigoConvenio) {
        this.xmlConfiguracao = xmlConfiguracao;
        this.codigoConvenio = codigoConvenio;
    }

    private IntegracaoOperadoraException montaExcecao(Exception excecao, LogIntegracaoOperadora log, String mensagemErro, String nomeProcesso) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (excecao instanceof IntegracaoOperadoraException) {
            buf.append(" - ").append(((IntegracaoOperadoraException)excecao).getMensagemErro());
        } else {
            if (excecao != null) {
                buf.append(" - ").append(excecao.toString());
            }
            if (excecao instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        if (mensagemErro != null) {
            buf.append(" - ").append(mensagemErro);
        }
        if (log != null) {
            buf.append("\nDADOS DO LOG: filial = ").append(log.getCodigoFilial()).append(", requisi\u00e7\u00e3o = ").append(log.getCodigoRequisicao());
            buf.append(", exame = ").append(log.getCodigoExame()).append(", material = ").append(log.getCodigoMaterial()).append(".");
        }
        IntegracaoOperadoraException novaExcecao = new IntegracaoOperadoraException(excecao, buf.toString(), nomeProcesso, log);
        if (excecao != null) {
            novaExcecao.setStackTrace(excecao.getStackTrace());
        }
        return novaExcecao;
    }

    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloCodigo, String codigoFilial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String[] comando) {
        new SimusService().insereIntegracaoOperadora(protocoloCodigo, codigoFilial, convenio, codigoRequsicao, codigoPaciente, codigoExame, codigoMaterial, tipoOperacao, comando);
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoOperadora(this, HINT_EXECUTANDO);
        try {
            List<LogIntegracaoOperadora> retorno = new SimusService().enviarResultado(String.valueOf(this.codigoConvenio), this.xmlConfiguracao);
            for (LogIntegracaoOperadora logIntegracaoOperadora : retorno) {
                if (logIntegracaoOperadora.getSituacao().equals("E")) continue;
                this.erros.errosEnvioResultado.add(new IntegracaoOperadoraException(new Exception(logIntegracaoOperadora.getRetorno()), logIntegracaoOperadora.getRetorno(), "ENVIO RESULTADO", logIntegracaoOperadora));
            }
        }
        catch (IntegracaoOperadoraException e) {
            this.erros.errosProcesso.add(e);
        }
        return this.erros;
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraSimus configuradorIntegracaoOperadoraSIMUS = ConfiguradorIntegracaoOperadoraSimus.novaInstancia(parent);
        configuradorIntegracaoOperadoraSIMUS.setXML(xmlConfig);
        configuradorIntegracaoOperadoraSIMUS.setVisible(true);
        if (configuradorIntegracaoOperadoraSIMUS.getOK()) {
            return configuradorIntegracaoOperadoraSIMUS.getXML();
        }
        return xmlConfig;
    }
}

