/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.simus;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoOperadoraSimus
extends AbstractDialogoOKCancelar {
    public static final String TAG_INTEGRACAO_CHAVE = "chave";
    public static final String TAG_INTEGRACAO_WS_RESGATE = "enderecoWBResgate";
    public static final String TAG_INTEGRACAO_WS_RESULTADOS = "enderecoWBResultados";
    private static String TITULO = "Configurando integra\u00e7\u00e3o SIMUS";
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelChave = new JLabel("Chave de Integra\u00e7\u00e3o:");
    private JLabel labelWSResgate = new JLabel("Web Service Resgate:");
    private JLabel labelWSResultado = new JLabel("Web Service Resultados:");
    private JLabel labelVlrEstacao = new JLabel();
    private TTextField txtEstacao = new TTextField(10, 1);
    private TTextField txtChave = new TTextField(30);
    private TTextField txtWSResgate = new TTextField(350);
    private TTextField txtWSResultado = new TTextField(350);
    private JButton buttonEstacao = new JButton();

    public static ConfiguradorIntegracaoOperadoraSimus novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraSimus((Dialog)pai);
        }
        return new ConfiguradorIntegracaoOperadoraSimus((Frame)pai);
    }

    public ConfiguradorIntegracaoOperadoraSimus(Dialog pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    public ConfiguradorIntegracaoOperadoraSimus(Frame pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    private void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(480, 175));
        ScreenUtil.centralizar(this);
        this.txtEstacao.setPreferredSize(new Dimension(80, 20));
        this.txtEstacao.setMinimumSize(this.txtEstacao.getPreferredSize());
        this.txtChave.setPreferredSize(new Dimension(1, 20));
        this.txtChave.setMinimumSize(this.txtChave.getPreferredSize());
        this.txtWSResgate.setPreferredSize(new Dimension(1, 20));
        this.txtWSResgate.setMinimumSize(this.txtWSResgate.getPreferredSize());
        this.txtWSResultado.setPreferredSize(new Dimension(1, 20));
        this.txtWSResultado.setMinimumSize(this.txtWSResultado.getPreferredSize());
        this.buttonEstacao.setPreferredSize(new Dimension(20, 20));
        this.buttonEstacao.setSize(this.buttonEstacao.getPreferredSize());
        this.buttonEstacao.setMinimumSize(this.buttonEstacao.getPreferredSize());
        this.buttonEstacao.setMaximumSize(this.buttonEstacao.getPreferredSize());
        this.buttonEstacao.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.labelVlrEstacao.setPreferredSize(new Dimension(1, 20));
        this.labelVlrEstacao.setMinimumSize(this.labelVlrEstacao.getPreferredSize());
        ScreenUtil.setBorda(new Component[]{this.labelVlrEstacao}, new TitledBorder(""));
        this.montaListeners();
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelEstacao, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtEstacao, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.buttonEstacao, c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.labelVlrEstacao, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelChave, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtChave, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelWSResgate, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtWSResgate, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelWSResultado, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtWSResultado, c);
        ScreenUtil.requisitarFoco(this.txtEstacao);
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraSimus.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraSimus.this.pesquisaEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraSimus.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraSimus.this.buscaEstacao(ConfiguradorIntegracaoOperadoraSimus.this.txtEstacao.getText());
                }
            }
        };
        this.txtEstacao.addKeyListener(keyAdapter);
        this.txtEstacao.addFocusListener(focusAdapter);
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraSimus.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraSimus.this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraSimus.this.labelVlrEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraSimus.this.txtEstacao.clear();
                    ConfiguradorIntegracaoOperadoraSimus.this.labelVlrEstacao.setText("");
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                ScreenUtil.requisitarFoco(ConfiguradorIntegracaoOperadoraSimus.this.txtEstacao);
            }
        });
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.txtEstacao.clear();
            this.labelVlrEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.txtEstacao.clear();
            this.labelVlrEstacao.setText("");
            ScreenUtil.requisitarFoco(this.txtEstacao);
        }
    }

    private void pesquisaEstacao() {
        this.txtEstacao.clear();
        this.labelVlrEstacao.setText("");
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.txtEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        }
    }

    public void setXML(String xml) {
        if (!Funcoes.textoVazio(xml) && ConfiguradorIntegracaoOperadoraSimus.isSIMUS(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.txtEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CHAVE))) {
                this.txtChave.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_WS_RESGATE))) {
                this.txtWSResgate.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_WS_RESULTADOS))) {
                this.txtWSResultado.setText(aux);
            }
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("integracaooperadora");
            xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS.getDescricao());
            xml.escrever("estacao", this.txtEstacao.getText());
            xml.escrever(TAG_INTEGRACAO_CHAVE, this.txtChave.getText().trim());
            xml.escrever(TAG_INTEGRACAO_WS_RESGATE, this.txtWSResgate.getText().trim());
            xml.escrever(TAG_INTEGRACAO_WS_RESULTADOS, this.txtWSResultado.getText().trim());
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    public static boolean isSIMUS(String xml) {
        return StringUtil.getValor(xml, "protocolo").equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS.getDescricao());
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.txtEstacao) || this.labelVlrEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.txtChave)) {
            Funcoes.mensagem(this, "A chave de acesso do laborat\u00f3rio deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtChave);
            return false;
        }
        if (Funcoes.textoVazio(this.txtWSResgate)) {
            Funcoes.mensagem(this, "O endere\u00e7o do Web Service para resgate dos exames deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtWSResgate);
            return false;
        }
        if (Funcoes.textoVazio(this.txtWSResultado)) {
            Funcoes.mensagem(this, "O endere\u00e7o do Web Service para envio dos resultados deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtWSResultado);
            return false;
        }
        return true;
    }
}

