/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.sdh;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.sdh.ConfiguradorIntegracaoOperadoraSDH;
import jalis.integracaooperadoras.sistemas.sdh.ValidaDadosIntegracao;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.FtpUtil;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Window;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class IntegracaoOperadoraSDH
extends AbstractIntegracaoOperadora {
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private final String xml;
    private final int codigoConvenio;
    private ArrayList<LogIntegracaoOperadora> listaLogs;
    private static String usuarioFTP = null;
    private static String senhaFTP = null;
    private static String enderecoFtp = null;
    private static String pastaFTP = null;
    private static String pastaLocal = null;
    public static final String TAG_NUMERO_GUIA = "codGuia";
    private static final String INTEGRAR_ARQUIVO = "Envio do PDF para o FTP";
    private static final String SEM_LOGS_PARA_ENVIO = "Sem log's para envio";
    private static final String PROCESSO_CRIAR_PDF = "Processo gerar PDF";
    private static final String PROCESSO_MARCA_LOG_EXPORTADO = "marcando log como exportado";
    private static final String PROCESSO_BUSCA_LOGS = "Processo Busca Logs";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_MONTA_LINHA = "montando linha de resultado";
    private static final String HINT_PARADO = "SEM CONEX\u00c3O COM FTP DA DATA HEALTH";
    private static final String HINT_GERANDO = "GERANDO ARQUIVOS PARA ENVIAR";
    private static final String HINT_ENVIANDO = "ENVIANDO ARQUIVOS";
    private static final String PROCESSO_INTEGRA_DADOS = "Inicio do processo de integra\u00e7\u00e3o";

    public IntegracaoOperadoraSDH(String xml, int codigoConvenio) {
        this.codigoConvenio = codigoConvenio;
        this.xml = xml;
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            usuarioFTP = StringUtil.getValor(xml, "login");
            senhaFTP = StringUtil.getValor(xml, "senha");
            enderecoFtp = StringUtil.getValor(xml, "enderecoFtp");
            pastaFTP = StringUtil.getValor(xml, "pastaFtp");
            pastaLocal = StringUtil.getValor(xml, "pastaLocal") + File.separatorChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequisicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) {
        Statement st = Conexao.getStatement();
        XMLStringBuilder xml = new XMLStringBuilder();
        if (!IntegracaoOperadoraSDH.todosExamesComResultados(filial, codigoRequisicao)) {
            return;
        }
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
        }
        if (!IntegracaoOperadoraSDH.getConvenioUtilizaIntegracaoOperadora(filial, convenio)) {
            return;
        }
        IntegracaoOperadoraSDH.montaXML(protocolo, xml, comando);
        String insert = IntegracaoOperadoraSDH.montaInsert(filial, convenio, tipoOperacao, codigoRequisicao, codigoPaciente, codigoExame, codigoMaterial, xml.getXML());
        try {
            Conexao.executeUpdate(filial, st, insert);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private static void criaPDF(LogIntegracaoOperadora log, DadosErrosIntegracaoOperadora erros) {
        try {
            Integer codigoRequisicao = log.getCodigoRequisicao();
            String codigoGuia = StringUtil.getValor(log.getXmlLog(), TAG_NUMERO_GUIA);
            StringBuilder fileName = new StringBuilder();
            fileName.append(String.format("%s%s.%s", pastaLocal, codigoGuia, "pdf"));
            RetornoImpressaoResultados impressos = ImpressaoResultados.imprimirExames(null, null, Variaveis.filialPadrao, String.valueOf(codigoRequisicao), true, true, null, null, null, true, fileName.toString(), false, true, null, false, "", true, false);
        }
        catch (SQLException e) {
            erros.errosProcesso.add(IntegracaoOperadoraSDH.montaExcecao(new Exception(), "N\u00e3o foi poss\u00edvel gerar PDF de resultado.\n" + e.getMessage(), PROCESSO_CRIAR_PDF));
        }
    }

    private static void montaXML(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, XMLStringBuilder xml, String ... comando) {
        try {
            xml.abrir("integracaooperadora");
            xml.escrever("nomeintegracaooperadora", protocolo.getDescricao());
            for (int i = 0; i < comando.length; i += 2) {
                xml.escrever(comando[i], comando[i + 1]);
            }
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean todosExamesComResultados(String filial, String codigoRequisicao) {
        StringBuilder buf = new StringBuilder();
        boolean todosConferidos = true;
        Statement st = Conexao.getStatement();
        buf.append(" select exr_situacao as situacao");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo =  ").append(filial);
        buf.append("    and req_codigo =  ").append(codigoRequisicao);
        buf.append("    and not exr_excluido ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                if (rs.getString("situacao").equalsIgnoreCase("C") || rs.getString("situacao").equalsIgnoreCase("A") || rs.getString("situacao").equalsIgnoreCase("I") || rs.getString("situacao").equalsIgnoreCase("E")) continue;
                todosConferidos = false;
                break;
            }
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel consultar situa\u00e7\u00e3o da Requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return todosConferidos;
    }

    private static String montaInsert(String filial, String convenio, String tipoOperacao, String codigoRequisicao, String codigoPaciente, String codigoExame, String codigoMaterial, String xml) {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append("            (fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(filial);
        buf.append(" ,").append(convenio);
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(filial)).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(codigoRequisicao);
        buf.append(" , ").append(codigoPaciente);
        buf.append(" , '").append(codigoExame).append("'");
        buf.append(" , ").append(codigoMaterial).append(")");
        return buf.toString();
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        String mensagem = "";
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
        if (Funcoes.textoVazio(enderecoFtp)) {
            this.erros.errosProcesso.add(IntegracaoOperadoraSDH.montaExcecao(new Exception(), "N\u00e3o foi possivel conectar ao Ftp da Data Health.\nVerifique as configura\u00e7\u00f5es.", PROCESSO_CARREGAR_PARAMETROS));
            return this.erros;
        }
        try {
            mensagem = this.integrarDados();
            if (!Funcoes.textoVazio(mensagem)) {
                this.erros.errosProcesso.add(IntegracaoOperadoraSDH.montaExcecao(new Exception(), mensagem, PROCESSO_INTEGRA_DADOS));
            }
        }
        catch (Exception e) {
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_PARADO);
            Laboratorio.setHintIntegracaoOperadora(this, HINT_PARADO);
        }
        return this.erros;
    }

    private String integrarDados() {
        String mensagemErro;
        block7: {
            int erro = 0;
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
            Laboratorio.setHintIntegracaoOperadora(this, HINT_GERANDO);
            FtpUtil ftp = new FtpUtil();
            File[] exportar = null;
            mensagemErro = "";
            try {
                if (!Funcoes.textoVazio(pastaLocal)) {
                    File diretorio = new File(pastaLocal);
                    ArrayList<LogIntegracaoOperadora> logs = this.getLogsIntegracao();
                    ValidaDadosIntegracao dados = new ValidaDadosIntegracao(diretorio, logs);
                    if (dados.isValidos()) {
                        ftp.conectar(enderecoFtp, usuarioFTP, senhaFTP);
                        for (LogIntegracaoOperadora log : logs) {
                            IntegracaoOperadoraSDH.criaPDF(log, this.erros);
                            exportar = diretorio.listFiles();
                            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
                            Laboratorio.setHintIntegracaoOperadora(this, HINT_ENVIANDO);
                            this.enviaArquivosFtp(exportar, ftp);
                            this.marcaLogExportado(log);
                        }
                        ftp.desconectar();
                    } else if (!dados.getMensagemErro().equalsIgnoreCase(SEM_LOGS_PARA_ENVIO)) {
                        this.erros.errosLogin.add(IntegracaoOperadoraSDH.montaExcecao(new Exception(), "N\u00e3o foi poss\u00edvel realizar a integra\u00e7\u00e3o.\n" + dados.getMensagemErro(), INTEGRAR_ARQUIVO));
                        erro = ftp.erroFtp();
                    }
                }
            }
            catch (Exception e) {
                if (ftp == null) break block7;
                erro = ftp.erroFtp();
                mensagemErro = this.getMensagemErro(erro);
            }
        }
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_PARADO);
        Laboratorio.setHintIntegracaoOperadora(this, HINT_PARADO);
        return mensagemErro;
    }

    private String getMensagemErro(int erro) {
        String mensagemErro = "";
        switch (erro) {
            case 421: {
                mensagemErro = "N\u00e3o foi possivel conectar ao Ftp da Data Health.";
                break;
            }
            case 452: {
                mensagemErro = "Espa\u00e7o insuficiente no servidor. Entre em contato com a operadora Data Health.";
                break;
            }
            case 530: {
                mensagemErro = "Usu\u00e1rio ou senha do FTP est\u00e3o incorretos.";
                break;
            }
            case 532: {
                mensagemErro = "Laborat\u00f3rio n\u00e3o autorizado para enviar arquivo. Entre em contato com a Data Health.";
                break;
            }
            default: {
                mensagemErro = "N\u00e3o foi possivel conectar ao Ftp da operadora Data Health. ERRO: (" + erro + ")";
            }
        }
        return mensagemErro;
    }

    private void enviaArquivosFtp(File[] exportar, FtpUtil ftp) throws Exception {
        for (File arquivo : exportar) {
            String nomeArquivo = arquivo.getName();
            if (!arquivo.isFile() || !nomeArquivo.substring(nomeArquivo.lastIndexOf(".") + 1).toUpperCase().equalsIgnoreCase("pdf") || !ftp.uploadAquivo(pastaLocal + nomeArquivo, nomeArquivo, pastaFTP)) continue;
            arquivo.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marcaLogExportado(LogIntegracaoOperadora log) {
        Statement st = Conexao.getStatement();
        String reqCodigo = StringUtil.getValor(log.getXmlLog(), "codreq");
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" update exportaintegracaooperadora ");
            buf.append(" set eio_exportado = true");
            buf.append(", eio_situacao = '").append("E").append("'");
            buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
            buf.append(" and eio_codigo = ").append(log.getCodigoLog());
            Conexao.executeUpdate(log.getCodigoFilial().toString(), st, buf.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    this.erros.errosProcesso.add(IntegracaoOperadoraSDH.montaExcecao(new Exception(), "N\u00e3o foi poss\u00edvel marcar o log como exportado.", PROCESSO_MARCA_LOG_EXPORTADO));
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    this.erros.errosProcesso.add(IntegracaoOperadoraSDH.montaExcecao(new Exception(), "N\u00e3o foi poss\u00edvel anular SQL.", PROCESSO_MARCA_LOG_EXPORTADO));
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private ArrayList<LogIntegracaoOperadora> getLogsIntegracao() throws IntegracaoOperadoraException {
        ArrayList<LogIntegracaoOperadora> arrayList;
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,pac_codigo    as codigoPaciente");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
        buf.append("   from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("  order by eio_codigo ");
        try {
            rs = Conexao.executeQuery(st, buf.toString());
            ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
            while (rs.next()) {
                Integer codigoFilial = rs.getInt("codigoFilial");
                Long codigoLog = rs.getLong("codigoLog");
                String tipoOperacao = rs.getString("tipoOperacao");
                String retorno = rs.getString("retorno");
                String situacao = rs.getString("situacao");
                String codigoPaciente = rs.getString("codigoPaciente");
                String operacao = rs.getString("operacao");
                Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(operacao, "codreq"));
                String codigoExame = StringUtil.getValor(operacao, "codexa");
                Integer codigoMaterial = Integer.parseInt(StringUtil.getValor(operacao, "codmat"));
                listaLogs.add(new LogIntegracaoOperadora(codigoFilial, codigoLog, codigoRequisicao, codigoPaciente, codigoExame, codigoMaterial, tipoOperacao, operacao, retorno, situacao, this.codigoConvenio));
            }
            arrayList = listaLogs;
        }
        catch (SQLException e) {
            try {
                throw IntegracaoOperadoraSDH.montaExcecao(e, "N\u00e3o foi poss\u00edvel buscar os logs de integra\u00e7\u00e3o.\n" + e.getMessage(), PROCESSO_BUSCA_LOGS);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return arrayList;
    }

    private static IntegracaoOperadoraException montaExcecao(Exception excecao, String mensagemErro, String nomeProcesso) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (excecao instanceof IntegracaoOperadoraException) {
            buf.append(" - ").append(((IntegracaoOperadoraException)excecao).getMensagemErro());
        } else {
            if (excecao != null) {
                buf.append(" - ").append(excecao.toString());
            }
            if (excecao instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        if (mensagemErro != null) {
            buf.append(" - ").append(mensagemErro);
        }
        IntegracaoOperadoraException novaExcecao = new IntegracaoOperadoraException(excecao, buf.toString(), nomeProcesso, null);
        if (excecao != null) {
            novaExcecao.setStackTrace(excecao.getStackTrace());
        }
        return novaExcecao;
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraSDH janelaConfiguracao = ConfiguradorIntegracaoOperadoraSDH.novaInstancia(parent);
        janelaConfiguracao.setXML(xmlConfig);
        janelaConfiguracao.setVisible(true);
        if (janelaConfiguracao.getOK()) {
            return janelaConfiguracao.getXML();
        }
        return xmlConfig;
    }
}

