/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.sdh;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoOperadoraSDH
extends AbstractDialogoOKCancelar {
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio FTP:");
    private JLabel labelSenha = new JLabel("Senha FTP:");
    private JLabel labelTipoIntegracao = new JLabel("Tipo integra\u00e7\u00e3o:");
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelPastaFTP = new JLabel("Pasta do FTP:");
    private JLabel labelVlrEstacao = new JLabel();
    private JLabel labelEnderecoFTP = new JLabel("Endere\u00e7o do FTP:");
    private JLabel labelLocalPasta = new JLabel("Pasta Local:");
    private TTextField textEnderecoFTP = new TTextField(300);
    private TTextField textUsuarioFTP = new TTextField(50);
    private TTextField textSenhaFTP = new TTextField(15, "[0-9A-Za-z\\_\\-\\!\\@\\#\\$\\%\\&]+");
    private TTextField textPastaFTP = new TTextField(200);
    private JComboBox comboIntegracaoOperadora = new JComboBox<String>(new String[]{"Data Health"});
    private TTextField textEstacao = new TTextField(10, 1);
    private TTextField textLocalPasta = new TTextField(200, "[a-zA-Z0-9./-\\_]+");
    private JButton buttonComandoExportacao = ComponenteFactory.novoJButton("...", 'P', this);
    private JButton buttonEstacao = new JButton();
    private JPanel panelFTP = new JPanel();
    public static final String TAG_LOGIN = "login";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_CODIGO_LABORATORIO = "codigoLaboratorio";
    public static final String TAG_FTP = "enderecoFtp";
    public static final String TAG_PASTA_FTP = "pastaFtp";
    public static final String TAG_LOCAL_PASTA = "pastaLocal";
    private static final String REGEX_PASTA = "[a-zA-Z0-9./-\\_]+";
    private static final String REGEX_SENHA = "[0-9A-Za-z\\_\\-\\!\\@\\#\\$\\%\\&]+";
    private String xml = null;
    private static final int COLUNA_OPERADORA_ORIGEM = 0;
    private static final int COLUNA_PRESTADOR_ORIGEM = 1;
    private static final int COLUNA_SENHA = 2;
    private static final int COLUNA_USUARIO = 3;
    private static final int COLUNA_WEB_SERVICE = 4;
    private static final int COLUNA_ESTACAO_INTEGRADORA = 5;
    private EstacaoService estacaoService;

    public ConfiguradorIntegracaoOperadoraSDH(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorIntegracaoOperadoraSDH(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(450, 200));
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelEstacao, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelEnderecoFTP, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelPastaFTP, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelUsuario, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelSenha, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelLocalPasta, c);
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.textEstacao.setPreferredSize(new Dimension(80, 20));
        this.textEstacao.setMinimumSize(new Dimension(80, 20));
        this.getPanelCentral().add((Component)this.textEstacao, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 0);
        this.buttonEstacao.setPreferredSize(new Dimension(20, 20));
        this.buttonEstacao.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.buttonEstacao.setFocusable(false);
        this.getPanelCentral().add((Component)this.buttonEstacao, c);
        ++c.gridx;
        this.labelVlrEstacao.setPreferredSize(new Dimension(230, 20));
        this.labelVlrEstacao.setMinimumSize(new Dimension(230, 20));
        ScreenUtil.setBorda(new Component[]{this.labelVlrEstacao}, new TitledBorder(""));
        this.getPanelCentral().add((Component)this.labelVlrEstacao, c);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.textEnderecoFTP.setPreferredSize(new Dimension(20, 20));
        this.textEnderecoFTP.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textEnderecoFTP, c);
        ++c.gridy;
        this.textPastaFTP.setPreferredSize(new Dimension(20, 20));
        this.textPastaFTP.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textPastaFTP, c);
        ++c.gridy;
        this.textUsuarioFTP.setPreferredSize(new Dimension(20, 20));
        this.textUsuarioFTP.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textUsuarioFTP, c);
        ++c.gridy;
        this.textSenhaFTP.setPreferredSize(new Dimension(20, 20));
        this.textSenhaFTP.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textSenhaFTP, c);
        ++c.gridy;
        c.fill = 0;
        this.textLocalPasta.setPreferredSize(new Dimension(302, 20));
        this.textLocalPasta.setMinimumSize(new Dimension(302, 20));
        this.getPanelCentral().add((Component)this.textLocalPasta, c);
        ++c.gridx;
        c.anchor = 13;
        this.buttonComandoExportacao.setPreferredSize(new Dimension(20, 20));
        this.buttonComandoExportacao.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.buttonComandoExportacao, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.getPanelCentral().add((Component)new JLabel(), c);
        this.montaListeners();
        ScreenUtil.requisitarFoco(this.textEstacao);
        this.textLocalPasta.setEditable(false);
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.textEstacao) || this.labelVlrEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.textPastaFTP)) {
            Funcoes.mensagem(this, "A pasta do FTP deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textPastaFTP);
            return false;
        }
        if (Funcoes.textoVazio(this.textUsuarioFTP)) {
            Funcoes.mensagem(this, "O usu\u00e1rio de login deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textUsuarioFTP);
            return false;
        }
        if (Funcoes.textoVazio(this.textSenhaFTP)) {
            Funcoes.mensagem(this, "A senha de login deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textSenhaFTP);
            return false;
        }
        if (Funcoes.textoVazio(this.textEnderecoFTP)) {
            Funcoes.mensagem(this, "O endere\u00e7o do FTP deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textEnderecoFTP);
            return false;
        }
        if (Funcoes.textoVazio(this.textLocalPasta)) {
            Funcoes.mensagem(this, "A pasta tempor\u00e1ria deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textLocalPasta);
            return false;
        }
        return true;
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraSDH.this.textEstacao) {
                    ConfiguradorIntegracaoOperadoraSDH.this.pesquisaEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraSDH.this.textEstacao) {
                    ConfiguradorIntegracaoOperadoraSDH.this.buscaEstacao(ConfiguradorIntegracaoOperadoraSDH.this.textEstacao.getText());
                }
            }
        };
        this.textEstacao.addKeyListener(keyAdapter);
        this.textEstacao.addFocusListener(focusAdapter);
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraSDH.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraSDH.this.textEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraSDH.this.labelVlrEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraSDH.this.textEstacao.clear();
                    ConfiguradorIntegracaoOperadoraSDH.this.labelVlrEstacao.setText("");
                }
            }
        });
        this.buttonComandoExportacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraSDH.this.buttonComandoExportacao) {
                    ConfiguradorIntegracaoOperadoraSDH.this.buscaDiretorio(ConfiguradorIntegracaoOperadoraSDH.this.textLocalPasta);
                }
            }
        });
    }

    private void buscaDiretorio(TTextField text) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser("Selecione um Diret\u00f3rio");
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            ((TTextField.TDocument)this.textLocalPasta.getDocument()).setRegex("");
            text.setText(chooser.getSelectedFile().getAbsolutePath());
            ((TTextField.TDocument)this.textLocalPasta.getDocument()).setRegex(REGEX_PASTA);
        }
    }

    private void pesquisaEstacao() {
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.textEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        } else {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SDH.getDescricao());
        xml.escrever("estacao", this.textEstacao.getText());
        xml.escreverCData(TAG_LOGIN, this.textUsuarioFTP.getText());
        xml.escreverCData(TAG_SENHA, this.textSenhaFTP.getText());
        xml.escreverCData(TAG_FTP, this.textEnderecoFTP.getText());
        xml.escreverCData(TAG_PASTA_FTP, this.textPastaFTP.getText());
        xml.escrever(TAG_LOCAL_PASTA, this.textLocalPasta.getText());
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    public static ConfiguradorIntegracaoOperadoraSDH novaInstancia(Window parent) {
        String titulo = "Configurando Data Health";
        if (parent instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraSDH((Dialog)parent, titulo);
        }
        return new ConfiguradorIntegracaoOperadoraSDH((Frame)parent, titulo);
    }

    public void setXML(String xml) {
        this.xml = xml;
        if (!Funcoes.textoVazio(xml) && StringUtil.getValor(xml, "protocolo").equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SDH.getDescricao()) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.textEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_LOGIN))) {
                this.textUsuarioFTP.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_SENHA))) {
                this.textSenhaFTP.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_PASTA_FTP))) {
                this.textPastaFTP.setText(aux);
            }
            aux = StringUtil.getValor(xml, TAG_FTP);
            if (!Funcoes.textoVazio(xml)) {
                this.textEnderecoFTP.setText(aux);
            }
            aux = StringUtil.getValor(xml, TAG_LOCAL_PASTA);
            if (!Funcoes.textoVazio(xml)) {
                ((TTextField.TDocument)this.textLocalPasta.getDocument()).setRegex("");
                this.textLocalPasta.setText(aux);
                ((TTextField.TDocument)this.textLocalPasta.getDocument()).setRegex(REGEX_PASTA);
            }
        }
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.textEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            ScreenUtil.requisitarFoco(this.textEstacao);
        }
    }
}

