/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.mksaude;

import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LAUDOSPortTypeProxy;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LOGINInput;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LOGINInputHASHVARCHAR2OUT;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LOGINInputLOGINVALIDOVARCHAR2OUT;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LOGINOutput;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.mksaude.AutenticacaoBasic;
import jalis.integracaooperadoras.sistemas.mksaude.ConfiguradorIntegracaoOperadoraMKSaude;
import jalis.integracaooperadoras.sistemas.mksaude.json.Exame;
import jalis.integracaooperadoras.sistemas.mksaude.json.JSONBuilder;
import jalis.integracaooperadoras.sistemas.mksaude.model.IntegracaoOperadoraMKSaudeService;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Window;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IntegracaoOperadoraMKSaude
extends AbstractIntegracaoOperadora {
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_LOGIN = "efetuando login no webservice";
    private static final String PROCESSO_ENVIA_RESULTADO = "enviando resultado";
    private static final String PROCESSO_MONTA_LABORATORIO = "montando dados do laborat\u00f3rio";
    private static final String PROCESSO_MARCA_LOG_EXPORTADO = "marcando log como exportado";
    private static final String PROCESSO_ENVIAR_RESULTADO = "enviar resultado";
    private static final String PROCESSO_RECEBER_RESPOSTA = "receber resposta do servidor";
    private static final String HINT_EXECUTANDO = "ENVIANDO RESULTADOS AO WEBSERVICE DO MK Sa\u00fade";
    private static final String HINT_AGUARDANDO_WS = "AGUARDANDO RETORNO DO WEBSERVICE DO UPY";
    private static final String CODIGO_TABELA_TUSS = "22";
    private static final String FORMATO_ARQUIVO_PDF = "PDF";
    private static final String SISTEMA_ORIGEM = "JALIS";
    private static final String MENSAGEM_EXAME_SEM_NUMERO_GUIA = "Exame n\u00e3o enviado por estar sem o N\u00ba da Guia.";
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private final String xml;
    private final int codigoConvenio;
    private ArrayList<LogIntegracaoOperadora> listaLogs;
    private final IntegracaoOperadoraMKSaudeService service;

    public IntegracaoOperadoraMKSaude(String xml, int codigoConvenio) {
        this.codigoConvenio = codigoConvenio;
        this.xml = xml;
        this.service = new IntegracaoOperadoraMKSaudeService();
    }

    @Override
    public synchronized DadosErrosIntegracaoOperadora integrarOperadora() {
        this.listaLogs = this.getLogIntegracao(this.codigoConvenio);
        if (this.erros.haErros()) {
            return this.erros;
        }
        try {
            this.enviarListaLogs();
        }
        catch (IntegracaoOperadoraException e1) {
            this.erros.errosProcesso.add(e1);
        }
        finally {
            this.definirIconeIntegracao();
            return this.erros;
        }
    }

    private void definirIconeIntegracao() {
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_PARADO);
        if (this.erros.haErros()) {
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_ERRO);
        } else {
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_AGUARDANDO_WS);
        }
    }

    private void enviarListaLogs() throws IntegracaoOperadoraException {
        if (this.listaLogs != null) {
            HashMap<Integer, ArrayList<LogIntegracaoOperadora>> logPorRequisicao = this.separaLogPorRequisicao();
            for (ArrayList<LogIntegracaoOperadora> log : logPorRequisicao.values()) {
                try {
                    this.enviarResultado(log);
                }
                catch (IntegracaoOperadoraException e) {
                    this.erros.errosEnvioResultado.add(e);
                }
            }
        }
    }

    private HashMap<Integer, ArrayList<LogIntegracaoOperadora>> separaLogPorRequisicao() throws IntegracaoOperadoraException {
        HashMap<Integer, ArrayList<LogIntegracaoOperadora>> logByReq = new HashMap<Integer, ArrayList<LogIntegracaoOperadora>>();
        for (LogIntegracaoOperadora log : this.listaLogs) {
            ArrayList<Object> aux;
            if (log.getSituacao().equals("E")) {
                this.marcaLogExportado(log);
                continue;
            }
            if (logByReq.containsKey(log.getCodigoRequisicao())) {
                aux = logByReq.get(log.getCodigoRequisicao());
                aux.add(log);
                continue;
            }
            aux = new ArrayList<LogIntegracaoOperadora>();
            aux.add(log);
            logByReq.put(log.getCodigoRequisicao(), aux);
        }
        return logByReq;
    }

    private void enviarResultado(ArrayList<LogIntegracaoOperadora> logPorReq) throws IntegracaoOperadoraException {
        try {
            LogIntegracaoOperadora logAux = logPorReq.get(0);
            ResultSet rs = this.getDados(logAux);
            if (rs == null || !rs.next()) {
                return;
            }
            if (!this.podeEnviarRequisicaoSemNumeroGuia(logAux)) {
                this.service.atualizarRetornoLog(logAux, MENSAGEM_EXAME_SEM_NUMERO_GUIA);
                throw this.montaExcecao(logAux, MENSAGEM_EXAME_SEM_NUMERO_GUIA, PROCESSO_ENVIAR_RESULTADO);
            }
            JSONObject json = this.montarJson(logPorReq, rs);
            rs.close();
            HttpResponse response = this.enviar(json);
            String mensagem = this.extrairMensagem(response);
            this.tratarResposta(mensagem, logPorReq);
        }
        catch (Exception e) {
            if (!(e instanceof IntegracaoOperadoraException)) {
                throw this.montaExcecao(e, logPorReq.get(0), "N\u00e3o foi poss\u00edvel enviar resultado.\nMensagem n\u00e3o identificada:\n" + e.getMessage(), PROCESSO_ENVIAR_RESULTADO);
            }
            throw (IntegracaoOperadoraException)e;
        }
    }

    private boolean podeEnviarRequisicaoSemNumeroGuia(LogIntegracaoOperadora log) throws SQLException {
        String parametroConfig = StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.ENVIAR_RESULTADO_SEM_NUMERO_GUIA.getTag());
        boolean requisicaoComNumeroGuiaPreenchido = this.service.requisicaoComNumeroDeGuiaPreenchido(log);
        boolean enviarRequisicaoSemNumeroGuia = false;
        enviarRequisicaoSemNumeroGuia = !Funcoes.textoVazio(parametroConfig) ? parametroConfig.equalsIgnoreCase("true") || !parametroConfig.equalsIgnoreCase("true") && requisicaoComNumeroGuiaPreenchido : requisicaoComNumeroGuiaPreenchido;
        return enviarRequisicaoSemNumeroGuia;
    }

    private void tratarResposta(String mensagem, ArrayList<LogIntegracaoOperadora> log) throws IntegracaoOperadoraException {
        try {
            JSONObject responseObj = new JSONObject(mensagem);
            String erro = responseObj.get("motivo") == null ? "null" : responseObj.get("motivo").toString();
            JSONArray retornoOperacao = responseObj.getJSONArray("retorno_operacao");
            Boolean status = retornoOperacao.getJSONObject(0).getBoolean("status");
            if (!status.booleanValue()) {
                Optional<Integer> codReq = log.stream().map(LogIntegracaoOperadora::getCodigoRequisicao).findAny();
                codReq.ifPresent(c -> this.debug("requisicao: " + c));
                this.debug("resposta: " + mensagem);
            }
            this.salvarErro(erro, log, status, retornoOperacao.toString());
        }
        catch (JSONException e) {
            throw this.montaExcecao(log.get(0), "N\u00e3o foi poss\u00edvel montar JSON de resposta \n" + mensagem + "\n" + e.getMessage(), PROCESSO_ENVIAR_RESULTADO);
        }
    }

    private void salvarErro(String erro, ArrayList<LogIntegracaoOperadora> logs, Boolean status, String retornoOperacao) throws IntegracaoOperadoraException {
        StringBuilder sql = new StringBuilder();
        String concat = erro + "\n" + retornoOperacao;
        String statusRetorno = status != false ? "E" : "R";
        String filial = logs.get(0).getCodigoFilial().toString();
        sql.append("update exportaintegracaooperadora set eio_situacao = '").append(statusRetorno).append("'");
        sql.append(", eio_retorno = '").append(concat).append("'");
        sql.append(", eio_exportado = '").append(true).append("'");
        sql.append(" where eio_codigo in (");
        for (LogIntegracaoOperadora log : logs) {
            sql.append(log.getCodigoLog()).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") ");
        sql.append("and fil_codigo = ").append(filial);
        Statement st = Conexao.getStatement();
        try {
            Conexao.execute(filial, st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            throw this.montaExcecao(logs.get(0), "N\u00e3o foi poss\u00edvel atualizar situa\u00e7\u00e3o do log:\n" + e.getMessage(), PROCESSO_RECEBER_RESPOSTA);
        }
    }

    private String extrairMensagem(HttpResponse response) throws IllegalStateException, IOException {
        if (response == null) {
            throw new NullPointerException("Resposta do servidor 'VAZIA'");
        }
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    private HttpResponse enviar(JSONObject json) throws IntegracaoOperadoraException {
        HttpResponse response = null;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            response = client.execute((HttpUriRequest)this.criarHttpPost(json));
        }
        catch (Exception e) {
            throw this.montaExcecao(new LogIntegracaoOperadora(), "N\u00e3o foi poss\u00edvel enviar JSON.\n" + e.getMessage(), PROCESSO_ENVIA_RESULTADO);
        }
        return response;
    }

    private HttpPost criarHttpPost(JSONObject json) throws UnsupportedEncodingException {
        HttpPost post = new HttpPost(this.getEnderecoWebService());
        String autenticacao = new AutenticacaoBasic(this.getUsuario(), this.getSenha()).getAutenticacao();
        post.setHeader("Authorization", "Basic " + autenticacao);
        post.setHeader("Accept", "application/json");
        post.setHeader("Content-type", "application/json");
        StringEntity entity = new StringEntity(json.toString());
        post.setEntity((HttpEntity)entity);
        return post;
    }

    private String getEnderecoWebService() {
        return StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.WEB_SERVICE.getTag());
    }

    private String getSenha() {
        return StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.SENHA.getTag());
    }

    private String getUsuario() {
        return StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.USUARIO.getTag());
    }

    private void verificarSituacaoExame(LogIntegracaoOperadora log, ResultSet rs) throws IntegracaoOperadoraException {
        try {
            String situacaoExame = rs.getString("situacaoExame");
            if (Funcoes.textoVazio(situacaoExame) || !this.situacaoPermitida(situacaoExame)) {
                this.debug("Requisicao: " + log.getCodigoRequisicao() + " exame: " + log.getCodigoExame() + " n\u00e3o enviado com situacao " + this.getDescricaoSituacao(situacaoExame));
                throw this.montaExcecao(log, "Situa\u00e7\u00e3o do exame n\u00e3o permitida.", PROCESSO_ENVIA_RESULTADO);
            }
            if (rs.getBoolean("excluidoExame")) {
                throw this.montaExcecao(log, "Exame removido da requisi\u00e7\u00e3o.", PROCESSO_ENVIA_RESULTADO);
            }
            if (rs.getBoolean("naoFaturarExame")) {
                this.debug("Requisicao: " + log.getCodigoRequisicao() + " exame: " + log.getCodigoExame() + " n\u00e3o enviado - marcado para nao faturar ");
                throw this.montaExcecao(log, "Exame marcado para n\u00e3o faturar.", PROCESSO_ENVIA_RESULTADO);
            }
        }
        catch (SQLException e) {
            throw this.montaExcecao(log, "N\u00e3o foi poss\u00edvel verificar a situa\u00e7\u00e3o do exame.\n" + e.getMessage(), PROCESSO_ENVIA_RESULTADO);
        }
    }

    private String getDescricaoSituacao(String situacao) {
        String retorno = " ";
        if (!Funcoes.textoVazio(situacao)) {
            if (situacao.equals("T")) {
                retorno = "A coletar";
            } else if (situacao.equals("F")) {
                retorno = "Falta Matrial";
            } else if (situacao.equals("R")) {
                retorno = "Recoleta";
            } else if (situacao.equals("A")) {
                retorno = "Apenas Faturamento";
            } else if (situacao.equals("P")) {
                retorno = "Salvo Parcial";
            } else if (situacao.equals("L")) {
                retorno = "Lan\u00e7ado";
            } else if (situacao.equals("U")) {
                retorno = "Urgente";
            } else if (situacao.equals("C")) {
                retorno = "Conferido";
            } else if (situacao.equals("O")) {
                retorno = "Repeti\u00e7\u00e3o";
            } else if (situacao.equals("I")) {
                retorno = "Impresso";
            } else if (situacao.equals("E")) {
                retorno = "Entregue";
            } else if (situacao.equals("N")) {
                retorno = "Transporte";
            } else if (situacao.equals("")) {
                retorno = "Sem resultado";
            }
        }
        return retorno;
    }

    private boolean situacaoPermitida(String situacaoExame) {
        return situacaoExame.equals("C") || situacaoExame.equals("E") || situacaoExame.equals("I");
    }

    private JSONObject montarJson(ArrayList<LogIntegracaoOperadora> logs, ResultSet rs) throws IntegracaoOperadoraException {
        JSONObject json = new JSONObject();
        try {
            String dataHora = this.formatarDataHora(rs.getDate("dataHora"));
            String nrCartaoBeneficiario = StringUtil.removeZerosEsquerda(rs.getString("nrCartaoBeneficiario"));
            String nrAutorizacaoOperadora = rs.getString("nrAutorizacaoOperadora");
            AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora tipoOperacao = logs.get(0).getTipoOperacao();
            String operadoraOrigem = StringUtil.getValor(this.xml, this.getOperadoraOrigem());
            String prestadorOrigem = StringUtil.getValor(this.xml, this.getPrestadorOrigem());
            JSONBuilder builder = new JSONBuilder();
            builder.adicionarHeader(operadoraOrigem, prestadorOrigem, SISTEMA_ORIGEM, dataHora);
            builder.abrirRegistro();
            for (LogIntegracaoOperadora log : logs) {
                if (!this.posicionarResultSet(rs, log.getCodigoExame())) continue;
                this.verificarSituacaoExame(log, rs);
                this.adicionarExame(rs, builder, log);
            }
            String anexo = this.montaPDF(logs);
            nrCartaoBeneficiario = this.validaNrCartaoBeneficiario(nrCartaoBeneficiario);
            builder.fecharRegistro(tipoOperacao.toString(), nrCartaoBeneficiario, nrAutorizacaoOperadora, anexo, FORMATO_ARQUIVO_PDF);
            json = builder.build();
        }
        catch (SQLException e) {
            throw this.montaExcecao(logs.get(0), "N\u00e3o foi poss\u00edvel extrair dados do ResultSet\n" + e.getMessage(), PROCESSO_ENVIA_RESULTADO);
        }
        catch (JSONException e) {
            throw this.montaExcecao(logs.get(0), "N\u00e3o foi poss\u00edvel montar JSON\n\n" + json.toString() + "\n" + e.getMessage(), PROCESSO_ENVIA_RESULTADO);
        }
        return json;
    }

    private String formatarDataHora(Date dataHora) throws SQLException {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dataHora);
    }

    private String validaNrCartaoBeneficiario(String nrCartao) {
        boolean considerarZerosBeneficiario;
        String nrCartaoBeneficiario = nrCartao;
        if (!Funcoes.textoVazio(this.xml) && (considerarZerosBeneficiario = Boolean.parseBoolean(StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.ZERO_INICIAIS_BENEFICIARIO.getTag())))) {
            for (int i = nrCartao.length(); i < 17; ++i) {
                nrCartaoBeneficiario = "0" + nrCartaoBeneficiario;
            }
        }
        return nrCartaoBeneficiario;
    }

    private String getPrestadorOrigem() {
        return ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.PRESTADOR_ORIGEM.getTag();
    }

    private String getOperadoraOrigem() {
        return ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.OPERADORA_ORIGEM.getTag();
    }

    private void adicionarExame(ResultSet rs, JSONBuilder builder, LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        try {
            int quantidade = rs.getInt("qtde");
            String codigoAmb = rs.getString("codigoAmb");
            if (Funcoes.textoVazio(codigoAmb)) {
                throw this.montaExcecao(log, "Codigo AMB/TUSS n\u00e3o esta cadastrado\nExame:" + log.getCodigoExame(), PROCESSO_CARREGAR_PARAMETROS);
            }
            codigoAmb = codigoAmb.replace(".", "");
            codigoAmb = codigoAmb.replace("-", "");
            Exame exame = new Exame(CODIGO_TABELA_TUSS, codigoAmb, quantidade, quantidade);
            builder.adicionarExame(exame);
        }
        catch (SQLException | JSONException e) {
            throw this.montaExcecao(log, "N\u00e3o foi poss\u00edvel adicionar exame no JSON\n" + e.getMessage(), PROCESSO_ENVIAR_RESULTADO);
        }
    }

    private boolean posicionarResultSet(ResultSet rs, String exame) throws SQLException {
        try {
            rs.beforeFirst();
            while (rs.next()) {
                if (!exame.equalsIgnoreCase(rs.getString("codigoExame"))) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLException("N\u00e3o foi poss\u00edvel identificar o c\u00f3digo do exame\n" + e.getMessage(), e);
        }
        return false;
    }

    private Boolean ehCurva(ResultSet rs) throws SQLException {
        return rs.getBoolean("curva");
    }

    private String montaPDF(ArrayList<LogIntegracaoOperadora> logs) {
        LogIntegracaoOperadora logAux = logs.get(0);
        String[] exames = this.extraiCodigoExame(logs);
        String[] materiais = this.extraiCodigoMaterial(logs);
        RetornoImpressaoResultados pdf = null;
        try {
            pdf = ImpressaoResultados.imprimirExames(null, null, logAux.getCodigoFilial().toString(), logAux.getCodigoRequisicao().toString(), true, true, null, exames, materiais, true, null, true, true, null, true, "", true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String pdfBinario = null;
        if (pdf != null) {
            pdfBinario = Base64.encodeBase64String((byte[])pdf.getResultadoPdfWeb());
        }
        return pdfBinario;
    }

    private String[] extraiCodigoMaterial(ArrayList<LogIntegracaoOperadora> logs) {
        String[] materiais = new String[logs.size()];
        int contador = 0;
        for (LogIntegracaoOperadora log : logs) {
            materiais[contador] = log.getCodigoMaterial().toString();
            ++contador;
        }
        return materiais;
    }

    private String[] extraiCodigoExame(ArrayList<LogIntegracaoOperadora> logs) {
        String[] exames = new String[logs.size()];
        int contador = 0;
        for (LogIntegracaoOperadora log : logs) {
            exames[contador] = log.getCodigoExame();
            ++contador;
        }
        return exames;
    }

    private void adicionarExamesFilhos(JSONBuilder builder, LogIntegracaoOperadora log, int quantidade, ResultSet rs) throws JSONException, IntegracaoOperadoraException {
        ResultSet rsDesm = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(this.getSelectExamesFilhos());
            sql.append(this.getWhereExamesFilhos(log));
            rsDesm = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
            int sequencia = 0;
            while (rsDesm.next()) {
                String codigoAmb = rsDesm.getString("codigoAmb");
                Exame exame = new Exame(CODIGO_TABELA_TUSS, codigoAmb, quantidade, ++sequencia);
                builder.adicionarExame(exame);
            }
            rsDesm.close();
        }
        catch (Exception e) {
            throw this.montaExcecao(log, "N\u00e3o foi poss\u00edvel adicionar exame filho \n" + e.getMessage(), PROCESSO_CARREGAR_PARAMETROS);
        }
    }

    private Object getWhereExamesFilhos(LogIntegracaoOperadora log) {
        StringBuilder sql = new StringBuilder();
        sql.append(" WHERE desm.fil_codigo = '").append(log.getCodigoFilial().toString()).append("'");
        sql.append(" AND desm.exa_codigo = '").append(log.getCodigoExame()).append("'");
        sql.append(" AND desm.mco_codigo = '").append(log.getCodigoMaterial()).append("'");
        sql.append(" AND a.emi_padrao ");
        return sql.toString();
    }

    private String getSelectExamesFilhos() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT");
        sql.append(" ac.emc_codigoamb as codigoAmb");
        sql.append(" FROM examematintdesmembrar desm");
        sql.append(" LEFT JOIN examematinterface a");
        sql.append(" ON desm.exa_codigo = a.exa_codigo");
        sql.append(" AND desm.fil_codigo = a.fil_codigo");
        sql.append(" AND desm.mco_codigo = a.mco_codigo");
        sql.append(" LEFT JOIN examematcoleta ac");
        sql.append(" ON desm.exa_kodigo = ac.exa_codigo");
        sql.append(" AND desm.fil_codigo = ac.fil_codigo");
        sql.append(" AND desm.mco_codigo = ac.mco_codigo");
        return sql.toString();
    }

    private ResultSet getDados(LogIntegracaoOperadora log) {
        ResultSet rs = null;
        Integer reqCodigo = log.getCodigoRequisicao();
        Integer filCodigo = log.getCodigoFilial();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT r.req_matricula AS nrCartaoBeneficiario, ");
            sql.append("       r.req_guia AS nrAutorizacaoOperadora, ");
            sql.append("       r.req_datarequisicao AS dataHora, ");
            sql.append("       exr.exa_codigo AS codigoExame, ");
            sql.append("       exr.exr_naofaturar AS naoFaturarExame, ");
            sql.append("       exr.exr_situacao AS situacaoExame, ");
            sql.append("       exr.exr_excluido AS excluidoExame, ");
            sql.append("");
            sql.append("  (SELECT count(exa_codigo) ");
            sql.append("   FROM examerequisicao e ");
            sql.append("   WHERE e.req_codigo = r.req_codigo ");
            sql.append("     AND e.fil_codigo = r.fil_codigo ");
            sql.append("     AND e.exa_codigo = exr.exa_codigo) AS qtde, ");
            sql.append("       coalesce(a.emi_curva, FALSE) AS curva, ");
            sql.append("       dtp.dtp_codamb AS codigoAmb, ");
            sql.append("       a.int_codigo ");
            sql.append("FROM requisicao r ");
            sql.append("LEFT JOIN paciente p ON r.pac_codigo = p.pac_codigo ");
            sql.append("AND r.fil_codigo = p.fil_codigo ");
            sql.append("LEFT JOIN examerequisicao exr ON r.req_codigo = exr.req_codigo ");
            sql.append("AND r.fil_codigo = exr.fil_codigo ");
            sql.append("LEFT JOIN examematinterface a ON exr.exa_codigo = a.exa_codigo ");
            sql.append("AND exr.fil_codigo = a.fil_codigo ");
            sql.append("AND exr.mco_codigo = a.mco_codigo ");
            sql.append("LEFT JOIN examematcoleta ac ON exr.exa_codigo = ac.exa_codigo ");
            sql.append("AND exr.fil_codigo = ac.fil_codigo ");
            sql.append("AND exr.mco_codigo = ac.mco_codigo ");
            sql.append("LEFT JOIN convenios con ON r.fil_codigo = con.fil_codigo ");
            sql.append("AND r.con_codigo = con.con_codigo ");
            sql.append("LEFT JOIN detalhetabelapreco dtp ON ac.fil_codigo = dtp.fil_codigo ");
            sql.append("AND dtp.exa_codigo = ac.exa_codigo ");
            sql.append("AND dtp.mco_codigo = ac.mco_codigo ");
            sql.append("AND dtp.tpe_codigo = con.tpe_codigo ");
            sql.append("where r.req_codigo = ").append(reqCodigo);
            sql.append(" and r.fil_codigo = ").append(filCodigo);
            sql.append(" and not exr.exr_excluido ");
            Statement st = Conexao.getStatement();
            rs = Conexao.executeQuery(st, sql.toString());
            return rs;
        }
        catch (SQLException e) {
            throw this.montaExcecao(log, "N\u00e3o foi poss\u00edvel realizar a consulta \n" + e.getMessage(), PROCESSO_CARREGAR_PARAMETROS);
        }
        finally {
            return rs;
        }
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraMKSaude janelaConfiguracao = ConfiguradorIntegracaoOperadoraMKSaude.novaInstancia(parent);
        janelaConfiguracao.setXML(xmlConfig);
        janelaConfiguracao.setVisible(true);
        if (janelaConfiguracao.getOK()) {
            return janelaConfiguracao.getXML();
        }
        return xmlConfig;
    }

    public boolean verificarRetificacao(LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        boolean isRetificacao = false;
        try {
            isRetificacao = new ExameRequisicaoService().getExameModificadoRetificado(log.getCodigoFilial(), log.getCodigoRequisicao(), log.getCodigoExame(), log.getCodigoMaterial());
        }
        catch (SQLException e) {
            throw this.montaExcecao(log, "N\u00e3o foi poss\u00edvel verificar se o resultado foi modificado/retificado.\n" + e.getMessage(), PROCESSO_ENVIA_RESULTADO);
        }
        return isRetificacao;
    }

    private String realizaLogin(LAUDOSPortTypeProxy proxyWebservice, boolean isThread) throws IntegracaoOperadoraException {
        this.verificaXML(PROCESSO_LOGIN);
        String usuario = StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.USUARIO.getTag());
        String senha = StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.SENHA.getTag());
        String webService = StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.WEB_SERVICE.getTag());
        try {
            this.iniciaStatusAguardandoWS(isThread);
            LOGINInput login = new LOGINInput();
            LOGINInputHASHVARCHAR2OUT hash = new LOGINInputHASHVARCHAR2OUT();
            LOGINInputLOGINVALIDOVARCHAR2OUT loginValido = new LOGINInputLOGINVALIDOVARCHAR2OUT();
            login.setHASHVARCHAR2OUT(hash);
            login.setLOGINVALIDOVARCHAR2OUT(loginValido);
            login.setUSUARIOVARCHAR2IN(usuario);
            login.setSENHAVARCHAR2IN(senha);
            proxyWebservice.setEndpoint(webService);
            LOGINOutput retornoLogin = proxyWebservice.LOGIN(login);
            this.finalizaStatusAguardandoWS(isThread);
            if (retornoLogin.getLOGINVALIDO().equalsIgnoreCase("true")) {
                return retornoLogin.getHASH();
            }
            throw this.montaExcecao(null, "O login foi recusado pelo webservice.", PROCESSO_LOGIN);
        }
        catch (Exception e) {
            if (!(e instanceof IntegracaoOperadoraException)) {
                throw this.montaExcecao(null, e.getMessage(), PROCESSO_LOGIN);
            }
            throw (IntegracaoOperadoraException)e;
        }
    }

    private void finalizaStatusAguardandoWS(boolean isThread) {
        if (isThread) {
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_AGUARDANDO_WS);
            Laboratorio.setHintIntegracaoOperadora(this, HINT_AGUARDANDO_WS);
        }
    }

    private void iniciaStatusAguardandoWS(boolean isThread) {
        if (isThread) {
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
            Laboratorio.setHintIntegracaoOperadora(this, HINT_EXECUTANDO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<LogIntegracaoOperadora> getLogIntegracao(int codigoConvenio2) {
        ArrayList<LogIntegracaoOperadora> listaLogIntegracao = null;
        try {
            ResultSet rs = this.selectLogIntegracao();
            listaLogIntegracao = this.extrairLogIntegracao(rs);
            rs.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        finally {
            return listaLogIntegracao;
        }
    }

    private ArrayList<LogIntegracaoOperadora> extrairLogIntegracao(ResultSet rs) throws SQLException {
        ArrayList<LogIntegracaoOperadora> resultado = new ArrayList<LogIntegracaoOperadora>();
        while (rs.next()) {
            Integer codigoFilial = rs.getInt("codigoFilial");
            Long codigoLog = rs.getLong("codigoLog");
            String tipoOperacao = rs.getString("tipoOperacao");
            String retorno = rs.getString("retorno");
            String situacao = rs.getString("situacao");
            Integer codigoConvenio = rs.getInt("convenio");
            String xmlLog = rs.getString("xml");
            Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(xmlLog, "codreq"));
            String codigoPaciente = StringUtil.getValor(xmlLog, "codPaciente");
            String codigoExame = StringUtil.getValor(xmlLog, "codexa");
            Integer codigoMaterial = Integer.parseInt(StringUtil.getValor(xmlLog, "codmat"));
            resultado.add(new LogIntegracaoOperadora(codigoFilial, codigoLog, codigoRequisicao, codigoPaciente, codigoExame, codigoMaterial, tipoOperacao, xmlLog, retorno, situacao, codigoConvenio));
        }
        return resultado;
    }

    private ResultSet selectLogIntegracao() throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select eio.fil_codigo as codigoFilial ");
        sql.append("       ,eio.eio_codigo as codigoLog ");
        sql.append("       ,eio.eio_operacao as xml ");
        sql.append("       ,eio.eio_tipooperacao as tipoOperacao ");
        sql.append("       ,eio.eio_retorno as retorno");
        sql.append("       ,COALESCE(eio.eio_situacao,'') as situacao ");
        sql.append("       ,eio.con_codigo as convenio ");
        sql.append("       ,eio.req_codigo as requisicao ");
        sql.append("   from exportaintegracaooperadora eio ");
        sql.append("   left join requisicao r ");
        sql.append("   on r.req_codigo = eio.req_codigo ");
        sql.append("  where eio.eio_exportado = false ");
        sql.append("    and eio.con_codigo = ").append(this.codigoConvenio);
        sql.append("    and eio.eio_operacao like '%<nomeintegracaooperadora>").append(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.MK.getDescricao()).append("</nomeintegracaooperadora>%'");
        sql.append("    and not r.req_excluida");
        Statement st = Conexao.getStatement();
        return Conexao.executeQuery(st, sql.toString());
    }

    private void verificaXML(String processo) {
        String usuario = StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.USUARIO.getTag());
        String senha = StringUtil.getValor(this.xml, ConfiguradorIntegracaoOperadoraMKSaude.CamposConfiguracao.SENHA.getTag());
        if (Funcoes.textoVazio(usuario)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, "O usu\u00e1rio de login do laboratorio n\u00e3o foi informado nas configura\u00e7\u00f5es do convenio.", processo));
        }
        if (Funcoes.textoVazio(senha)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, "A senha de login do laboratorio n\u00e3o foi informado nas configura\u00e7\u00f5es do convenio.", processo));
        }
    }

    private IntegracaoOperadoraException montaExcecao(LogIntegracaoOperadora log, String mensagem, String nomeProcesso) {
        return new IntegracaoOperadoraException(new Exception(), mensagem, nomeProcesso, log);
    }

    private IntegracaoOperadoraException montaExcecao(Exception e, LogIntegracaoOperadora log, String mensagem, String nomeProcesso) {
        return new IntegracaoOperadoraException(e, mensagem, nomeProcesso, log);
    }

    private void limpaErros() {
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    private void marcaLogExportado(LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        Statement st = ConexaoTemporaria.getStatement();
        String logRetorno = StringUtil.textoDBEscape(log.getRetorno());
        if (logRetorno.length() > 2000) {
            logRetorno = log.getRetorno().substring(0, 1999);
        }
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" update exportaintegracaooperadora ");
            buf.append(" set eio_exportado = true ");
            buf.append(" ,eio_retorno = ").append(logRetorno);
            buf.append(" ,eio_situacao = '").append("E").append("'");
            buf.append(" ,req_codigo = ").append(log.getCodigoRequisicao());
            buf.append(" ,exa_codigo = '").append(log.getCodigoExame()).append("'");
            buf.append(" ,mco_codigo = ").append(log.getCodigoMaterial());
            buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
            buf.append(" and eio_codigo = ").append(log.getCodigoLog());
            int qtde = ConexaoTemporaria.executeUpdate(st, buf);
            if (qtde == 0) {
                throw this.montaExcecao(log, "N\u00e3o foi poss\u00edvel marcar o log como exportado.", PROCESSO_MARCA_LOG_EXPORTADO);
            }
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw this.montaExcecao(log, "N\u00e3o foi poss\u00edvel marcar log como exportado.\n" + e.getMessage(), PROCESSO_MARCA_LOG_EXPORTADO);
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        if (!IntegracaoOperadoraMKSaude.getConvenioUtilizaIntegracaoOperadora(filial, convenio)) {
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("nomeintegracaooperadora", protocolo.getDescricao());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append("            (fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(filial);
        buf.append(" ,").append(convenio);
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(filial)).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(codigoRequsicao);
        buf.append(" , ").append(codigoPaciente);
        buf.append(" , '").append(codigoExame).append("'");
        buf.append(" , ").append(codigoMaterial).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(filial, st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }
}

