/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.mksaude;

import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoOperadoraMKSaude
extends AbstractDialogoOKCancelar {
    private JLabel labelEstacaoIntegradora = new JLabel("Esta\u00e7\u00e3o integradora:");
    private TTextField fieldCodEstacaoIntegradora = new TTextField(20);
    private JButton buttonEstacaoIntegradora = new JButton();
    private JLabel labelDescEstacaoIntegradora = new JLabel();
    private JLabel labelOperadoraOrigem = new JLabel(CamposConfiguracao.OPERADORA_ORIGEM.toString().concat(":"));
    private TTextField fieldOperadoraOrigem = new TTextField(100);
    private JLabel labelPrestadorOrigem = new JLabel(CamposConfiguracao.PRESTADOR_ORIGEM.toString().concat(":"));
    private TTextField fieldPrestadorOrigem = new TTextField(100);
    private JLabel labelUsuarioLogin = new JLabel(CamposConfiguracao.USUARIO.toString().concat(":"));
    private TTextField fieldUsuarioLogin = new TTextField(100);
    private JLabel labelSenhaLogin = new JLabel(CamposConfiguracao.SENHA.toString().concat(":"));
    private TTextField fieldSenhaLogin = new TTextField(100);
    private JLabel labelWebService = new JLabel(CamposConfiguracao.WEB_SERVICE.toString().concat(":"));
    private TTextField fieldWebService = new TTextField(200);
    private JPanel panelCentral = new JPanel();
    private JCheckBox checkEnviarResultadoSemNumeroGuia = new JCheckBox(CamposConfiguracao.ENVIAR_RESULTADO_SEM_NUMERO_GUIA.toString());
    private JCheckBox checkRemoverZerosIniciais = new JCheckBox(CamposConfiguracao.ZERO_INICIAIS_BENEFICIARIO.toString());
    private static final int COLUNA_OPERADORA_ORIGEM = 0;
    private static final int COLUNA_PRESTADOR_ORIGEM = 1;
    private static final int COLUNA_SENHA = 2;
    private static final int COLUNA_USUARIO = 3;
    private static final int COLUNA_WEB_SERVICE = 4;
    private static final int COLUNA_ESTACAO_INTEGRADORA = 5;
    private static final int COLUNA_ENVIAR_RESULTADO_SEM_GUIA = 6;
    private static final int COLUNA_CONSIDERAR_ZEROS_BENEFICIARIO = 7;
    private EstacaoService estacaoService;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{CamposConfiguracao.access$000(CamposConfiguracao.OPERADORA_ORIGEM), CamposConfiguracao.access$000(CamposConfiguracao.PRESTADOR_ORIGEM), CamposConfiguracao.access$000(CamposConfiguracao.SENHA), CamposConfiguracao.access$000(CamposConfiguracao.USUARIO), CamposConfiguracao.access$000(CamposConfiguracao.WEB_SERVICE), CamposConfiguracao.access$000(CamposConfiguracao.ESTACAO_INTEGRADORA), CamposConfiguracao.access$000(CamposConfiguracao.ENVIAR_RESULTADO_SEM_NUMERO_GUIA), CamposConfiguracao.access$000(CamposConfiguracao.ZERO_INICIAIS_BENEFICIARIO)});
    public static final String TAG_EXAME_INTEGRACOES_INTEGRACAO_MKSA\u00daDE = "mkSaude";

    public ConfiguradorIntegracaoOperadoraMKSaude(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorIntegracaoOperadoraMKSaude(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.estacaoService = new EstacaoService();
        this.setSize(new Dimension(520, 230));
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.panelCentral.setLayout(new GridBagLayout());
        ScreenUtil.centralizar(this);
        this.dimensionarLabels();
        this.dimensionarTexts();
        this.dimensionarBotoes();
        ScreenUtil.setBorda(new Component[]{this.labelDescEstacaoIntegradora}, new TitledBorder(""));
        this.adicionarComponentes();
        this.adicionarAcoes();
    }

    private void dimensionarLabels() {
        Dimension d = new Dimension(125, 20);
        this.labelEstacaoIntegradora.setPreferredSize(d);
        this.labelEstacaoIntegradora.setMaximumSize(d);
        this.labelEstacaoIntegradora.setSize(d);
        this.labelEstacaoIntegradora.setMinimumSize(d);
        Dimension dve = new Dimension(253, 20);
        this.labelDescEstacaoIntegradora.setPreferredSize(dve);
        this.labelDescEstacaoIntegradora.setMaximumSize(dve);
        this.labelDescEstacaoIntegradora.setSize(dve);
        this.labelDescEstacaoIntegradora.setMinimumSize(dve);
        this.labelOperadoraOrigem.setPreferredSize(d);
        this.labelOperadoraOrigem.setSize(d);
        this.labelOperadoraOrigem.setMinimumSize(d);
        this.labelOperadoraOrigem.setMaximumSize(d);
        this.labelPrestadorOrigem.setPreferredSize(d);
        this.labelPrestadorOrigem.setSize(d);
        this.labelPrestadorOrigem.setMinimumSize(d);
        this.labelPrestadorOrigem.setMaximumSize(d);
        this.labelUsuarioLogin.setPreferredSize(d);
        this.labelUsuarioLogin.setSize(d);
        this.labelUsuarioLogin.setMinimumSize(d);
        this.labelUsuarioLogin.setMaximumSize(d);
        this.labelSenhaLogin.setPreferredSize(d);
        this.labelSenhaLogin.setSize(d);
        this.labelSenhaLogin.setMinimumSize(d);
        this.labelSenhaLogin.setMaximumSize(d);
        this.labelWebService.setPreferredSize(d);
        this.labelWebService.setSize(d);
        this.labelWebService.setMinimumSize(d);
        this.labelWebService.setMaximumSize(d);
    }

    private void dimensionarTexts() {
        Dimension de = new Dimension(100, 20);
        this.fieldCodEstacaoIntegradora.setPreferredSize(de);
        this.fieldCodEstacaoIntegradora.setMinimumSize(de);
        this.fieldCodEstacaoIntegradora.setSize(de);
        Dimension dt = new Dimension(375, 20);
        this.fieldOperadoraOrigem.setPreferredSize(dt);
        this.fieldOperadoraOrigem.setSize(dt);
        this.fieldOperadoraOrigem.setMinimumSize(dt);
        this.fieldPrestadorOrigem.setPreferredSize(dt);
        this.fieldPrestadorOrigem.setSize(dt);
        this.fieldPrestadorOrigem.setMinimumSize(dt);
        this.fieldUsuarioLogin.setPreferredSize(dt);
        this.fieldUsuarioLogin.setSize(dt);
        this.fieldUsuarioLogin.setMinimumSize(dt);
        this.fieldSenhaLogin.setPreferredSize(dt);
        this.fieldSenhaLogin.setSize(dt);
        this.fieldSenhaLogin.setMinimumSize(dt);
        this.fieldWebService.setPreferredSize(dt);
        this.fieldWebService.setSize(dt);
        this.fieldWebService.setMinimumSize(dt);
    }

    private void dimensionarBotoes() {
        Dimension db = new Dimension(20, 20);
        this.buttonEstacaoIntegradora.setPreferredSize(db);
        this.buttonEstacaoIntegradora.setMinimumSize(db);
        this.buttonEstacaoIntegradora.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstacaoIntegradora);
    }

    private void adicionarComponentes() {
        Integer gridWidth = 7;
        Integer gridWidthI = 1;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = gridWidthI;
        c.gridheight = 1;
        c.insets = new Insets(0, 1, 1, 0);
        c.gridy = 0;
        c.gridx = 0;
        this.panelCentral.add((Component)this.labelEstacaoIntegradora, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.fieldCodEstacaoIntegradora, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.buttonEstacaoIntegradora, c);
        ++c.gridx;
        c.gridwidth = 5;
        this.panelCentral.add((Component)this.labelDescEstacaoIntegradora, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelOperadoraOrigem, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.fieldOperadoraOrigem, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelPrestadorOrigem, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.fieldPrestadorOrigem, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelUsuarioLogin, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.fieldUsuarioLogin, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelSenhaLogin, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.fieldSenhaLogin, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelWebService, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.fieldWebService, c);
        ++c.gridy;
        c.gridx = 1;
        this.panelCentral.add((Component)this.checkEnviarResultadoSemNumeroGuia, c);
        ++c.gridy;
        c.gridx = 1;
        this.panelCentral.add((Component)this.checkRemoverZerosIniciais, c);
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.getPanelBotoesDireita(), "South");
    }

    private void adicionarAcoes() {
        this.buttonEstacaoIntegradora.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorIntegracaoOperadoraMKSaude.this.pesquisaEstacao();
            }
        });
        this.fieldCodEstacaoIntegradora.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    try {
                        ConfiguradorIntegracaoOperadoraMKSaude.this.pesquisaEstacao();
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(ConfiguradorIntegracaoOperadoraMKSaude.this, ex.getMessage(), ex.getStackTrace());
                    }
                }
            }
        });
        this.fieldCodEstacaoIntegradora.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block5: {
                    try {
                        try {
                            if (!Funcoes.textoVazio(ConfiguradorIntegracaoOperadoraMKSaude.this.fieldCodEstacaoIntegradora)) {
                                ConfiguradorIntegracaoOperadoraMKSaude.this.preencheEstacao();
                                break block5;
                            }
                            ConfiguradorIntegracaoOperadoraMKSaude.this.labelDescEstacaoIntegradora.setText("");
                        }
                        catch (NullPointerException nullException) {
                            ConfiguradorIntegracaoOperadoraMKSaude.this.labelDescEstacaoIntegradora.setText("");
                        }
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(ConfiguradorIntegracaoOperadoraMKSaude.this, ex.getMessage(), ex.getStackTrace());
                    }
                }
            }
        });
    }

    @Override
    protected boolean acaoOk() {
        if (this.camposPreenchidos()) {
            this.modelo.clear();
            String estacaoIntegradora = this.fieldCodEstacaoIntegradora.getText();
            String operadoraOrigem = this.fieldOperadoraOrigem.getText();
            String prestadorOrigem = this.fieldPrestadorOrigem.getText();
            String usuarioLogin = this.fieldUsuarioLogin.getText();
            String senhaLogin = this.fieldSenhaLogin.getText();
            String webService = this.fieldWebService.getText();
            String enviarResultadoSemNumeroGuia = this.checkEnviarResultadoSemNumeroGuia.isSelected() ? "true" : "false";
            String considerarZerosBeneficiario = this.checkRemoverZerosIniciais.isSelected() ? "true" : "false";
            this.modelo.addLine(new String[]{operadoraOrigem, prestadorOrigem, senhaLogin, usuarioLogin, webService, estacaoIntegradora, enviarResultadoSemNumeroGuia, considerarZerosBeneficiario});
            return true;
        }
        return false;
    }

    private boolean camposPreenchidos() {
        boolean preenchidos;
        boolean bl = preenchidos = !Funcoes.textoVazio(this.fieldCodEstacaoIntegradora) && !Funcoes.textoVazio(this.fieldOperadoraOrigem) && !Funcoes.textoVazio(this.fieldPrestadorOrigem) && !Funcoes.textoVazio(this.fieldSenhaLogin) && !Funcoes.textoVazio(this.fieldUsuarioLogin) && !Funcoes.textoVazio(this.fieldWebService);
        if (!preenchidos) {
            Funcoes.mensagem(this, "Todos os campos s\u00e3o de preenchimento obrigat\u00f3rio", 2);
        }
        return preenchidos;
    }

    public void setXML(String xmlConfig) {
        String[] lines;
        if (Funcoes.textoVazio(xmlConfig)) {
            return;
        }
        for (String line : lines = StringUtil.getValores(xmlConfig, TAG_EXAME_INTEGRACOES_INTEGRACAO_MKSA\u00daDE)) {
            String operadoraOrigem = StringUtil.getValor(line, CamposConfiguracao.OPERADORA_ORIGEM.getTag());
            String prestadorOrigem = StringUtil.getValor(line, CamposConfiguracao.PRESTADOR_ORIGEM.getTag());
            String usuarioLogin = StringUtil.getValor(line, CamposConfiguracao.USUARIO.getTag());
            String senhaLogin = StringUtil.getValor(line, CamposConfiguracao.SENHA.getTag());
            String webService = StringUtil.getValor(line, CamposConfiguracao.WEB_SERVICE.getTag());
            String estacao = StringUtil.getValor(line, CamposConfiguracao.ESTACAO_INTEGRADORA.getTag());
            String enviarResultadoSemNumeroGuia = StringUtil.getValor(line, CamposConfiguracao.ENVIAR_RESULTADO_SEM_NUMERO_GUIA.getTag());
            String considerarZerosBeneficiario = StringUtil.getValor(line, CamposConfiguracao.ZERO_INICIAIS_BENEFICIARIO.getTag());
            this.modelo.addLine(new String[]{operadoraOrigem, prestadorOrigem, senhaLogin, usuarioLogin, webService, estacao, enviarResultadoSemNumeroGuia, considerarZerosBeneficiario});
        }
        this.preencheCampos();
    }

    private void preencheCampos() {
        try {
            for (int i = this.modelo.getRowCount() - 1; i >= 0; --i) {
                this.fieldCodEstacaoIntegradora.setText(this.modelo.getValueAt(i, 5).toString());
                try {
                    if (!Funcoes.textoVazio(this.fieldCodEstacaoIntegradora)) {
                        String descEstacao = ((EstacaoVO)this.estacaoService.getVO(Variaveis.filialPadrao, this.fieldCodEstacaoIntegradora.getText())).getDescricao();
                        this.labelDescEstacaoIntegradora.setText(descEstacao);
                    }
                }
                catch (NullPointerException descEstacao) {
                    // empty catch block
                }
                this.fieldOperadoraOrigem.setText(this.modelo.getValueAt(i, 0).toString());
                this.fieldPrestadorOrigem.setText(this.modelo.getValueAt(i, 1).toString());
                this.fieldSenhaLogin.setText(this.modelo.getValueAt(i, 2).toString());
                this.fieldUsuarioLogin.setText(this.modelo.getValueAt(i, 3).toString());
                this.fieldWebService.setText(this.modelo.getValueAt(i, 4).toString());
                boolean enviarResultadosSemNumeroGuia = this.modelo.getValueAt(i, 6).toString().equals("true");
                boolean considerarZerosBeneficiario = this.modelo.getValueAt(i, 7).toString().equals("true");
                this.checkEnviarResultadoSemNumeroGuia.setSelected(enviarResultadosSemNumeroGuia);
                this.checkRemoverZerosIniciais.setSelected(considerarZerosBeneficiario);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_EXAME_INTEGRACOES_INTEGRACAO_MKSA\u00daDE);
            for (int i = this.modelo.getRowCount() - 1; i >= 0; --i) {
                xml.escrever(CamposConfiguracao.ESTACAO_INTEGRADORA.tag, this.modelo.getValueAt(i, 5).toString());
                xml.escrever(CamposConfiguracao.OPERADORA_ORIGEM.tag, this.modelo.getValueAt(i, 0).toString());
                xml.escrever(CamposConfiguracao.PRESTADOR_ORIGEM.tag, this.modelo.getValueAt(i, 1).toString());
                xml.escrever(CamposConfiguracao.SENHA.tag, this.modelo.getValueAt(i, 2).toString());
                xml.escrever(CamposConfiguracao.USUARIO.tag, this.modelo.getValueAt(i, 3).toString());
                xml.escrever(CamposConfiguracao.WEB_SERVICE.tag, this.modelo.getValueAt(i, 4).toString());
                xml.escrever(CamposConfiguracao.ENVIAR_RESULTADO_SEM_NUMERO_GUIA.tag, this.modelo.getValueAt(i, 6).toString());
                xml.escrever(CamposConfiguracao.ZERO_INICIAIS_BENEFICIARIO.tag, this.modelo.getValueAt(i, 7).toString());
            }
            xml.fechar(TAG_EXAME_INTEGRACOES_INTEGRACAO_MKSA\u00daDE);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar o XML de configura\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    private void pesquisaEstacao() {
        EstacaoVO estacaoVO = (EstacaoVO)this.estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.fieldCodEstacaoIntegradora.setText(estacaoVO.getCodigo().toString());
            this.labelDescEstacaoIntegradora.setText(estacaoVO.getDescricao());
        }
    }

    private void preencheEstacao() throws Exception {
        EstacaoVO estacao = (EstacaoVO)this.estacaoService.getVO(Variaveis.filialPadrao, this.fieldCodEstacaoIntegradora.getText());
        this.labelDescEstacaoIntegradora.setText(estacao.getDescricao());
    }

    public static ConfiguradorIntegracaoOperadoraMKSaude novaInstancia(Window parent) {
        String titulo = "Configurando MKSa\u00fade";
        return parent instanceof Dialog ? new ConfiguradorIntegracaoOperadoraMKSaude((Dialog)parent, titulo) : new ConfiguradorIntegracaoOperadoraMKSaude((Frame)parent, titulo);
    }

    static enum CamposConfiguracao {
        OPERADORA_ORIGEM("Operadora Origem", "operadoraOrigem"),
        PRESTADOR_ORIGEM("Prestador Origem", "prestadorOrigem"),
        USUARIO("Usuario (login)", "usuario"),
        SENHA("Senha (login)", "senha"),
        WEB_SERVICE("Web Service", "webService"),
        ESTACAO_INTEGRADORA("Esta\u00e7\u00e3o integradora", "estacao"),
        ENVIAR_RESULTADO_SEM_NUMERO_GUIA("Enviar resultados dos procedimentos sem o N\u00ba da Guia", "enviarSemGuiaOperadora"),
        ZERO_INICIAIS_BENEFICIARIO("Considerar os zeros iniciais do cart\u00e3o do benefici\u00e1rio.", "considerarZerosBeneficiario");

        private String descricao;
        private String tag;

        private CamposConfiguracao(String descricao, String tag) {
            this.descricao = descricao;
            this.tag = tag;
        }

        public String toString() {
            return this.descricao;
        }

        public String getTag() {
            return this.tag;
        }

        static /* synthetic */ String access$000(CamposConfiguracao x0) {
            return x0.descricao;
        }
    }
}

