/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.ipmsaude;

import atende.net.IdentificacaoRequisicao;
import atende.net.IdentificacaoResultado;
import atende.net.InformacoesListaResultados;
import atende.net.InformacoesRetornoRequisicao;
import atende.net.InformacoesRetornoResultado;
import atende.net.RetornoErro;
import atende.net.SAUIntegraLaboratorioLocator;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.ipmsaude.IPMSaudeDao;
import jalis.integracaooperadoras.sistemas.ipmsaude.models.IPMSaudeVO;
import jalis.integracaooperadoras.sistemas.ipmsaude.models.OperacaoIPMSaude;
import jalis.integracaooperadoras.sistemas.ipmsaude.models.RetornoIPMSaudeVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.commons.codec.digest.DigestUtils;

public class IPMSaudeService {
    private static final String TAG_EXPORTACAO_INTEGRACAO_OPERADORA = "integracaooperadora";
    private static final String TAG_EXPORTACAO_NOME_INTEGRACAO = "nomeintegracaooperadora";
    private IPMSaudeDao dao = new IPMSaudeDao();
    private boolean debug = true;

    public ArrayList<LogIntegracaoOperadora> buscaLogs(String codigoConvenio) throws IntegracaoOperadoraException {
        ArrayList<LogIntegracaoOperadora> lista = null;
        try {
            lista = this.dao.buscaLogs(codigoConvenio);
        }
        catch (SQLException e) {
            throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel buscar os logs de integra\u00e7\u00e3o.\n" + e.getMessage(), " buscando logs de integra\u00e7\u00e3o", null);
        }
        return lista;
    }

    public List<LogIntegracaoOperadora> enviarResultado(String codigoConvenio, String xmlConfiguracao) throws IntegracaoOperadoraException {
        IPMSaudeVO ipmSaudeVO = new IPMSaudeVO();
        if (!Funcoes.textoVazio(xmlConfiguracao)) {
            String codigoCnes = null;
            Integer codigoProfissional = null;
            boolean enviarLaudoEmImagem = false;
            if (!Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracao, "cnes"))) {
                codigoCnes = StringUtil.getValor(xmlConfiguracao, "cnes");
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracao, "codigo"))) {
                codigoProfissional = Integer.parseInt(StringUtil.getValor(xmlConfiguracao, "codigo"));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracao, "enviarLaudoEmImagem"))) {
                enviarLaudoEmImagem = StringUtil.getBoolean(StringUtil.getValor(xmlConfiguracao, "enviarLaudoEmImagem"));
            }
            if (codigoCnes != null) {
                ipmSaudeVO.setCnes(codigoCnes);
            }
            ipmSaudeVO.setChaveIntegracao(StringUtil.getValor(xmlConfiguracao, "chave"));
            ipmSaudeVO.setUrl(StringUtil.getValor(xmlConfiguracao, "enderecoWebService"));
            if (codigoProfissional != null) {
                ipmSaudeVO.setCodigoProfissional(codigoProfissional);
            }
            ipmSaudeVO.setNomeProfissional(StringUtil.getValor(xmlConfiguracao, "nome"));
            ipmSaudeVO.setCpfProfissional(StringUtil.getValor(xmlConfiguracao, "cpf"));
            ipmSaudeVO.setCnsProfissional(StringUtil.getValor(xmlConfiguracao, "cns"));
            ipmSaudeVO.setConselhoTipoProfissional(StringUtil.getValor(xmlConfiguracao, "conselho"));
            ipmSaudeVO.setConselhoNumeroProfissional(StringUtil.getValor(xmlConfiguracao, "numero"));
            ipmSaudeVO.setConselhoEstadoProfisisonal(StringUtil.getValor(xmlConfiguracao, "estado"));
            ipmSaudeVO.setCbosProfissional(StringUtil.getValor(xmlConfiguracao, "cbos"));
            ipmSaudeVO.setSexoProfissional(StringUtil.getValor(xmlConfiguracao, "sexo"));
            ipmSaudeVO.setEnviarCabecalhoLaudo(StringUtil.getValor(xmlConfiguracao, "enviaCabecalhoLaudo"));
            ipmSaudeVO.setEnviarLaudoEmImagem(enviarLaudoEmImagem);
        }
        ArrayList<LogIntegracaoOperadora> listaLogs = this.buscaLogs(codigoConvenio);
        List<OperacaoIPMSaude> listaOperacoes = new ArrayList<OperacaoIPMSaude>();
        ArrayList<LogIntegracaoOperadora> erros = new ArrayList<LogIntegracaoOperadora>();
        for (LogIntegracaoOperadora logIntegracaoOperadora : listaLogs) {
            if (logIntegracaoOperadora.getTipoOperacao() != AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO) continue;
            try {
                listaOperacoes = this.dao.buscarResultados(logIntegracaoOperadora, listaOperacoes);
            }
            catch (IntegracaoOperadoraException e) {
                logIntegracaoOperadora.setRetorno(e.getMensagemErro());
                logIntegracaoOperadora.setSituacao("N");
                erros.add(logIntegracaoOperadora);
            }
        }
        if (!listaOperacoes.isEmpty()) {
            try {
                ArrayList<RetornoIPMSaudeVO> listaRetornos = new ArrayList<RetornoIPMSaudeVO>();
                SAUIntegraLaboratorioLocator sauILL = new SAUIntegraLaboratorioLocator();
                for (OperacaoIPMSaude operacaoIPMSaude : listaOperacoes) {
                    LogIntegracaoOperadora lio = operacaoIPMSaude.getLogIntegracaoOperadora();
                    this.debug("Enviando F " + lio.getCodigoFilial() + " R " + lio.getCodigoRequisicao() + " E " + lio.getCodigoExame() + " M " + lio.getCodigoMaterial());
                    InformacoesRetornoResultado informacoesRetornoResultado = null;
                    IdentificacaoResultado identificacaoResultado = new IdentificacaoResultado();
                    identificacaoResultado.setChave(this.chaveAcesso(ipmSaudeVO.getCnes(), ipmSaudeVO.getChaveIntegracao()));
                    identificacaoResultado.setCnesprestador(ipmSaudeVO.getCnes());
                    identificacaoResultado.setListaresultados(new InformacoesListaResultados[]{operacaoIPMSaude.getInformacoesListaResultados()});
                    informacoesRetornoResultado = sauILL.getSAUIntegraLaboratorioPort(new URL(ipmSaudeVO.getUrl())).setResultado(identificacaoResultado);
                    System.out.println("=================");
                    System.out.println("Resultado:: " + operacaoIPMSaude.getInformacoesListaResultados().getResultado());
                    if (this.debug) {
                        System.out.println("========");
                        System.out.println("informacoesRetornoResultado: " + informacoesRetornoResultado);
                        System.out.println("informacoesRetornoResultado.getRetorno: " + informacoesRetornoResultado.getRetorno());
                        System.out.println("========");
                        System.out.println("requisicao: " + operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoRequisicao() + " / retorno ==== " + informacoesRetornoResultado != null && !Funcoes.textoVazio(informacoesRetornoResultado.getRetorno()) ? informacoesRetornoResultado.getRetorno() : "infomacoes nulas");
                    }
                    RetornoErro[] arrayRetorno = informacoesRetornoResultado.getErro();
                    boolean isRetornoCodigo28 = false;
                    if (arrayRetorno != null) {
                        for (RetornoErro retorno : arrayRetorno) {
                            System.out.println("ERRO: " + retorno.getDescricao() + "/ " + retorno.getId());
                            isRetornoCodigo28 = retorno.getId().contains("28");
                        }
                    }
                    if (Funcoes.objectIsNull(informacoesRetornoResultado.getErro()) || isRetornoCodigo28) {
                        RetornoIPMSaudeVO retornoIPMSaudeVO = new RetornoIPMSaudeVO();
                        retornoIPMSaudeVO.setInformacoesRetornoResultado(informacoesRetornoResultado);
                        if (isRetornoCodigo28) {
                            retornoIPMSaudeVO.getInformacoesRetornoResultado().setRetorno("Laudo do exame j\u00e1 registrado na IPM.");
                        }
                        retornoIPMSaudeVO.setOperacaoIPMSaude(operacaoIPMSaude);
                        listaRetornos.add(retornoIPMSaudeVO);
                        LogIntegracaoOperadora log = this.logAtual(listaLogs, operacaoIPMSaude, erros);
                        if (log == null) continue;
                        this.dao.rejeitarErro(log, "R", "Laudo do exame j\u00e1 registrado na IPM.");
                        continue;
                    }
                    LogIntegracaoOperadora log = this.logAtual(listaLogs, operacaoIPMSaude, erros);
                    if (!Funcoes.objectIsNull(log)) {
                        StringBuilder mensagemRetorno = new StringBuilder("");
                        if (log != null) {
                            log.setSituacao("R");
                        }
                        for (RetornoErro retornoErro : informacoesRetornoResultado.getErro()) {
                            if (!mensagemRetorno.toString().isEmpty()) {
                                mensagemRetorno.append("\n");
                            }
                            mensagemRetorno.append("(").append(retornoErro.getId()).append(") ").append(retornoErro.getDescricao());
                            if (retornoErro.getId().contains("25") && operacaoIPMSaude.getInformacoesListaResultados().getResultado().isEmpty()) {
                                mensagemRetorno.append("\nProblemas ao converter o resultado para o padr\u00e3o da integradora.");
                            }
                            if (!mensagemRetorno.toString().contains("9") || !mensagemRetorno.toString().contains("10")) continue;
                            mensagemRetorno = new StringBuilder("O Exame n\u00e3o foi encontrado na base de dados da integradora. \n").append((CharSequence)mensagemRetorno);
                        }
                        log.setRetorno(mensagemRetorno.toString());
                    }
                    if (log != null) {
                        this.dao.salvarErro(log, log.getSituacao(), log.getRetorno());
                    }
                    erros.add(log);
                }
                List<LogIntegracaoOperadora> logs = this.dao.atualizarLogs(listaRetornos, codigoConvenio);
                logs.addAll(erros);
                return logs;
            }
            catch (SQLException e) {
                throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel salvar as informa\u00e7\u00f5es recebidas!", "comunica\u00e7\u00e3o com integradora", null);
            }
            catch (RemoteException | ServiceException e) {
                StringBuilder erro = new StringBuilder("A comunica\u00e7\u00e3o com a integradora n\u00e3o foi realizada! \n");
                if (e.getMessage().contains("envelope tag")) {
                    erro.append("Link do web service inv\u00e1lido.\n");
                    erro.append("Verifique o endere\u00e7o informado para integra\u00e7\u00e3o.");
                } else {
                    erro.append(e.getMessage());
                }
                throw new IntegracaoOperadoraException((Exception)e, erro.toString(), "comunica\u00e7\u00e3o com integradora", null);
            }
            catch (MalformedURLException e) {
                throw new IntegracaoOperadoraException(e, "A comunica\u00e7\u00e3o com a integradora n\u00e3o foi realizada! \nLink do web service inv\u00e1lido.\nVerifique o endere\u00e7o informado para integra\u00e7\u00e3o.", "comunica\u00e7\u00e3o com integradora", null);
            }
        }
        if (listaOperacoes.isEmpty() && !erros.isEmpty()) {
            return erros;
        }
        return null;
    }

    public void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        if (!this.dao.isConvenioUtilizaIntegracaoOperadora(filial, convenio)) {
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXPORTACAO_INTEGRACAO_OPERADORA);
        xml.escrever(TAG_EXPORTACAO_NOME_INTEGRACAO, protocolo.getDescricao());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        try {
            xml.fechar(TAG_EXPORTACAO_INTEGRACAO_OPERADORA);
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        this.dao.insereIntegracaoOperadora(protocolo, filial, convenio, codigoRequsicao, codigoPaciente, codigoExame, codigoMaterial, tipoOperacao, xml);
    }

    public Registro getInformacaoRequisicao(String codigoFilial, String codigoRequisicao) {
        return this.dao.getInformacaoRequisicao(codigoFilial, codigoRequisicao);
    }

    private LogIntegracaoOperadora logAtual(ArrayList<LogIntegracaoOperadora> listaLogs, OperacaoIPMSaude operacaoIPMSaude, List<LogIntegracaoOperadora> erros) {
        for (LogIntegracaoOperadora lio : listaLogs) {
            if (!operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoRequisicao().toString().equals(String.valueOf(lio.getCodigoRequisicao())) || !operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoFilial().toString().equals(String.valueOf(lio.getCodigoFilial())) || !operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoExame().equals(lio.getCodigoExame()) || !operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoMaterial().toString().equals(String.valueOf(lio.getCodigoMaterial())) || erros.contains(lio)) continue;
            return lio;
        }
        return null;
    }

    private String md5(String chaveAcesso) {
        return DigestUtils.md5Hex((String)chaveAcesso);
    }

    private String chaveAcesso(String CNES, String chave) {
        StringBuilder buf = new StringBuilder(CNES);
        buf.append("-").append(chave).append("-").append(Funcoes.formataData("ddMMyyyy", new Date())).append("-IPM");
        return this.md5(buf.toString());
    }

    public IPMSaudeVO getConvenioUtilizaIntegracaoOperadora(String codigoFilial, String codigoConvenio) {
        return this.dao.getConvenioUtilizaIntegracaoOperadora(codigoFilial, codigoConvenio);
    }

    public InformacoesRetornoRequisicao consultaRequisicao(String codigoFilial, String codigoConvenio, String[] metodo) throws RemoteException, ServiceException, MalformedURLException {
        IPMSaudeVO ipmSaudeVO = this.getConvenioUtilizaIntegracaoOperadora(codigoFilial, codigoConvenio);
        Integer requisicao = null;
        if (!metodo[0].isEmpty()) {
            requisicao = Integer.parseInt(metodo[0]);
        }
        IdentificacaoRequisicao identificacaoRequisicao = new IdentificacaoRequisicao();
        identificacaoRequisicao.setChave(this.chaveAcesso(ipmSaudeVO.getCnes(), ipmSaudeVO.getChaveIntegracao()));
        identificacaoRequisicao.setCnesprestador(String.valueOf(ipmSaudeVO.getCnes()));
        identificacaoRequisicao.setCodrequis(requisicao);
        identificacaoRequisicao.setClientecpf(metodo[1]);
        identificacaoRequisicao.setClientecns(metodo[2]);
        SAUIntegraLaboratorioLocator sauILL = new SAUIntegraLaboratorioLocator();
        sauILL.setSAUIntegraLaboratorioPortEndpointAddress(ipmSaudeVO.getUrl());
        return sauILL.getSAUIntegraLaboratorioPort().getRequisicao(identificacaoRequisicao);
    }

    private void debug(String mensagem) {
        if (this.debug) {
            System.out.println(mensagem);
        }
    }
}

