/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.ipmsaude;

import atende.net.InformacoesListaResultados;
import atende.net.InformacoesProfissional;
import br.com.thread.openpdf.text.html.HtmlEncoder;
import jalis.comum.CBOS;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.ipmsaude.models.IPMSaudeVO;
import jalis.integracaooperadoras.sistemas.ipmsaude.models.OperacaoIPMSaude;
import jalis.integracaooperadoras.sistemas.ipmsaude.models.RetornoIPMSaudeVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ConteudoTextoResultado;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class IPMSaudeDao {
    public static final String PROCESSO_MONTA_LINHA = "montando linha de resultado";
    private static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final String CAMINHO_USUARIO = System.getProperty("user.home");
    private static final String CAMINHO_RESULTADO_IPM = CAMINHO_USUARIO + File.separator + "resultadosipm";
    private static final String EXTENSAO_ARQUIVO = ".html";

    public ArrayList<LogIntegracaoOperadora> buscaLogs(String codigoConvenio) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
        buf.append("   from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("    and con_codigo = ").append(codigoConvenio);
        buf.append("    and (eio_situacao = '' or  eio_situacao is null)  ");
        buf.append("  order by eio_codigo limit 100 ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        ArrayList<LogIntegracaoOperadora> listaLogs = null;
        if (!Funcoes.objectIsNull(rs) && rs.next()) {
            listaLogs = new ArrayList<LogIntegracaoOperadora>();
            do {
                String operacao = rs.getString("operacao");
                Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(operacao, "codreq"));
                String codigoExame = StringUtil.getValor(operacao, "codexa");
                Integer codigoMaterial = Integer.parseInt(StringUtil.getValor(operacao, "codmat"));
                LogIntegracaoOperadora log = new LogIntegracaoOperadora();
                log.setCodigoFilial(rs.getInt("codigoFilial"));
                log.setCodigoLog(rs.getLong("codigoLog"));
                log.setCodigoConvenio(rs.getInt("codigoConvenio"));
                log.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(rs.getString("tipoOperacao")));
                log.setRetorno(rs.getString("retorno"));
                log.setSituacao(rs.getString("situacao"));
                log.setCodigoRequisicao(codigoRequisicao);
                log.setCodigoExame(codigoExame);
                log.setCodigoMaterial(codigoMaterial);
                log.setXmlLog(operacao);
                listaLogs.add(log);
            } while (rs.next());
        }
        return listaLogs;
    }

    public List<OperacaoIPMSaude> buscarResultados(LogIntegracaoOperadora logIntegracaoOperadora, List<OperacaoIPMSaude> listaOperacoes) throws IntegracaoOperadoraException {
        StringBuilder bui = new StringBuilder();
        bui.append("select");
        bui.append(" req.req_codigoipm as codigo,");
        bui.append(" exr.exr_codigoipm as idproced,");
        bui.append(" dtp.dtp_codamb as proced,");
        bui.append(" exr.exr_guia as codigoagenda,");
        bui.append(" exr.exr_dataassina as dataliberacao,");
        bui.append(" case when exa.exa_proibidowebconvenio is true then 1 else 2 end as restrito,");
        bui.append(" ert.ert_resultado as resultado,");
        bui.append(" exr.exr_situacao as situacao");
        bui.append(" from examerequisicaoresultado ert");
        bui.append(" left join requisicao req on req.fil_codigo = ert.fil_codigo and ert.req_codigo = req.req_codigo");
        bui.append(" left join examerequisicao exr on exr.fil_codigo = ert.fil_codigo and ert.req_codigo = exr.req_codigo and exr.exa_codigo = ert.exa_codigo and ert.mco_codigo = exr.mco_codigo");
        bui.append(" left join exames exa on exa.fil_codigo = ert.fil_codigo and   exa.exa_codigo = ert.exa_codigo");
        bui.append(" left join convenios con on exa.fil_codigo = con.fil_codigo and con.con_codigo = req.con_codigo");
        bui.append(" left join tabelaprecoexames tpe on tpe.fil_codigo = con.fil_codigo and con.tpe_codigo = tpe.tpe_codigo");
        bui.append(" left join detalhetabelapreco dtp on tpe.fil_codigo = dtp.fil_codigo and dtp.tpe_codigo = tpe.tpe_codigo and ert.exa_codigo = dtp.exa_codigo and ert.mco_codigo = dtp.mco_codigo");
        bui.append(" where ert.fil_codigo = ").append(logIntegracaoOperadora.getCodigoFilial());
        bui.append(" and ert.req_codigo = ").append(logIntegracaoOperadora.getCodigoRequisicao());
        bui.append(" and exr.exa_codigo = '").append(logIntegracaoOperadora.getCodigoExame()).append("'");
        Statement stResultado = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(stResultado, bui);
            IPMSaudeVO ipmSaudeVO = this.getConvenioUtilizaIntegracaoOperadora(String.valueOf(logIntegracaoOperadora.getCodigoFilial()), String.valueOf(logIntegracaoOperadora.getCodigoConvenio()));
            InformacoesProfissional informacoesProfissional = new InformacoesProfissional();
            informacoesProfissional.setProfcod(Integer.valueOf(ipmSaudeVO.getCodigoProfissional()));
            informacoesProfissional.setProfnome(ipmSaudeVO.getNomeProfissional());
            informacoesProfissional.setProfcpf(ipmSaudeVO.getCpfProfissional());
            informacoesProfissional.setProfcns(ipmSaudeVO.getCnsProfissional());
            informacoesProfissional.setProfcbo(CBOS.getDescCBO((String)ipmSaudeVO.getCbosProfissional()).codigo.replace(".", ""));
            informacoesProfissional.setProfsexo(ipmSaudeVO.getSexoProfissional());
            informacoesProfissional.setNumconselho(ipmSaudeVO.getConselhoNumeroProfissional());
            while (rs.next()) {
                String situacao = rs.getString("situacao");
                if (!situacao.equals("C") && !situacao.equals("I") && !situacao.equals("E")) continue;
                String procedID = rs.getString("proced");
                if (!Funcoes.textoVazio(procedID)) {
                    procedID = procedID.replace(".", "").replace("-", "").trim();
                }
                RetornoImpressaoResultados retornoImpressao = ImpressaoResultados.imprimirExames(null, null, String.valueOf(logIntegracaoOperadora.getCodigoFilial()), String.valueOf(logIntegracaoOperadora.getCodigoRequisicao()), true, true, null, new String[]{logIntegracaoOperadora.getCodigoExame()}, new String[]{String.valueOf(logIntegracaoOperadora.getCodigoMaterial())}, true, null, true, true, null, false, "", true, false);
                String resultado = this.processaHTML(logIntegracaoOperadora, ipmSaudeVO.getEnviarCabecalhoLaudo(), ipmSaudeVO.isEnviarLaudoEmImagem(), retornoImpressao);
                System.out.println("resultado===========");
                System.out.println(resultado);
                if (DEBUG) {
                    String nomeArquivo = String.format("%s-%s(%s-%s)", logIntegracaoOperadora.getCodigoExame(), logIntegracaoOperadora.getCodigoMaterial(), logIntegracaoOperadora.getCodigoFilial(), logIntegracaoOperadora.getCodigoRequisicao());
                    IPMSaudeDao.salvarArquivo(resultado.replace("<![CDATA[", "").replace("]]>", ""), nomeArquivo);
                }
                Integer codigoAgenda = null;
                if (!Funcoes.textoVazio(rs.getString("codigoagenda"))) {
                    codigoAgenda = rs.getInt("codigoagenda");
                }
                InformacoesListaResultados informacoesListaResultados = new InformacoesListaResultados();
                informacoesListaResultados.setCodrequis(Integer.valueOf(rs.getInt("codigo")));
                informacoesListaResultados.setIdproced(Integer.valueOf(rs.getInt("idproced")));
                informacoesListaResultados.setProced(procedID);
                informacoesListaResultados.setCodagenda(codigoAgenda);
                informacoesListaResultados.setDtliberacao(Funcoes.formataData("dd/MM/yyyy", new Date(rs.getTimestamp("dataliberacao").getTime())));
                informacoesListaResultados.setRestrito(Integer.valueOf(rs.getInt("restrito")));
                informacoesListaResultados.setProfliberador(informacoesProfissional);
                informacoesListaResultados.setResultado(resultado);
                if (ipmSaudeVO.isEnviarLaudoEmImagem() && !Funcoes.textoVazio(retornoImpressao.getAssinaturaUsuarioConferencia())) {
                    informacoesListaResultados.setImagembase64("data:image/png;base64," + retornoImpressao.getAssinaturaUsuarioConferencia());
                }
                OperacaoIPMSaude operacaoIPMSaude = new OperacaoIPMSaude();
                operacaoIPMSaude.setLogIntegracaoOperadora(logIntegracaoOperadora);
                operacaoIPMSaude.setInformacoesListaResultados(informacoesListaResultados);
                listaOperacoes.add(operacaoIPMSaude);
            }
        }
        catch (Exception e) {
            throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel buscar resultado", "buscaresultado", logIntegracaoOperadora);
        }
        return listaOperacoes;
    }

    private static void salvarArquivo(String html, String nomeArquivo) {
        try {
            String data;
            Path dateDir;
            Path resultadoDiretorio = Paths.get(CAMINHO_RESULTADO_IPM, new String[0]);
            if (!Files.exists(resultadoDiretorio, new LinkOption[0])) {
                Files.createDirectory(resultadoDiretorio, new FileAttribute[0]);
            }
            if (!Files.exists(dateDir = resultadoDiretorio.resolve(data = new SimpleDateFormat("yyyy-MM-dd").format(new Date())), new LinkOption[0])) {
                Files.createDirectory(dateDir, new FileAttribute[0]);
            }
            Path filePath = dateDir.resolve(nomeArquivo + EXTENSAO_ARQUIVO);
            try (BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);){
                writer.write(html);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<LogIntegracaoOperadora> atualizarLogs(List<RetornoIPMSaudeVO> listaRetornos, String codigoConvenio) throws IntegracaoOperadoraException, SQLException {
        ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
        if (!Funcoes.objectIsNull(listaRetornos)) {
            for (RetornoIPMSaudeVO retorno : listaRetornos) {
                LogIntegracaoOperadora log = this.buscarLog(retorno.getOperacaoIPMSaude());
                if (Funcoes.objectIsNull(log) || !log.getCodigoRequisicao().toString().equals(retorno.getOperacaoIPMSaude().getLogIntegracaoOperadora().getCodigoRequisicao().toString())) continue;
                log.setCodigoExame(retorno.getOperacaoIPMSaude().getLogIntegracaoOperadora().getCodigoExame());
                log.setCodigoMaterial(retorno.getOperacaoIPMSaude().getLogIntegracaoOperadora().getCodigoMaterial());
                log.setRetorno(retorno.getInformacoesRetornoResultado().getRetorno());
                log.setSituacao(Funcoes.textoVazio(retorno.getInformacoesRetornoResultado().getRetorno()) ? "R" : "E");
                listaLogs.add(log);
                this.salvarErro(log, log.getSituacao(), log.getRetorno());
            }
        }
        return listaLogs;
    }

    public LogIntegracaoOperadora buscarLog(OperacaoIPMSaude operacaoIPMSaude) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,exa_codigo as codigoExame ");
        buf.append("       ,mco_codigo as codigoMaterial ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
        buf.append("   from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("    and fil_codigo = ").append(operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoFilial());
        buf.append("    and con_codigo = ").append(operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoConvenio());
        buf.append("   and eio_operacao ilike '%").append(operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoRequisicao()).append("%'");
        buf.append("   and eio_operacao ilike '%").append(operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoExame()).append("%'");
        buf.append("   and eio_operacao ilike '%").append(operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoMaterial()).append("%'");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        LogIntegracaoOperadora log = null;
        while (rs.next()) {
            String codigoRequisicao = StringUtil.getValor(rs.getString("operacao"), "codreq");
            String codigoExame = StringUtil.getValor(rs.getString("operacao"), "codexa");
            String codigoMaterial = StringUtil.getValor(rs.getString("operacao"), "codmat");
            if (!operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoRequisicao().equals(Integer.valueOf(codigoRequisicao))) continue;
            log = new LogIntegracaoOperadora();
            log.setCodigoFilial(rs.getInt("codigoFilial"));
            log.setCodigoConvenio(rs.getInt("codigoConvenio"));
            log.setCodigoLog(rs.getInt("codigoLog"));
            log.setCodigoRequisicao(Integer.valueOf(codigoRequisicao));
            if (codigoExame.equals(operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoExame()) && codigoMaterial.equals(operacaoIPMSaude.getLogIntegracaoOperadora().getCodigoMaterial().toString())) {
                log.setCodigoExame(codigoExame);
                log.setCodigoMaterial(Integer.valueOf(codigoMaterial));
            }
            log.setXmlLog(rs.getString("operacao"));
            log.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(rs.getString("tipoOperacao")));
        }
        return log;
    }

    public void salvarErro(LogIntegracaoOperadora logs, String status, String retornoOperacao) throws IntegracaoOperadoraException, SQLException {
        StringBuilder sql = new StringBuilder();
        String statusRetorno = status.equals("E") ? "t" : "f";
        String filial = logs.getCodigoFilial().toString();
        sql.append("update exportaintegracaooperadora set eio_situacao = '").append(status).append("'");
        sql.append(", eio_retorno = '").append(retornoOperacao).append("'");
        sql.append(", eio_exportado = '").append(statusRetorno).append("'");
        sql.append(", req_codigo = '").append(logs.getCodigoRequisicao()).append("'");
        if (!Funcoes.textoVazio(logs.getCodigoExame())) {
            sql.append(", exa_codigo = '").append(logs.getCodigoExame()).append("'");
        }
        if (!Funcoes.objectIsNull(logs.getCodigoMaterial())) {
            sql.append(", mco_codigo = '").append(logs.getCodigoMaterial()).append("'");
        }
        sql.append(" where eio_codigo in (");
        sql.append(logs.getCodigoLog());
        sql.append(") ");
        sql.append("and fil_codigo = ").append(filial);
        Statement st = Conexao.getStatement();
        Conexao.execute(filial, st, sql.toString());
        Conexao.arquivaSQL();
    }

    public void rejeitarErro(LogIntegracaoOperadora logs, String status, String retornoOperacao) throws IntegracaoOperadoraException, SQLException {
        StringBuilder sql = new StringBuilder();
        String filial = logs.getCodigoFilial().toString();
        sql.append("update exportaintegracaooperadora set eio_situacao = '").append(status).append("'");
        sql.append(", eio_retorno = '").append(retornoOperacao).append("'");
        sql.append(", eio_exportado = true");
        sql.append(", req_codigo = '").append(logs.getCodigoRequisicao()).append("'");
        if (!Funcoes.textoVazio(logs.getCodigoExame())) {
            sql.append(", exa_codigo = '").append(logs.getCodigoExame()).append("'");
        }
        if (!Funcoes.objectIsNull(logs.getCodigoMaterial())) {
            sql.append(", mco_codigo = '").append(logs.getCodigoMaterial()).append("'");
        }
        sql.append(" where eio_codigo in (");
        sql.append(logs.getCodigoLog());
        sql.append(") ");
        sql.append("and fil_codigo = ").append(filial);
        Statement st = Conexao.getStatement();
        Conexao.execute(filial, st, sql.toString());
        Conexao.arquivaSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConvenioUtilizaIntegracaoOperadora(String codigoFilial, String codigoConvenio) {
        boolean bl;
        Statement st;
        block5: {
            StringBuilder buf = new StringBuilder();
            buf.append(" select NULLIF(TRIM(con_integracaooperadora), '') IS NOT NULL as configurado ");
            buf.append("   from convenios ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and con_codigo = ").append(codigoConvenio);
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (!rs.next()) break block5;
            boolean bl2 = rs.getBoolean("configurado");
            Conexao.fecharStatement(st);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se o conv\u00eanio " + codigoConvenio + " utiliza integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, XMLStringBuilder xml) {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append("(fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(filial);
        buf.append(" ,").append(convenio);
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(filial)).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(codigoRequsicao);
        buf.append(" , ").append(codigoPaciente);
        buf.append(" , '").append(codigoExame).append("'");
        buf.append(" , ").append(codigoMaterial).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(filial, st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPMSaudeVO getConvenioUtilizaIntegracaoOperadora(String codigoFilial, String codigoConvenio) {
        IPMSaudeVO iPMSaudeVO;
        IPMSaudeVO ipmSaudeVO = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_integracaooperadora as configuracao ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and con_codigo = ").append(codigoConvenio);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                String xml = rs.getString("configuracao");
                boolean enviarLaudoEmImagem = false;
                if (!Funcoes.textoVazio(StringUtil.getValor(xml, "enviarLaudoEmImagem"))) {
                    enviarLaudoEmImagem = StringUtil.getBoolean(StringUtil.getValor(xml, "enviarLaudoEmImagem"));
                }
                if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
                    ipmSaudeVO = new IPMSaudeVO();
                    ipmSaudeVO.setCnes(StringUtil.getValor(xml, "cnes"));
                    ipmSaudeVO.setChaveIntegracao(StringUtil.getValor(xml, "chave"));
                    ipmSaudeVO.setUrl(StringUtil.getValor(xml, "enderecoWebService"));
                    ipmSaudeVO.setCodigoProfissional(Integer.parseInt(StringUtil.getValor(xml, "codigo")));
                    ipmSaudeVO.setNomeProfissional(StringUtil.getValor(xml, "nome"));
                    ipmSaudeVO.setCpfProfissional(StringUtil.getValor(xml, "cpf"));
                    ipmSaudeVO.setCnsProfissional(StringUtil.getValor(xml, "cns"));
                    ipmSaudeVO.setConselhoTipoProfissional(StringUtil.getValor(xml, "conselho"));
                    ipmSaudeVO.setConselhoNumeroProfissional(StringUtil.getValor(xml, "numero"));
                    ipmSaudeVO.setConselhoEstadoProfisisonal(StringUtil.getValor(xml, "estado"));
                    ipmSaudeVO.setCbosProfissional(StringUtil.getValor(xml, "cbos"));
                    ipmSaudeVO.setSexoProfissional(StringUtil.getValor(xml, "sexo"));
                    ipmSaudeVO.setEnviarCabecalhoLaudo(StringUtil.getValor(xml, "enviaCabecalhoLaudo"));
                    ipmSaudeVO.setEnviarLaudoEmImagem(enviarLaudoEmImagem);
                }
            }
            iPMSaudeVO = ipmSaudeVO;
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se o conv\u00eanio " + codigoConvenio + " utiliza integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return null;
        }
        Conexao.fecharStatement(st);
        return iPMSaudeVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registro getInformacaoRequisicao(String codigoFilial, String codigoRequisicao) {
        Registro dadosRequisicao = null;
        StringBuilder buf = new StringBuilder("");
        if (!(Funcoes.objectIsNull(codigoFilial) || Funcoes.objectIsNull(codigoRequisicao) || codigoFilial.isEmpty() || codigoRequisicao.isEmpty())) {
            Statement st;
            block6: {
                buf.append(" select req_guia, req_codigoipm, exr_codigoipm from requisicao r ");
                buf.append(" join examerequisicao er on r.fil_codigo = er.fil_codigo and r.req_codigo = er.req_codigo ");
                buf.append(" where r.fil_codigo = ").append(codigoFilial).append(" and r.req_codigo = ").append(codigoRequisicao);
                st = Conexao.getStatement();
                try {
                    ResultSet rs = Conexao.executeQuery(st, buf);
                    if (!rs.next()) break block6;
                    dadosRequisicao = new Registro(rs);
                    if (Funcoes.objectIsNull(rs.getObject("req_codigoipm"))) {
                        dadosRequisicao.setValor("req_codigoipm", "");
                    }
                    if (!Funcoes.objectIsNull(rs.getObject("exr_codigoipm"))) break block6;
                    dadosRequisicao.setValor("exr_codigoipm", "");
                }
                catch (SQLException e) {
                    try {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se a requisi\u00e7\u00e3o " + codigoRequisicao + " utiliza integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        return dadosRequisicao;
    }

    public String processaHTML(LogIntegracaoOperadora logIntegracaoOperadora, boolean enviarCabecalhoLaudo, boolean enviarLaudoEImagem, RetornoImpressaoResultados impressao) throws IntegracaoOperadoraException {
        String html = null;
        try {
            ConteudoTextoResultado resultadoEmTexto = ConteudoTextoResultado.novaInstancia(impressao.getDocumentoImpressao());
            if (enviarCabecalhoLaudo) {
                html = resultadoEmTexto.getLaudoCompleto().toString();
            } else {
                StringBuilder corpoResultado = new StringBuilder();
                corpoResultado.append((CharSequence)resultadoEmTexto.getResultado());
                corpoResultado.append((CharSequence)resultadoEmTexto.getRodapeExame());
                corpoResultado.append((CharSequence)resultadoEmTexto.getSumario());
                html = corpoResultado.toString();
            }
            if (!Funcoes.textoVazio(html)) {
                html = this.adicionarTagsHtml(this.adicionarCaracterEspeciais(this.removeLinhasAdicionais(html)));
                System.out.println("processa HTML===================================");
                System.out.println(html);
                return html;
            }
        }
        catch (Exception e) {
            String mensagem = "N\u00e3o foi poss\u00edvel buscar o resultado na filial " + logIntegracaoOperadora.getCodigoFilial() + " da requisi\u00e7\u00e3o " + logIntegracaoOperadora.getCodigoRequisicao() + " para o exame " + "logIntegracaoOperadora.getCodigoExame()";
            throw new IntegracaoOperadoraException(e, mensagem, "buscaresultado", logIntegracaoOperadora);
        }
        return "<![CDATA[<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:875px;\"></table>]]>";
    }

    private String removeLinhasAdicionais(String resultado) {
        String resultadoProcessado = resultado;
        if (resultadoProcessado.split("\n")[0].contains("Paciente")) {
            resultadoProcessado = resultadoProcessado.substring(resultadoProcessado.indexOf("\n") + 1, resultadoProcessado.length());
        }
        if (resultadoProcessado.split("\n")[0].contains("M\u00e9dico")) {
            resultadoProcessado = resultadoProcessado.substring(resultadoProcessado.indexOf("\n") + 1, resultadoProcessado.length());
        }
        if (resultadoProcessado.split("\n")[0].contains("Conv\u00eanio")) {
            resultadoProcessado = resultadoProcessado.substring(resultadoProcessado.indexOf("\n") + 1, resultadoProcessado.length());
        }
        if (resultadoProcessado.lastIndexOf("\n") != -1 && resultadoProcessado.substring(resultadoProcessado.lastIndexOf("\n"), resultadoProcessado.length()).contains("P\u00e1gina")) {
            resultadoProcessado = resultadoProcessado.substring(0, resultadoProcessado.lastIndexOf("\n"));
        }
        if (resultadoProcessado.lastIndexOf("\n") != -1 && resultadoProcessado.substring(resultadoProcessado.lastIndexOf("\n"), resultadoProcessado.length()).contains("Exame liberado")) {
            resultadoProcessado = resultadoProcessado.substring(0, resultadoProcessado.lastIndexOf("\n"));
        }
        return resultadoProcessado;
    }

    private String adicionarCaracterEspeciais(String resultado) {
        String resultadoProcessado = "";
        resultado = HtmlEncoder.encode((String)resultado).replace("<br />", "");
        for (String linha : resultado.split("\n")) {
            resultadoProcessado = resultadoProcessado + "&#160;" + linha + "\n";
        }
        resultadoProcessado = resultadoProcessado.substring(0, resultadoProcessado.lastIndexOf("\n"));
        return resultadoProcessado;
    }

    private String adicionarTagsHtml(String resultado) {
        String resultadoProcessado = "<![CDATA[<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:875px;\"></table>]]>";
        if (!resultado.trim().isEmpty()) {
            resultadoProcessado = "<![CDATA[<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:875px;\">\n<tr><td><pre>" + resultado.replace("\n", "</pre></td></tr>\n<tr><td><pre>") + "</pre></td></tr>\n</table>]]>";
        }
        return resultadoProcessado;
    }
}

