/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.ipmsaude;

import atende.net.InformacoesCabecalhoDadosRequis;
import atende.net.InformacoesItensRequis;
import atende.net.InformacoesRetornoRequisicao;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class ConsultaRequisicoesPaciente
extends AbstractDialogoOKCancelar {
    private static final String titulo = "Consultar requisi\u00e7\u00f5es do paciente";
    private final int COLUNA_REQUISICAO_OBJ = 2;
    private ModeloGridTable modeloRequisicoes = null;
    private ModeloGridTable modeloExames = null;
    private JTable tableRequisicoes = null;

    public static ConsultaRequisicoesPaciente novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConsultaRequisicoesPaciente((Dialog)pai, titulo);
        }
        return new ConsultaRequisicoesPaciente((Frame)pai, titulo);
    }

    public ConsultaRequisicoesPaciente(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    public ConsultaRequisicoesPaciente(Frame pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    public void montarTela() {
        this.setResizable(false);
        this.setSize(new Dimension(775, 410));
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        ScreenUtil.centralizar(this);
        JPanel panelRequisicoes = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Requisi\u00e7\u00f5es"));
        JPanel panelExames = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Exames"));
        this.modeloRequisicoes = new ModeloGridTable(new String[]{"C\u00f3digo", "Dt.Solic."});
        this.modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "C\u00f3d. Agendamento", "Dt. Agendamento"});
        this.tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, 0, 150);
        JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, 90, 0, 120);
        JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
        JScrollPane scrollExames = new JScrollPane(tableExames);
        this.tableRequisicoes.getSelectionModel().setSelectionMode(0);
        tableExames.getSelectionModel().setSelectionMode(0);
        this.montaListeners();
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 0);
        c.weightx = 0.7;
        c.weighty = 1.0;
        this.getPanelCentral().add((Component)panelRequisicoes, c);
        c.weightx = 1.0;
        ++c.gridx;
        this.getPanelCentral().add((Component)panelExames, c);
        c.gridx = 0;
        panelRequisicoes.add((Component)scrollRequisicoes, c);
        panelExames.add((Component)scrollExames, c);
    }

    private void montaListeners() {
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getSource() == ConsultaRequisicoesPaciente.this.tableRequisicoes && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
                    ConsultaRequisicoesPaciente.this.carregaExames();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getSource() == ConsultaRequisicoesPaciente.this.tableRequisicoes) {
                    ConsultaRequisicoesPaciente.this.carregaExames();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        };
        this.tableRequisicoes.addKeyListener(keyListener);
        this.tableRequisicoes.addMouseListener(mouseListener);
    }

    public void carregaRequisicoes(InformacoesRetornoRequisicao informacoesRetornoRequisicao) {
        this.modeloRequisicoes.clear();
        if (!Funcoes.objectIsNull(informacoesRetornoRequisicao.getListarequisicao())) {
            for (InformacoesCabecalhoDadosRequis informacoesCabecalhoDadosRequis : informacoesRetornoRequisicao.getListarequisicao()) {
                this.modeloRequisicoes.addLine(new Object[]{informacoesCabecalhoDadosRequis.getDadosrequis().getCodrequis(), informacoesCabecalhoDadosRequis.getDadosrequis().getDatarequis(), informacoesCabecalhoDadosRequis});
            }
            this.tableRequisicoes.setRowSelectionInterval(0, 0);
            this.carregaExames();
        }
    }

    private void carregaExames() {
        this.modeloExames.clear();
        if (this.tableRequisicoes.getSelectedRow() > -1) {
            InformacoesCabecalhoDadosRequis informacoesCabecalhoDadosRequis = (InformacoesCabecalhoDadosRequis)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2);
            for (InformacoesItensRequis informacoesItensRequis : informacoesCabecalhoDadosRequis.getItensrequis()) {
                this.modeloExames.addLine(new Object[]{informacoesItensRequis.getProced(), informacoesItensRequis.getCodagenda(), informacoesItensRequis.getDtagenda()});
            }
        }
    }

    public InformacoesCabecalhoDadosRequis getRequisicao() {
        return (InformacoesCabecalhoDadosRequis)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2);
    }

    @Override
    protected boolean acaoOk() {
        if (this.tableRequisicoes.getSelectedRow() < 0) {
            Funcoes.mensagem(this, "Selecione uma requisi\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.tableRequisicoes);
            return false;
        }
        return true;
    }
}

