/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.ipmsaude;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class ConsultaRequisicao
extends AbstractDialogoOKCancelar {
    private static String titulo = "Consultar requisi\u00e7\u00e3o de exames no IPM-Sa\u00fade";
    private TTextField txtRequisicao = new TTextField(10, 1);
    private TTextField txtCPF = new TTextField(11, 1);
    private TTextField txtCNS = new TTextField(15);
    private JRadioButton radioButtonRequisicao = new JRadioButton("Consultar c\u00f3digo identificador da requisi\u00e7\u00e3o", true);
    private JRadioButton radioButtonCPF = new JRadioButton("Consultar paciente pelo CPF");
    private JRadioButton radioButtonCNS = new JRadioButton("Consultar paciente pelo CNS");
    private ButtonGroup buttonGroupConsultar = new ButtonGroup();

    public static ConsultaRequisicao novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConsultaRequisicao((Dialog)pai, titulo);
        }
        return new ConsultaRequisicao((Frame)pai, titulo);
    }

    public ConsultaRequisicao(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    public ConsultaRequisicao(Frame pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    private void montarTela() {
        this.setResizable(false);
        this.setSize(new Dimension(380, 240));
        ScreenUtil.centralizar(this);
        this.buttonGroupConsultar.add(this.radioButtonRequisicao);
        this.buttonGroupConsultar.add(this.radioButtonCPF);
        this.buttonGroupConsultar.add(this.radioButtonCNS);
        this.getBotaoOK().setText("Consultar");
        this.controlaCampos();
        this.montaListeners();
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.radioButtonRequisicao, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.txtRequisicao, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.radioButtonCPF, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.txtCPF, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.radioButtonCNS, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.txtCNS, c);
    }

    private void montaListeners() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ConsultaRequisicao.this.radioButtonRequisicao || e.getSource() == ConsultaRequisicao.this.radioButtonCPF || e.getSource() == ConsultaRequisicao.this.radioButtonCNS) {
                    ConsultaRequisicao.this.controlaCampos();
                }
            }
        };
        this.radioButtonRequisicao.addActionListener(actionListener);
        this.radioButtonCPF.addActionListener(actionListener);
        this.radioButtonCNS.addActionListener(actionListener);
    }

    private void controlaCampos() {
        this.limpaCampos();
        this.txtRequisicao.setEnabled(false);
        this.txtCPF.setEnabled(false);
        this.txtCNS.setEnabled(false);
        if (this.radioButtonRequisicao.isSelected()) {
            this.txtRequisicao.setEnabled(true);
            ScreenUtil.requisitarFoco(this.txtRequisicao);
        } else if (this.radioButtonCPF.isSelected()) {
            this.txtCPF.setEnabled(true);
            ScreenUtil.requisitarFoco(this.txtCPF);
        } else {
            this.txtCNS.setEnabled(true);
            ScreenUtil.requisitarFoco(this.txtCNS);
        }
    }

    private void limpaCampos() {
        this.txtRequisicao.setText("");
        this.txtCPF.setText("");
        this.txtCNS.setText("");
    }

    public String[] getValorConsulta() {
        return new String[]{this.txtRequisicao.getText().trim(), this.txtCPF.getText().trim(), this.txtCNS.getText().trim()};
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.txtRequisicao) && this.radioButtonRequisicao.isSelected()) {
            Funcoes.mensagem(this, "Informe o c\u00f3digo da requisi\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.txtRequisicao);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCPF) && this.radioButtonCPF.isSelected()) {
            Funcoes.mensagem(this, "Informe o CPF do paciente.", 2);
            ScreenUtil.requisitarFoco(this.txtCPF);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCNS) && this.radioButtonCNS.isSelected()) {
            Funcoes.mensagem(this, "Informe o CNS do paciente.", 2);
            ScreenUtil.requisitarFoco(this.txtCNS);
            return false;
        }
        try {
            if (this.radioButtonRequisicao.isSelected()) {
                Integer.parseInt(this.txtRequisicao.getText().trim());
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "O c\u00f3digo identificador informado n\u00e3o \u00e9 valido.", 2);
            ScreenUtil.requisitarFoco(this.txtRequisicao);
            return false;
        }
        return true;
    }
}

