/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.ipmsaude;

import jalis.comum.CBOS;
import jalis.comum.ConstantesGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TTextFieldCPF;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoOperadoraIPMSaude
extends AbstractDialogoOKCancelar {
    public static final String TAG_INTEGRACAO_CNES = "cnes";
    public static final String TAG_INTEGRACAO_CHAVE = "chave";
    public static final String TAG_INTEGRACAO_WEBSERVICE = "enderecoWebService";
    public static final String TAG_INTEGRACAO_CODIGO = "codigo";
    public static final String TAG_INTEGRACAO_NOME = "nome";
    public static final String TAG_INTEGRACAO_CPF = "cpf";
    public static final String TAG_INTEGRACAO_CNS = "cns";
    public static final String TAG_INTEGRACAO_CONSELHO = "conselho";
    public static final String TAG_INTEGRACAO_CONSELHO_NUMERO = "numero";
    public static final String TAG_INTEGRACAO_CONSELHO_ESTADO = "estado";
    public static final String TAG_INTEGRACAO_CBOS = "cbos";
    public static final String TAG_INTEGRACAO_SEXO = "sexo";
    public static final String TAG_INTEGRACAO_ENVIAR_CABECALHO_LAUDO = "enviaCabecalhoLaudo";
    public static final String TAG_INTEGRACAO_ENVIAR_LAUDO_EM_IMAGEM = "enviarLaudoEmImagem";
    private static String TITULO = "Configurando IPM Sa\u00fade";
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelCNES = new JLabel("CNES do Laborat\u00f3rio:");
    private JLabel labelChave = new JLabel("Chave de Integra\u00e7\u00e3o:");
    private JLabel labelWebService = new JLabel("Web Service:");
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelNome = new JLabel("Nome:");
    private JLabel labelCPF = new JLabel("CPF:");
    private JLabel labelCNS = new JLabel("CNS:");
    private JLabel labelConselho = new JLabel("Conselho:");
    private JLabel labelCBOS = new JLabel("CBO-S:");
    private JLabel labelSexo = new JLabel("Sexo:");
    private JLabel labelVlrEstacao = new JLabel();
    private TTextField txtEstacao = new TTextField(10, 1);
    private TTextField txtCNES = new TTextField(7, 1);
    private TTextField txtChave = new TTextField(30);
    private TTextField txtWebService = new TTextField(350);
    private TTextField txtCodigo = new TTextField(20, 1);
    private TTextField txtNome = new TTextField(80);
    private TTextField txtCPF = new TTextFieldCPF(14);
    private TTextField txtCNS = new TTextField(15);
    private TTextField txtCRM = new TTextField(10);
    private JComboBox comboConselho = new JComboBox<String>(ConstantesGerais.CONSELHOS);
    private JComboBox comboEstado = new JComboBox<String>(ConstantesGerais.ESTADOS);
    private JComboBox comboCBOS = new JComboBox();
    private JComboBox comboSexo = new JComboBox<String>(new String[]{"Masculino", "Feminino"});
    private JCheckBox enviarCabecalhoLaudo = new JCheckBox("Enviar cabe\u00e7alho do laudo");
    private JCheckBox enviarLaudoEmImagem = new JCheckBox("Enviar laudo em imagem");
    private JButton buttonEstacao = new JButton();
    private JPanel panelProfissional = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Profissional liberador dos resultados"));

    public static ConfiguradorIntegracaoOperadoraIPMSaude novaInstancia(Window pai, int codigoConvenio) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraIPMSaude((Dialog)pai, codigoConvenio);
        }
        return new ConfiguradorIntegracaoOperadoraIPMSaude((Frame)pai, codigoConvenio);
    }

    public ConfiguradorIntegracaoOperadoraIPMSaude(Dialog pai, int codigoConvenio) {
        super(pai, TITULO);
        this.montarTela();
    }

    public ConfiguradorIntegracaoOperadoraIPMSaude(Frame pai, int codigoConvenio) {
        super(pai, TITULO);
        this.montarTela();
    }

    private void montarTela() {
        this.setResizable(false);
        this.setSize(new Dimension(500, 380));
        ScreenUtil.centralizar(this);
        this.txtEstacao.setPreferredSize(new Dimension(80, 20));
        this.txtEstacao.setMinimumSize(this.txtEstacao.getPreferredSize());
        this.txtCodigo.setPreferredSize(new Dimension(100, 20));
        this.txtCodigo.setMinimumSize(this.txtCodigo.getPreferredSize());
        this.txtCPF.setPreferredSize(new Dimension(150, 20));
        this.txtCPF.setMinimumSize(this.txtCPF.getPreferredSize());
        this.txtCRM.setPreferredSize(new Dimension(130, 20));
        this.txtCRM.setMinimumSize(this.txtCRM.getPreferredSize());
        this.buttonEstacao.setPreferredSize(new Dimension(20, 20));
        this.buttonEstacao.setSize(this.buttonEstacao.getPreferredSize());
        this.buttonEstacao.setMinimumSize(this.buttonEstacao.getPreferredSize());
        this.buttonEstacao.setMaximumSize(this.buttonEstacao.getPreferredSize());
        this.buttonEstacao.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.labelVlrEstacao.setPreferredSize(new Dimension(1, 20));
        this.labelVlrEstacao.setMinimumSize(this.labelVlrEstacao.getPreferredSize());
        ScreenUtil.setBorda(new Component[]{this.labelVlrEstacao}, new TitledBorder(""));
        this.comboConselho.setPreferredSize(new Dimension(85, 20));
        this.comboConselho.setMinimumSize(this.comboConselho.getPreferredSize());
        this.comboEstado.setPreferredSize(new Dimension(85, 20));
        this.comboEstado.setMinimumSize(this.comboEstado.getPreferredSize());
        this.comboCBOS.setPreferredSize(new Dimension(302, 20));
        this.comboCBOS.setMinimumSize(this.comboCBOS.getPreferredSize());
        this.comboSexo.setPreferredSize(new Dimension(150, 20));
        this.comboSexo.setMinimumSize(this.comboSexo.getPreferredSize());
        this.montaListeners();
        CBOS.CBO[] cbos = CBOS.getCBOS(null);
        Arrays.sort(cbos, new Comparator<CBOS.CBO>(){

            @Override
            public int compare(CBOS.CBO cbo1, CBOS.CBO cbo2) {
                return cbo1.descricao.compareTo(cbo2.descricao);
            }
        });
        for (CBOS.CBO s : cbos) {
            this.comboCBOS.addItem(s.descricao);
        }
        this.comboEstado.setSelectedItem("SP");
        ScreenUtil.requisitarFoco(this.txtEstacao);
        JPanel panelCPF = new JPanel(new GridBagLayout());
        JPanel panelConselho = new JPanel(new GridBagLayout());
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelEstacao, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtEstacao, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.buttonEstacao, c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.labelVlrEstacao, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelCNES, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtCNES, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelChave, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtChave, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelWebService, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtWebService, c);
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        this.getPanelCentral().add((Component)this.panelProfissional, c);
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        this.getPanelCentral().add((Component)this.enviarCabecalhoLaudo, c);
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        this.getPanelCentral().add((Component)this.enviarLaudoEmImagem, c);
        c.fill = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        this.panelProfissional.add((Component)this.labelCodigo, c);
        c.fill = 0;
        ++c.gridx;
        c.gridwidth = 1;
        this.panelProfissional.add((Component)this.txtCodigo, c);
        c.fill = 2;
        ++c.gridy;
        c.gridx = 0;
        this.panelProfissional.add((Component)this.labelNome, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.panelProfissional.add((Component)this.txtNome, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.panelProfissional.add((Component)this.labelCPF, c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridx;
        this.panelProfissional.add((Component)panelCPF, c);
        c.insets = new Insets(1, 1, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        this.panelProfissional.add((Component)this.labelConselho, c);
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridx;
        this.panelProfissional.add((Component)panelConselho, c);
        c.fill = 2;
        c.insets = new Insets(1, 1, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        this.panelProfissional.add((Component)this.labelCBOS, c);
        c.fill = 0;
        ++c.gridx;
        c.gridwidth = 1;
        this.panelProfissional.add((Component)this.comboCBOS, c);
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        this.panelProfissional.add((Component)this.labelSexo, c);
        c.fill = 0;
        ++c.gridx;
        c.gridwidth = 1;
        this.panelProfissional.add((Component)this.comboSexo, c);
        c.gridx = 0;
        c.gridy = 0;
        panelCPF.add((Component)this.txtCPF, c);
        ++c.gridx;
        panelCPF.add((Component)this.labelCNS, c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        panelCPF.add((Component)this.txtCNS, c);
        c.gridx = 0;
        c.weightx = 0.0;
        panelConselho.add((Component)this.comboConselho, c);
        ++c.gridx;
        panelConselho.add((Component)this.txtCRM, c);
        ++c.gridx;
        panelConselho.add((Component)this.comboEstado, c);
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraIPMSaude.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraIPMSaude.this.pesquisaEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraIPMSaude.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraIPMSaude.this.buscaEstacao(ConfiguradorIntegracaoOperadoraIPMSaude.this.txtEstacao.getText());
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraIPMSaude.this.txtCPF) {
                    ConfiguradorIntegracaoOperadoraIPMSaude.this.txtCPF.selectAll();
                }
            }
        };
        this.txtEstacao.addKeyListener(keyAdapter);
        this.txtEstacao.addFocusListener(focusAdapter);
        this.txtCPF.addFocusListener(focusAdapter);
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraIPMSaude.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraIPMSaude.this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraIPMSaude.this.labelVlrEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraIPMSaude.this.txtEstacao.clear();
                    ConfiguradorIntegracaoOperadoraIPMSaude.this.labelVlrEstacao.setText("");
                }
            }
        });
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.txtEstacao.clear();
            this.labelVlrEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.txtEstacao.clear();
            this.labelVlrEstacao.setText("");
            ScreenUtil.requisitarFoco(this.txtEstacao);
        }
    }

    private void pesquisaEstacao() {
        this.txtEstacao.clear();
        this.labelVlrEstacao.setText("");
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.txtEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        }
    }

    public void setXML(String xml) {
        if (!Funcoes.textoVazio(xml) && ConfiguradorIntegracaoOperadoraIPMSaude.isIPMSaude(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.txtEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CNES))) {
                this.txtCNES.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CHAVE))) {
                this.txtChave.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_WEBSERVICE))) {
                this.txtWebService.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_ENVIAR_CABECALHO_LAUDO))) {
                this.enviarCabecalhoLaudo.setSelected(aux.equals("True"));
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_ENVIAR_LAUDO_EM_IMAGEM))) {
                this.enviarLaudoEmImagem.setSelected(aux.equals("True"));
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CODIGO))) {
                this.txtCodigo.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_NOME))) {
                this.txtNome.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CPF))) {
                this.txtCPF.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CNS))) {
                this.txtCNS.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CONSELHO))) {
                this.comboConselho.setSelectedItem(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CONSELHO_NUMERO))) {
                this.txtCRM.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CONSELHO_ESTADO))) {
                this.comboEstado.setSelectedItem(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_CBOS))) {
                this.comboCBOS.setSelectedItem(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_SEXO))) {
                this.comboSexo.setSelectedItem("Feminino");
                if (aux.contains("M")) {
                    this.comboSexo.setSelectedItem("Masculino");
                }
            }
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("integracaooperadora");
            xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.IPMSAUDE.getDescricao());
            xml.escrever("estacao", this.txtEstacao.getText());
            xml.escrever(TAG_INTEGRACAO_CNES, this.txtCNES.getText().trim());
            xml.escrever(TAG_INTEGRACAO_CHAVE, this.txtChave.getText().trim());
            xml.escrever(TAG_INTEGRACAO_WEBSERVICE, this.txtWebService.getText().trim());
            xml.escrever(TAG_INTEGRACAO_ENVIAR_CABECALHO_LAUDO, this.enviarCabecalhoLaudo.isSelected() ? "True" : "False");
            xml.escrever(TAG_INTEGRACAO_ENVIAR_LAUDO_EM_IMAGEM, this.enviarLaudoEmImagem.isSelected() ? "True" : "False");
            xml.escrever(TAG_INTEGRACAO_CODIGO, this.txtCodigo.getText().trim());
            xml.escrever(TAG_INTEGRACAO_NOME, this.txtNome.getText().trim());
            xml.escrever(TAG_INTEGRACAO_CPF, this.txtCPF.getText().trim().replace(".", "").replace("-", ""));
            xml.escrever(TAG_INTEGRACAO_CNS, this.txtCNS.getText().trim());
            xml.escrever(TAG_INTEGRACAO_CONSELHO, this.comboConselho.getSelectedItem().toString().trim());
            xml.escrever(TAG_INTEGRACAO_CONSELHO_NUMERO, this.txtCRM.getText().trim());
            xml.escrever(TAG_INTEGRACAO_CONSELHO_ESTADO, this.comboEstado.getSelectedItem().toString().trim());
            xml.escrever(TAG_INTEGRACAO_CBOS, this.comboCBOS.getSelectedItem().toString().trim());
            xml.escrever(TAG_INTEGRACAO_SEXO, this.comboSexo.getSelectedItem().toString().contains("Masculino") ? "M" : "F");
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    public static boolean isIPMSaude(String xml) {
        return StringUtil.getValor(xml, "protocolo").equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.IPMSAUDE.getDescricao());
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.txtEstacao) || this.labelVlrEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCNES)) {
            Funcoes.mensagem(this, "O c\u00f3digo CNES do laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtCNES);
            return false;
        }
        if (Funcoes.textoVazio(this.txtChave)) {
            Funcoes.mensagem(this, "A chave de integra\u00e7\u00e3o deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtChave);
            return false;
        }
        if (Funcoes.textoVazio(this.txtWebService)) {
            Funcoes.mensagem(this, "O endere\u00e7o de Web Service deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtWebService);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodigo)) {
            Funcoes.mensagem(this, "O c\u00f3digo do profissional liberador dos resultados deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.txtNome)) {
            Funcoes.mensagem(this, "O nome do profissional liberador dos resultados deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtNome);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCPF.getText().trim().replace(".", "").replace("-", ""))) {
            Funcoes.mensagem(this, "O CPF do profissional liberador dos resultados deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtCPF);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCNS)) {
            Funcoes.mensagem(this, "O CNS do profissional liberador dos resultados deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtCNS);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCRM)) {
            Funcoes.mensagem(this, "O c\u00f3digo do conselho do profissional liberador dos resultados deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtCRM);
            return false;
        }
        if (this.comboCBOS.getSelectedIndex() == 0) {
            Funcoes.mensagem(this, "O CBO do profissional liberador dos resultados deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.comboCBOS);
            return false;
        }
        return true;
    }
}

