/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.ipmsaude;

import jalis.comum.ConstantesGerais;
import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class BuscaMedico
extends AbstractDialogoOKCancelar
implements ActionListener {
    private static String TITULO = "Selecionar m\u00e9dico da requisi\u00e7\u00e3o";
    private String cnes = "";
    private JLabel lblMSG = new JLabel();
    private JButton buttonConsultarCNES = new JButton("Consultar CNES");
    private JButton buttonPesquisarMedicos = new JButton("Pesquisar m\u00e9dicos");
    private JLabel lblNomeMedicoCNES = new JLabel("Nome:");
    private JLabel lblCNS = new JLabel("CNS:");
    private JLabel lblCBO = new JLabel("CBO:");
    private JLabel lblCPFMedicoCNES = new JLabel("CPF:");
    private TTextField textNomeMedicoCNES = new TTextField();
    private TTextField textCNS = new TTextField();
    private TTextField textCBO = new TTextField();
    private TTextField textCPFMedicoCNES = new TTextField();
    private TTextField textDescCBO = new TTextField();
    private JLabel lblConselho = new JLabel("Conselho: ");
    private JLabel lblNomeMedicoRequisicao = new JLabel("Nome:");
    private JLabel lblCPFMedicoRequisicao = new JLabel("  CPF: ");
    private JComboBox comboConselho = new JComboBox<String>(ConstantesGerais.CONSELHOS);
    private JComboBox comboUf = new JComboBox<String>(ConstantesGerais.ESTADOS);
    private TTextField textCrm = new TTextField();
    private TTextField textNomeMedicoRequisicao = new TTextField();
    private TTextField textCPFMedicoRequisicao = new TTextField();
    private JPanel panelDadosMedico = new JPanel(new GridBagLayout());
    private JPanel panelMedicoRequisicao = new JPanel(new GridBagLayout());
    private JPanel panelGeral = new JPanel();

    public static BuscaMedico novaInstancia(Object pai, String cnes) {
        if (pai instanceof Frame) {
            return new BuscaMedico((Frame)pai, cnes);
        }
        return new BuscaMedico((Dialog)pai, cnes);
    }

    public BuscaMedico(Frame pai, String cnes) {
        super(pai, TITULO);
        this.cnes = cnes;
        this.montarTela();
        this.setLocationRelativeTo(pai);
    }

    public BuscaMedico(Dialog pai, String cnes) {
        super(pai, TITULO);
        this.cnes = cnes;
        this.montarTela();
        this.setLocationRelativeTo(pai);
    }

    private void montarTela() {
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.setSize(new Dimension(450, 300));
        this.setResizable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        JPanel pnlAux = new JPanel(new GridBagLayout());
        this.lblMSG.setText("M\u00e9dico com o CNS " + this.cnes + " n\u00e3o encontrado");
        this.buttonConsultarCNES.setPreferredSize(new Dimension(123, 20));
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        pnlAux.add((Component)this.lblMSG, c);
        ++c.gridx;
        c.anchor = 13;
        pnlAux.add((Component)this.buttonConsultarCNES, c);
        this.add((Component)pnlAux, "North");
        this.panelGeral.add((Component)this.panelDadosMedico, "North");
        this.panelGeral.add((Component)this.panelMedicoRequisicao, "South");
        this.add((Component)this.panelGeral, "Center");
        this.montaPanelMedicoCNES();
        this.montaPanelMedicoRequisicao();
        this.add((Component)this.getPanelBotoesDireita(), "South");
        this.buttonConsultarCNES.setEnabled(false);
        this.buttonConsultarCNES.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuscaMedico.this.consultarCNS();
            }
        });
        this.buttonPesquisarMedicos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuscaMedico.this.pesquisarMedico();
            }
        });
    }

    private void montaPanelMedicoRequisicao() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        this.panelMedicoRequisicao.setBorder(new TitledBorder("Informar m\u00e9dico da requisi\u00e7\u00e3o"));
        this.panelMedicoRequisicao.setPreferredSize(new Dimension(445, 85));
        c.gridwidth = 3;
        this.buttonPesquisarMedicos.setMinimumSize(new Dimension(150, 20));
        this.buttonPesquisarMedicos.setMaximumSize(new Dimension(150, 20));
        this.buttonPesquisarMedicos.setPreferredSize(new Dimension(150, 20));
        this.panelMedicoRequisicao.add((Component)this.buttonPesquisarMedicos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.panelMedicoRequisicao.add((Component)this.lblConselho, c);
        ++c.gridx;
        this.comboConselho.setEnabled(false);
        this.comboConselho.setMinimumSize(new Dimension(60, 20));
        this.comboConselho.setMaximumSize(new Dimension(60, 20));
        this.comboConselho.setPreferredSize(new Dimension(60, 20));
        this.panelMedicoRequisicao.add((Component)this.comboConselho, c);
        ++c.gridx;
        this.textCrm.setEditable(false);
        this.textCrm.setFocusable(false);
        this.textCrm.setMinimumSize(new Dimension(60, 20));
        this.textCrm.setMaximumSize(new Dimension(60, 20));
        this.textCrm.setPreferredSize(new Dimension(60, 20));
        this.panelMedicoRequisicao.add((Component)this.textCrm, c);
        ++c.gridx;
        this.comboUf.setEnabled(false);
        this.comboUf.setMinimumSize(new Dimension(60, 20));
        this.comboUf.setMaximumSize(new Dimension(60, 20));
        this.comboUf.setPreferredSize(new Dimension(60, 20));
        this.panelMedicoRequisicao.add((Component)this.comboUf, c);
        ++c.gridx;
        this.panelMedicoRequisicao.add((Component)this.lblCPFMedicoRequisicao, c);
        ++c.gridx;
        this.textCPFMedicoRequisicao.setEditable(false);
        this.textCPFMedicoRequisicao.setFocusable(false);
        this.textCPFMedicoRequisicao.setMinimumSize(new Dimension(161, 20));
        this.textCPFMedicoRequisicao.setMaximumSize(new Dimension(161, 20));
        this.textCPFMedicoRequisicao.setPreferredSize(new Dimension(161, 20));
        this.panelMedicoRequisicao.add((Component)this.textCPFMedicoRequisicao, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelMedicoRequisicao.add((Component)this.lblNomeMedicoRequisicao, c);
        ++c.gridx;
        c.gridwidth = 6;
        this.textNomeMedicoRequisicao.setEditable(false);
        this.textNomeMedicoRequisicao.setFocusable(false);
        this.textNomeMedicoRequisicao.setMinimumSize(new Dimension(375, 20));
        this.textNomeMedicoRequisicao.setMaximumSize(new Dimension(375, 20));
        this.textNomeMedicoRequisicao.setPreferredSize(new Dimension(375, 20));
        this.panelMedicoRequisicao.add((Component)this.textNomeMedicoRequisicao, c);
    }

    private void montaPanelMedicoCNES() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 2, 1, 2);
        this.panelDadosMedico.setBorder(new TitledBorder("Dados do m\u00e9dico no CNES"));
        this.panelDadosMedico.setPreferredSize(new Dimension(445, 85));
        this.panelDadosMedico.add((Component)this.lblNomeMedicoCNES, c);
        this.textNomeMedicoCNES.setEditable(false);
        this.textNomeMedicoCNES.setFocusable(false);
        this.textNomeMedicoCNES.setMinimumSize(new Dimension(393, 20));
        this.textNomeMedicoCNES.setMaximumSize(new Dimension(393, 20));
        this.textNomeMedicoCNES.setPreferredSize(new Dimension(393, 20));
        ++c.gridx;
        c.gridwidth = 3;
        this.panelDadosMedico.add((Component)this.textNomeMedicoCNES, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.panelDadosMedico.add((Component)this.lblCNS, c);
        ++c.gridx;
        this.textCNS.setEditable(false);
        this.textCNS.setFocusable(false);
        this.textCNS.setMinimumSize(new Dimension(180, 20));
        this.textCNS.setMaximumSize(new Dimension(180, 20));
        this.textCNS.setPreferredSize(new Dimension(180, 20));
        this.panelDadosMedico.add((Component)this.textCNS, c);
        ++c.gridx;
        this.panelDadosMedico.add((Component)this.lblCPFMedicoCNES, c);
        ++c.gridx;
        this.textCPFMedicoCNES.setEditable(false);
        this.textCPFMedicoCNES.setFocusable(false);
        this.textCPFMedicoCNES.setMinimumSize(new Dimension(180, 20));
        this.textCPFMedicoCNES.setMaximumSize(new Dimension(180, 20));
        this.textCPFMedicoCNES.setPreferredSize(new Dimension(180, 20));
        this.panelDadosMedico.add((Component)this.textCPFMedicoCNES, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelDadosMedico.add((Component)this.lblCBO, c);
        ++c.gridx;
        this.textCBO.setEditable(false);
        this.textCBO.setFocusable(false);
        this.textCBO.setMinimumSize(new Dimension(180, 20));
        this.textCBO.setMaximumSize(new Dimension(180, 20));
        this.textCBO.setPreferredSize(new Dimension(180, 20));
        this.panelDadosMedico.add((Component)this.textCBO, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.textDescCBO.setEditable(false);
        this.textDescCBO.setFocusable(false);
        this.textDescCBO.setMinimumSize(new Dimension(209, 20));
        this.textDescCBO.setMaximumSize(new Dimension(209, 20));
        this.textDescCBO.setPreferredSize(new Dimension(209, 20));
        this.panelDadosMedico.add((Component)this.textDescCBO, c);
    }

    private void pesquisarMedico() {
        boolean retorno;
        Hashtable resultado = Pesquisas.medico(Laboratorio.getInstancia(), true);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.comboConselho.setSelectedItem(resultado.get("med_conselho").toString());
            this.textCrm.setText(resultado.get("med_crm").toString());
            this.textNomeMedicoRequisicao.setText(resultado.get("med_nome").toString());
            this.textCPFMedicoRequisicao.setText(resultado.get("med_cpf").toString());
            this.comboUf.setSelectedItem(resultado.get("med_uf").toString());
            ScreenUtil.requisitarFoco(this.buttonOK);
        }
    }

    private void consultarCNS() {
    }

    public MedicoVO getMedicoSelecionado() {
        MedicoVO medicoVO = new MedicoVO();
        medicoVO.setUf(this.comboUf.getSelectedItem().toString());
        medicoVO.setCrm(this.textCrm.getText().trim());
        medicoVO.setConselho(this.comboConselho.getSelectedItem().toString());
        return medicoVO;
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.textCrm)) {
            Funcoes.mensagem(this, "Informe o m\u00e9dico.", 2);
            ScreenUtil.requisitarFoco(this.buttonPesquisarMedicos);
            return false;
        }
        return true;
    }
}

