/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.agsi;

import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.RESULTADOSEXAMESOutput;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.agsi.ConfiguradorIntegracaoOperadoraAGSI;
import jalis.integracaooperadoras.sistemas.agsi.ProcedimentoAGSI;
import jalis.integracaooperadoras.sistemas.agsi.ResultadoAutorizacaoAGSI;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.RetornoIntegracaoDePara;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLUtil;
import java.awt.Window;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.messaging.URLEndpoint;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IntegracaoOperadoraAGSI
extends AbstractIntegracaoOperadora {
    private String xmlConfiguracao;
    public static final String TAG_INTEGRACAO_OPERADORA = "integracaooperadora";
    public static final String TAG_INTEGRACAO_PROTOCOLO = "protocolo";
    public static final String TAG_INTEGRACAO_TERMINAL = "terminal";
    public static final String TAG_INTEGRACAO_LOGIN = "login";
    public static final String TAG_INTEGRACAO_SENHA = "senha";
    public static final String TAG_INTEGRACAO_WEB_SERVICE = "enderecoWebService";
    public static final String TAG_INTEGRACAO_PROCEDIMENTO_INCORRETO = "procedimentoincorreto";
    public static final String TAG_INTEGRACAO_XML_INCORRETO = "xmlincorreto";
    public static final String TAG_INTEGRACAO_JA_AUTORIZADO = "codigoautorizacaopreenchido";
    private static String VERSAO = "20060809";
    public static final String ACTION_EXECUTAR_PROCEDIMENTO = "execucaoprocedimento";
    private static final String HINT_AGUARDANDO_WS = "AGUARDANDO RETORNO DO WEBSERVICE DO AGSI";
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private String crmSolic = "";
    private String cbosSolic = "";
    private String matriculaRequisicao = "";
    private String codigoLoginConfiguracao = "";
    private String senhaLoginConfiguracao = "";
    private String codigoTerminalConfiguracao = "";
    private String enderecoWebService = "";
    private RESULTADOSEXAMESOutput retornoSolicitacao = null;
    private String codigoAutorizacao;

    public IntegracaoOperadoraAGSI(String xmlConfiguracao, int codigoConvenio) {
        this.xmlConfiguracao = xmlConfiguracao;
        this.codigoConvenio = codigoConvenio;
        if (!Funcoes.textoVazio(xmlConfiguracao)) {
            this.xmlConfiguracao = StringUtil.getValor(xmlConfiguracao, TAG_INTEGRACAO_OPERADORA);
            if (!Funcoes.textoVazio(xmlConfiguracao)) {
                this.codigoLoginConfiguracao = StringUtil.getValor(xmlConfiguracao, TAG_INTEGRACAO_LOGIN);
                this.senhaLoginConfiguracao = StringUtil.getValor(xmlConfiguracao, TAG_INTEGRACAO_SENHA);
                this.codigoTerminalConfiguracao = StringUtil.getValor(xmlConfiguracao, TAG_INTEGRACAO_TERMINAL);
                this.enderecoWebService = StringUtil.getValor(xmlConfiguracao, TAG_INTEGRACAO_WEB_SERVICE);
            }
        }
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
        return this.erros;
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraAGSI configuradorIntegracaoOperadoraAGSI = ConfiguradorIntegracaoOperadoraAGSI.novaInstancia(parent);
        configuradorIntegracaoOperadoraAGSI.setXML(xmlConfig);
        configuradorIntegracaoOperadoraAGSI.setVisible(true);
        if (configuradorIntegracaoOperadoraAGSI.getOK()) {
            return configuradorIntegracaoOperadoraAGSI.getXML();
        }
        return xmlConfig;
    }

    private RequestConfig buildRequestConfig() {
        int timeout = 60;
        return RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
    }

    private SSLConnectionSocketFactory construirSSL() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        return new SSLConnectionSocketFactory(builder.build());
    }

    private boolean statusOK(CloseableHttpResponse response) {
        return null != response && response.getStatusLine().getStatusCode() == 200;
    }

    public String enviarSolicitacao(List<String> ambExames, String codigoAutorizacao) throws ClientProtocolException, IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        if (!StringUtil.isEmpty(codigoAutorizacao)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Requisi\u00e7\u00e3o j\u00e1 possui exames autorizados,\n para mais informa\u00e7\u00f5es entre em contato com a operadora.", 1);
            return "";
        }
        String url = this.createURLSolicitacoes(ambExames);
        this.debug("URL envio: " + url);
        URLEndpoint endpoint = new URLEndpoint(url);
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.buildRequestConfig()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.post().setUri(url).build();
        CloseableHttpResponse response = client.execute(request);
        RetornoIntegracaoDePara retorno = new RetornoIntegracaoDePara();
        Object log = null;
        HttpEntity entity = response.getEntity();
        this.debug("C\u00f3d resposta: " + response.getStatusLine().getStatusCode());
        if (this.statusOK(response)) {
            try {
                ResultadoAutorizacaoAGSI retornoXML = this.validarRetornoSolicitacao(EntityUtils.toString((HttpEntity)entity));
                if (retornoXML.isAutorizado()) {
                    return retornoXML.getCodigoAutorizacao();
                }
                String mensagem = retornoXML.getMensagemNaoAutorizado().equals(TAG_INTEGRACAO_PROCEDIMENTO_INCORRETO) ? "Retorno inv\u00e1lido,\nconsulte a operadora." : "Procedimento n\u00e3o autorizado\n" + retornoXML.getMensagemNaoAutorizado();
                Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 1);
                return "";
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha ao pprocessar resposta AGSI", e.getStackTrace());
            }
        } else {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel realizar solicita\u00e7\u00e3o. Entre em contato com a operadora de sa\u00fade.\n", 1);
            return "";
        }
        return "";
    }

    private ResultadoAutorizacaoAGSI validarRetornoSolicitacao(String response) throws Exception {
        ResultadoAutorizacaoAGSI resultadoAutorizacao = new ResultadoAutorizacaoAGSI();
        String detalhesProcedimento = "";
        List<String> tmp = StringUtil.getListValoresTagAberta(response, "ems", true);
        String x = "<?xml version='1.0' encoding='ISO-8859-1'?>\n";
        for (String s : tmp) {
            x = x + s;
        }
        Document doc = XMLUtil.analisarXMLString(x);
        if (doc == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o arquivo\n", 1);
            resultadoAutorizacao.setAutorizado(false);
            resultadoAutorizacao.setMensagemNaoAutorizado(TAG_INTEGRACAO_XML_INCORRETO);
        }
        Element raiz = doc.getDocumentElement();
        List<ProcedimentoAGSI> listProcedimentos = this.parse(XMLUtil.getElementosFilhos(raiz));
        for (ProcedimentoAGSI procedimentoAGSI : listProcedimentos) {
            if (procedimentoAGSI.getSituacao().equalsIgnoreCase("N") || procedimentoAGSI.getSituacao().equalsIgnoreCase("A")) {
                if (procedimentoAGSI.getSituacao().equalsIgnoreCase("N")) {
                    resultadoAutorizacao.setAutorizado(false);
                    detalhesProcedimento = detalhesProcedimento.concat(procedimentoAGSI.getNumero()).concat(" - ").concat(procedimentoAGSI.getDescricao()).concat("\n");
                    resultadoAutorizacao.setMensagemNaoAutorizado(detalhesProcedimento);
                    continue;
                }
                resultadoAutorizacao.setAutorizado(resultadoAutorizacao.getMensagemNaoAutorizado() == null);
                resultadoAutorizacao.setCodigoAutorizacao(procedimentoAGSI.getCodigoAutorizacao());
                continue;
            }
            resultadoAutorizacao.setAutorizado(false);
            resultadoAutorizacao.setMensagemNaoAutorizado(TAG_INTEGRACAO_PROCEDIMENTO_INCORRETO);
        }
        this.debug("Retorno solicitacao: " + resultadoAutorizacao.isAutorizado());
        return resultadoAutorizacao;
    }

    public List<ProcedimentoAGSI> parse(List<Element> elements) {
        ArrayList<ProcedimentoAGSI> procedimentos = new ArrayList<ProcedimentoAGSI>();
        for (Element e : elements) {
            if (e.getNodeName().equalsIgnoreCase("resultados")) {
                if (e.getAttribute("versao").equalsIgnoreCase(VERSAO)) continue;
                Funcoes.mensagem(Laboratorio.getInstancia(), "O arquivo selecionado n\u00e3o \u00e9 um XML de resultado v\u00e1lido", 1);
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("procedimento")) {
                ProcedimentoAGSI procedimento = new ProcedimentoAGSI();
                procedimento.setNumero(e.getAttribute("Numero"));
                procedimento.setDescricao(e.getAttribute("DescricaoMensagem"));
                procedimento.setSituacao(e.getAttribute("Situacao"));
                procedimento.setCodigoAutorizacao(e.getAttribute("Autorizacao"));
                procedimentos.add(procedimento);
                continue;
            }
            if (!e.hasChildNodes()) continue;
            procedimentos.addAll(this.parse(XMLUtil.getElementosFilhos(e)));
        }
        return procedimentos;
    }

    private LinkedHashMap<String, String> construirParametrosAGSI() {
        LinkedHashMap<String, String> retorno = new LinkedHashMap<String, String>();
        retorno.put("Action", ACTION_EXECUTAR_PROCEDIMENTO);
        retorno.put("Login", this.codigoLoginConfiguracao);
        retorno.put("Senha", this.senhaLoginConfiguracao);
        retorno.put("Terminal", this.codigoTerminalConfiguracao);
        retorno.put("CrmSolic", this.crmSolic);
        retorno.put("CbosSolic", this.cbosSolic);
        retorno.put("Usuario", this.matriculaRequisicao);
        return retorno;
    }

    private String createURLSolicitacoes(List<String> ambExames) {
        StringBuilder url = new StringBuilder();
        HashMap<String, Integer> ambPorQtdSessoes = new HashMap<String, Integer>();
        int qtde = 1;
        for (String amb : ambExames) {
            if (ambPorQtdSessoes.containsKey(amb.toLowerCase())) {
                qtde = (Integer)ambPorQtdSessoes.get(amb.toLowerCase()) + 1;
            }
            ambPorQtdSessoes.put(amb.toLowerCase(), qtde);
        }
        LinkedHashMap<String, String> params = this.construirParametrosAGSI();
        int contaParams = 0;
        for (String k : ambPorQtdSessoes.keySet()) {
            Integer q = (Integer)ambPorQtdSessoes.get(k);
            if (null == q) continue;
            params.put("Procedimento" + (contaParams > 0 ? String.valueOf(contaParams) : ""), StringUtil.limpaString(k, new String[]{".", "-"}));
            params.put("QtdSessoes" + (contaParams > 0 ? String.valueOf(contaParams) : ""), q.toString());
            ++contaParams;
        }
        if (!this.enderecoWebService.endsWith("?")) {
            this.enderecoWebService = this.enderecoWebService + "?";
        }
        return this.enderecoWebService + this.paramsToString(params);
    }

    private String paramsToString(LinkedHashMap<String, String> params) {
        StringBuilder buf = new StringBuilder();
        for (String k : params.keySet()) {
            if (buf.length() > 0) {
                buf.append("&");
            }
            buf.append(k).append("=").append(params.get(k));
        }
        return buf.toString();
    }

    public void setCrmSolic(String crmSolic) {
        this.crmSolic = crmSolic;
    }

    public void setCbosSolic(String cbosSolic) {
        this.cbosSolic = cbosSolic;
    }

    public void setMatriculaRequisicao(String matriculaRequisicao) {
        this.matriculaRequisicao = matriculaRequisicao;
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }
}

