/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.agsi;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;

public class ConfiguradorIntegracaoOperadoraAGSI
extends AbstractDialogoOKCancelar {
    private static String TITULO = "Configurando AGSI Sistemas";
    private JLabel labelTerminal = new JLabel("Terminal:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio (login):");
    private JLabel labelSenha = new JLabel("Senha (login):");
    private JLabel labelLinkWS = new JLabel("Web Service:");
    private TTextField txtTerminal = new TTextField(350, 1);
    private TTextField txtUsuario = new TTextField(350);
    private TTextField txtSenha = new TTextField(350);
    private TTextField txtLinkWS = new TTextField(350);

    public static ConfiguradorIntegracaoOperadoraAGSI novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraAGSI((Dialog)pai);
        }
        return new ConfiguradorIntegracaoOperadoraAGSI((Frame)pai);
    }

    public ConfiguradorIntegracaoOperadoraAGSI(Dialog pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    public ConfiguradorIntegracaoOperadoraAGSI(Frame pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    private void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(480, 175));
        ScreenUtil.centralizar(this);
        this.txtTerminal.setPreferredSize(new Dimension(355, 20));
        this.txtTerminal.setMinimumSize(this.txtTerminal.getPreferredSize());
        this.txtTerminal.setHorizontalAlignment(2);
        this.txtUsuario.setPreferredSize(new Dimension(1, 20));
        this.txtUsuario.setMinimumSize(this.txtUsuario.getPreferredSize());
        this.txtSenha.setPreferredSize(new Dimension(1, 20));
        this.txtSenha.setMinimumSize(this.txtSenha.getPreferredSize());
        this.txtLinkWS.setPreferredSize(new Dimension(1, 20));
        this.txtLinkWS.setMinimumSize(this.txtLinkWS.getPreferredSize());
        this.montaListeners();
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 10, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelTerminal, c);
        c.fill = 2;
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtTerminal, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelUsuario, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtUsuario, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelSenha, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtSenha, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelLinkWS, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.txtLinkWS, c);
        ScreenUtil.requisitarFoco(this.txtTerminal);
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
            }
        };
        this.txtTerminal.addKeyListener(keyAdapter);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                ScreenUtil.requisitarFoco(ConfiguradorIntegracaoOperadoraAGSI.this.txtTerminal);
            }
        });
    }

    public static boolean isAGSI(String xml) {
        return StringUtil.getValor(xml, "protocolo").equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.AGSI.getDescricao());
    }

    public void setXML(String xml) {
        if (!Funcoes.textoVazio(xml) && ConfiguradorIntegracaoOperadoraAGSI.isAGSI(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "terminal");
            if (!Funcoes.textoVazio(aux)) {
                this.txtTerminal.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, "login"))) {
                this.txtUsuario.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, "senha"))) {
                this.txtSenha.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, "enderecoWebService"))) {
                this.txtLinkWS.setText(aux);
            }
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("integracaooperadora");
            xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.AGSI.getDescricao());
            xml.escrever("terminal", this.txtTerminal.getText());
            xml.escrever("login", this.txtUsuario.getText().trim());
            xml.escrever("senha", this.txtSenha.getText().trim());
            xml.escrever("enderecoWebService", this.txtLinkWS.getText().trim());
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.txtTerminal) || this.labelTerminal.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "O Terminal deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtTerminal);
            return false;
        }
        if (Funcoes.textoVazio(this.txtUsuario)) {
            Funcoes.mensagem(this, "O login de acesso do laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtUsuario);
            return false;
        }
        if (Funcoes.textoVazio(this.txtSenha)) {
            Funcoes.mensagem(this, "A senha de acesso do laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.txtLinkWS)) {
            Funcoes.mensagem(this, "O endere\u00e7o do Web Service para envio dos resultados deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtLinkWS);
            return false;
        }
        return true;
    }
}

