/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JanelaErrosIntegracaoOperadora
extends JDialog
implements ActionListener {
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_LOG = 1;
    private final int COLUNA_TIPO = 2;
    private final int COLUNA_XML = 3;
    private final int COLUNA_OBJETO = 4;
    private JLabel labelLocalizar = new JLabel("Localizar XML contendo:");
    private TTextField textLocalizar = new TTextField();
    private JPanel panelLogs = new JPanel(new GridBagLayout());
    private JPanel panelExcecao = new JPanel(new BorderLayout());
    private JPanel panelPilhaExcecao = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JButton buttonMarcarComoExportado = new JButton("Marcar como exportado");
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonLocalizar = new JButton("Localizar");
    private JButton buttonImprimir = new JButton("Imprimir");
    private ModeloGridTable modeloLogs = new ModeloGridTable(new String[]{"Fil.", "Log", "Tipo", "XML/Mensagem"});
    private JTable tableLogs = new JTable(this.modeloLogs);
    private JScrollPane scrollLogs = new JScrollPane(this.tableLogs);
    private JTextPane textPaneExcecao = new JTextPane();
    private JScrollPane scrollExcecao = new JScrollPane(this.textPaneExcecao);
    private JTextPane textPanePilhaExcecao = new JTextPane();
    private JScrollPane scrollPilhaExcecao = new JScrollPane(this.textPanePilhaExcecao);
    private PreparedStatement prstMarcarExportado = null;
    private FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo = null;
    private DadosErrosIntegracaoOperadora errosIntegracao = null;
    private boolean podeMarcarExportado = false;
    private JPopupMenu menuImprimir = new JPopupMenu();
    private String[] camposRelatorio = new String[]{"codigoLog", "erroLog", "operacaoLog", "usuarioLogado"};

    public JanelaErrosIntegracaoOperadora(Frame pai, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, DadosErrosIntegracaoOperadora errosIntegracao, boolean podeMarcarExportado) {
        super(pai);
        this.protocolo = protocolo;
        this.errosIntegracao = errosIntegracao;
        this.podeMarcarExportado = podeMarcarExportado;
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, Constantes.CAMPOS_FILIAL);
        this.setTitle("Erros de Integra\u00e7\u00e3o" + (protocolo != null ? " - " + protocolo.getDescricao() : ""));
        this.setModal(true);
        this.montaTela();
        this.carregaDados();
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaooperadora ");
        buf.append("    set eio_exportado = true ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and eio_codigo = ? ");
        this.prstMarcarExportado = Conexao.getPreparedStatement(buf.toString());
    }

    private void carregaDados() {
        this.modeloLogs.clear();
        if (this.errosIntegracao != null) {
            String erroAux;
            IntegracaoOperadoraException erro;
            int i;
            if (this.errosIntegracao.errosProcesso != null) {
                for (i = 0; i < this.errosIntegracao.errosProcesso.size(); ++i) {
                    erro = this.errosIntegracao.errosProcesso.get(i);
                    erroAux = erro.getMensagemErro().replace("\n", "");
                    this.modeloLogs.addLine(new Object[]{null, null, null, erroAux, erro});
                }
            }
            if (this.errosIntegracao.errosLogin != null) {
                for (i = 0; i < this.errosIntegracao.errosLogin.size(); ++i) {
                    erro = this.errosIntegracao.errosLogin.get(i);
                    erroAux = erro.getMensagemErro().replace("\n", "");
                    this.modeloLogs.addLine(new Object[]{null, null, null, erroAux, erro});
                }
            }
            if (this.errosIntegracao.errosEnvioResultado != null) {
                for (i = 0; i < this.errosIntegracao.errosEnvioResultado.size(); ++i) {
                    erro = this.errosIntegracao.errosEnvioResultado.get(i);
                    erroAux = erro.getMensagemErro().replace("\n", "");
                    String codigoFilial = "";
                    String codigoLog = "";
                    AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora tipoOperacao = null;
                    String xmlLog = "";
                    LogIntegracaoOperadora log = erro.getLog();
                    if (log != null) {
                        codigoFilial = String.valueOf(log.getCodigoFilial());
                        codigoLog = String.valueOf(log.getCodigoLog());
                        xmlLog = String.valueOf(log.getXmlLog());
                        tipoOperacao = log.getTipoOperacao();
                    }
                    this.modeloLogs.addLine(new Object[]{codigoFilial, codigoLog, tipoOperacao, xmlLog, erro});
                }
            }
        }
    }

    private void montaPanelLogs() {
        this.panelLogs.setBorder(new TitledBorder("Logs"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        this.panelLogs.add((Component)this.scrollLogs, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.labelLocalizar.setDisplayedMnemonic('o');
        this.labelLocalizar.setLabelFor(this.textLocalizar);
        this.panelLogs.add((Component)this.labelLocalizar, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textLocalizar.setPreferredSize(new Dimension(20, 20));
        this.textLocalizar.setMinimumSize(new Dimension(20, 20));
        this.panelLogs.add((Component)this.textLocalizar, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonLocalizar.setMnemonic('L');
        this.buttonLocalizar.setPreferredSize(new Dimension(100, 20));
        this.buttonLocalizar.setMinimumSize(new Dimension(100, 20));
        this.buttonLocalizar.setMargin(new Insets(1, 1, 1, 1));
        this.buttonLocalizar.addActionListener(this);
        this.panelLogs.add((Component)this.buttonLocalizar, c);
        this.modeloLogs.setColumnSize(new int[]{40, 40, 40, 0}, this.tableLogs);
        this.tableLogs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IntegracaoOperadoraException excecao;
                int row = JanelaErrosIntegracaoOperadora.this.tableLogs.getSelectedRow();
                if (row > -1 && (excecao = (IntegracaoOperadoraException)JanelaErrosIntegracaoOperadora.this.modeloLogs.getValueAt(row, 4)) != null) {
                    StringBuilder buf = new StringBuilder();
                    if (!Funcoes.textoVazio(excecao.getMensagemErro())) {
                        buf.append("***MENSAGEM DE RETORNO***");
                        buf.append("\n");
                        buf.append(excecao.getMensagemErro());
                    }
                    JanelaErrosIntegracaoOperadora.this.textPaneExcecao.setText(buf.toString());
                    if (excecao.getStackTrace() != null) {
                        buf.setLength(0);
                        for (StackTraceElement element : excecao.getStackTrace()) {
                            buf.append(element.toString()).append("\n");
                        }
                        JanelaErrosIntegracaoOperadora.this.textPanePilhaExcecao.setText(buf.toString());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JanelaErrosIntegracaoOperadora.this.textPaneExcecao.scrollRectToVisible(new Rectangle(0, 0));
                            JanelaErrosIntegracaoOperadora.this.textPanePilhaExcecao.scrollRectToVisible(new Rectangle(0, 0));
                        }
                    });
                }
                JanelaErrosIntegracaoOperadora.this.controlaBotaoMarcarExportado();
            }
        });
        this.tableLogs.setDefaultRenderer(Object.class, new LogRenderer());
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setVerticalAlignment(0);
        this.tableLogs.setDefaultRenderer(Object.class, centerRenderer);
    }

    private void montaPanelExcecao() {
        this.panelExcecao.setBorder(new TitledBorder("Exce\u00e7\u00e3o"));
        this.panelExcecao.add(this.scrollExcecao);
        this.textPaneExcecao.setEditable(false);
    }

    private void montaPanelPilhaExcecao() {
        this.panelPilhaExcecao.setBorder(new TitledBorder("Pilha de exce\u00e7\u00e3o"));
        this.panelPilhaExcecao.add(this.scrollPilhaExcecao);
        this.textPanePilhaExcecao.setEditable(false);
    }

    private void montaTela() {
        JPanel panelCentral = (JPanel)this.getContentPane();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.4;
        panelCentral.add((Component)this.panelLogs, c);
        ++c.gridy;
        c.weighty = 0.4;
        panelCentral.add((Component)this.panelExcecao, c);
        ++c.gridy;
        c.weighty = 0.2;
        panelCentral.add((Component)this.panelPilhaExcecao, c);
        ++c.gridy;
        c.weighty = 0.0;
        panelCentral.add((Component)this.panelBotoes, c);
        this.montaPanelLogs();
        this.montaPanelExcecao();
        this.montaPanelPilhaExcecao();
        this.montaPanelBotoes();
        this.setSize(700, 500);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }

    private void montaPanelBotoes() {
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        this.panelBotoes.add((Component)panelEsquerda, "West");
        this.panelBotoes.add((Component)panelDireita, "East");
        panelEsquerda.add(this.buttonMarcarComoExportado);
        panelEsquerda.add(this.buttonImprimir);
        panelDireita.add(this.buttonFechar);
        this.buttonMarcarComoExportado.setMnemonic('E');
        this.buttonMarcarComoExportado.addActionListener(this);
        this.buttonFechar.setMnemonic('F');
        this.buttonFechar.addActionListener(this);
        this.buttonImprimir.addActionListener(this);
        this.controlaBotaoMarcarExportado();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonMarcarComoExportado) {
            this.marcarComoExportado();
        } else if (e.getSource() == this.buttonLocalizar) {
            this.localizar();
        } else if (e.getSource() == this.buttonImprimir) {
            this.imprimirRelatorio();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void imprimirRelatorio() {
        String modeloRelatorio = "<relatorio><alturaPagina>21.0</alturaPagina><larguraPagina>29.7</larguraPagina><margens><esquerda>1.5</esquerda><direita>1.5</direita><superior>1.5</superior><inferior>1.5</inferior></margens><forcarRetrato>Nao</forcarRetrato><linhasGuias></linhasGuias><bandas><banda><tipoBanda>0</tipoBanda><nome>Banda1</nome><altura>38.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><quebrarPagina>false</quebrarPagina><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo1</nome><retangulo><x>1</x><y>1</y><largura>114.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Listagem de erros na integra\u00e7\u00e3o</texto></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco1</nome><retangulo><x>1</x><y>13</y><largura>295.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>descricaoFilial</nomeCampo><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao1</nome><retangulo><x>626</x><y>1</y><largura>128.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>data(dataHoraCorrente; \"dd/MM/aaaa hh:mm\")</expressao><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao2</nome><retangulo><x>684</x><y>13</y><largura>70.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>\"P\u00e1gina: \" + paginaCorrente + \"/\" + quantidadePaginas</expressao><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma1</nome><retangulo><x>1</x><y>23</y><largura>753.0</largura><altura>4.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo4</nome><retangulo><x>35</x><y>26</y><largura>40.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Erro</texto></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo3</nome><retangulo><x>1</x><y>26</y><largura>30.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>C\u00f3digo</texto></itemBanda></itens></banda><banda><tipoBanda>2</tipoBanda><nome>Banda2</nome><altura>9.0</altura><colunas>0</colunas><entreColunas>0</entreColunas><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><quebrarPagina>false</quebrarPagina><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco2</nome><retangulo><x>1</x><y>1</y><largura>30.0</largura><altura>7.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>codigoLog</nomeCampo><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco3</nome><retangulo><x>36</x><y>0</y><largura>717.0</largura><altura>7.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>erroLog</nomeCampo><mascara></mascara></itemBanda></itens></banda></bandas></relatorio>";
        ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
        if (this.errosIntegracao != null) {
            int col;
            Object[] o;
            String erroAux;
            IntegracaoOperadoraException erro;
            int i;
            if (this.errosIntegracao.errosProcesso != null) {
                for (i = 0; i < this.errosIntegracao.errosProcesso.size(); ++i) {
                    erro = this.errosIntegracao.errosProcesso.get(i);
                    erroAux = erro.getMensagemErro().replace("\n", "");
                    o = new Object[this.camposRelatorio.length];
                    for (col = 0; col < this.camposRelatorio.length; ++col) {
                        o[col] = this.camposRelatorio[col].equalsIgnoreCase("usuarioLogado") ? Variaveis.login : (this.camposRelatorio[col].equalsIgnoreCase("erroLog") ? erroAux : "");
                    }
                    modelo.addLine(o);
                }
            }
            if (this.errosIntegracao.errosLogin != null) {
                for (i = 0; i < this.errosIntegracao.errosLogin.size(); ++i) {
                    erro = this.errosIntegracao.errosLogin.get(i);
                    erroAux = erro.getMensagemErro().replace("\n", "");
                    o = new Object[this.camposRelatorio.length];
                    for (col = 0; col < this.camposRelatorio.length; ++col) {
                        o[col] = this.camposRelatorio[col].equalsIgnoreCase("usuarioLogado") ? Variaveis.login : (this.camposRelatorio[col].equalsIgnoreCase("erroLog") ? erroAux : "");
                    }
                    modelo.addLine(o);
                }
            }
            HashMap<Integer, Registro> filiais = new HashMap<Integer, Registro>();
            if (this.errosIntegracao.errosEnvioResultado != null) {
                for (int i2 = 0; i2 < this.errosIntegracao.errosEnvioResultado.size(); ++i2) {
                    IntegracaoOperadoraException erro2 = this.errosIntegracao.errosEnvioResultado.get(i2);
                    String erroAux2 = erro2.getMensagemErro().replace("\n", "");
                    if (erroAux2.toUpperCase().indexOf("Necess\u00e1rio fazer a confirma\u00e7\u00e3o do pedido m\u00e9dico antes da transmiss\u00e3o do laudo.".toUpperCase()) > -1) {
                        erroAux2 = erroAux2.replace("Necess\u00e1rio fazer a confirma\u00e7\u00e3o do pedido m\u00e9dico antes da transmiss\u00e3o do laudo.", "Necess\u00e1rio confirmar o pedido.");
                    }
                    if (erroAux2.indexOf("::") > -1) {
                        erroAux2 = erroAux2.substring(erroAux2.indexOf("::") + 2);
                    }
                    Object[] o2 = new Object[this.camposRelatorio.length];
                    for (int col2 = 0; col2 < this.camposRelatorio.length; ++col2) {
                        if (this.camposRelatorio[col2].equalsIgnoreCase("usuarioLogado")) {
                            o2[col2] = Variaveis.login;
                            continue;
                        }
                        if (this.camposRelatorio[col2].equalsIgnoreCase("codigoLog")) {
                            o2[col2] = erro2.getLog().getCodigoLog();
                            continue;
                        }
                        if (this.camposRelatorio[col2].equalsIgnoreCase("operacaoLog")) {
                            o2[col2] = erro2.getLog().getXmlLog();
                            continue;
                        }
                        if (!this.camposRelatorio[col2].equalsIgnoreCase("erroLog")) continue;
                        o2[col2] = erroAux2;
                    }
                    modelo.addLine(o2);
                    Statement st = Conexao.getStatement();
                    try {
                        Registro regFilial = null;
                        if (!filiais.containsKey(erro2.getLog().getCodigoFilial())) {
                            regFilial = RelatorioUtil.pegaDadosFilial(st, erro2.getLog().getCodigoFilial().toString());
                            filiais.put(erro2.getLog().getCodigoFilial(), regFilial);
                        } else {
                            regFilial = (Registro)filiais.get(erro2.getLog().getCodigoFilial());
                        }
                        RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                    }
                    catch (Exception exception) {
                        Conexao.fecharStatement(st);
                        continue;
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                    }
                    Conexao.fecharStatement(st);
                    continue;
                }
            }
        }
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
            gerador.setPreVisualizar(true);
            gerador.setZoomPreVisualizar(0.5f);
            gerador.executar("<relatorio><alturaPagina>21.0</alturaPagina><larguraPagina>29.7</larguraPagina><margens><esquerda>1.5</esquerda><direita>1.5</direita><superior>1.5</superior><inferior>1.5</inferior></margens><forcarRetrato>Nao</forcarRetrato><linhasGuias></linhasGuias><bandas><banda><tipoBanda>0</tipoBanda><nome>Banda1</nome><altura>38.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><quebrarPagina>false</quebrarPagina><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo1</nome><retangulo><x>1</x><y>1</y><largura>114.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Listagem de erros na integra\u00e7\u00e3o</texto></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco1</nome><retangulo><x>1</x><y>13</y><largura>295.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>descricaoFilial</nomeCampo><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao1</nome><retangulo><x>626</x><y>1</y><largura>128.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>data(dataHoraCorrente; \"dd/MM/aaaa hh:mm\")</expressao><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao2</nome><retangulo><x>684</x><y>13</y><largura>70.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>\"P\u00e1gina: \" + paginaCorrente + \"/\" + quantidadePaginas</expressao><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma1</nome><retangulo><x>1</x><y>23</y><largura>753.0</largura><altura>4.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo4</nome><retangulo><x>35</x><y>26</y><largura>40.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Erro</texto></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo3</nome><retangulo><x>1</x><y>26</y><largura>30.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>C\u00f3digo</texto></itemBanda></itens></banda><banda><tipoBanda>2</tipoBanda><nome>Banda2</nome><altura>9.0</altura><colunas>0</colunas><entreColunas>0</entreColunas><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><quebrarPagina>false</quebrarPagina><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco2</nome><retangulo><x>1</x><y>1</y><largura>30.0</largura><altura>7.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>codigoLog</nomeCampo><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco3</nome><retangulo><x>36</x><y>0</y><largura>717.0</largura><altura>7.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>erroLog</nomeCampo><mascara></mascara></itemBanda></itens></banda></bandas></relatorio>", (TableModel)modelo, null);
        } else {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
        }
    }

    private void configurarRelatorio() {
    }

    private void marcarComoExportado() {
        int row = this.tableLogs.getSelectedRow();
        if (row > -1) {
            Integer filial = (Integer)this.modeloLogs.getValueAt(row, 0);
            Integer log = (Integer)this.modeloLogs.getValueAt(row, 1);
            if (log != null && filial != null) {
                try {
                    this.prstMarcarExportado.setInt(1, filial);
                    this.prstMarcarExportado.setInt(2, log);
                    int qtde = this.prstMarcarExportado.executeUpdate();
                    if (qtde == 0) {
                        throw new Exception("O log n\u00e3o foi atualizado. Filial = " + filial + ", log = " + log);
                    }
                    Conexao.arquivaSQL();
                    if (qtde > 0) {
                        this.modeloLogs.removeLine(row);
                    }
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel marcar o log como exportado.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    private void controlaBotaoMarcarExportado() {
        int row = this.tableLogs.getSelectedRow();
        if (row > -1 && this.podeMarcarExportado) {
            this.buttonMarcarComoExportado.setEnabled(this.modeloLogs.getValueAt(row, 1) != null);
        } else {
            this.buttonMarcarComoExportado.setEnabled(false);
        }
    }

    private void localizar() {
        int row;
        if (Funcoes.textoVazio(this.textLocalizar)) {
            return;
        }
        String textoLocalizar = this.textLocalizar.getText();
        for (int i = row = this.tableLogs.getSelectedRow() + 1; i < this.modeloLogs.getRowCount(); ++i) {
            String xml;
            IntegracaoOperadoraException excecao = (IntegracaoOperadoraException)this.modeloLogs.getValueAt(i, 4);
            if (excecao == null || Funcoes.textoVazio(xml = excecao.getLog().getXmlLog()) || !xml.contains(textoLocalizar)) continue;
            this.tableLogs.getSelectionModel().setSelectionInterval(i, i);
            this.tableLogs.scrollRectToVisible(this.tableLogs.getCellRect(i, 0, false));
            break;
        }
    }

    class LogRenderer
    extends JTextArea
    implements TableCellRenderer {
        public LogRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
            if (table.getRowHeight(row) != this.getPreferredSize().height) {
                table.setRowHeight(row, this.getPreferredSize().height);
            }
            if (isSelected) {
                this.setBackground((Color)UIManager.get("Table.selectionBackground"));
                this.setForeground((Color)UIManager.get("Table.selectionForeground"));
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }
}

