/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas;

import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.agsi.IntegracaoOperadoraAGSI;
import jalis.integracaooperadoras.sistemas.ipmsaude.IntegracaoOperadoraIPMSaude;
import jalis.integracaooperadoras.sistemas.mksaude.IntegracaoOperadoraMKSaude;
import jalis.integracaooperadoras.sistemas.sdh.IntegracaoOperadoraSDH;
import jalis.integracaooperadoras.sistemas.simus.IntegracaoOperadoraSimus;
import jalis.integracaooperadoras.sistemas.sline.IntegracaoOperadoraSLine;
import jalis.integracaooperadoras.sistemas.unimed.guaxupe.IntegracaoOperadoraGuaxupe;
import jalis.integracaooperadoras.sistemas.unimed.ibitinga.IntegracaoOperadoraUnimedIbitinga;
import jalis.integracaooperadoras.sistemas.unimed.pr.IntegracaoOperadoraPR;
import jalis.integracaooperadoras.sistemas.unimed.sinos.IntegracaoOperadoraUnimedValeSinos;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.IntegracaoOperadoraUnimedUberaba;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.IntegracaoOperadoraUnimedVTRP;
import jalis.integracaooperadoras.sistemas.upy.IntegracaoOperadoraUpy;

public class FabricaIntegracaoOperadora {
    private static AbstractIntegracaoOperadora integracaoOperadora;

    public static AbstractIntegracaoOperadora getIntegracaoOperadora() {
        return integracaoOperadora;
    }

    public void setIntegracaoOperadora(AbstractIntegracaoOperadora integracaoOperadora) {
        FabricaIntegracaoOperadora.integracaoOperadora = integracaoOperadora;
    }

    public static AbstractIntegracaoOperadora novaIntegracaoOperadora(String descricaoProtocolo, String xml, int codigoConvenio) {
        ProtocoloIntegracaoOperadora protocolo = ProtocoloIntegracaoOperadora.getProtocoloDescricao(descricaoProtocolo);
        if (protocolo == null) {
            return null;
        }
        if (protocolo == ProtocoloIntegracaoOperadora.UPY) {
            return new IntegracaoOperadoraUpy(xml, codigoConvenio);
        }
        if (protocolo == ProtocoloIntegracaoOperadora.IBI) {
            return new IntegracaoOperadoraUnimedIbitinga(xml, codigoConvenio);
        }
        if (protocolo == ProtocoloIntegracaoOperadora.SDH) {
            return new IntegracaoOperadoraSDH(xml, codigoConvenio);
        }
        return null;
    }

    public static AbstractIntegracaoOperadora novaIntegracaoOperadora(ProtocoloIntegracaoOperadora protocolo, String xml, int codigoConvenio) {
        if (protocolo == null) {
            return null;
        }
        if (protocolo == ProtocoloIntegracaoOperadora.UPY) {
            integracaoOperadora = new IntegracaoOperadoraUpy(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.IBI) {
            integracaoOperadora = new IntegracaoOperadoraUnimedIbitinga(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.VTRP) {
            integracaoOperadora = new IntegracaoOperadoraUnimedVTRP(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.MK) {
            integracaoOperadora = new IntegracaoOperadoraMKSaude(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.SDH) {
            integracaoOperadora = new IntegracaoOperadoraSDH(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.SINOS) {
            integracaoOperadora = new IntegracaoOperadoraUnimedValeSinos(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.UBERABA) {
            integracaoOperadora = new IntegracaoOperadoraUnimedUberaba(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.IPMSAUDE) {
            integracaoOperadora = new IntegracaoOperadoraIPMSaude(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.SIMUS) {
            integracaoOperadora = new IntegracaoOperadoraSimus(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.UNIMEDPR) {
            integracaoOperadora = new IntegracaoOperadoraPR(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.UNIMEDGUAXUPE) {
            integracaoOperadora = new IntegracaoOperadoraGuaxupe(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.SLINE) {
            integracaoOperadora = new IntegracaoOperadoraSLine(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.AGSI) {
            integracaoOperadora = new IntegracaoOperadoraAGSI(xml, codigoConvenio);
        } else {
            return null;
        }
        return integracaoOperadora;
    }

    public static AbstractIntegracaoOperadora novaIntegracaoOperadoraComParametro(ProtocoloIntegracaoOperadora protocolo, String xml, int codigoConvenio, Object[] parametro) {
        if (protocolo == null) {
            return null;
        }
        if (protocolo == ProtocoloIntegracaoOperadora.UPY) {
            integracaoOperadora = new IntegracaoOperadoraUpy(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.IBI) {
            integracaoOperadora = new IntegracaoOperadoraUnimedIbitinga(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.VTRP) {
            integracaoOperadora = new IntegracaoOperadoraUnimedVTRP(xml, codigoConvenio, parametro);
        } else if (protocolo == ProtocoloIntegracaoOperadora.MK) {
            integracaoOperadora = new IntegracaoOperadoraMKSaude(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.SDH) {
            integracaoOperadora = new IntegracaoOperadoraSDH(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.SINOS) {
            integracaoOperadora = new IntegracaoOperadoraUnimedValeSinos(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.UBERABA) {
            integracaoOperadora = new IntegracaoOperadoraUnimedUberaba(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.IPMSAUDE) {
            integracaoOperadora = new IntegracaoOperadoraIPMSaude(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.SIMUS) {
            integracaoOperadora = new IntegracaoOperadoraSimus(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.UNIMEDPR) {
            integracaoOperadora = new IntegracaoOperadoraPR(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.UNIMEDGUAXUPE) {
            integracaoOperadora = new IntegracaoOperadoraGuaxupe(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.SLINE) {
            integracaoOperadora = new IntegracaoOperadoraSLine(xml, codigoConvenio);
        } else if (protocolo == ProtocoloIntegracaoOperadora.AGSI) {
            integracaoOperadora = new IntegracaoOperadoraAGSI(xml, codigoConvenio);
        } else {
            return null;
        }
        return integracaoOperadora;
    }

    public static enum ProtocoloIntegracaoOperadora {
        UPY("UPY Lab", "U"),
        IBI("Unimed Ibitinga", "I"),
        VTRP("Unimed VTRP", "V"),
        MK("MK Sa\u00fade", "M"),
        SDH("Data Health", "D"),
        SINOS("Unimed Vale dos Sinos", "S"),
        UBERABA("Unimed Uberaba", "B"),
        IPMSAUDE("IPM Sa\u00fade", "P"),
        SIMUS("SIMUS", "A"),
        UNIMEDPR("Unimed PR", "R"),
        UNIMEDGUAXUPE("Unimed Guaxup\u00e9", "G"),
        SLINE("SLine", "L"),
        AGSI("AGSI Sistemas", "Y");

        private String descricao = null;
        private String codigo = null;

        private ProtocoloIntegracaoOperadora(String descricao, String codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public static ProtocoloIntegracaoOperadora getProtocoloDescricao(String nomeIntegracaoOperadora) {
            for (ProtocoloIntegracaoOperadora protocolo : ProtocoloIntegracaoOperadora.values()) {
                if (!protocolo.descricao.equalsIgnoreCase(nomeIntegracaoOperadora)) continue;
                return protocolo;
            }
            return null;
        }

        public static ProtocoloIntegracaoOperadora[] getOperadoras() {
            ProtocoloIntegracaoOperadora[] operadoras = new ProtocoloIntegracaoOperadora[ProtocoloIntegracaoOperadora.values().length - 1];
            Integer contador = 0;
            for (ProtocoloIntegracaoOperadora protocoloIntegracaoOperadora : ProtocoloIntegracaoOperadora.values()) {
                if (!ProtocoloIntegracaoOperadora.isNotMK(protocoloIntegracaoOperadora.codigo)) continue;
                Integer n = contador;
                Integer n2 = contador = Integer.valueOf(contador + 1);
                operadoras[n.intValue()] = protocoloIntegracaoOperadora;
            }
            return operadoras;
        }

        private static boolean isNotMK(String codigo) {
            return !codigo.equals(ProtocoloIntegracaoOperadora.MK.codigo);
        }

        public static ProtocoloIntegracaoOperadora getProtocoloCodigo(String codigo) {
            for (ProtocoloIntegracaoOperadora protocolo : ProtocoloIntegracaoOperadora.values()) {
                if (null == protocolo || !protocolo.codigo.equalsIgnoreCase(codigo)) continue;
                return protocolo;
            }
            return null;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getCodigo() {
            return this.codigo;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

