/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.ConfiguradorAgrupamentoUnimedVTRPModel;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.util.ImagemUtils;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Window;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public abstract class AbstractIntegracaoOperadora {
    protected int codigoConvenio = -1;
    public static final ImageIcon ICONE_EXECUTANDO = ImagemUtils.carregaImagemJalis("enviando_operadora_on.jpg");
    public static final ImageIcon ICONE_PARADO = ImagemUtils.carregaImagemJalis("enviando_operadora_off.jpg");
    public static final ImageIcon ICONE_ERRO = ImagemUtils.carregaImagemJalis("enviando_operadora_erro.jpg");
    public static final ImageIcon ICONE_AGUARDANDO_WS = ImagemUtils.carregaImagemJalis("enviando_operadora_aguardando_ws.jpg");
    public static final String TAG_EXPORTACAO_INTEGRACAO_OPERADORA = "integracaooperadora";
    public static final String TAG_EXPORTACAO_NOME_INTEGRACAO = "nomeintegracaooperadora";
    public static final String TAG_EXPORTACAO_FILIAL = "filial";
    public static final String TAG_EXPORTACAO_CODIGO_REQUISICAO = "codreq";
    public static final String TAG_EXPORTACAO_CODIGO_EXAME = "codexa";
    public static final String TAG_EXPORTACAO_CODIGO_MATERIAL = "codmat";
    public static final String TAG_EXPORTACAO_CODIGO_PACIENTE = "codPaciente";
    public static final String TAG_INTEGRACAO_OPERADORA = "integracaooperadora";
    public static final String TAG_INTEGRACAO_PROTOCOLO = "protocolo";
    public static final String TAG_INTEGRACAO_ESTACAO = "estacao";
    public DadosErrosIntegracaoOperadora erros = new DadosErrosIntegracaoOperadora();
    private ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel = new ArrayList();
    private String xmlConfiguracao = null;
    private boolean isExecutando = false;

    public ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> getArrayConfiguradorAgrupUnimedModel() {
        return this.arrayConfiguradorAgrupUnimedModel;
    }

    public AbstractIntegracaoOperadora setArrayConfiguradorAgrupUnimedModel(ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel) {
        this.arrayConfiguradorAgrupUnimedModel = arrayConfiguradorAgrupUnimedModel;
        return this;
    }

    public DadosErrosIntegracaoOperadora getErros() {
        return this.erros;
    }

    public abstract DadosErrosIntegracaoOperadora integrarOperadora();

    public void setXML(String xml) {
        this.xmlConfiguracao = xml;
    }

    public String getXML() {
        return this.xmlConfiguracao;
    }

    public abstract String configurar(Window var1, String var2);

    public boolean isExecutando() {
        return this.isExecutando;
    }

    public synchronized void setExecutando(boolean isExecutando) {
        this.isExecutando = isExecutando;
    }

    public String getNomeIntegracaoOperadora() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String tipoOperacao, String ... comando) {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        if (!AbstractIntegracaoOperadora.getConvenioUtilizaIntegracaoOperadora(filial, convenio)) {
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever(TAG_EXPORTACAO_NOME_INTEGRACAO, protocolo.getDescricao());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append("            (fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado) ");
        buf.append("     values (").append(filial);
        buf.append(" ,").append(convenio);
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(filial)).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false) ");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ConexaoTemporaria.executeUpdate(filial, st, buf);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean getConvenioUtilizaIntegracaoOperadora(String codigoFilial, String codigoConvenio) {
        boolean bl;
        Statement st;
        block5: {
            StringBuilder buf = new StringBuilder();
            buf.append(" select NULLIF(TRIM(con_integracaooperadora), '') IS NOT NULL as configurado ");
            buf.append("   from convenios ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and con_codigo = ").append(codigoConvenio);
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (!rs.next()) break block5;
            boolean bl2 = rs.getBoolean("configurado");
            Conexao.fecharStatement(st);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se o conv\u00eanio " + codigoConvenio + " utiliza integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    public static enum TipoOperacaoIntegracaoOperadora {
        ENVIO_RESULTADO("R"),
        ENVIO_LAUDO("L");

        private String operacao = null;

        private TipoOperacaoIntegracaoOperadora(String operacao) {
            this.operacao = operacao;
        }

        public static TipoOperacaoIntegracaoOperadora getTipoOperacao(String operacao) {
            for (TipoOperacaoIntegracaoOperadora aux : TipoOperacaoIntegracaoOperadora.values()) {
                if (!aux.toString().equals(operacao)) continue;
                return aux;
            }
            return null;
        }

        public String toString() {
            return this.operacao;
        }
    }
}

