/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.warelinebd;

import jalis.integracaohospitais.util.AbstractConfiguradorConveniosIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorConvenioWarelineBD
extends AbstractConfiguradorConveniosIntegracaoHospital {
    private static final String TITULO = "Configurando integra\u00e7\u00e3o WarelineBD";
    private JButton buttonOkConv = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonRemoverConfig = ComponenteFactory.novoJButton("Remover Configura\u00e7\u00e3o", 'R', this);
    private TTextField textCodigoLaboratorio = new TTextField();
    private TTextField textCodigoOperador = new TTextField();
    private TTextField textIdConvenioHospital = new TTextField();
    private JLabel labelLaboratorio = new JLabel("Laborat\u00f3rio:");
    private JLabel labelOperador = new JLabel("Operador:");
    private JLabel labelConvenioHospital = new JLabel("Conv\u00eanio Hospital:");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"ID Conv\u00eanio"});
    private JTable tableConvenio = new JTable(this.modelo);
    private JScrollPane scrollConvenio = new JScrollPane(this.tableConvenio);
    public static final String TAG_OPERADOR = "codigoOperador";
    public static final String TAG_LABORATORIO = "codigoLaboratorio";
    public static final String TAG_CONVENIOHOSPITAL = "convenioHospital";
    public static final String TAG_CONVENIOSHOSPITAL = "conveniosHospital";
    public static final String TAG_IDCONVENIO = "idConvenio";
    private boolean removeuConfiguracaoHospital = false;

    public static AbstractConfiguradorConveniosIntegracaoHospital novaInstancia(Object pai, String xmlIntegracaoHospital) {
        if (pai instanceof Frame) {
            return new ConfiguradorConvenioWarelineBD((Frame)pai, TITULO, xmlIntegracaoHospital);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorConvenioWarelineBD((Dialog)pai, TITULO, xmlIntegracaoHospital);
        }
        return null;
    }

    public ConfiguradorConvenioWarelineBD(Frame pai, String titulo, String xmlIntegracaoHospital) {
        super(pai, titulo, xmlIntegracaoHospital);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.montaTela();
    }

    public ConfiguradorConvenioWarelineBD(Dialog pai, String titulo, String xmlIntegracaoHospital) {
        super(pai, titulo, xmlIntegracaoHospital);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.montaTela();
    }

    private void montaTela() {
        JPanel panelPrincipal = this.getPanelCentral();
        JPanel panelNorte = new JPanel();
        JPanel panelSul = new JPanel(new BorderLayout());
        panelNorte.setLayout(new GridBagLayout());
        this.setUsuarioPodeCancelar(false);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.setResizable(false);
        Funcoes.montaEnter((JComponent)panelPrincipal);
        Dimension tamanhoCaixaTexto = new Dimension(418, 20);
        Dimension tamanhoCaixaTextoMenor = new Dimension(170, 20);
        this.buttonOkConv.setMinimumSize(new Dimension(40, 20));
        this.buttonOkConv.setPreferredSize(new Dimension(40, 20));
        this.textCodigoLaboratorio.setMinimumSize(tamanhoCaixaTexto);
        this.textCodigoLaboratorio.setPreferredSize(tamanhoCaixaTexto);
        this.textCodigoOperador.setMinimumSize(tamanhoCaixaTexto);
        this.textCodigoOperador.setPreferredSize(tamanhoCaixaTexto);
        this.textIdConvenioHospital.setMinimumSize(tamanhoCaixaTextoMenor);
        this.textIdConvenioHospital.setPreferredSize(tamanhoCaixaTextoMenor);
        panelNorte.setSize(new Dimension(550, 320));
        this.modelo.setColumnSize(new int[]{0}, this.tableConvenio);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 2, 0, 4);
        panelNorte.add((Component)this.labelLaboratorio, c);
        ++c.gridx;
        c.gridwidth = 8;
        panelNorte.add((Component)this.textCodigoLaboratorio, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        panelNorte.add((Component)this.labelOperador, c);
        ++c.gridx;
        c.gridwidth = 8;
        panelNorte.add((Component)this.textCodigoOperador, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panelNorte.add((Component)this.labelConvenioHospital, c);
        ++c.gridx;
        c.gridwidth = 6;
        c.insets = new Insets(1, 2, 0, 0);
        panelNorte.add((Component)this.textIdConvenioHospital, c);
        c.gridx = 7;
        c.gridwidth = 2;
        panelNorte.add((Component)this.buttonOkConv, c);
        panelSul.add((Component)this.scrollConvenio, "Center");
        panelPrincipal.setLayout(new BorderLayout());
        panelPrincipal.add((Component)panelNorte, "North");
        panelPrincipal.add((Component)panelSul, "Center");
        this.getPanelBotoesEsquerda().add(this.buttonRemoverConfig);
        this.setSize(new Dimension(550, 320));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textCodigoLaboratorio);
        this.buttonOkConv.addActionListener(this);
        this.tableConvenio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorConvenioWarelineBD.this.tableConvenio.getSelectedRow() >= 0 && Funcoes.mensagem(ConfiguradorConvenioWarelineBD.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfiguradorConvenioWarelineBD.this.modelo.removeLine(ConfiguradorConvenioWarelineBD.this.tableConvenio.getSelectedRow());
                }
            }
        });
        this.carregarDados();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK && this.validaCampos()) {
            this.ok = true;
            this.dispose();
        }
        if (e.getSource() == this.buttonCancelar) {
            this.dispose();
        }
        if (e.getSource() == this.buttonOkConv) {
            this.adicionarConvenio();
        }
        if (e.getSource() == this.buttonRemoverConfig) {
            this.removerConfiguracao();
        }
    }

    private void removerConfiguracao() {
        if (Funcoes.mensagem(this, "Deseja excluir a configura\u00e7\u00e3o ?", 4) == 0) {
            this.limpaCampos();
            this.getXmlIntegracaoHospital();
            this.removeuConfiguracaoHospital = true;
        }
    }

    private void limpaCampos() {
        this.textCodigoLaboratorio.setText("");
        this.textCodigoOperador.setText("");
        this.textIdConvenioHospital.setText("");
        this.modelo.clear();
    }

    private boolean validaCampos() {
        if (this.removeuConfiguracaoHospital) {
            return true;
        }
        if (Funcoes.textoVazio(this.textCodigoLaboratorio.getText())) {
            Funcoes.mensagem(this, "O c\u00f3digo do Laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoLaboratorio);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoOperador.getText())) {
            Funcoes.mensagem(this, "O c\u00f3digo do operador deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoOperador);
            return false;
        }
        if (this.modelo.getRowCount() < 1) {
            Funcoes.mensagem(this, "ID de Conv\u00eanio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textIdConvenioHospital);
            return false;
        }
        return true;
    }

    private void adicionarConvenio() {
        if (!Funcoes.textoVazio(this.textIdConvenioHospital)) {
            boolean encontrado = false;
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                String idPlano = (String)this.modelo.getValueAt(i, 0);
                if (!idPlano.equals(this.textIdConvenioHospital.getText())) continue;
                encontrado = true;
                break;
            }
            if (!encontrado) {
                this.modelo.addLine(new Object[]{this.textIdConvenioHospital.getText()});
            }
            this.textIdConvenioHospital.clear();
            ScreenUtil.requisitarFoco(this.textIdConvenioHospital);
        }
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (!Funcoes.textoVazio(this.textCodigoLaboratorio.getText())) {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append("xmlconveniohospital").append(">");
            buf.append("<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.WARELINEBD.getNome()).append("</").append("protocolo").append(">");
            buf.append("<").append(TAG_LABORATORIO).append(">").append(this.textCodigoLaboratorio.getText()).append("</").append(TAG_LABORATORIO).append(">");
            buf.append("<").append(TAG_OPERADOR).append(">").append(this.textCodigoOperador.getText()).append("</").append(TAG_OPERADOR).append(">");
            buf.append("<").append(TAG_CONVENIOSHOSPITAL).append(">");
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                String codigoPlano = (String)this.modelo.getValueAt(i, 0);
                buf.append("<").append(TAG_CONVENIOHOSPITAL).append(">");
                buf.append("<").append(TAG_IDCONVENIO).append(">").append(codigoPlano).append("</").append(TAG_IDCONVENIO).append(">");
                buf.append("</").append(TAG_CONVENIOHOSPITAL).append(">");
            }
            buf.append("</").append(TAG_CONVENIOSHOSPITAL).append(">");
            buf.append("</").append("xmlconveniohospital").append(">");
            return buf.toString();
        }
        return null;
    }

    private void carregarDados() {
        if (!Funcoes.textoVazio(this.xmlIntegracaoHospital)) {
            String operador = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_OPERADOR);
            String laboratorio = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_LABORATORIO);
            String convenios = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_CONVENIOSHOSPITAL);
            String[] convenio = StringUtil.getValores(convenios, TAG_CONVENIOHOSPITAL);
            if (!Funcoes.textoVazio(operador)) {
                this.textCodigoOperador.setText(operador);
            }
            if (!Funcoes.textoVazio(laboratorio)) {
                this.textCodigoLaboratorio.setText(laboratorio);
            }
            for (String conv : convenio) {
                String con = StringUtil.getValor(conv, TAG_IDCONVENIO);
                this.modelo.addLine(new String[]{con});
            }
        }
    }
}

