/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.tasyws;

import jalis.integracaohospitais.util.AbstractConfiguradorConveniosIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfiguradorConveniosTasyWS
extends AbstractConfiguradorConveniosIntegracaoHospital {
    private TTextField textConvenio = new TTextField(6, 1);
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private TTextField textSetorAtendimento = new TTextField(6, 1);
    private JLabel labelSetorAtendimento = new JLabel("Setor Atendimento:");

    public static ConfiguradorConveniosTasyWS novaInstancia(Object pai, String xmlIntegracaoHospital) {
        if (pai instanceof Frame) {
            return new ConfiguradorConveniosTasyWS((Frame)pai, xmlIntegracaoHospital);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorConveniosTasyWS((Dialog)pai, xmlIntegracaoHospital);
        }
        return null;
    }

    public ConfiguradorConveniosTasyWS(Dialog pai, String xmlIntegracaoHospital) {
        super(pai, "Configura\u00e7\u00e3o conv\u00eanios do TasyWebService", xmlIntegracaoHospital);
        if (!Funcoes.textoVazio(xmlIntegracaoHospital)) {
            String protocolo = StringUtil.getValor(xmlIntegracaoHospital, "protocolo");
            this.xmlIntegracaoHospital = !Funcoes.textoVazio(protocolo) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.TASY_WEBSERVICE.getNome()) ? xmlIntegracaoHospital : null;
        }
        this.montaTela();
    }

    public ConfiguradorConveniosTasyWS(Frame pai, String xmlIntegracaoHospital) {
        super(pai, "Configura\u00e7\u00e3o TasyWebService", xmlIntegracaoHospital);
        if (!Funcoes.textoVazio(xmlIntegracaoHospital)) {
            String protocolo = StringUtil.getValor(xmlIntegracaoHospital, "protocolo");
            this.xmlIntegracaoHospital = !Funcoes.textoVazio(protocolo) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.TASY_WEBSERVICE.getNome()) ? xmlIntegracaoHospital : null;
        }
        this.montaTela();
    }

    private void montaTela() {
        JPanel painelCentral = this.getPanelCentral();
        painelCentral.setLayout(new GridBagLayout());
        this.textConvenio.setMinimumSize(new Dimension(80, 20));
        this.textConvenio.setPreferredSize(new Dimension(80, 20));
        this.textSetorAtendimento.setMinimumSize(new Dimension(80, 20));
        this.textSetorAtendimento.setPreferredSize(new Dimension(80, 20));
        if (this.xmlIntegracaoHospital != null) {
            String aux = StringUtil.getValor(this.xmlIntegracaoHospital, "xmlconveniohospital");
            this.textConvenio.setText(StringUtil.getValor(aux, "codigo"));
            this.textSetorAtendimento.setText(StringUtil.getValor(aux, "setor"));
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.insets = new Insets(1, 5, 0, 0);
        this.labelConvenio.setDisplayedMnemonic('o');
        this.labelConvenio.setLabelFor(this.textConvenio);
        painelCentral.add((Component)this.labelConvenio, c);
        ++c.gridx;
        painelCentral.add((Component)this.textConvenio, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        painelCentral.add((Component)new JLabel(), c);
        c.anchor = 17;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.labelSetorAtendimento.setLabelFor(this.textSetorAtendimento);
        painelCentral.add((Component)this.labelSetorAtendimento, c);
        ++c.gridx;
        painelCentral.add((Component)this.textSetorAtendimento, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        painelCentral.add((Component)new JLabel(), c);
        this.setResizable(false);
        this.setSize(new Dimension(270, 130));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textConvenio);
    }

    public Integer getCodigoConvenio() {
        String valor = this.textConvenio.getText();
        if (!Funcoes.textoVazio(valor)) {
            return Integer.parseInt(valor);
        }
        return null;
    }

    public String getSetorConvenio() {
        return this.textSetorAtendimento.getText();
    }

    @Override
    public boolean acaoOk() {
        return true;
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (this.getCodigoConvenio() != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append("xmlconveniohospital").append(">");
            buf.append("<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.TASY_WEBSERVICE.getNome()).append("</").append("protocolo").append(">");
            buf.append("<").append("codigo").append(">").append(this.getCodigoConvenio()).append("</").append("codigo").append(">");
            buf.append("<").append("setor").append(">").append(this.getSetorConvenio()).append("</").append("setor").append(">");
            buf.append("</").append("xmlconveniohospital").append(">");
            return buf.toString();
        }
        return null;
    }
}

