/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.tasy;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.integracaohospitais.DadosIntegracaoHospitalBean;
import jalis.model.utils.ThreadDaoException;
import jalis.service.integracaohospitais.DadosIntegracaoHospitalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class JanelaAssociacaoMedicamentos
extends AbstractDialogoOKCancelar {
    private static final int COLUNA_MEDICAMENTO = 0;
    private static final int COLUNA_CODIGO_TASY = 1;
    private JLabel labelMedicamento = new JLabel("Descri\u00e7\u00e3o medicamento");
    private JLabel labelCodigoTasy = new JLabel("C\u00f3digo Tasy");
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private TTextField textMedicamentoDescricao = new TTextField(50, 3);
    private TTextField textMedicamentoCodigoTasy = new TTextField(10, 3);
    private TTextField textLocalizar = new TTextField(50, 3);
    private JButton buttonOkAssociacao = new JButton("OK");
    private ModeloGridTable modeloAssoaciacao = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o Medicamento", "C\u00f3digo Tasy"});
    private JTable tableAssociacao = new JTable(this.modeloAssoaciacao);
    private JScrollPane scrollAssociacao = new JScrollPane(this.tableAssociacao);
    private JPanel panelPesquisa = new JPanel(new BorderLayout());
    private int linhaEdicao = -1;

    public static JanelaAssociacaoMedicamentos novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new JanelaAssociacaoMedicamentos((Dialog)pai);
        }
        if (pai instanceof Frame) {
            return new JanelaAssociacaoMedicamentos((Frame)pai);
        }
        return null;
    }

    public JanelaAssociacaoMedicamentos(Dialog pai) {
        super(pai, "Associando medicamentos");
        this.montaTela();
        this.carregarDados();
    }

    public JanelaAssociacaoMedicamentos(Frame pai) {
        super(pai, "Associando medicamentos");
        this.montaTela();
        this.carregarDados();
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        Dimension d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelMedicamento.setLabelFor(this.textMedicamentoDescricao);
        this.labelMedicamento.setDisplayedMnemonic('D');
        panelCentral.add((Component)this.labelMedicamento, c);
        ++c.gridx;
        this.labelCodigoTasy.setLabelFor(this.textMedicamentoCodigoTasy);
        this.labelCodigoTasy.setDisplayedMnemonic('M');
        panelCentral.add((Component)this.labelCodigoTasy, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.textMedicamentoDescricao.setPreferredSize(d);
        this.textMedicamentoDescricao.setMinimumSize(d);
        panelCentral.add((Component)this.textMedicamentoDescricao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        d = new Dimension(80, 20);
        this.textMedicamentoCodigoTasy.setPreferredSize(d);
        d = new Dimension(80, 20);
        this.textMedicamentoCodigoTasy.setMinimumSize(d);
        panelCentral.add((Component)this.textMedicamentoCodigoTasy, c);
        ++c.gridx;
        d = new Dimension(40, 20);
        this.buttonOkAssociacao.setMinimumSize(d);
        this.buttonOkAssociacao.setPreferredSize(d);
        this.buttonOkAssociacao.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkAssociacao.addActionListener(this);
        this.buttonOkAssociacao.setMnemonic('K');
        panelCentral.add((Component)this.buttonOkAssociacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.modeloAssoaciacao.setColumnSize(new int[]{0, 80}, this.tableAssociacao);
        d = new Dimension(20, 120);
        this.scrollAssociacao.setMinimumSize(d);
        d = new Dimension(20, 120);
        this.scrollAssociacao.setPreferredSize(d);
        this.tableAssociacao.getTableHeader().addMouseListener(this.modeloAssoaciacao);
        this.modeloAssoaciacao.ordenarColuna(0);
        panelCentral.add((Component)this.scrollAssociacao, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        panelCentral.add((Component)this.panelPesquisa, c);
        this.panelPesquisa.add((Component)this.labelLocalizar, "West");
        d = new Dimension(20, 20);
        this.textLocalizar.setMinimumSize(d);
        this.textLocalizar.setPreferredSize(d);
        this.panelPesquisa.add((Component)this.textLocalizar, "Center");
        this.setSize(350, 350);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.montaListeners();
        this.getBotaoOK().setText("Salvar");
        this.getBotaoOK().setMnemonic('S');
        ((JComponent)this.getContentPane()).getActionMap().remove("escape");
        ScreenUtil.requisitarFoco(this.textMedicamentoDescricao);
        Funcoes.montaEnter((JComponent)panelCentral);
    }

    private void montaListeners() {
        this.tableAssociacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && JanelaAssociacaoMedicamentos.this.tableAssociacao.getSelectedRow() > -1 && Funcoes.mensagem(JanelaAssociacaoMedicamentos.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    JanelaAssociacaoMedicamentos.this.modeloAssoaciacao.removeLine(JanelaAssociacaoMedicamentos.this.tableAssociacao.getSelectedRow());
                } else if (e.getKeyCode() == 32 && JanelaAssociacaoMedicamentos.this.tableAssociacao.getSelectedRow() > -1) {
                    JanelaAssociacaoMedicamentos.this.linhaEdicao = JanelaAssociacaoMedicamentos.this.tableAssociacao.getSelectedRow();
                    JanelaAssociacaoMedicamentos.this.textMedicamentoDescricao.setText(JanelaAssociacaoMedicamentos.this.modeloAssoaciacao.getValueAt(JanelaAssociacaoMedicamentos.this.linhaEdicao, 0).toString());
                    JanelaAssociacaoMedicamentos.this.textMedicamentoCodigoTasy.setText(JanelaAssociacaoMedicamentos.this.modeloAssoaciacao.getValueAt(JanelaAssociacaoMedicamentos.this.linhaEdicao, 1).toString());
                    ScreenUtil.requisitarFoco(JanelaAssociacaoMedicamentos.this.textMedicamentoDescricao);
                }
            }
        });
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int linha = JanelaAssociacaoMedicamentos.this.modeloAssoaciacao.localizarParcial(JanelaAssociacaoMedicamentos.this.modeloAssoaciacao.getColunaOrdenacao(), JanelaAssociacaoMedicamentos.this.textLocalizar.getText());
                if (linha != -1) {
                    JanelaAssociacaoMedicamentos.this.tableAssociacao.getSelectionModel().setSelectionInterval(linha, linha);
                    JanelaAssociacaoMedicamentos.this.tableAssociacao.scrollRectToVisible(JanelaAssociacaoMedicamentos.this.tableAssociacao.getCellRect(linha, 0, false));
                }
            }
        });
    }

    private void carregarDados() {
        ArrayList<DadosIntegracaoHospitalBean> listaDados = null;
        try {
            listaDados = new DadosIntegracaoHospitalService().getBeans("E");
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados das associa\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
        if (listaDados != null) {
            for (DadosIntegracaoHospitalBean dados : listaDados) {
                String xml = dados.getConfiguracao();
                if (Funcoes.textoVazio(xml)) continue;
                String medicamento = StringUtil.getValor(xml, "assocnomemed", true);
                String codigoTasy = StringUtil.getValor(xml, "assocmedtasy", true);
                this.modeloAssoaciacao.addLine(new Object[]{medicamento, codigoTasy});
            }
        }
        this.modeloAssoaciacao.ordenarColunaSemTrocarSentido(this.modeloAssoaciacao.getColunaOrdenacao());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getBotaoOK()) {
            this.salvar();
            this.dispose();
        } else if (e.getSource() == this.buttonOkAssociacao) {
            this.adicionaAssociacao();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionaAssociacao() {
        String medicamento = this.textMedicamentoDescricao.getText();
        String codigoTasy = this.textMedicamentoCodigoTasy.getText();
        if (Funcoes.textoVazio(medicamento) && Funcoes.textoVazio(codigoTasy)) {
            ScreenUtil.requisitarFoco(this.textMedicamentoCodigoTasy);
            return;
        }
        if (Funcoes.textoVazio(medicamento)) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o do medicamento deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textMedicamentoDescricao);
            return;
        }
        if (Funcoes.textoVazio(codigoTasy)) {
            Funcoes.mensagem(this, "O c\u00f3digo do Tasy do medicamento deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textMedicamentoCodigoTasy);
            return;
        }
        for (int i = 0; i < this.modeloAssoaciacao.getRowCount(); ++i) {
            if (!this.modeloAssoaciacao.getValueAt(i, 0).toString().equalsIgnoreCase(medicamento)) continue;
            Funcoes.mensagem(this, "O medicamento j\u00e1 foi associado.", 2);
            return;
        }
        if (this.linhaEdicao > -1) {
            this.modeloAssoaciacao.setValueAt(this.textMedicamentoDescricao.getText(), this.linhaEdicao, 0);
            this.modeloAssoaciacao.setValueAt(this.textMedicamentoCodigoTasy.getText(), this.linhaEdicao, 1);
        } else {
            this.modeloAssoaciacao.addLine(new Object[]{medicamento, codigoTasy});
        }
        this.textMedicamentoDescricao.clear();
        this.textMedicamentoCodigoTasy.clear();
        this.modeloAssoaciacao.ordenarColunaSemTrocarSentido(this.modeloAssoaciacao.getColunaOrdenacao());
        ScreenUtil.requisitarFoco(this.textMedicamentoDescricao);
    }

    private void salvar() {
        DadosIntegracaoHospitalService service = new DadosIntegracaoHospitalService();
        try {
            service.removerAssociacoes("E");
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel remover as associa\u00e7\u00f5es antigas.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        for (int i = 0; i < this.modeloAssoaciacao.getRowCount(); ++i) {
            String nomeMedicamento = this.modeloAssoaciacao.getValueAt(i, 0).toString();
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("assocmed");
            xml.escrever("assocnomemed", nomeMedicamento);
            xml.escrever("assocmedtasy", this.modeloAssoaciacao.getValueAt(i, 1).toString());
            try {
                xml.fechar("assocmed");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar xml de associa\u00e7\u00e3o de medicamentos.\n" + e.getMessage(), e.getStackTrace());
            }
            DadosIntegracaoHospitalBean bean = new DadosIntegracaoHospitalBean();
            bean.setCodigo(null);
            bean.setTipo("E");
            bean.setDescricao(nomeMedicamento);
            bean.setConfiguracao(xml.getXML());
            try {
                service.insert(bean, null, Variaveis.filialPadrao, null);
                continue;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel inserir associa\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar associa\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }
}

