/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.tasy;

import jalis.integracaohospitais.util.AbstractConfiguradorExamesIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.tasy.ConfiguradorDadosMicrobiologia;
import jalis.integracaohospitais.util.tasy.DadosMedicamento;
import jalis.integracaohospitais.util.tasy.DadosMicroorganismo;
import jalis.integracaohospitais.util.tasy.TipoExame;
import jalis.integracaohospitais.util.tasy.ValorComboMicrobiologia;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ConfiguradorExamesTasy
extends AbstractConfiguradorExamesIntegracaoHospital
implements WindowListener {
    private static final int COLUNA_ANALITO_CODIGO_TASY = 0;
    private static final int COLUNA_ANALITO_RESULTADO = 1;
    private static final int COLUNA_ANALITO_MICROBIOLOGIA = 2;
    private static final int COLUNA_ANALITO_CONFIGURACAO = 3;
    private static final int COLUNA_ITEM_DESCRICAO = 0;
    private static final int COLUNA_ITEM_RESULTADO_DESCRITIVO = 1;
    private static final int COLUNA_ITEM_RESULTADO_VALOR = 2;
    private static final int COLUNA_ITEM_RESULTADO_PERCENTUAL = 3;
    private static final int COLUNA_ITEM_REFERENCIA = 4;
    private static final int COLUNA_ITEM_UNIDADE_MEDIDA = 5;
    private static final int COLUNA_ITEM_OBSERVACAO = 6;
    static final Dimension TAM_CAMPOS_COMBO = new Dimension(150, 20);
    static final Dimension TAM_CAMPOS_COMBO_SIM_NAO = new Dimension(70, 20);
    static final Dimension TAM_CAMPOS_TEXTO = new Dimension(80, 20);
    static final Dimension TAM_BOTOES = new Dimension(40, 20);
    public static final String TAG_EXAME_AMOSTRA_MICROORGANISMO = "amostramicro";
    public static final String TAG_EXAME_ANALITO = "analito";
    public static final String TAG_EXAME_CODIGO_ANALITO = "codigoanalito";
    public static final String TAG_EXAME_CODIGO_MEDICAMENTO = "codigomed";
    public static final String TAG_EXAME_CODIGO_MICROORGANISMO = "codigomicro";
    public static final String TAG_EXAME_DESCRICAO_ITEM = "descitem";
    public static final String TAG_EXAME_DESCRICAO_MEDICAMENTO = "descmed";
    public static final String TAG_EXAME_DESCRICAO_MICROORGANISMO = "descmicro";
    public static final String TAG_EXAME_ITEM = "item";
    public static final String TAG_EXAME_LISTA_ANALITOS = "listaanalitos";
    public static final String TAG_EXAME_LISTA_ITENS = "listaitens";
    public static final String TAG_EXAME_LISTA_MEDICAMENTOS = "listamedicamentos";
    public static final String TAG_EXAME_LISTA_MICROORGANISMOS = "listamicroorganismo";
    public static final String TAG_EXAME_MEDICAMENTO = "medicamento";
    public static final String TAG_EXAME_MICROORGANISMO = "microorganismo";
    public static final String TAG_EXAME_OBSERVACAO = "observacao";
    public static final String TAG_EXAME_QUANTIDADE_MICROORGANISMO = "qtdemicro";
    public static final String TAG_EXAME_REFERENCIA = "referencia";
    public static final String TAG_EXAME_RESULTADO_ANALITO = "resultadoanalito";
    public static final String TAG_EXAME_RESULTADO_DESCRITIVO = "descresultado";
    public static final String TAG_EXAME_RESULTADO_MEDICAMENTO = "resultmed";
    public static final String TAG_EXAME_RESULTADO_PERCENTUAL = "percresultado";
    public static final String TAG_EXAME_RESULTADO_VALOR = "valorresultado";
    public static final String TAG_EXAME_TIPO = "tipo";
    public static final String TAG_EXAME_UNIDADE_MEDIDA = "unidade";
    public static final String TAG_ASSOCIACAO_GERME = "assoc";
    public static final String TAG_ASSOCIACAO_GERME_NOME = "assocgerme";
    public static final String TAG_ASSOCIACAO_GERME_CODIGO_TASY = "assoctasy";
    public static final String TAG_ASSOCIACAO_MEDICAMENTO = "assocmed";
    public static final String TAG_ASSOCIACAO_MEDICAMENTO_NOME = "assocnomemed";
    public static final String TAG_ASSOCIACAO_MEDICAMENTO_CODIGO_TASY = "assocmedtasy";
    private JLabel labelCodigoExame = new JLabel("Exame Tasy:");
    private JLabel labelCodigoMaterial = new JLabel("Material Tasy:");
    private JLabel labelCodigoAnalito = new JLabel("C\u00f3d. Tasy");
    private JLabel labelResultadoAnalito = new JLabel("Resultado");
    private JLabel labelMicrobiologia = new JLabel("Micro?");
    private JLabel labelResultado = new JLabel("Resultado Valor:");
    private JLabel labelResultadoPercentual = new JLabel("Resultado Percentual:");
    private JLabel labelResultadoDescritivo = new JLabel("Resultado Descritivo:");
    private JLabel labelTipoExame = new JLabel("Tipo do Exame:");
    protected JLabel labelDescricaoItem = new JLabel("Descri\u00e7\u00e3o Item:");
    private JLabel labelReferencia = new JLabel("Refer\u00eancia:");
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o:");
    private JLabel labelUnidadeMedida = new JLabel("Unidade Medida:");
    private TTextField textCodigoExame = new TTextField(12, 3);
    private TTextField textCodigoMaterial = new TTextField(12, 3);
    private TTextField textCodigoAnalito = new TTextField(10, 3);
    private TTextField textDescricaoItem = new TTextField(20, 3);
    private JComboBox comboResultadoAnalito = new JComboBox();
    private JComboBox comboMicrobiologia = new JComboBox<ValorComboMicrobiologia>(ValorComboMicrobiologia.values());
    private JComboBox comboResultadoValor = new JComboBox();
    private JComboBox comboResultadoPercentual = new JComboBox();
    private JComboBox comboResultadoDescritivo = new JComboBox();
    private JComboBox comboReferencia = new JComboBox();
    private JComboBox comboObservacao = new JComboBox();
    private JComboBox comboUnidadeMedida = new JComboBox();
    private JComboBox comboTipoExame = new JComboBox<TipoExame>(TipoExame.values());
    private JButton buttonOkAnalito = new JButton("OK");
    private JButton buttonOkItem = new JButton("OK");
    protected ModeloGridTable modeloItens = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o Item", "Res. Descritivo", "Resultado Valor", "Res. Percentual", "Refer\u00eancia", "Unid. Medida", "Observa\u00e7\u00e3o"});
    private ModeloGridTable modeloAnalitos = new ModeloGridTable(new String[]{"C\u00f3d. Tasy", "Resultado", "Micro", "Conf."}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return Boolean.class;
            }
            if (columnIndex == 3) {
                return ArrayList.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 3) {
                return (Boolean)ConfiguradorExamesTasy.this.tableAnalitos.getValueAt(rowIndex, 2);
            }
            return false;
        }
    };
    private JTable tableItens = new JTable(this.modeloItens);
    private JTable tableAnalitos = new JTable(this.modeloAnalitos);
    private JScrollPane scrollItens = new JScrollPane(this.tableItens);
    private JScrollPane scrollAnalitos = new JScrollPane(this.tableAnalitos);
    private JPanel panelExameMaterial = new JPanel(new GridBagLayout());
    private JPanel panelItensExame = new JPanel(new GridBagLayout());
    private JPanel panelAnalitos = new JPanel(new GridBagLayout());
    private JPanel panelTipoExame = new JPanel(new GridBagLayout());
    private List<String> listaCampos = null;
    private boolean isEditando = false;
    private int linhaEditando = -1;

    public static ConfiguradorExamesTasy novaInstancia(Window pai, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        if (pai instanceof Frame) {
            return new ConfiguradorExamesTasy((Frame)pai, "Configura\u00e7\u00e3o para exames do Tasy", xmlIntegracaoHospital, xmlAssociacaoCampos);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorExamesTasy((Dialog)pai, "Configura\u00e7\u00e3o para exames do Tasy", xmlIntegracaoHospital, xmlAssociacaoCampos);
        }
        return null;
    }

    public ConfiguradorExamesTasy(Dialog pai, String titulo, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        super(pai, titulo, xmlIntegracaoHospital, xmlAssociacaoCampos);
        this.montaTela();
    }

    public ConfiguradorExamesTasy(Frame pai, String titulo, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        super(pai, titulo, xmlIntegracaoHospital, xmlAssociacaoCampos);
        this.montaTela();
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (!Funcoes.textoVazio(this.textCodigoExame)) {
            XMLStringBuilder xml = new XMLStringBuilder();
            try {
                xml.abrir("xmlexamehospital");
                xml.escrever("protocolo", this.getProcotoloName());
                xml.escrever("codExame", this.textCodigoExame.getText());
                xml.escrever("codMaterial", this.textCodigoMaterial.getText());
                xml.fechar("xmlexamehospital");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
                return null;
            }
            return xml.getXML();
        }
        return null;
    }

    protected String getProcotoloName() {
        return ProtocoloIntegracaoHospital.TASY.getNome();
    }

    @Override
    public String getXmlAssociacaoCampos() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            int i;
            xml.abrir("xmlassociacaocampos");
            String tipoExame = this.comboTipoExame.getSelectedItem().toString();
            xml.escrever(TAG_EXAME_TIPO, tipoExame);
            if (this.modeloItens.getRowCount() > 0 && TipoExame.SADT.equals(tipoExame)) {
                xml.abrir(TAG_EXAME_LISTA_ITENS);
                for (i = 0; i < this.modeloItens.getRowCount(); ++i) {
                    String descricaoItem = (String)this.modeloItens.getValueAt(i, 0);
                    String resultadoDesc = (String)this.modeloItens.getValueAt(i, 1);
                    String resultadoValor = (String)this.modeloItens.getValueAt(i, 2);
                    String resultadoPerc = (String)this.modeloItens.getValueAt(i, 3);
                    String referencia = (String)this.modeloItens.getValueAt(i, 4);
                    String unidade = (String)this.modeloItens.getValueAt(i, 5);
                    String observacao = (String)this.modeloItens.getValueAt(i, 6);
                    xml.abrir(TAG_EXAME_ITEM);
                    xml.escrever(TAG_EXAME_DESCRICAO_ITEM, descricaoItem);
                    xml.escrever(TAG_EXAME_RESULTADO_DESCRITIVO, resultadoDesc);
                    xml.escrever(TAG_EXAME_RESULTADO_VALOR, resultadoValor);
                    xml.escrever(TAG_EXAME_RESULTADO_PERCENTUAL, resultadoPerc);
                    xml.escrever(TAG_EXAME_REFERENCIA, referencia);
                    xml.escrever(TAG_EXAME_UNIDADE_MEDIDA, unidade);
                    xml.escrever(TAG_EXAME_OBSERVACAO, observacao);
                    xml.fechar(TAG_EXAME_ITEM);
                }
                xml.fechar(TAG_EXAME_LISTA_ITENS);
            }
            if (this.modeloAnalitos.getRowCount() > 0 && TipoExame.CULTURA.equals(tipoExame)) {
                xml.abrir(TAG_EXAME_LISTA_ANALITOS);
                for (i = 0; i < this.modeloAnalitos.getRowCount(); ++i) {
                    String codigo = (String)this.modeloAnalitos.getValueAt(i, 0);
                    String resultado = (String)this.modeloAnalitos.getValueAt(i, 1);
                    ArrayList listaMicroorganismos = (ArrayList)this.modeloAnalitos.getValueAt(i, 3);
                    xml.abrir(TAG_EXAME_ANALITO);
                    xml.escrever(TAG_EXAME_CODIGO_ANALITO, codigo);
                    xml.escrever(TAG_EXAME_RESULTADO_ANALITO, resultado);
                    if (listaMicroorganismos != null && !listaMicroorganismos.isEmpty()) {
                        xml.abrir(TAG_EXAME_LISTA_MICROORGANISMOS);
                        for (DadosMicroorganismo microorganismo : listaMicroorganismos) {
                            xml.abrir(TAG_EXAME_MICROORGANISMO);
                            xml.escrever(TAG_EXAME_CODIGO_MICROORGANISMO, microorganismo.getCodigo());
                            xml.escrever(TAG_EXAME_DESCRICAO_MICROORGANISMO, microorganismo.getDescricao());
                            xml.escrever(TAG_EXAME_QUANTIDADE_MICROORGANISMO, microorganismo.getQuantidade());
                            xml.escrever(TAG_EXAME_AMOSTRA_MICROORGANISMO, microorganismo.getAmostra());
                            List<DadosMedicamento> listaMedicamentos = microorganismo.getMedicamentos();
                            if (listaMedicamentos != null && !listaMedicamentos.isEmpty()) {
                                xml.abrir(TAG_EXAME_LISTA_MEDICAMENTOS);
                                for (DadosMedicamento medicamento : listaMedicamentos) {
                                    xml.abrir(TAG_EXAME_MEDICAMENTO);
                                    xml.escrever(TAG_EXAME_CODIGO_MEDICAMENTO, medicamento.getCodigo());
                                    xml.escrever(TAG_EXAME_DESCRICAO_MEDICAMENTO, medicamento.getDescricao());
                                    xml.escrever(TAG_EXAME_RESULTADO_MEDICAMENTO, medicamento.getResultado());
                                    xml.fechar(TAG_EXAME_MEDICAMENTO);
                                }
                                xml.fechar(TAG_EXAME_LISTA_MEDICAMENTOS);
                            }
                            xml.fechar(TAG_EXAME_MICROORGANISMO);
                        }
                        xml.fechar(TAG_EXAME_LISTA_MICROORGANISMOS);
                    }
                    xml.fechar(TAG_EXAME_ANALITO);
                }
                xml.fechar(TAG_EXAME_LISTA_ANALITOS);
            }
            xml.fechar("xmlassociacaocampos");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.listaCampos == null || this.listaCampos.isEmpty()) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 campos do laudo para serem configurados.", 2);
        }
    }

    public void setCamposLaudo(String[] campos) {
        if (campos != null) {
            ArrayList<String> listaCamposOrdenados = new ArrayList<String>();
            for (int i = 0; i < campos.length; ++i) {
                listaCamposOrdenados.add(campos[i]);
            }
            Collections.sort(listaCamposOrdenados);
            this.listaCampos = listaCamposOrdenados;
        }
    }

    protected void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        panelCentral.add((Component)this.panelExameMaterial, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        panelCentral.add((Component)this.panelTipoExame, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panelCentral.add((Component)this.panelItensExame, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panelCentral.add((Component)this.panelAnalitos, c);
        this.montaPanelExameMaterial();
        this.montaPanelTipoExame();
        this.montaPanelItensExame();
        this.montaPanelAnalitos();
        this.setSize(800, 400);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        Funcoes.montaEnter((JComponent)panelCentral);
        ((JComponent)this.getContentPane()).getActionMap().remove("escape");
        ScreenUtil.requisitarFoco(this.textCodigoExame);
    }

    private void montaPanelTipoExame() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelTipoExame.add((Component)this.labelTipoExame, c);
        ++c.gridx;
        this.panelTipoExame.add((Component)this.comboTipoExame, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelTipoExame.add((Component)new JLabel(), c);
        this.comboTipoExame.addActionListener(listener -> this.atualizaPaineisTipoExame());
    }

    private void atualizaPaineisTipoExame() {
        if (this.comboTipoExame.getSelectedItem() == TipoExame.SADT) {
            this.panelItensExame.setVisible(true);
            this.panelAnalitos.setVisible(false);
        } else {
            this.panelItensExame.setVisible(false);
            this.panelAnalitos.setVisible(true);
        }
    }

    private void montaPanelExameMaterial() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelCodigoExame.setDisplayedMnemonic('E');
        this.labelCodigoExame.setLabelFor(this.textCodigoExame);
        this.panelExameMaterial.add((Component)this.labelCodigoExame, c);
        ++c.gridx;
        this.textCodigoExame.setPreferredSize(TAM_CAMPOS_TEXTO);
        this.textCodigoExame.setMinimumSize(TAM_CAMPOS_TEXTO);
        this.panelExameMaterial.add((Component)this.textCodigoExame, c);
        ++c.gridx;
        c.insets = new Insets(5, 20, 1, 1);
        this.labelCodigoMaterial.setDisplayedMnemonic('M');
        this.labelCodigoMaterial.setLabelFor(this.textCodigoMaterial);
        this.panelExameMaterial.add((Component)this.labelCodigoMaterial, c);
        ++c.gridx;
        c.insets = new Insets(5, 1, 1, 1);
        this.textCodigoMaterial.setPreferredSize(TAM_CAMPOS_TEXTO);
        this.textCodigoMaterial.setMinimumSize(TAM_CAMPOS_TEXTO);
        this.panelExameMaterial.add((Component)this.textCodigoMaterial, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelExameMaterial.add((Component)new JLabel(), c);
    }

    private void montaPanelItensExame() {
        this.panelItensExame.setBorder(new TitledBorder("\u00cdtens do Exame"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelItensExame.add((Component)this.labelDescricaoItem, c);
        ++c.gridx;
        this.textDescricaoItem.setPreferredSize(TAM_CAMPOS_COMBO);
        this.textDescricaoItem.setMinimumSize(TAM_CAMPOS_COMBO);
        this.panelItensExame.add((Component)this.textDescricaoItem, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelItensExame.add((Component)this.labelResultadoDescritivo, c);
        ++c.gridx;
        this.comboResultadoDescritivo.setPreferredSize(TAM_CAMPOS_COMBO);
        this.comboResultadoDescritivo.setMinimumSize(TAM_CAMPOS_COMBO);
        this.panelItensExame.add((Component)this.comboResultadoDescritivo, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        this.panelItensExame.add((Component)this.labelResultado, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 0, 0);
        this.comboResultadoValor.setPreferredSize(TAM_CAMPOS_COMBO);
        this.comboResultadoValor.setMinimumSize(TAM_CAMPOS_COMBO);
        this.panelItensExame.add((Component)this.comboResultadoValor, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 0, 0);
        this.panelItensExame.add((Component)this.labelResultadoPercentual, c);
        ++c.gridx;
        this.comboResultadoPercentual.setPreferredSize(TAM_CAMPOS_COMBO);
        this.comboResultadoPercentual.setMinimumSize(TAM_CAMPOS_COMBO);
        this.panelItensExame.add((Component)this.comboResultadoPercentual, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        this.panelItensExame.add((Component)this.labelReferencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 0, 0);
        this.comboReferencia.setPreferredSize(TAM_CAMPOS_COMBO);
        this.comboReferencia.setMinimumSize(TAM_CAMPOS_COMBO);
        this.panelItensExame.add((Component)this.comboReferencia, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 0, 0);
        this.panelItensExame.add((Component)this.labelUnidadeMedida, c);
        ++c.gridx;
        this.comboUnidadeMedida.setPreferredSize(TAM_CAMPOS_COMBO);
        this.comboUnidadeMedida.setMinimumSize(TAM_CAMPOS_COMBO);
        this.panelItensExame.add((Component)this.comboUnidadeMedida, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        this.panelItensExame.add((Component)this.labelObservacao, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 0, 0);
        this.comboObservacao.setPreferredSize(TAM_CAMPOS_COMBO);
        this.comboObservacao.setMinimumSize(TAM_CAMPOS_COMBO);
        this.panelItensExame.add((Component)this.comboObservacao, c);
        ++c.gridx;
        this.buttonOkItem.setPreferredSize(TAM_BOTOES);
        this.buttonOkItem.setMinimumSize(TAM_BOTOES);
        this.buttonOkItem.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkItem.addActionListener(this);
        this.panelItensExame.add((Component)this.buttonOkItem, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelItensExame.add((Component)this.scrollItens, c);
        this.tableItens.setToolTipText("<html>Pressione ESPA\u00c7O para editar<br>Pressione DELETE para remover</html>");
        this.modeloItens.setColumnSize(new int[]{0, 110, 110, 110, 110, 110, 110}, this.tableItens);
        this.tableItens.getSelectionModel().addListSelectionListener(listener -> {
            int row = this.tableItens.getSelectedRow();
            if (this.isEditando && row != this.linhaEditando) {
                this.textDescricaoItem.clear();
                this.comboResultadoDescritivo.setSelectedIndex(0);
                this.comboResultadoValor.setSelectedIndex(0);
                this.comboResultadoPercentual.setSelectedIndex(0);
                this.comboReferencia.setSelectedIndex(0);
                this.comboUnidadeMedida.setSelectedIndex(0);
                this.comboObservacao.setSelectedIndex(0);
                this.isEditando = false;
                this.linhaEditando = -1;
            }
        });
        this.tableItens.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = ConfiguradorExamesTasy.this.tableItens.getSelectedRow();
                if (row == -1) {
                    return;
                }
                if (e.getKeyCode() == 32) {
                    ConfiguradorExamesTasy.this.isEditando = true;
                    ConfiguradorExamesTasy.this.linhaEditando = row;
                    String descricaoItem = (String)ConfiguradorExamesTasy.this.modeloItens.getValueAt(row, 0);
                    String resultadoDesc = (String)ConfiguradorExamesTasy.this.modeloItens.getValueAt(row, 1);
                    String resultadoValor = (String)ConfiguradorExamesTasy.this.modeloItens.getValueAt(row, 2);
                    String resultadoPerc = (String)ConfiguradorExamesTasy.this.modeloItens.getValueAt(row, 3);
                    String referencia = (String)ConfiguradorExamesTasy.this.modeloItens.getValueAt(row, 4);
                    String unidadeMedida = (String)ConfiguradorExamesTasy.this.modeloItens.getValueAt(row, 5);
                    String observacao = (String)ConfiguradorExamesTasy.this.modeloItens.getValueAt(row, 6);
                    ConfiguradorExamesTasy.this.textDescricaoItem.setText(descricaoItem);
                    ConfiguradorExamesTasy.this.comboResultadoDescritivo.setSelectedItem(resultadoDesc);
                    ConfiguradorExamesTasy.this.comboResultadoValor.setSelectedItem(resultadoValor);
                    ConfiguradorExamesTasy.this.comboResultadoPercentual.setSelectedItem(resultadoPerc);
                    ConfiguradorExamesTasy.this.comboReferencia.setSelectedItem(referencia);
                    ConfiguradorExamesTasy.this.comboUnidadeMedida.setSelectedItem(unidadeMedida);
                    ConfiguradorExamesTasy.this.comboObservacao.setSelectedItem(observacao);
                    ScreenUtil.requisitarFoco(ConfiguradorExamesTasy.this.comboResultadoDescritivo);
                } else if (e.getKeyCode() == 127) {
                    ConfiguradorExamesTasy.this.modeloItens.removeLine(row);
                    ConfiguradorExamesTasy.this.isEditando = false;
                    ConfiguradorExamesTasy.this.linhaEditando = -1;
                    ConfiguradorExamesTasy.this.controlaComboTipoExame();
                }
            }
        });
    }

    private void montaPanelAnalitos() {
        this.panelAnalitos.setBorder(new TitledBorder("Analitos"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelAnalitos.add((Component)this.labelCodigoAnalito, c);
        ++c.gridx;
        this.panelAnalitos.add((Component)this.labelResultadoAnalito, c);
        ++c.gridx;
        this.panelAnalitos.add((Component)this.labelMicrobiologia, c);
        ++c.gridy;
        c.gridx = 0;
        this.textCodigoAnalito.setPreferredSize(TAM_CAMPOS_TEXTO);
        this.textCodigoAnalito.setMinimumSize(TAM_CAMPOS_TEXTO);
        this.panelAnalitos.add((Component)this.textCodigoAnalito, c);
        ++c.gridx;
        this.comboResultadoAnalito.setPreferredSize(TAM_CAMPOS_COMBO);
        this.comboResultadoAnalito.setMinimumSize(TAM_CAMPOS_COMBO);
        this.panelAnalitos.add((Component)this.comboResultadoAnalito, c);
        ++c.gridx;
        this.comboMicrobiologia.setPreferredSize(TAM_CAMPOS_COMBO_SIM_NAO);
        this.comboMicrobiologia.setMinimumSize(TAM_CAMPOS_COMBO_SIM_NAO);
        this.panelAnalitos.add((Component)this.comboMicrobiologia, c);
        ++c.gridx;
        this.buttonOkAnalito.setPreferredSize(TAM_BOTOES);
        this.buttonOkAnalito.setMinimumSize(TAM_BOTOES);
        this.buttonOkAnalito.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkAnalito.addActionListener(this);
        this.panelAnalitos.add((Component)this.buttonOkAnalito, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelAnalitos.add((Component)this.scrollAnalitos, c);
        this.tableAnalitos.setToolTipText("<html>Pressione ESPA\u00c7O para editar<br>Pressione DELETE para remover</html>");
        this.tableAnalitos.setDefaultEditor(ArrayList.class, new DadosMicrobiologiaEditor(this.isWebService()));
        this.tableAnalitos.setDefaultRenderer(ArrayList.class, new DadosMicrobiologiaRenderer());
        this.modeloAnalitos.setColumnSize(new int[]{80, 0, 40, 50}, this.tableAnalitos);
        this.tableAnalitos.getSelectionModel().addListSelectionListener(listener -> {
            int row = this.tableAnalitos.getSelectedRow();
            if (this.isEditando && row != this.linhaEditando) {
                this.textCodigoAnalito.clear();
                this.comboResultadoAnalito.setSelectedIndex(0);
                this.comboMicrobiologia.setSelectedIndex(0);
                this.isEditando = false;
                this.linhaEditando = -1;
            }
        });
        this.tableAnalitos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = ConfiguradorExamesTasy.this.tableAnalitos.getSelectedRow();
                if (row == -1) {
                    return;
                }
                if (e.getKeyCode() == 32) {
                    ConfiguradorExamesTasy.this.isEditando = true;
                    ConfiguradorExamesTasy.this.linhaEditando = row;
                    String codigo = (String)ConfiguradorExamesTasy.this.modeloAnalitos.getValueAt(row, 0);
                    String resultado = (String)ConfiguradorExamesTasy.this.modeloAnalitos.getValueAt(row, 1);
                    boolean isMicrobiologia = (Boolean)ConfiguradorExamesTasy.this.modeloAnalitos.getValueAt(row, 2);
                    ConfiguradorExamesTasy.this.textCodigoAnalito.setText(codigo);
                    ConfiguradorExamesTasy.this.comboResultadoAnalito.setSelectedItem(resultado);
                    ConfiguradorExamesTasy.this.comboMicrobiologia.setSelectedItem((Object)(isMicrobiologia ? ValorComboMicrobiologia.SIM : ValorComboMicrobiologia.NAO));
                    ScreenUtil.requisitarFoco(ConfiguradorExamesTasy.this.textCodigoAnalito);
                } else if (e.getKeyCode() == 127) {
                    ConfiguradorExamesTasy.this.modeloAnalitos.removeLine(row);
                    ConfiguradorExamesTasy.this.isEditando = false;
                    ConfiguradorExamesTasy.this.linhaEditando = -1;
                    ConfiguradorExamesTasy.this.controlaComboTipoExame();
                }
            }
        });
        this.panelAnalitos.setVisible(false);
    }

    protected boolean isWebService() {
        return false;
    }

    public void carregaDados() {
        String protocolo;
        if (!Funcoes.textoVazio(this.xmlIntegracaoHospital) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(this.xmlIntegracaoHospital, "protocolo")) && protocolo.equals(this.getProcotoloName())) {
            String codigoExame = StringUtil.getValor(this.xmlIntegracaoHospital, "codExame");
            String codigoMaterial = StringUtil.getValor(this.xmlIntegracaoHospital, "codMaterial");
            if (!Funcoes.textoVazio(codigoExame)) {
                this.textCodigoExame.setText(codigoExame);
            }
            if (!Funcoes.textoVazio(codigoMaterial)) {
                this.textCodigoMaterial.setText(codigoMaterial);
            }
        }
        this.atualizaCombos();
        if (!Funcoes.textoVazio(this.xmlAssociacaoCampos)) {
            this.xmlAssociacaoCampos = StringUtil.getValor(this.xmlAssociacaoCampos, "xmlassociacaocampos", true);
            this.preencheDadosCampos(this.xmlAssociacaoCampos);
        }
        this.controlaComboTipoExame();
    }

    private void controlaComboTipoExame() {
        this.comboTipoExame.setEnabled(this.modeloAnalitos.getRowCount() == 0 && this.modeloItens.getRowCount() == 0);
    }

    private void preencheDadosCampos(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            String[] itens = StringUtil.getValores(xml, TAG_EXAME_ITEM);
            String[] analitos = StringUtil.getValores(xml, TAG_EXAME_ANALITO);
            String tipoExame = StringUtil.getValor(xml, TAG_EXAME_TIPO);
            if (itens != null && TipoExame.SADT.equals(tipoExame)) {
                for (String item : itens) {
                    String descricaoItem = StringUtil.getValor(item, TAG_EXAME_DESCRICAO_ITEM);
                    String resultadoDescritivo = StringUtil.getValor(item, TAG_EXAME_RESULTADO_DESCRITIVO);
                    String resultadoValor = StringUtil.getValor(item, TAG_EXAME_RESULTADO_VALOR);
                    String resultadoPercentual = StringUtil.getValor(item, TAG_EXAME_RESULTADO_PERCENTUAL);
                    String referencia = StringUtil.getValor(item, TAG_EXAME_REFERENCIA);
                    String unidadeMedida = StringUtil.getValor(item, TAG_EXAME_UNIDADE_MEDIDA);
                    String observacao = StringUtil.getValor(item, TAG_EXAME_OBSERVACAO);
                    this.modeloItens.addLine(new Object[]{descricaoItem, resultadoDescritivo, resultadoValor, resultadoPercentual, referencia, unidadeMedida, observacao});
                }
            }
            if (analitos != null && TipoExame.CULTURA.equals(tipoExame)) {
                this.comboTipoExame.setSelectedItem((Object)TipoExame.CULTURA);
                for (String analito : analitos) {
                    String codigoAnalito = StringUtil.getValor(analito, TAG_EXAME_CODIGO_ANALITO);
                    String resultadoAnalito = StringUtil.getValor(analito, TAG_EXAME_RESULTADO_ANALITO);
                    ArrayList<DadosMicroorganismo> listaMicroorganismos = null;
                    String[] microorganismos = StringUtil.getValores(analito, TAG_EXAME_MICROORGANISMO);
                    if (microorganismos != null && microorganismos.length > 0) {
                        listaMicroorganismos = new ArrayList<DadosMicroorganismo>();
                        for (String microorganismo : microorganismos) {
                            String codigoMicroorganismo = StringUtil.getValor(microorganismo, TAG_EXAME_CODIGO_MICROORGANISMO);
                            String descricaoMicroorganismo = StringUtil.getValor(microorganismo, TAG_EXAME_DESCRICAO_MICROORGANISMO);
                            String quantidadeMicroorganismo = StringUtil.getValor(microorganismo, TAG_EXAME_QUANTIDADE_MICROORGANISMO);
                            String amostraMicroorganismo = StringUtil.getValor(microorganismo, TAG_EXAME_AMOSTRA_MICROORGANISMO);
                            ArrayList<DadosMedicamento> listaMedicamentos = null;
                            String[] medicamentos = StringUtil.getValores(microorganismo, TAG_EXAME_MEDICAMENTO);
                            if (medicamentos != null && medicamentos.length > 0) {
                                listaMedicamentos = new ArrayList<DadosMedicamento>();
                                for (String medicamento : medicamentos) {
                                    String codigoMedicamento = StringUtil.getValor(medicamento, TAG_EXAME_CODIGO_MEDICAMENTO);
                                    String descricaoMedicamento = StringUtil.getValor(medicamento, TAG_EXAME_DESCRICAO_MEDICAMENTO);
                                    String resultadoMedicamento = StringUtil.getValor(medicamento, TAG_EXAME_RESULTADO_MEDICAMENTO);
                                    listaMedicamentos.add(new DadosMedicamento(codigoMedicamento, descricaoMedicamento, resultadoMedicamento));
                                }
                            }
                            listaMicroorganismos.add(new DadosMicroorganismo(codigoMicroorganismo, descricaoMicroorganismo, quantidadeMicroorganismo, amostraMicroorganismo, listaMedicamentos));
                        }
                    }
                    this.modeloAnalitos.addLine(new Object[]{codigoAnalito, resultadoAnalito, listaMicroorganismos != null, listaMicroorganismos});
                }
            } else {
                this.comboTipoExame.setSelectedItem((Object)TipoExame.SADT);
            }
        }
    }

    private void atualizaCombos() {
        this.comboResultadoDescritivo.removeAllItems();
        this.comboResultadoAnalito.removeAllItems();
        this.comboResultadoValor.removeAllItems();
        this.comboReferencia.removeAllItems();
        this.comboObservacao.removeAllItems();
        this.comboUnidadeMedida.removeAllItems();
        this.comboResultadoPercentual.removeAllItems();
        this.comboResultadoDescritivo.addItem("");
        this.comboResultadoAnalito.addItem("");
        this.comboResultadoValor.addItem("");
        this.comboReferencia.addItem("");
        this.comboObservacao.addItem("");
        this.comboUnidadeMedida.addItem("");
        this.comboResultadoPercentual.addItem("");
        if (this.listaCampos != null) {
            for (int i = 0; i < this.listaCampos.size(); ++i) {
                String campo = this.listaCampos.get(i);
                this.comboResultadoDescritivo.addItem(campo);
                this.comboResultadoAnalito.addItem(campo);
                this.comboResultadoValor.addItem(campo);
                this.comboReferencia.addItem(campo);
                this.comboObservacao.addItem(campo);
                this.comboUnidadeMedida.addItem(campo);
                this.comboResultadoPercentual.addItem(campo);
            }
        }
        boolean enabled = true;
        this.comboResultadoDescritivo.setEnabled(enabled);
        this.comboResultadoAnalito.setEnabled(enabled);
        this.comboResultadoValor.setEnabled(enabled);
        this.comboReferencia.setEnabled(enabled);
        this.comboObservacao.setEnabled(enabled);
        this.comboUnidadeMedida.setEnabled(enabled);
        this.comboResultadoPercentual.setEnabled(enabled);
    }

    @Override
    @Deprecated
    public void windowClosing(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowClosed(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowIconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowActivated(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.buttonOkAnalito) {
            if (this.validaAnalito()) {
                this.adicionaAnalito();
            }
        } else if (e.getSource() == this.buttonOkItem && this.validaItemExame()) {
            this.adicionaItemExame();
        }
    }

    private boolean validaAnalito() {
        String codigoAux = this.textCodigoAnalito.getText();
        String resultadoAux = (String)this.comboResultadoAnalito.getSelectedItem();
        if (Funcoes.textoVazio(codigoAux) && Funcoes.textoVazio(resultadoAux)) {
            ScreenUtil.requisitarFoco(this.textCodigoAnalito);
            return false;
        }
        if (Funcoes.textoVazio(codigoAux)) {
            Funcoes.mensagem(this, "O c\u00f3digo do analito deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoAnalito);
            return false;
        }
        if (Funcoes.textoVazio(resultadoAux)) {
            Funcoes.mensagem(this, "O campo de resultado do analito deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.comboResultadoAnalito);
            return false;
        }
        return true;
    }

    private boolean validaItemExame() {
        String resultadoValor = (String)this.comboResultadoValor.getSelectedItem();
        String resultadoPercentual = (String)this.comboResultadoPercentual.getSelectedItem();
        String resultadoDescritivo = (String)this.comboResultadoDescritivo.getSelectedItem();
        if (Funcoes.textoVazio(this.textDescricaoItem) && Funcoes.textoVazio(resultadoValor) && Funcoes.textoVazio(resultadoPercentual) && Funcoes.textoVazio(resultadoDescritivo)) {
            ScreenUtil.requisitarFoco(this.textDescricaoItem);
            return false;
        }
        if (Funcoes.textoVazio(this.textDescricaoItem)) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o do item deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDescricaoItem);
            return false;
        }
        if (Funcoes.textoVazio(resultadoValor) && Funcoes.textoVazio(resultadoPercentual) && Funcoes.textoVazio(resultadoDescritivo)) {
            Funcoes.mensagem(this, "O resultado descritivo, percentual e valor n\u00e3o foram informados.\nPelo menos um tipo de resultado deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.comboResultadoDescritivo);
            return false;
        }
        return true;
    }

    private void adicionaAnalito() {
        String codigo = this.textCodigoAnalito.getText();
        String resultado = (String)this.comboResultadoAnalito.getSelectedItem();
        boolean isMicrobiologia = ((ValorComboMicrobiologia)((Object)this.comboMicrobiologia.getSelectedItem())).getValor();
        if (this.isEditando && this.linhaEditando > -1) {
            this.modeloAnalitos.setValueAt(codigo, this.linhaEditando, 0);
            this.modeloAnalitos.setValueAt(resultado, this.linhaEditando, 1);
            this.modeloAnalitos.setValueAt(isMicrobiologia, this.linhaEditando, 2);
            if (!isMicrobiologia) {
                this.modeloAnalitos.setValueAt(null, this.linhaEditando, 3);
            } else if (this.modeloAnalitos.getValueAt(this.linhaEditando, 3) == null) {
                this.modeloAnalitos.setValueAt(new ArrayList(), this.linhaEditando, 3);
            }
        } else {
            this.modeloAnalitos.addLine(new Object[]{codigo, resultado, isMicrobiologia, null});
        }
        this.textCodigoAnalito.clear();
        this.comboResultadoAnalito.setSelectedIndex(0);
        this.comboMicrobiologia.setSelectedIndex(0);
        this.controlaComboTipoExame();
        ScreenUtil.requisitarFoco(this.textCodigoAnalito);
    }

    private void adicionaItemExame() {
        String descricaoItem = this.textDescricaoItem.getText();
        String resultadoDesc = (String)this.comboResultadoDescritivo.getSelectedItem();
        String resultadoValor = (String)this.comboResultadoValor.getSelectedItem();
        String resultadoPerc = (String)this.comboResultadoPercentual.getSelectedItem();
        String referencia = (String)this.comboReferencia.getSelectedItem();
        String unidadeMedida = (String)this.comboUnidadeMedida.getSelectedItem();
        String observacao = (String)this.comboObservacao.getSelectedItem();
        if (this.isEditando && this.linhaEditando > -1) {
            this.modeloItens.setValueAt(descricaoItem, this.linhaEditando, 0);
            this.modeloItens.setValueAt(resultadoDesc, this.linhaEditando, 1);
            this.modeloItens.setValueAt(resultadoValor, this.linhaEditando, 2);
            this.modeloItens.setValueAt(resultadoPerc, this.linhaEditando, 3);
            this.modeloItens.setValueAt(referencia, this.linhaEditando, 4);
            this.modeloItens.setValueAt(unidadeMedida, this.linhaEditando, 5);
            this.modeloItens.setValueAt(observacao, this.linhaEditando, 6);
        } else {
            this.modeloItens.addLine(new Object[]{descricaoItem, resultadoDesc, resultadoValor, resultadoPerc, referencia, unidadeMedida, observacao});
        }
        this.textDescricaoItem.clear();
        this.comboResultadoDescritivo.setSelectedIndex(0);
        this.comboResultadoValor.setSelectedIndex(0);
        this.comboResultadoPercentual.setSelectedIndex(0);
        this.comboReferencia.setSelectedIndex(0);
        this.comboUnidadeMedida.setSelectedIndex(0);
        this.comboObservacao.setSelectedIndex(0);
        this.linhaEditando = -1;
        this.isEditando = false;
        this.controlaComboTipoExame();
        ScreenUtil.requisitarFoco(this.textDescricaoItem);
    }

    public class DadosMicrobiologiaRenderer
    extends JButton
    implements TableCellRenderer {
        public DadosMicrobiologiaRenderer() {
            this.setText("...");
            this.setToolTipText("Clique para configurar");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean valor = (Boolean)table.getValueAt(row, 2);
            return valor == null || valor == false ? new JLabel() : this;
        }
    }

    private class DadosMicrobiologiaEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JButton botao = new JButton();
        private static final String ABRIR_CONF = "abrir_conf";
        private List<DadosMicroorganismo> dadosMicroorganismos = null;
        private ConfiguradorDadosMicrobiologia configurador = null;
        private boolean isWebService = false;

        public DadosMicrobiologiaEditor(boolean isWebService) {
            this.botao.setText("...");
            this.botao.setActionCommand(ABRIR_CONF);
            this.botao.addActionListener(this);
            this.isWebService = isWebService;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ABRIR_CONF.equals(e.getActionCommand())) {
                this.configurador = new ConfiguradorDadosMicrobiologia((Dialog)ConfiguradorExamesTasy.this, ConfiguradorExamesTasy.this.listaCampos, this.dadosMicroorganismos, this.isWebService);
                this.configurador.setVisible(true);
                if (this.configurador.getOK()) {
                    this.dadosMicroorganismos = this.configurador.getDadosMicroorganismos();
                }
                this.fireEditingStopped();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.dadosMicroorganismos;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.dadosMicroorganismos = (ArrayList)value;
            return this.botao;
        }
    }
}

