/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.tasy;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaohospitais.util.tasy.ConfiguradorExamesTasy;
import jalis.integracaohospitais.util.tasy.DadosMedicamento;
import jalis.integracaohospitais.util.tasy.DadosMicroorganismo;
import jalis.integracaohospitais.util.tasy.JanelaAssociacaoGermes;
import jalis.integracaohospitais.util.tasy.JanelaAssociacaoMedicamentos;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class ConfiguradorDadosMicrobiologia
extends AbstractDialogoOKCancelar {
    private final int COLUNA_MICROORGANISMO_CODIGO_TASY = 0;
    private final int COLUNA_MEDICAMENTO_CODIGO_TASY = 0;
    private JLabel labelCodigoMicroorganismo = new JLabel("Cod.Tasy");
    private JLabel labelDescricaoMicroorganismo = new JLabel("Descri\u00e7\u00e3o");
    private JLabel labelQuantidadeMicroorganismo = new JLabel("Quantidade");
    private JLabel labelAmostraMicroorganismo = new JLabel("Amostra");
    private JLabel labelCodigoMedicamento = new JLabel("C\u00f3d. Tasy");
    private JLabel labelDescricaoMedicamento = new JLabel("Descri\u00e7\u00e3o");
    private JLabel labelResultadoMedicamento = new JLabel("Resultado");
    private TTextField textCodigoMicroorganismo = new TTextField(10, 3);
    private TTextField textCodigoMedicamento = new TTextField(10, 3);
    private JComboBox comboDescricaoMicroorganismo = new JComboBox();
    private JComboBox comboQuantidadeMicroorganismo = new JComboBox();
    private JComboBox comboAmostraMicroorganismo = new JComboBox();
    private JComboBox comboDescricaoMedicamento = new JComboBox();
    private JComboBox comboResultadoMedicamento = new JComboBox();
    private JButton buttonOkMicroorganismo = new JButton("OK");
    private JButton buttonOkMedicamento = new JButton("OK");
    private JButton buttonAssociarGermes = new JButton("Germes");
    private JButton buttonAssociarMedicamentos = new JButton("Medicamentos");
    private ModeloGridTable modeloMicroorganismos = new ModeloGridTable(this.getCamposMicro());
    private ModeloGridTable modeloMedicamentos = new ModeloGridTable(this.getCamposMed());
    private JTable tableMicroorganismos = new JTable(this.modeloMicroorganismos);
    private JTable tableMedicamentos = new JTable(this.modeloMedicamentos);
    private JScrollPane scrollMicroorganismos = new JScrollPane(this.tableMicroorganismos);
    private JScrollPane scrollMedicamentos = new JScrollPane(this.tableMedicamentos);
    private JPanel panelMicroorganismos = new JPanel(new GridBagLayout());
    private JPanel panelMedicamentos = new JPanel(new GridBagLayout());
    private boolean isEditandoMicroorganismo = false;
    private int linhaEditandoMicroorganismo = -1;
    private boolean isEditandoMedicamento = false;
    private int linhaEditandoMedicamento = -1;
    private List<String> listaCampos = null;
    private boolean isWebService = false;

    public ConfiguradorDadosMicrobiologia(Dialog pai, List<String> listacampos, List<DadosMicroorganismo> listaMicroorganismos, boolean isWebService) {
        super(pai, "Dados de Microbiologia");
        this.listaCampos = listacampos;
        this.isWebService = isWebService;
        this.montaTela();
        this.preencheDados(listaMicroorganismos);
    }

    private int getColunaArrayMedicamentoMicro() {
        if (this.isWebService) {
            return 4;
        }
        return 3;
    }

    private int getColunaAmostraMicro() {
        if (this.isWebService) {
            return 3;
        }
        return 2;
    }

    private int getColunaQuantidadeMicro() {
        if (this.isWebService) {
            return 2;
        }
        return 1;
    }

    private int getColunaDescricaoMicro() {
        if (this.isWebService) {
            return 1;
        }
        return 0;
    }

    private int getColunaDescricaoMedicamento() {
        if (this.isWebService) {
            return 1;
        }
        return 0;
    }

    private int getColunaMedicamentoResultado() {
        if (this.isWebService) {
            return 2;
        }
        return 1;
    }

    private int getColunaObjetoMedicamento() {
        if (this.isWebService) {
            return 3;
        }
        return 2;
    }

    public ConfiguradorDadosMicrobiologia(Frame pai, String titulo, List<String> listacampos, List<DadosMicroorganismo> listaMicroorganismos) {
        super(pai, "Dados de Microbiologia");
        this.listaCampos = listacampos;
        this.montaTela();
        this.preencheDados(listaMicroorganismos);
    }

    private void montaPanelBotoes() {
        JPanel panelBotoesEsquerda = this.getPanelBotoesEsquerda();
        this.buttonAssociarGermes.setMnemonic('e');
        this.buttonAssociarMedicamentos.setMnemonic('m');
        panelBotoesEsquerda.add(this.buttonAssociarGermes);
        panelBotoesEsquerda.add(this.buttonAssociarMedicamentos);
        this.buttonAssociarGermes.addActionListener(listener -> {
            JanelaAssociacaoGermes janela = JanelaAssociacaoGermes.novaInstancia(this);
            janela.setVisible(true);
        });
        this.buttonAssociarMedicamentos.addActionListener(listener -> {
            JanelaAssociacaoMedicamentos janela = JanelaAssociacaoMedicamentos.novaInstancia(this);
            janela.setVisible(true);
        });
    }

    private String[] getCamposMicro() {
        if (this.isWebService) {
            return new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Quantidade", "Amostra"};
        }
        return new String[]{"Descri\u00e7\u00e3o", "Quantidade", "Amostra"};
    }

    private String[] getCamposMed() {
        if (this.isWebService) {
            return new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Resultado"};
        }
        return new String[]{"Descri\u00e7\u00e3o", "Resultado"};
    }

    private void preencheDados(List<DadosMicroorganismo> listaMicroorganismos) {
        if (listaMicroorganismos != null) {
            for (DadosMicroorganismo microorganismo : listaMicroorganismos) {
                if (this.isWebService) {
                    this.modeloMicroorganismos.addLine(new Object[]{microorganismo.getCodigo(), microorganismo.getDescricao(), microorganismo.getQuantidade(), microorganismo.getAmostra(), microorganismo.getMedicamentos()});
                    continue;
                }
                this.modeloMicroorganismos.addLine(new Object[]{microorganismo.getDescricao(), microorganismo.getQuantidade(), microorganismo.getAmostra(), microorganismo.getMedicamentos()});
            }
        }
    }

    public List<DadosMicroorganismo> getDadosMicroorganismos() {
        if (this.modeloMicroorganismos.getRowCount() == 0) {
            return null;
        }
        ArrayList<DadosMicroorganismo> listaMicroorganismos = new ArrayList<DadosMicroorganismo>();
        for (int i = 0; i < this.modeloMicroorganismos.getRowCount(); ++i) {
            if (this.isWebService) {
                listaMicroorganismos.add(new DadosMicroorganismo((String)this.modeloMicroorganismos.getValueAt(i, 0), (String)this.modeloMicroorganismos.getValueAt(i, this.getColunaDescricaoMicro()), (String)this.modeloMicroorganismos.getValueAt(i, this.getColunaQuantidadeMicro()), (String)this.modeloMicroorganismos.getValueAt(i, this.getColunaAmostraMicro()), (ArrayList)this.modeloMicroorganismos.getValueAt(i, this.getColunaArrayMedicamentoMicro())));
                continue;
            }
            listaMicroorganismos.add(new DadosMicroorganismo((String)this.modeloMicroorganismos.getValueAt(i, this.getColunaDescricaoMicro()), (String)this.modeloMicroorganismos.getValueAt(i, this.getColunaQuantidadeMicro()), (String)this.modeloMicroorganismos.getValueAt(i, this.getColunaAmostraMicro()), (ArrayList)this.modeloMicroorganismos.getValueAt(i, this.getColunaArrayMedicamentoMicro())));
        }
        return listaMicroorganismos;
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelCentral.add((Component)this.panelMicroorganismos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        panelCentral.add((Component)this.panelMedicamentos, c);
        this.montaPanelMicroorganismos();
        this.montaPanelMedicamentos();
        this.setSize(620, 380);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        Funcoes.montaEnter((JComponent)panelCentral);
        this.montaPanelBotoes();
        this.atualizaCombos();
        this.controlaCamposMedicamento();
        ScreenUtil.requisitarFoco(this.comboDescricaoMicroorganismo);
    }

    private void montaPanelMicroorganismos() {
        this.panelMicroorganismos.setBorder(new TitledBorder("Microorganismos"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        if (this.isWebService) {
            this.panelMicroorganismos.add((Component)this.labelCodigoMicroorganismo, c);
            ++c.gridx;
        }
        this.panelMicroorganismos.add((Component)this.labelDescricaoMicroorganismo, c);
        ++c.gridx;
        this.panelMicroorganismos.add((Component)this.labelQuantidadeMicroorganismo, c);
        ++c.gridx;
        this.panelMicroorganismos.add((Component)this.labelAmostraMicroorganismo, c);
        ++c.gridy;
        c.gridx = 0;
        if (this.isWebService) {
            this.textCodigoMicroorganismo.setPreferredSize(ConfiguradorExamesTasy.TAM_CAMPOS_TEXTO);
            this.textCodigoMicroorganismo.setMinimumSize(ConfiguradorExamesTasy.TAM_CAMPOS_TEXTO);
            this.panelMicroorganismos.add((Component)this.textCodigoMicroorganismo, c);
            ++c.gridx;
        }
        this.comboDescricaoMicroorganismo.setPreferredSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.comboDescricaoMicroorganismo.setMinimumSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.panelMicroorganismos.add((Component)this.comboDescricaoMicroorganismo, c);
        ++c.gridx;
        this.comboQuantidadeMicroorganismo.setPreferredSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.comboQuantidadeMicroorganismo.setMinimumSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.panelMicroorganismos.add((Component)this.comboQuantidadeMicroorganismo, c);
        ++c.gridx;
        this.comboAmostraMicroorganismo.setPreferredSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.comboAmostraMicroorganismo.setMinimumSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.panelMicroorganismos.add((Component)this.comboAmostraMicroorganismo, c);
        ++c.gridx;
        this.buttonOkMicroorganismo.setPreferredSize(ConfiguradorExamesTasy.TAM_BOTOES);
        this.buttonOkMicroorganismo.setMinimumSize(ConfiguradorExamesTasy.TAM_BOTOES);
        this.buttonOkMicroorganismo.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkMicroorganismo.addActionListener(this);
        this.panelMicroorganismos.add((Component)this.buttonOkMicroorganismo, c);
        this.modeloMicroorganismos = new ModeloGridTable(this.getCamposMicro());
        this.modeloMedicamentos = new ModeloGridTable(this.getCamposMed());
        this.tableMicroorganismos = new JTable(this.modeloMicroorganismos);
        this.tableMedicamentos = new JTable(this.modeloMedicamentos);
        this.scrollMicroorganismos = new JScrollPane(this.tableMicroorganismos);
        this.scrollMedicamentos = new JScrollPane(this.tableMedicamentos);
        if (this.isWebService) {
            this.textCodigoMicroorganismo.setVisible(true);
        } else {
            this.textCodigoMicroorganismo.setVisible(false);
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelMicroorganismos.add((Component)this.scrollMicroorganismos, c);
        this.modeloMicroorganismos.setColumnSize(new int[]{80, 0, 0, 0}, this.tableMicroorganismos);
        this.tableMicroorganismos.getSelectionModel().addListSelectionListener(listener -> {
            int row = this.tableMicroorganismos.getSelectedRow();
            if (this.isEditandoMicroorganismo && row != this.linhaEditandoMicroorganismo) {
                this.textCodigoMicroorganismo.clear();
                this.comboDescricaoMicroorganismo.setSelectedIndex(0);
                this.comboQuantidadeMicroorganismo.setSelectedIndex(0);
                this.comboAmostraMicroorganismo.setSelectedIndex(0);
                this.isEditandoMicroorganismo = false;
                this.linhaEditandoMicroorganismo = -1;
                this.isEditandoMedicamento = false;
                this.linhaEditandoMedicamento = -1;
            }
            this.atualizaMedicamentos();
            this.controlaCamposMedicamento();
        });
        this.tableMicroorganismos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = ConfiguradorDadosMicrobiologia.this.tableMicroorganismos.getSelectedRow();
                if (row == -1) {
                    return;
                }
                if (e.getKeyCode() == 32) {
                    ConfiguradorDadosMicrobiologia.this.isEditandoMicroorganismo = true;
                    ConfiguradorDadosMicrobiologia.this.linhaEditandoMicroorganismo = row;
                    String codigo = (String)ConfiguradorDadosMicrobiologia.this.modeloMicroorganismos.getValueAt(row, 0);
                    String descricao = (String)ConfiguradorDadosMicrobiologia.this.modeloMicroorganismos.getValueAt(row, ConfiguradorDadosMicrobiologia.this.getColunaDescricaoMicro());
                    String quantidade = (String)ConfiguradorDadosMicrobiologia.this.modeloMicroorganismos.getValueAt(row, ConfiguradorDadosMicrobiologia.this.getColunaQuantidadeMicro());
                    String amostra = (String)ConfiguradorDadosMicrobiologia.this.modeloMicroorganismos.getValueAt(row, ConfiguradorDadosMicrobiologia.this.getColunaAmostraMicro());
                    ConfiguradorDadosMicrobiologia.this.textCodigoMicroorganismo.setText(codigo);
                    ConfiguradorDadosMicrobiologia.this.comboDescricaoMicroorganismo.setSelectedItem(descricao);
                    ConfiguradorDadosMicrobiologia.this.comboQuantidadeMicroorganismo.setSelectedItem(quantidade);
                    ConfiguradorDadosMicrobiologia.this.comboAmostraMicroorganismo.setSelectedItem(amostra);
                    ScreenUtil.requisitarFoco(ConfiguradorDadosMicrobiologia.this.comboDescricaoMicroorganismo);
                } else if (e.getKeyCode() == 127) {
                    ConfiguradorDadosMicrobiologia.this.modeloMicroorganismos.removeLine(row);
                    ConfiguradorDadosMicrobiologia.this.isEditandoMicroorganismo = false;
                    ConfiguradorDadosMicrobiologia.this.linhaEditandoMicroorganismo = -1;
                    ConfiguradorDadosMicrobiologia.this.isEditandoMedicamento = false;
                    ConfiguradorDadosMicrobiologia.this.linhaEditandoMedicamento = -1;
                    ConfiguradorDadosMicrobiologia.this.atualizaMedicamentos();
                }
            }
        });
    }

    private void montaPanelMedicamentos() {
        this.panelMedicamentos.setBorder(new TitledBorder("Medicamentos"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        if (this.isWebService) {
            this.panelMedicamentos.add((Component)this.labelCodigoMedicamento, c);
            ++c.gridx;
        }
        this.panelMedicamentos.add((Component)this.labelDescricaoMedicamento, c);
        ++c.gridx;
        this.panelMedicamentos.add((Component)this.labelResultadoMedicamento, c);
        ++c.gridy;
        c.gridx = 0;
        if (this.isWebService) {
            this.textCodigoMedicamento.setPreferredSize(ConfiguradorExamesTasy.TAM_CAMPOS_TEXTO);
            this.textCodigoMedicamento.setMinimumSize(ConfiguradorExamesTasy.TAM_CAMPOS_TEXTO);
            this.panelMedicamentos.add((Component)this.textCodigoMedicamento, c);
            ++c.gridx;
        }
        this.comboDescricaoMedicamento.setPreferredSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.comboDescricaoMedicamento.setMinimumSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.panelMedicamentos.add((Component)this.comboDescricaoMedicamento, c);
        ++c.gridx;
        this.comboResultadoMedicamento.setPreferredSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.comboResultadoMedicamento.setMinimumSize(ConfiguradorExamesTasy.TAM_CAMPOS_COMBO);
        this.panelMedicamentos.add((Component)this.comboResultadoMedicamento, c);
        ++c.gridx;
        this.buttonOkMedicamento.setPreferredSize(ConfiguradorExamesTasy.TAM_BOTOES);
        this.buttonOkMedicamento.setMinimumSize(ConfiguradorExamesTasy.TAM_BOTOES);
        this.buttonOkMedicamento.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkMedicamento.addActionListener(this);
        this.panelMedicamentos.add((Component)this.buttonOkMedicamento, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelMedicamentos.add((Component)this.scrollMedicamentos, c);
        this.modeloMedicamentos.setColumnSize(new int[]{80, 0, 0}, this.tableMedicamentos);
        if (this.isWebService) {
            this.modeloMedicamentos.setColumnSize(new int[]{0, 80, 0, 0}, this.tableMedicamentos);
        }
        this.tableMedicamentos.getSelectionModel().addListSelectionListener(listener -> {
            int row = this.tableMedicamentos.getSelectedRow();
            if (this.isEditandoMedicamento && row != this.linhaEditandoMedicamento) {
                this.textCodigoMedicamento.clear();
                this.comboDescricaoMedicamento.setSelectedIndex(0);
                this.comboResultadoMedicamento.setSelectedIndex(0);
                this.isEditandoMedicamento = false;
                this.linhaEditandoMedicamento = -1;
            }
        });
        this.tableMedicamentos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = ConfiguradorDadosMicrobiologia.this.tableMedicamentos.getSelectedRow();
                if (row == -1) {
                    return;
                }
                if (e.getKeyCode() == 32) {
                    ConfiguradorDadosMicrobiologia.this.isEditandoMedicamento = true;
                    ConfiguradorDadosMicrobiologia.this.linhaEditandoMedicamento = row;
                    String codigo = (String)ConfiguradorDadosMicrobiologia.this.modeloMedicamentos.getValueAt(row, 0);
                    String descricao = (String)ConfiguradorDadosMicrobiologia.this.modeloMedicamentos.getValueAt(row, ConfiguradorDadosMicrobiologia.this.getColunaDescricaoMedicamento());
                    String resultado = (String)ConfiguradorDadosMicrobiologia.this.modeloMedicamentos.getValueAt(row, ConfiguradorDadosMicrobiologia.this.getColunaMedicamentoResultado());
                    ConfiguradorDadosMicrobiologia.this.textCodigoMedicamento.setText(codigo);
                    ConfiguradorDadosMicrobiologia.this.comboDescricaoMedicamento.setSelectedItem(descricao);
                    ConfiguradorDadosMicrobiologia.this.comboResultadoMedicamento.setSelectedItem(resultado);
                    ScreenUtil.requisitarFoco(ConfiguradorDadosMicrobiologia.this.comboDescricaoMedicamento);
                } else if (e.getKeyCode() == 127) {
                    DadosMedicamento medicamento = (DadosMedicamento)ConfiguradorDadosMicrobiologia.this.modeloMedicamentos.getValueAt(row, ConfiguradorDadosMicrobiologia.this.getColunaObjetoMedicamento());
                    int rowMicroorganismo = ConfiguradorDadosMicrobiologia.this.tableMicroorganismos.getSelectedRow();
                    if (rowMicroorganismo > -1) {
                        ArrayList listaMedicamentos = (ArrayList)ConfiguradorDadosMicrobiologia.this.modeloMicroorganismos.getValueAt(rowMicroorganismo, ConfiguradorDadosMicrobiologia.this.getColunaArrayMedicamentoMicro());
                        if (listaMedicamentos != null) {
                            listaMedicamentos.remove(medicamento);
                        }
                        ConfiguradorDadosMicrobiologia.this.isEditandoMedicamento = false;
                        ConfiguradorDadosMicrobiologia.this.linhaEditandoMedicamento = -1;
                        ConfiguradorDadosMicrobiologia.this.atualizaMedicamentos();
                    }
                }
            }
        });
    }

    private void controlaCamposMedicamento() {
        int row = this.tableMicroorganismos.getSelectedRow();
        boolean isEnabled = row > -1;
        this.textCodigoMedicamento.setEnabled(isEnabled);
        this.comboDescricaoMedicamento.setEnabled(isEnabled);
        this.comboResultadoMedicamento.setEnabled(isEnabled);
        if (row == -1) {
            this.textCodigoMedicamento.clear();
            this.comboDescricaoMedicamento.setSelectedIndex(0);
            this.comboResultadoMedicamento.setSelectedIndex(0);
        }
    }

    private void atualizaMedicamentos() {
        ArrayList listaMedicamentos;
        this.modeloMedicamentos.clear();
        int row = this.tableMicroorganismos.getSelectedRow();
        if (row > -1 && (listaMedicamentos = (ArrayList)this.modeloMicroorganismos.getValueAt(row, this.getColunaArrayMedicamentoMicro())) != null) {
            for (DadosMedicamento medicamento : listaMedicamentos) {
                if (this.isWebService) {
                    this.modeloMedicamentos.addLine(new Object[]{medicamento.getCodigo(), medicamento.getDescricao(), medicamento.getResultado(), medicamento});
                    continue;
                }
                this.modeloMedicamentos.addLine(new Object[]{medicamento.getDescricao(), medicamento.getResultado(), medicamento});
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.buttonOkMicroorganismo & this.validaMicroorganismo()) {
            this.adicionaMicroorganismo();
        } else if (e.getSource() == this.buttonOkMedicamento && this.validaMedicamento()) {
            this.adicionaMedicamento();
        }
    }

    private boolean validaMicroorganismo() {
        String codigoAux = this.textCodigoMicroorganismo.getText();
        String descricaoAux = (String)this.comboDescricaoMicroorganismo.getSelectedItem();
        String quantidadeAux = (String)this.comboQuantidadeMicroorganismo.getSelectedItem();
        if (Funcoes.textoVazio(codigoAux) && Funcoes.textoVazio(descricaoAux)) {
            ScreenUtil.requisitarFoco(this.textCodigoMicroorganismo);
            return false;
        }
        if (Funcoes.textoVazio(codigoAux) && this.isWebService) {
            Funcoes.mensagem(this, "O c\u00f3digo do microorganismo deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoMicroorganismo);
            return false;
        }
        if (Funcoes.textoVazio(descricaoAux)) {
            Funcoes.mensagem(this, "O campo de descri\u00e7\u00e3o do microorganismo deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.comboDescricaoMicroorganismo);
            return false;
        }
        if (Funcoes.textoVazio(quantidadeAux)) {
            Funcoes.mensagem(this, "O campo de quantidade do microorganismo deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.comboQuantidadeMicroorganismo);
            return false;
        }
        return true;
    }

    private boolean validaMedicamento() {
        String codigoAux = this.textCodigoMedicamento.getText();
        String resultadoAux = (String)this.comboResultadoMedicamento.getSelectedItem();
        if (Funcoes.textoVazio(codigoAux) && Funcoes.textoVazio(resultadoAux)) {
            ScreenUtil.requisitarFoco(this.textCodigoMedicamento);
            return false;
        }
        if (Funcoes.textoVazio(codigoAux) && this.isWebService) {
            Funcoes.mensagem(this, "O c\u00f3digo do medicamento deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoMedicamento);
            return false;
        }
        if (Funcoes.textoVazio(resultadoAux)) {
            Funcoes.mensagem(this, "O campo de resultado do microorganismo deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.comboAmostraMicroorganismo);
            return false;
        }
        return true;
    }

    private void adicionaMicroorganismo() {
        String codigo = this.textCodigoMicroorganismo.getText();
        String descricao = (String)this.comboDescricaoMicroorganismo.getSelectedItem();
        String quantidade = (String)this.comboQuantidadeMicroorganismo.getSelectedItem();
        String amostra = (String)this.comboAmostraMicroorganismo.getSelectedItem();
        boolean jaExiste = false;
        for (int i = 0; i < this.modeloMicroorganismos.getRowCount(); ++i) {
            String codigoAux;
            if (i == this.linhaEditandoMicroorganismo || Funcoes.textoVazio(codigoAux = (String)this.modeloMicroorganismos.getValueAt(i, 0)) || !codigoAux.equals(codigo)) continue;
            jaExiste = true;
            break;
        }
        if (jaExiste) {
            Funcoes.mensagem(this, "O microorganismo j\u00e1 foi informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoMicroorganismo);
            return;
        }
        if (this.isEditandoMicroorganismo && this.linhaEditandoMicroorganismo > -1) {
            if (this.isWebService) {
                this.modeloMicroorganismos.setValueAt(codigo, this.linhaEditandoMicroorganismo, 0);
            }
            this.modeloMicroorganismos.setValueAt(descricao, this.linhaEditandoMicroorganismo, this.getColunaDescricaoMicro());
            this.modeloMicroorganismos.setValueAt(quantidade, this.linhaEditandoMicroorganismo, this.getColunaQuantidadeMicro());
            this.modeloMicroorganismos.setValueAt(amostra, this.linhaEditandoMicroorganismo, this.getColunaAmostraMicro());
        } else if (this.isWebService) {
            this.modeloMicroorganismos.addLine(new Object[]{codigo, descricao, quantidade, amostra, new ArrayList()});
        } else {
            this.modeloMicroorganismos.addLine(new Object[]{descricao, quantidade, amostra, new ArrayList()});
        }
        this.textCodigoMicroorganismo.clear();
        this.comboDescricaoMicroorganismo.setSelectedIndex(0);
        this.comboQuantidadeMicroorganismo.setSelectedIndex(0);
        this.comboAmostraMicroorganismo.setSelectedIndex(0);
        this.isEditandoMicroorganismo = false;
        this.linhaEditandoMicroorganismo = -1;
        ScreenUtil.requisitarFoco(this.comboDescricaoMicroorganismo);
    }

    private void adicionaMedicamento() {
        String codigo = this.textCodigoMedicamento.getText();
        String descricao = (String)this.comboDescricaoMedicamento.getSelectedItem();
        String resultado = (String)this.comboResultadoMedicamento.getSelectedItem();
        int rowMicroorganismo = this.tableMicroorganismos.getSelectedRow();
        if (rowMicroorganismo == -1) {
            return;
        }
        ArrayList<DadosMedicamento> listaMedicamentos = (ArrayList<DadosMedicamento>)this.modeloMicroorganismos.getValueAt(rowMicroorganismo, this.getColunaArrayMedicamentoMicro());
        if (listaMedicamentos != null) {
            boolean jaExiste = false;
            for (int i = 0; i < listaMedicamentos.size(); ++i) {
                DadosMedicamento medicamento;
                if (i == this.linhaEditandoMedicamento || (medicamento = (DadosMedicamento)listaMedicamentos.get(i)) == null || !medicamento.getCodigo().equals(codigo)) continue;
                jaExiste = true;
                break;
            }
            if (jaExiste) {
                Funcoes.mensagem(this, "O medicamento j\u00e1 foi informado.", 2);
                ScreenUtil.requisitarFoco(this.textCodigoMedicamento);
                return;
            }
        }
        if (this.isEditandoMedicamento && this.linhaEditandoMedicamento > -1) {
            DadosMedicamento medicamento = (DadosMedicamento)this.modeloMedicamentos.getValueAt(this.linhaEditandoMedicamento, this.getColunaObjetoMedicamento());
            medicamento.setCodigo(codigo);
            medicamento.setDescricao(descricao);
            medicamento.setResultado(resultado);
            this.modeloMedicamentos.setValueAt(medicamento, this.linhaEditandoMedicamento, this.getColunaObjetoMedicamento());
        } else {
            if (listaMedicamentos == null) {
                listaMedicamentos = new ArrayList<DadosMedicamento>();
            }
            listaMedicamentos.add(new DadosMedicamento(codigo, descricao, resultado));
        }
        this.atualizaMedicamentos();
        this.textCodigoMedicamento.clear();
        this.comboDescricaoMedicamento.setSelectedIndex(0);
        this.comboResultadoMedicamento.setSelectedIndex(0);
        this.isEditandoMedicamento = false;
        this.linhaEditandoMedicamento = -1;
        ScreenUtil.requisitarFoco(this.comboDescricaoMedicamento);
    }

    private void atualizaCombos() {
        this.comboDescricaoMicroorganismo.removeAllItems();
        this.comboQuantidadeMicroorganismo.removeAllItems();
        this.comboAmostraMicroorganismo.removeAllItems();
        this.comboDescricaoMedicamento.removeAllItems();
        this.comboResultadoMedicamento.removeAllItems();
        this.comboDescricaoMicroorganismo.addItem("");
        this.comboAmostraMicroorganismo.addItem("");
        this.comboDescricaoMedicamento.addItem("");
        if (this.listaCampos != null) {
            for (int i = 0; i < this.listaCampos.size(); ++i) {
                String campo = this.listaCampos.get(i);
                this.comboDescricaoMicroorganismo.addItem(campo);
                this.comboQuantidadeMicroorganismo.addItem(campo);
                this.comboAmostraMicroorganismo.addItem(campo);
                this.comboDescricaoMedicamento.addItem(campo);
                this.comboResultadoMedicamento.addItem(campo);
            }
        }
        this.comboDescricaoMicroorganismo.setEnabled(this.comboDescricaoMicroorganismo.getItemCount() > 0);
        this.comboQuantidadeMicroorganismo.setEnabled(this.comboQuantidadeMicroorganismo.getItemCount() > 0);
        this.comboAmostraMicroorganismo.setEnabled(this.comboAmostraMicroorganismo.getItemCount() > 0);
        this.comboDescricaoMedicamento.setEnabled(this.comboDescricaoMedicamento.getItemCount() > 0);
        this.comboResultadoMedicamento.setEnabled(this.comboResultadoMedicamento.getItemCount() > 0);
    }

    @Override
    protected boolean acaoOk() {
        boolean haErros = false;
        for (int i = 0; i < this.modeloMicroorganismos.getRowCount(); ++i) {
            ArrayList listaMedicamentos = (ArrayList)this.modeloMicroorganismos.getValueAt(i, this.getColunaArrayMedicamentoMicro());
            String codigo = (String)this.modeloMicroorganismos.getValueAt(i, 0);
            String descricao = (String)this.modeloMicroorganismos.getValueAt(i, this.getColunaDescricaoMicro());
            if (listaMedicamentos != null && !listaMedicamentos.isEmpty()) continue;
            Funcoes.mensagem(this, "Pelo menos um medicamento deve ser associado ao microorganismo " + codigo + " \"" + descricao + "\".", 2);
            haErros = true;
            break;
        }
        return !haErros;
    }
}

