/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.sinconecta.service;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.DadosMaterialUtilizado;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.sinconecta.ConfiguradorExamesSinconecta;
import jalis.integracaohospitais.util.sinconecta.dao.SinconectaDao;
import jalis.integracaohospitais.util.sinconecta.dto.ExameSinconectaDto;
import jalis.integracaohospitais.util.sinconecta.dto.IntegracaoSinconectaDto;
import jalis.integracaohospitais.util.sinconecta.dto.PrescricaoSinconectaDto;
import jalis.integracaohospitais.util.sinconecta.service.LaudoSinconecta;
import jalis.integracaohospitais.util.sinconecta.service.SinconectaComunicacao;
import jalis.integracaohospitais.util.sinconecta.service.SituacaoExameSinconecta;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.mensagens.NovaMensagem;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.BairroVO;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.auxiliares.BairroService;
import jalis.service.cadastro.auxiliares.CidadeService;
import jalis.util.ConvenioUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.ValidaDoc;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SinconectaService {
    private IntegracaoSinconectaDto integracaoDto;
    private final SinconectaComunicacao comunicacao;
    private final SinconectaDao dao;
    private DadosErrosIntegracaoHospital erros;
    public static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    public static final String PROCESSO_CONSULTAR_INTEGRACAO_HOSPITAL = "consultando integra\u00e7\u00e3o hospital";
    public static final String PROCESSO_INSERIRPACIENTE = "inserindo paciente";
    public static final String PROCESSO_INSERIRREQUISICAO = "inserindo requisi\u00e7\u00e3o";
    public static final String PROCESSO_INSERIREXAMEREQUISICAO = "inserindo Exame";
    private static final String PROCESSO_ENVIAR_LAUDO = "enviando laudo";
    private static final String PROCESSO_ATUALIZAR_SITUACAO_LAUDO = "atualizando situacao laudo";
    public static final String PROCESSO_ENVIAR_INTEGRACAO_HOSPITAL = "enviar integra\u00e7\u00e3o hospital";
    public static final String TAG_XML_SINCONECTA = "xmlSinconecta";
    public static final String TAG_PROTOCOLO = "protocolo";
    public static final String TAG_NUMERO_PRESCRICAO = "numeroPrescricao";
    public static final String TAG_NR_PRESCRICAO = "nr_prescricao";
    public static final String TAG_ID_EXAME = "id_exame";
    public static final String TAG_ID_MATERIAL = "material";
    public static final String TAG_NR_EXAME = "nr_exame";
    public static final String TAG_COD_ANS_SUS = "cod_ans_sus";
    public static final String TAG_DS_EXAME = "ds_exame";
    public static final String TAG_RETORNO = "retorno";
    public static final String TAG_SEQUENCIAL = "sequencial";
    public static final String TAG_NOMEINTEGRACAOHOSPITAL = "NomeIntegracaoHospital";
    private static final String TAG_IDSOLICITACAO = "idSolicitacao";
    private static final String TAG_IDPROCEDIMENTO = "idProcedimento";
    public static final String LOG_SITUACAO_SOLICITACAO = "Solicita\u00e7\u00e3o";
    public static final String LOG_SITUACAO_EXAME = "Exame";
    private static final String MENSAGEM_LOG_SITUACAO = "Ocorreu um erro ao gravar a Solicita\u00e7\u00e3o com N\u00famero de Prescri\u00e7\u00e3o %s. %s.";
    private static final String MENSAGEM_LOG_EXAME = "O ID do Exame solicitado pelo Hospital, n\u00e3o possui exame correspondente configurado no Jalis.";
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final Logger LOGGER = Logger.getLogger(SinconectaService.class.getName());
    private static final String TAG_FILIAL = "filial";
    private static final String TAG_CODREQ = "codReq";
    private static final String TAG_CODEXA = "codExa";
    private static final String TAG_CODMAT = "codMat";
    public static final String RESULTADO_RETIFICADO = "A";
    public static final String SITUACAO_EXAME = "I";
    public static final String RESULTADO_PRIMEIRA_CONFERENCIA = "I";
    private Integer codigoRequisicao;
    private String xml;
    private Handler logHandler;

    public SinconectaService() {
        this.dao = new SinconectaDao();
        this.comunicacao = new SinconectaComunicacao();
    }

    public SinconectaService(String xml, SinconectaDao dao) {
        this.comunicacao = new SinconectaComunicacao();
        this.dao = dao;
        this.xml = xml;
        this.iniciarLog();
    }

    public boolean convenioIntegradoSinconecta(String codigoFilial, String codigoConvenio) throws SQLException {
        ConvenioVO convenioVO = new ConvenioVO();
        if (!Funcoes.textoVazio(codigoConvenio)) {
            convenioVO = this.dao.buscaConvenios(codigoFilial, "", codigoConvenio);
        }
        return convenioVO.getIntegracaoHospital() != null && convenioVO.getIntegracaoHospital().contains("Sinconecta");
    }

    public void iniciarLog() {
        try {
            this.logHandler = new FileHandler(System.getProperty("user.home") + System.getProperty("file.separator") + "sinconecta.log");
            this.logHandler.setLevel(Level.ALL);
            this.logHandler.setFormatter(new SimpleFormatter(){
                private static final String format = "[%1$tF %1$tT] %3$s %n";

                @Override
                public synchronized String format(LogRecord lr) {
                    return String.format(format, new Date(lr.getMillis()), lr.getLevel().getLocalizedName(), lr.getMessage());
                }
            });
            LOGGER.addHandler(this.logHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void consultarIntegracaoHospital() throws Exception {
        this.debug("Consultando Prescri\u00e7\u00f5es");
        this.codigoRequisicao = 0;
        JSONArray respostaConsulta = this.comunicacao.consultarPrescricoes();
        List<PrescricaoSinconectaDto> prescricoes = this.converterRespostaConsultaParaPrescricaoSinconectaDto(respostaConsulta);
        if (!prescricoes.isEmpty()) {
            this.debug(prescricoes.size() + " prescri\u00e7\u00f5es respondidas");
            for (PrescricaoSinconectaDto prescricaoDto : prescricoes) {
                if (!this.prescricaoValida(prescricaoDto)) continue;
                RequisicaoVO requisicao = this.dao.pesquisarRequisicaoPorNumeroDePrescricao(prescricaoDto.getNumPrescricao());
                ConvenioVO convenio = this.dao.pesquisarConvenioConfiguradoSinconecta();
                if (requisicao.getCodigo() == null) {
                    this.cadastrarNovaRequisicao(prescricaoDto, convenio);
                    continue;
                }
                this.compararExamesDeRequisicaoExistente(requisicao, prescricaoDto, convenio.getCodigo());
            }
        }
    }

    protected boolean prescricaoValida(PrescricaoSinconectaDto prescricaoDto) {
        StringBuilder invalido = new StringBuilder();
        invalido.append(!ValidaDoc.checkDoc(prescricaoDto.getNumCpf(), 8) ? String.format("CPF %s inv\u00e1lido", prescricaoDto.getNumCpf()) : "");
        invalido.append(Funcoes.textoVazio(prescricaoDto.getSexo()) ? " - Sexo do paciente n\u00e3o informado" : "");
        invalido.append(Funcoes.textoVazio(prescricaoDto.getNomePaciente()) ? " - Nome do paciente n\u00e3o informado" : "");
        if (invalido.length() > 0) {
            this.debug("prescricao invalida: " + invalido.toString());
            this.escreverLogRequisicao(prescricaoDto, invalido.toString());
        }
        return invalido.length() == 0;
    }

    protected List<PrescricaoSinconectaDto> converterRespostaConsultaParaPrescricaoSinconectaDto(JSONArray respostaConsulta) throws Exception {
        ArrayList<PrescricaoSinconectaDto> prescricoes = new ArrayList<PrescricaoSinconectaDto>();
        if (respostaConsulta != null) {
            for (int i = 0; i < respostaConsulta.length(); ++i) {
                JSONObject prescricaoObj = respostaConsulta.getJSONObject(i);
                Integer numPrescricao = !prescricaoObj.isNull(TAG_NR_PRESCRICAO) ? prescricaoObj.getInt(TAG_NR_PRESCRICAO) : 0;
                String dataPrescricao = !prescricaoObj.isNull("dt_prescricao") ? prescricaoObj.getString("dt_prescricao") : "";
                String nomePaciente = !prescricaoObj.isNull("nm_paciente") ? prescricaoObj.getString("nm_paciente") : "";
                String nomeSocial = !prescricaoObj.isNull("nm_social") ? prescricaoObj.getString("nm_social") : "";
                String dataNascimento = !prescricaoObj.isNull("dt_nascimento") ? prescricaoObj.getString("dt_nascimento") : "";
                String sexo = !prescricaoObj.isNull("ie_sexo") ? prescricaoObj.getString("ie_sexo") : "";
                String logradouroEndereco = !prescricaoObj.isNull("ds_endereco") ? prescricaoObj.getString("ds_endereco") : "";
                String numeroEndereco = !prescricaoObj.isNull("nr_endereco") ? prescricaoObj.getString("nr_endereco") : "";
                String complementoEndereco = !prescricaoObj.isNull("ds_complemento") ? prescricaoObj.getString("ds_complemento") : "";
                String bairroEndereco = !prescricaoObj.isNull("ds_bairro") ? prescricaoObj.getString("ds_bairro") : "";
                Integer codIbgeMunicipio = !prescricaoObj.isNull("nr_municipio") ? prescricaoObj.getInt("nr_municipio") : 0;
                String siglaEstado = !prescricaoObj.isNull("sg_estado") ? prescricaoObj.getString("sg_estado") : "";
                String numTelefone = !prescricaoObj.isNull("nr_telefone") ? prescricaoObj.getString("nr_telefone") : "";
                String numCpf = !prescricaoObj.isNull("nr_cpf") ? prescricaoObj.getString("nr_cpf") : "";
                String numCRM = !prescricaoObj.isNull("nr_crm") ? prescricaoObj.getString("nr_crm") : "";
                String ufCRM = !prescricaoObj.isNull("uf_crm") ? prescricaoObj.getString("uf_crm") : "";
                String nomeMedico = !prescricaoObj.isNull("nm_medico") ? prescricaoObj.getString("nm_medico") : "";
                String nomeUsuario = !prescricaoObj.isNull("nm_usuario") ? prescricaoObj.getString("nm_usuario") : "";
                JSONArray listExames = prescricaoObj.getJSONArray("exames");
                ArrayList<ExameSinconectaDto> exames = new ArrayList<ExameSinconectaDto>();
                if (listExames != null) {
                    for (int e = 0; e < listExames.length(); ++e) {
                        JSONObject exameObj = listExames.getJSONObject(e);
                        ExameSinconectaDto exame = this.converterJSONObjectParaExameSinconectaDto(exameObj);
                        exames.add(exame);
                    }
                }
                PrescricaoSinconectaDto prescricao = new PrescricaoSinconectaDto.Builder().bairroEndereco(bairroEndereco).codIbgeMunicipio(codIbgeMunicipio).complementoEndereco(complementoEndereco).dataNascimento(dataNascimento).dataPrescricao(dataPrescricao).exames(exames).logradouroEndereco(logradouroEndereco).nomeMedico(nomeMedico).nomePaciente(nomePaciente).nomeSocial(nomeSocial).nomeUsuario(nomeUsuario).numCpf(numCpf).numCRM(numCRM).numeroEndereco(numeroEndereco).numPrescricao(numPrescricao).numTelefone(numTelefone).sexo(sexo).siglaEstado(siglaEstado).ufCRM(ufCRM).jsonSinconecta(prescricaoObj.toString()).build();
                prescricoes.add(prescricao);
            }
        }
        return prescricoes;
    }

    protected void cadastrarExamesRequisicao(RequisicaoVO requisicaoVO) {
        if (requisicaoVO.getExames() == null || requisicaoVO.getExames().isEmpty()) {
            requisicaoVO.setExames(new ArrayList<ExameRequisicaoVO>());
        }
        Integer ordem = 0;
        for (ExameRequisicaoVO exameRequisicaoVO : requisicaoVO.getExames()) {
            try {
                this.dao.inserirExamesRequisicao(requisicaoVO, exameRequisicaoVO, ordem);
                Integer n = ordem;
                Integer n2 = ordem = Integer.valueOf(ordem + 1);
            }
            catch (Exception e) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", Variaveis.filialPadrao);
                this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_INSERIRREQUISICAO, e.getMessage(), chaves, null, Variaveis.filialPadrao, null));
            }
        }
    }

    protected ExameSinconectaDto converterJSONObjectParaExameSinconectaDto(JSONObject exameObj) throws JSONException {
        Integer numExame = !exameObj.isNull(TAG_NR_EXAME) ? exameObj.getInt(TAG_NR_EXAME) : 0;
        String codAnsSus = !exameObj.isNull(TAG_COD_ANS_SUS) ? exameObj.getString(TAG_COD_ANS_SUS) : "";
        String descricaoExame = !exameObj.isNull(TAG_DS_EXAME) ? exameObj.getString(TAG_DS_EXAME) : "";
        String material = !exameObj.isNull(TAG_ID_MATERIAL) ? exameObj.getString(TAG_ID_MATERIAL) : "";
        String obs = !exameObj.isNull("obs") ? exameObj.getString("obs") : "";
        Integer idExame = !exameObj.isNull(TAG_ID_EXAME) ? exameObj.getInt(TAG_ID_EXAME) : 0;
        return new ExameSinconectaDto.Builder().numExame(numExame).codAnsSus(codAnsSus).descricaoExame(descricaoExame).material(material).obs(obs).idExame(idExame).build();
    }

    protected RequisicaoVO cadastrarNovaRequisicao(PrescricaoSinconectaDto prescricaoDto, ConvenioVO convenio) throws Exception {
        this.debug("Cadastrar nova requisicao");
        RequisicaoVO requisicaoVO = new RequisicaoVO();
        ArrayList<ExameRequisicaoVO> exames = this.converterExamesSinconectaParaExamesJalis(prescricaoDto, convenio.getCodigo(), 0);
        if (!exames.isEmpty()) {
            requisicaoVO = this.construirRequisicao(prescricaoDto, exames, convenio);
            int requisicaoCadastrada = this.dao.inserirNovaRequisicao(requisicaoVO);
            if (requisicaoCadastrada > 0) {
                this.cadastrarExamesRequisicao(requisicaoVO);
            }
        } else {
            this.escreverLogRequisicao(prescricaoDto, "Prescri\u00e7\u00e3o sem exame configurado");
        }
        return requisicaoVO;
    }

    private RequisicaoVO construirRequisicao(PrescricaoSinconectaDto prescricaoDto, ArrayList<ExameRequisicaoVO> exames, ConvenioVO convenio) throws Exception {
        this.debug("constuir requisicao");
        RequisicaoVO requisicaoVO = new RequisicaoVO();
        this.codigoRequisicao = this.dao.getCodigoRequisicao(Variaveis.filialPadrao);
        requisicaoVO.setConvenio(convenio);
        requisicaoVO.setMedico(this.converterPrescricaoSinconectaDtoParaMedicoVO(prescricaoDto));
        requisicaoVO.setPaciente(this.converterPrescricaoSinconectaDtoParaPacienteVO(prescricaoDto));
        requisicaoVO.setColeta(requisicaoVO.getConvenio().getColeta());
        requisicaoVO.setDestino(requisicaoVO.getConvenio().getDestino());
        requisicaoVO.setGuia(prescricaoDto.getNumPrescricao().toString());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date dataGuia = sdf.parse(prescricaoDto.getDataPrescricao());
        requisicaoVO.setDataGuia(dataGuia);
        requisicaoVO.setIntegracaoHospital(this.getXmlIntegracaoHospital(prescricaoDto.getNumPrescricao().toString()));
        EstacaoVO estacao = new EstacaoVO();
        estacao.setCodigo(Integer.valueOf(Variaveis.codigoEstacao));
        estacao.setDescricao(Variaveis.nomeEstacao);
        requisicaoVO.setEstacao(estacao);
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        requisicaoVO.setUsuario(usuario);
        requisicaoVO.setUsuarioAbertura(usuario);
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
        requisicaoVO.setFilial(filial);
        requisicaoVO.setCodigo(this.codigoRequisicao);
        requisicaoVO.setExames(exames);
        return requisicaoVO;
    }

    private void compararExamesDeRequisicaoExistente(RequisicaoVO requisicaoVO, PrescricaoSinconectaDto prescricaoDto, Integer codigoConvenio) throws Exception {
        this.debug("Compara exames requisicao");
        Integer codReq = requisicaoVO.getCodigo() == null ? 0 : requisicaoVO.getCodigo();
        ArrayList<ExameRequisicaoVO> examesDaPrescricao = this.converterExamesSinconectaParaExamesJalis(prescricaoDto, codigoConvenio, codReq);
        ArrayList<ExameRequisicaoVO> examesDaRequisicao = requisicaoVO.getExames();
        ArrayList<ExameRequisicaoVO> copiaPrescricao = new ArrayList<ExameRequisicaoVO>();
        ArrayList<ExameRequisicaoVO> copiaRequisicao = new ArrayList<ExameRequisicaoVO>();
        examesDaPrescricao.forEach(copiaPrescricao::add);
        examesDaRequisicao.forEach(copiaRequisicao::add);
        for (ExameRequisicaoVO examePrescricao : examesDaPrescricao) {
            for (ExameRequisicaoVO exameRequisicao : examesDaRequisicao) {
                if (!this.examesIguais(examePrescricao, exameRequisicao)) continue;
                copiaPrescricao.remove(examePrescricao);
                if (!this.exameImportado(exameRequisicao)) continue;
                copiaRequisicao.remove(exameRequisicao);
            }
        }
        this.adicionarExamesRequisicaoExistente(copiaPrescricao, requisicaoVO);
        this.excluirExamesRequisicaoExistente(copiaRequisicao, requisicaoVO);
    }

    private void adicionarExamesRequisicaoExistente(List<ExameRequisicaoVO> copiaPrescricao, RequisicaoVO requisicaoVO) throws Exception {
        if (!copiaPrescricao.isEmpty()) {
            this.debug("adicionar exames requisicao");
            Integer ordem = requisicaoVO.getExames().size();
            for (ExameRequisicaoVO examePrescricao : copiaPrescricao) {
                this.dao.inserirExamesRequisicao(requisicaoVO, examePrescricao, ordem);
                if (!Funcoes.textoVazio(this.integracaoDto.getUsuarioInclusaoExames())) {
                    String mensagem = this.getMensagem(examePrescricao, requisicaoVO.getCodigo(), SituacaoExameSinconecta.ADICIONADO);
                    String codUsuario = this.getCodigoUsuario(examePrescricao, true);
                    this.enviarMensagem(mensagem, codUsuario, SituacaoExameSinconecta.ADICIONADO.getAssunto());
                }
                Integer n = ordem;
                Integer n2 = ordem = Integer.valueOf(ordem + 1);
            }
        }
    }

    private void excluirExamesRequisicaoExistente(List<ExameRequisicaoVO> copiaRequisicao, RequisicaoVO requisicaoVO) throws Exception {
        if (!copiaRequisicao.isEmpty()) {
            this.debug("excluir exames requisicao");
            StringBuilder novaObservacao = new StringBuilder();
            int c = 0;
            for (ExameRequisicaoVO exameRequisicao : copiaRequisicao) {
                String codUsuario = this.getCodigoUsuario(exameRequisicao, false);
                if (exameRequisicao.getSituacao().equals("T")) {
                    this.dao.excluirExameRequisicao(exameRequisicao);
                    if (!Funcoes.textoVazio(this.integracaoDto.getUsuarioExclusaoExames()) && !Funcoes.textoVazio(codUsuario)) {
                        String mensagem = this.getMensagem(exameRequisicao, exameRequisicao.getRequisicao(), SituacaoExameSinconecta.EXCLUIDO);
                        this.enviarMensagem(mensagem, codUsuario, SituacaoExameSinconecta.EXCLUIDO.getAssunto());
                    }
                } else if (!Funcoes.textoVazio(codUsuario)) {
                    String agora = LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
                    novaObservacao.append(!Funcoes.textoVazio(requisicaoVO.getObservacao()) && c == 0 ? requisicaoVO.getObservacao() : "");
                    StringBuilder mensagem = new StringBuilder();
                    mensagem.append(novaObservacao.length() > 0 ? " " : "");
                    mensagem.append("Exame ").append(exameRequisicao.getExame().getCodigo()).append(" (").append(exameRequisicao.getMaterial().getCodigo()).append(") - ");
                    mensagem.append("Pedido de exclus\u00e3o via integra\u00e7\u00e3o n\u00e3o realizado em ").append(agora).append(" - ");
                    mensagem.append("Exame em andamento - (nr_exame ").append(exameRequisicao.getCodAutorizacao()).append(")");
                    if (!novaObservacao.toString().contains(mensagem.toString().substring(0, 50))) {
                        novaObservacao.append(mensagem.toString());
                        String msg = this.getMensagem(exameRequisicao, exameRequisicao.getRequisicao(), SituacaoExameSinconecta.PEDIDO);
                        this.enviarMensagem(msg, codUsuario, SituacaoExameSinconecta.PEDIDO.getAssunto());
                    }
                }
                ++c;
            }
            if (novaObservacao.length() > 0) {
                requisicaoVO.setObservacao(novaObservacao.toString());
                this.dao.atualizarObservacaoRequisicao(requisicaoVO);
            }
        }
    }

    private void enviarMensagem(String mensagem, String codUsuario, String assunto) throws Exception {
        Statement st = Conexao.getStatement();
        NovaMensagem.enviarMensagem(false, st, Variaveis.filialPadrao, Variaveis.login, codUsuario, assunto, mensagem, false, "C");
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
    }

    private String getCodigoUsuario(ExameRequisicaoVO exameRequisicao, boolean inclusao) throws SQLException {
        String codUsuario;
        String string = codUsuario = inclusao ? this.integracaoDto.getUsuarioInclusaoExames() : this.integracaoDto.getUsuarioExclusaoExames();
        if (codUsuario.equals("Respons\u00e1veldoSetor")) {
            codUsuario = this.dao.pesquisarUsuarioDoSetorPorExame(exameRequisicao);
        }
        return codUsuario;
    }

    private boolean exameImportado(ExameRequisicaoVO exame) {
        return exame.getSolicitadoTISS() != false && exame.getDataSolicitadoTISS() != null;
    }

    private boolean examesIguais(ExameRequisicaoVO examePrescricao, ExameRequisicaoVO exameRequisicao) {
        return examePrescricao.getFilial().getCodigo().equals(exameRequisicao.getFilial().getCodigo()) && examePrescricao.getExame().getCodigo().equals(exameRequisicao.getExame().getCodigo()) && examePrescricao.getMaterial().getCodigo().equals(exameRequisicao.getMaterial().getCodigo());
    }

    private String getMensagem(ExameRequisicaoVO exameRequisicaoVO, Integer codRequisicao, SituacaoExameSinconecta situacaoExame) {
        String exame = exameRequisicaoVO.getExame().getCodigo();
        Integer material = exameRequisicaoVO.getMaterial().getCodigo();
        String numExameSinconecta = exameRequisicaoVO.getCodAutorizacao();
        StringBuilder msgCabecalho = new StringBuilder();
        msgCabecalho.append(String.format("%s de exame na requisi\u00e7\u00e3o %d via pedido de integra\u00e7\u00e3o", situacaoExame.getCabecalho(), codRequisicao));
        msgCabecalho.append(situacaoExame.equals((Object)SituacaoExameSinconecta.PEDIDO) ? " - N\u00e3o realizado (exame em andamento).\n" : ".\n");
        StringBuilder mensagemCompleta = new StringBuilder();
        mensagemCompleta.append(msgCabecalho.toString());
        mensagemCompleta.append(String.format("Exame %s %s (%d) - nr_exame %s\n", new Object[]{situacaoExame, exame, material, numExameSinconecta}));
        mensagemCompleta.append(String.format("Filial: %s\n", Variaveis.filialPadrao));
        mensagemCompleta.append(String.format("Usu\u00e1rio respons\u00e1vel: %s\n", Variaveis.login));
        mensagemCompleta.append(String.format("Data: %s\n", LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"))));
        return mensagemCompleta.toString();
    }

    private ArrayList<ExameRequisicaoVO> converterExamesSinconectaParaExamesJalis(PrescricaoSinconectaDto prescricaoDto, Integer codigoConvenio, Integer codRequisicao) throws Exception {
        ArrayList<ExameRequisicaoVO> exames = new ArrayList<ExameRequisicaoVO>();
        for (ExameSinconectaDto exameDto : prescricaoDto.getExames()) {
            ExameRequisicaoVO exameJalis = this.getExameJalis(codigoConvenio, exameDto, prescricaoDto);
            if (!Funcoes.textoVazio(exameJalis.getCodAutorizacao())) {
                boolean adicionarExame = true;
                for (ExameRequisicaoVO exameRequisicao : exames) {
                    if (!exameRequisicao.getExame().equals(exameJalis.getExame()) || !exameRequisicao.getMaterial().equals(exameJalis.getMaterial())) continue;
                    adicionarExame = false;
                    break;
                }
                if (!adicionarExame) continue;
                exameJalis.setSolicitadoTISS(true);
                exameJalis.setDataSolicitadoTISS(new Date());
                exames.add(exameJalis);
                continue;
            }
            this.escreverLogExame(exameDto, prescricaoDto.getNumPrescricao(), codRequisicao);
        }
        return exames;
    }

    public ExameRequisicaoVO getExameJalis(Integer codConvenio, ExameSinconectaDto exameDto, PrescricaoSinconectaDto prescricaoDto) throws Exception {
        ExameRequisicaoVO exameRequisicaoVO = new ExameRequisicaoVO();
        String xmlConfiguracaoExame = this.getXmlConfiguracaoExame(exameDto.getIdExame().toString(), exameDto.getMaterial().toString());
        ArrayList<Registro> listaExames = this.dao.pesquisarExames(Variaveis.filialPadrao, xmlConfiguracaoExame);
        if (!listaExames.isEmpty()) {
            Statement st = Conexao.getStatement();
            DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, codConvenio, st);
            for (Registro registro : listaExames) {
                FilialVO filialVO = new FilialVO();
                filialVO.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
                exameRequisicaoVO.setFilial(filialVO);
                ExameVO exame = new ExameVO();
                exame.setCodigo(registro.getString("codigoexame"));
                exame.setFilial(filialVO);
                exame.setDescricao(registro.getString("exa_descricao"));
                MaterialColetaVO material = new MaterialColetaVO();
                material.setCodigo(registro.getInt("codigomaterial"));
                material.setFilial(filialVO);
                exameRequisicaoVO.setExame(exame);
                exameRequisicaoVO.setMaterial(material);
                DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, material.getCodigo(), st);
                DadosExames dadosExame = ExameUtil.getDadosExame(Variaveis.filialPadrao, exame.getCodigo(), dadosMaterial, Conexao.getStatement());
                ExameUtil.calculaPrecoExame(Variaveis.filialPadrao, dadosExame, dadosMaterial, dadosConvenio, false, true, false, null, null, (Integer)Integer.parseInt(dadosExame.getCodMetodo()), st);
                exameRequisicaoVO.setValorCh(dadosConvenio.getCH().doubleValue());
                exameRequisicaoVO.setValorExame(dadosExame.getValor().doubleValue());
                exameRequisicaoVO.setValorChExame(dadosExame.getValorCH().doubleValue());
                exameRequisicaoVO.setValorMaterial(this.getValorMaterial(dadosExame.getMatUtilizado()));
                exameRequisicaoVO.setData(new Date());
                exameRequisicaoVO.setDataColetar(new Date());
                exameRequisicaoVO.setDataMaterial(new Date());
                exameRequisicaoVO.setPercentualBalcao(dadosConvenio.getPercentualBalcao());
                String codPrazo = this.dao.pesquisarCodigoPrazoPorExame(exame, material);
                Date dataEntregaPrev = ExameUtil.calculaDataEntrega(Variaveis.filialPadrao, codPrazo, exame.getCodigo().toString(), material.getCodigo().toString(), codConvenio.toString(), "");
                exameRequisicaoVO.setDataEntregaPrevista(dataEntregaPrev);
                exameRequisicaoVO.setAutorizar(false);
                exameRequisicaoVO.setNaoFaturar(false);
                exameRequisicaoVO.setDeveGuia(false);
                exameRequisicaoVO.setAvisarEntrega(false);
                exameRequisicaoVO.setUrgente(false);
                exameRequisicaoVO.setCodigoApoiado("");
                exameRequisicaoVO.setVolumeDiurese(BigDecimal.ZERO.doubleValue());
                exameRequisicaoVO.setSituacao("T");
                exameRequisicaoVO.setGuia(prescricaoDto.getNumPrescricao().toString());
                exameRequisicaoVO.setCodAutorizacao(exameDto.getNumExame().toString());
                exameRequisicaoVO.setSolicitadoTISS(true);
                exameRequisicaoVO.setDataSolicitadoTISS(new Date());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                exameRequisicaoVO.setDataAutorizacao(sdf.parse(prescricaoDto.getDataPrescricao()));
                MetodologiaVO metodo = new MetodologiaVO();
                metodo.setCodigo(Integer.valueOf(dadosExame.getCodMetodo()));
                metodo.setDescricao(dadosExame.getDescricao());
                exameRequisicaoVO.setMetodologia(metodo);
            }
        }
        return exameRequisicaoVO;
    }

    private Double getValorMaterial(ArrayList matUtilizado) {
        BigDecimal valorMaterial = BigDecimal.ZERO;
        for (int i = 0; i < matUtilizado.size(); ++i) {
            DadosMaterialUtilizado mat = (DadosMaterialUtilizado)matUtilizado.get(i);
            valorMaterial.add(mat.getValor());
        }
        return valorMaterial.doubleValue();
    }

    private String getXmlConfiguracaoExame(String idExame, String idMaterial) {
        String material = !Funcoes.textoVazio(idMaterial) ? idMaterial : "";
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(ConfiguradorExamesSinconecta.TAG_EXPORTAR_SINCONECTA);
        xml.escrever("idExame", idExame);
        xml.escrever("idMaterial", material);
        try {
            xml.fechar(ConfiguradorExamesSinconecta.TAG_EXPORTAR_SINCONECTA);
        }
        catch (XMLStringBuilderException xMLStringBuilderException) {
            // empty catch block
        }
        return xml.getXML().replaceAll("\n", "").replaceAll(" ", "");
    }

    private String getXmlIntegracaoHospital(String numPrescricao) throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_XML_SINCONECTA);
        xml.abrir(TAG_PROTOCOLO);
        xml.escrever(ProtocoloIntegracaoHospital.SINCONECTA.getNome());
        xml.fechar(TAG_PROTOCOLO);
        xml.abrir(TAG_NUMERO_PRESCRICAO);
        xml.escrever(numPrescricao);
        xml.fechar(TAG_NUMERO_PRESCRICAO);
        xml.fechar(TAG_XML_SINCONECTA);
        return xml.getXML().replaceAll("\n", "").replaceAll(" ", "");
    }

    private MedicoVO converterPrescricaoSinconectaDtoParaMedicoVO(PrescricaoSinconectaDto prescricaoDto) throws SQLException {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
        MedicoVO medico = new MedicoVO();
        medico.setFilial(filial);
        medico.setCrm(prescricaoDto.getNumCRM());
        medico.setUf(prescricaoDto.getUfCRM());
        medico.setConselho("CRM");
        if (!this.dao.medicoCadastrado(medico)) {
            medico.setNome(prescricaoDto.getNomeMedico());
            this.dao.salvarMedico(medico);
        }
        return medico;
    }

    private PacienteVO converterPrescricaoSinconectaDtoParaPacienteVO(PrescricaoSinconectaDto prescricaoDto) throws Exception {
        PacienteVO paciente = this.dao.pesquisarPacientePorCpf(prescricaoDto.getNumCpf());
        try {
            if (paciente.getCodigo() == null) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
                paciente.setFilial(filial);
                paciente.setCpf(prescricaoDto.getNumCpf());
                paciente.setNome(prescricaoDto.getNomePaciente());
                paciente.setSexo(prescricaoDto.getSexo());
                if (!Funcoes.textoVazio(prescricaoDto.getDataNascimento())) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    Date dataNascimento = format.parse(prescricaoDto.getDataNascimento());
                    paciente.setDataNascimento(dataNascimento);
                }
                if (!Funcoes.textoVazio(prescricaoDto.getNomeSocial())) {
                    paciente.setNomeSocial(prescricaoDto.getNomeSocial());
                }
                if (!Funcoes.textoVazio(prescricaoDto.getNumTelefone())) {
                    paciente.setFone(prescricaoDto.getNumTelefone());
                }
                this.converterPrescricaoSinconectaDtoParaEndereco(prescricaoDto, paciente);
                paciente.setCodigo(this.dao.salvarPaciente(paciente));
            }
        }
        catch (Exception e) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_INSERIRPACIENTE, e.getMessage(), null, null));
        }
        return paciente;
    }

    private void converterPrescricaoSinconectaDtoParaEndereco(PrescricaoSinconectaDto prescricaoDto, PacienteVO paciente) throws Exception {
        if (!Funcoes.textoVazio(prescricaoDto.getBairroEndereco())) {
            paciente.setBairro(this.pesquisarBairro(prescricaoDto.getBairroEndereco()));
        }
        if (!Funcoes.textoVazio(prescricaoDto.getLogradouroEndereco())) {
            paciente.setEndereco(prescricaoDto.getLogradouroEndereco());
        }
        if (!Funcoes.textoVazio(prescricaoDto.getNumeroEndereco())) {
            paciente.setNumeroEndereco(prescricaoDto.getNumeroEndereco());
        }
        paciente.setCidade(this.pesquisarCidadePorCodigoIbge(prescricaoDto.getCodIbgeMunicipio()));
        if (!Funcoes.textoVazio(prescricaoDto.getComplementoEndereco())) {
            paciente.setComplemento(prescricaoDto.getComplementoEndereco());
        }
        if (!Funcoes.textoVazio(prescricaoDto.getBairroEndereco())) {
            paciente.setBairro(this.pesquisarBairro(prescricaoDto.getBairroEndereco()));
        }
    }

    private BairroVO pesquisarBairro(String bairro) throws Exception {
        BairroVO bairroVO = null;
        try {
            Set bairros = new BairroService().loadVO(" where fil_codigo = " + Variaveis.filialPadrao + " and bai_descricao = '" + bairro + "' ");
            if (bairros != null) {
                bairroVO = (BairroVO)(bairros != null && bairros.size() > 0 ? bairros.toArray()[0] : null);
            }
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel inserir o bairro do paciente!");
        }
        return bairroVO;
    }

    private CidadeVO pesquisarCidadePorCodigoIbge(Integer codigoIbge) throws Exception {
        CidadeVO cidadeVO = null;
        try {
            StringBuilder where = new StringBuilder();
            where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            where.append(" and cid_codigoibge = ").append(codigoIbge);
            Set cidades = new CidadeService().loadVO(where.toString());
            if (!cidades.isEmpty()) {
                cidadeVO = (CidadeVO)(cidades != null && cidades.size() > 0 ? cidades.toArray()[0] : null);
            } else {
                where.delete(0, where.length());
                where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                where.append(" and cid_codigo = ").append(ParametrosGerais.getCidCodigo());
                cidades = new CidadeService().loadVO(where.toString());
                cidadeVO = (CidadeVO)(cidades != null && cidades.size() > 0 ? cidades.toArray()[0] : null);
            }
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel inserir a cidade do paciente!");
        }
        return cidadeVO;
    }

    public boolean configuracaoValida() {
        boolean avisoInclusao;
        String estacao = StringUtil.getValor(this.xml, "estacaoIntegradora");
        String linkConsulta = StringUtil.getValor(this.xml, "webServiceCadastro");
        String linkEnvioResultados = StringUtil.getValor(this.xml, "webServiceSADT");
        String login = StringUtil.getValor(this.xml, "login");
        String senha = StringUtil.getValor(this.xml, "senha");
        String usuarioExclusaoExames = "";
        String usuarioInclusaoExames = "";
        String t = Boolean.TRUE.toString().toLowerCase();
        boolean avisoExclusao = StringUtil.getValor(this.xml, "avisoExclusao").equals(t);
        if (avisoExclusao) {
            usuarioExclusaoExames = StringUtil.getValor(this.xml, "usuarioExclusao");
        }
        if (avisoInclusao = StringUtil.getValor(this.xml, "avisoInclusao").equals(t)) {
            usuarioInclusaoExames = StringUtil.getValor(this.xml, "usuarioInclusao");
        }
        if (Funcoes.textoVazio(estacao)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Esta\u00e7\u00e3o n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        if (Funcoes.textoVazio(linkConsulta)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Link de Consulta n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        if (Funcoes.textoVazio(linkEnvioResultados)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Link de Envido de Rsultados n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        if (Funcoes.textoVazio(login)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O login n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        if (Funcoes.textoVazio(senha)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "A senha n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        return true;
    }

    public IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls) {
        return this.montaExcecao(exception, nomeProcesso, mensagem, chaves, xmls, null, null);
    }

    public IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls, String codigoFilialLog, Long codigoLog) {
        String tmp;
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (exception != null && exception instanceof IntegracaoHospitalException) {
            buf.append(" - ").append(((IntegracaoHospitalException)exception).getMensagemErro());
        }
        if (mensagem != null) {
            buf.append(" - ").append(mensagem);
        }
        if (chaves != null) {
            buf.append(" - ");
            int i = 0;
            for (String chave : chaves.keySet()) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object valor = chaves.get(chave);
                buf.append(chave.toUpperCase()).append(" = ").append(valor == null ? "null" : valor.toString());
                ++i;
            }
        }
        if (exception != null) {
            buf.append("\n").append(exception.toString());
            if (exception instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        StringBuilder xmlAux = new StringBuilder();
        if (xmls != null) {
            for (String aux : xmls) {
                if (!Funcoes.textoVazio(xmlAux.toString())) {
                    xmlAux.append("\n\n");
                }
                xmlAux.append(aux);
            }
        }
        if ((tmp = codigoFilialLog) == null || Funcoes.isNumeric(tmp)) {
            tmp = "1";
        }
        IntegracaoHospitalException novaExcecao = new IntegracaoHospitalException(exception, Integer.valueOf(tmp), codigoLog, null, buf.toString(), xmlAux.toString(), null);
        if (exception != null) {
            novaExcecao.setStackTrace(exception.getStackTrace());
        }
        return novaExcecao;
    }

    public void limparErros() {
        this.erros = new DadosErrosIntegracaoHospital();
    }

    public void converterXmlParaIntegracaoSinconectaDto() {
        boolean avisoInclusao;
        String linkConsulta = StringUtil.getValor(this.xml, "webServiceCadastro");
        String linkEnvioResultados = StringUtil.getValor(this.xml, "webServiceSADT");
        String login = StringUtil.getValor(this.xml, "login");
        String senha = StringUtil.getValor(this.xml, "senha");
        String usuarioExclusaoExames = "";
        String usuarioInclusaoExames = "";
        String t = Boolean.TRUE.toString().toLowerCase();
        boolean avisoExclusao = StringUtil.getValor(this.xml, "avisoExclusao").equals(t);
        if (avisoExclusao) {
            usuarioExclusaoExames = StringUtil.getValor(this.xml, "usuarioExclusao");
        }
        if (avisoInclusao = StringUtil.getValor(this.xml, "avisoInclusao").equals(t)) {
            usuarioInclusaoExames = StringUtil.getValor(this.xml, "usuarioInclusao");
        }
        this.integracaoDto = new IntegracaoSinconectaDto.Builder().linkConsulta(linkConsulta).linkEnvioResultados(linkEnvioResultados).login(login).senha(senha).usuarioExclusaoExames(usuarioExclusaoExames).usuarioInclusaoExames(usuarioInclusaoExames).build();
        this.comunicacao.setIntegracaoDto(this.integracaoDto);
    }

    public DadosErrosIntegracaoHospital getErros() {
        return this.erros;
    }

    private void escreverLogRequisicao(PrescricaoSinconectaDto prescricaoDto, String motivoLog) {
        String log = this.construirRetornoSolicitacao(prescricaoDto, motivoLog);
        LOGGER.info("Falha ao inserir Requisi\u00e7\u00e3o ".concat(log).concat("\n"));
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", Variaveis.filialPadrao);
        int ini = log.indexOf("<json>");
        int fim = log.indexOf("</json>");
        StringBuilder logSemJson = new StringBuilder();
        logSemJson.append(log.substring(0, ini));
        logSemJson.append(log.substring(fim + 8, log.length()));
        this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_INSERIRREQUISICAO, logSemJson.toString(), chaves, null, Variaveis.filialPadrao, null));
    }

    private void escreverLogExame(ExameSinconectaDto exameDto, Integer numPrescricaoDto, Integer codRequisicao) {
        String log = this.construirRetornoExame(exameDto, numPrescricaoDto, codRequisicao);
        LOGGER.info("Falha ao inserir Exame ".concat(log).concat("\n"));
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", Variaveis.filialPadrao);
        this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_INSERIREXAMEREQUISICAO, log, chaves, null, Variaveis.filialPadrao, null));
    }

    private String construirRetornoExame(ExameSinconectaDto exameDto, Integer numPrescricaoDto, Integer codRequisicao) {
        XMLStringBuilder xmlBuilder = new XMLStringBuilder();
        xmlBuilder.abrir("IntegracaoHospital");
        xmlBuilder.escrever(TAG_NOMEINTEGRACAOHOSPITAL, ProtocoloIntegracaoHospital.SINCONECTA.getNome());
        xmlBuilder.escrever(TAG_NR_PRESCRICAO, numPrescricaoDto.toString());
        xmlBuilder.escrever(TAG_FILIAL, Variaveis.filialPadrao);
        xmlBuilder.escrever(TAG_CODREQ, codRequisicao.toString());
        xmlBuilder.abrir(LOG_SITUACAO_EXAME);
        xmlBuilder.escrever(TAG_ID_EXAME, exameDto.getIdExame().toString());
        xmlBuilder.escrever(TAG_ID_MATERIAL, exameDto.getMaterial());
        xmlBuilder.escrever(TAG_NR_EXAME, exameDto.getNumExame().toString());
        xmlBuilder.escrever(TAG_COD_ANS_SUS, exameDto.getCodAnsSus());
        xmlBuilder.escrever(TAG_DS_EXAME, exameDto.getDescricaoExame());
        try {
            xmlBuilder.fechar(LOG_SITUACAO_EXAME);
            xmlBuilder.escrever(TAG_RETORNO, MENSAGEM_LOG_EXAME);
            xmlBuilder.fechar("IntegracaoHospital");
        }
        catch (XMLStringBuilderException xMLStringBuilderException) {
            // empty catch block
        }
        return xmlBuilder.getXML();
    }

    private String construirRetornoSolicitacao(PrescricaoSinconectaDto prescricaoDto, String motivoLog) {
        XMLStringBuilder xmlBuilder = new XMLStringBuilder();
        xmlBuilder.abrir("IntegracaoHospital");
        xmlBuilder.escrever(TAG_NOMEINTEGRACAOHOSPITAL, ProtocoloIntegracaoHospital.SINCONECTA.getNome());
        xmlBuilder.escrever(TAG_NR_PRESCRICAO, prescricaoDto.getNumPrescricao().toString());
        xmlBuilder.abrir("json");
        xmlBuilder.escrever(prescricaoDto.getJsonSinconecta());
        try {
            xmlBuilder.fechar("json");
            String mensagemRetorno = String.format("Ocorreu um erro ao gravar a Solicita\u00e7\u00e3o com N\u00famero de Prescri\u00e7\u00e3o \"%s\". Motivo: %s", prescricaoDto.getNumPrescricao(), motivoLog);
            xmlBuilder.escrever(TAG_RETORNO, mensagemRetorno);
            xmlBuilder.fechar("IntegracaoHospital");
        }
        catch (XMLStringBuilderException xMLStringBuilderException) {
            // empty catch block
        }
        return xmlBuilder.getXML();
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    public void enviarIntegracaoHospital() throws Exception {
        List<Registro> logs = this.dao.recuperarLogExportaIntegracaoHospital();
        this.debug("encontrados " + logs.size() + " logs para integracao");
        for (Registro log : logs) {
            LaudoSinconecta laudo = this.logToLaudo(log);
            boolean retorno = false;
            try {
                retorno = this.comunicacao.registrarLaudo(this.integracaoDto.getLogin(), this.integracaoDto.getSenha(), laudo);
                String codLog = log.getString("eih_codigo");
                String operacao = log.getString("eih_operacao");
                String codFilial = StringUtil.getValor(operacao, TAG_FILIAL, true).trim();
                if (retorno) {
                    this.dao.atualizarLogEnviadoComSucesso(codFilial, codLog);
                    continue;
                }
                this.dao.atualizarLogHospitalEnviarLaudo(codFilial, codLog, "R");
            }
            catch (Exception e) {
                this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_ENVIAR_LAUDO, e.getMessage(), null, null));
            }
        }
        this.debug("processo de envio de logs concluido");
    }

    private Integer existeLogIntegracaoHospital(String codLog, String codFilial) {
        return this.dao.existeLogIntegracaoHospital(codLog, codFilial);
    }

    private LaudoSinconecta logToLaudo(Registro log) throws Exception {
        LaudoSinconecta laudo = new LaudoSinconecta();
        String operacao = log.getString("eih_operacao");
        String nrExame = StringUtil.getValor(operacao, TAG_NR_EXAME, true).trim();
        String nrPrescricao = StringUtil.getValor(operacao, TAG_NR_PRESCRICAO, true).trim();
        String codFilial = StringUtil.getValor(operacao, TAG_FILIAL, true).trim();
        String codRequisicao = StringUtil.getValor(operacao, TAG_CODREQ, true).trim();
        String codExame = StringUtil.getValor(operacao, TAG_CODEXA, true).trim();
        String codMaterial = StringUtil.getValor(operacao, TAG_CODMAT, true).trim();
        String sequencial = StringUtil.getValor(operacao, TAG_SEQUENCIAL, true).trim();
        String idSolicitacao = StringUtil.getValor(operacao, TAG_IDSOLICITACAO, true).trim();
        Registro datas = this.dao.recuperarDatasExameRequisicao(codFilial, codRequisicao, codExame, codMaterial);
        String dataFormatada = Funcoes.formataDataEHora(datas.getString("dataliberacao").substring(0, 15).replace("/", "-"));
        String dataLiberacao = dataFormatada.replace(" ", "T");
        byte[] resultadoPDF = this.gerarResultadoPDF(codFilial, codRequisicao, codExame, codMaterial);
        laudo.setConteudo(resultadoPDF);
        laudo.setFormato("BASE64");
        laudo.setDataLiberacao(dataLiberacao.replace("/", "-"));
        laudo.setNumeroPrescricao(nrPrescricao);
        laudo.setNumeroExame(nrExame);
        String versao = "01";
        laudo.setID(idSolicitacao.concat(this.padronizarSequencialExame(sequencial)));
        laudo.setSequencia(Integer.valueOf(versao));
        laudo.setSituacao("L");
        return laudo;
    }

    private String padronizarSequencialExame(String sequencialExame) {
        return sequencialExame.length() < 2 ? "0".concat(sequencialExame) : sequencialExame;
    }

    private byte[] gerarResultadoPDF(String codFilial, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(null, null, codFilial, codRequisicao, true, true, null, new String[]{codExame}, new String[]{codMaterial}, true, null, true, true, null, false, "", true, false);
        return retorno.getResultadoPdfWeb();
    }

    public String getRequisicaoGuia(String filial, String requisicao) {
        return this.dao.getRequisicaoGuia(filial, requisicao);
    }

    public String getAutorizaocaoExame(String filial, String requisicao, String exame, int material) {
        return this.dao.getAutorizaocaoExame(filial, requisicao, exame, material);
    }

    public Boolean getSolicitacaoTiss(String filial, String requisicao, String exame, int material) {
        return this.dao.getSolicitacaoTiss(filial, requisicao, exame, material);
    }
}

