/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.sinconecta.service;

import jalis.integracaohospitais.util.sinconecta.dto.IntegracaoSinconectaDto;
import jalis.integracaohospitais.util.sinconecta.service.LaudoSinconecta;
import jalis.util.Funcoes;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SinconectaComunicacao {
    private static final String DATA_INICIAL = "p_data_inicial";
    private static final String DATA_FINAL = "p_data_final";
    private static final String HORA_INICIAL = "p_hora_inicial";
    private static final String HORA_FINAL = "p_hora_final";
    private IntegracaoSinconectaDto integracaoDto;
    public static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    public JSONArray consultarPrescricoes() throws Exception {
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build())).build();
        URI uri = new URIBuilder(this.integracaoDto.getLinkConsulta()).addParameter(DATA_INICIAL, this.getDataInicial()).addParameter(DATA_FINAL, LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"))).addParameter(HORA_INICIAL, "00:00:00").addParameter(HORA_FINAL, LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"))).build();
        String autenticacao = this.getAutenticacao();
        HttpGet get = new HttpGet(uri);
        get.setHeader("Authorization", "Basic " + autenticacao);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
        this.debug("consultar prescricoes sinconecta respondeu http c\u00f3d: " + response.getStatusLine().getStatusCode());
        HttpEntity corpoResposta = response.getEntity();
        JSONArray respostaConsulta = null;
        if (response.getStatusLine().getStatusCode() == 200) {
            String resposta = EntityUtils.toString((HttpEntity)corpoResposta, (String)"UTF-8");
            resposta = resposta.substring(0, resposta.length() - 1).replace("{\"items\":", "");
            respostaConsulta = new JSONArray(resposta);
        }
        return respostaConsulta;
    }

    private String getDataInicial() {
        LocalDate dataInicial = LocalDate.now().minusDays(3L);
        return dataInicial.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
    }

    private String getAutenticacao() {
        String autenticacao = this.integracaoDto.getLogin().concat(":").concat(this.integracaoDto.getSenha());
        String autenticacaoCodificada = DatatypeConverter.printBase64Binary((byte[])autenticacao.getBytes(StandardCharsets.UTF_8));
        return autenticacaoCodificada;
    }

    public void setIntegracaoDto(IntegracaoSinconectaDto integracaoDto) {
        this.integracaoDto = integracaoDto;
    }

    private void debug(String mensagem) {
        if (DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    public boolean registrarLaudo(String login, String senha, LaudoSinconecta laudoSinconecta) throws Exception {
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build())).build();
        URI uri = new URIBuilder(this.integracaoDto.getLinkEnvioResultados()).addParameter("NR_PRESCRICAO", laudoSinconecta.getNumeroPrescricao()).addParameter("NR_EXAME", laudoSinconecta.setNumeroExame()).addParameter("DATA_LIBERACAO", laudoSinconecta.getDataLiberacao()).build();
        String autenticacao = this.getAutenticacao();
        HttpPost post = new HttpPost(uri);
        post.setHeader("Authorization", "Basic " + autenticacao);
        post.setHeader("Accept", "application/json");
        post.setHeader("Content-type", "application/json");
        JSONObject json = new JSONObject();
        json.put("NR_PRESCRICAO", (Object)laudoSinconecta.getNumeroPrescricao());
        json.put("NR_EXAME", (Object)laudoSinconecta.setNumeroExame());
        json.put("DATA_LIBERACAO", (Object)laudoSinconecta.getDataLiberacao());
        json.put("BODY", (Object)new Base64().encodeAsString(laudoSinconecta.getConteudo()));
        StringEntity entity = new StringEntity(json.toString());
        post.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        this.debug("registrar laudo sinconecta respondeu http c\u00f3d: " + response.getStatusLine().getStatusCode());
        HttpEntity corpoResposta = response.getEntity();
        boolean respostaConsulta = false;
        if (response.getStatusLine().getStatusCode() == 200) {
            String resposta = EntityUtils.toString((HttpEntity)corpoResposta, (String)"UTF-8");
            respostaConsulta = resposta.contains("SUCESSO");
        }
        return respostaConsulta;
    }
}

