/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.sinconecta.dao;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.sinconecta.ConfiguradorExamesSinconecta;
import jalis.model.vo.cadastro.ColetaVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.DestinoVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SinconectaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequisicaoVO pesquisarRequisicaoPorNumeroDePrescricao(Integer numeroPrescricao) throws SQLException {
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" r.fil_codigo, r.req_codigo, er.exa_codigo, er.mco_codigo, r.con_codigo, e.exa_descricao, r.usr_codigo, er.exr_solicitadotiss, ");
        sql.append(" er.exr_datasolicitadotiss, er.exr_codautorizacao, er.exr_situacao, r.req_obs ");
        sql.append(" from requisicao r ");
        sql.append(" left join examerequisicao er on r.fil_codigo = er.fil_codigo and r.req_codigo = er.req_codigo ");
        sql.append(" left join exames e on r.fil_codigo = e.fil_codigo and er.exa_codigo = e.exa_codigo ");
        sql.append(" where r.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and r.req_guia = ").append(StringUtil.textoDBEscape(numeroPrescricao.toString()));
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        RequisicaoVO requisicao = new RequisicaoVO();
        try {
            rs = Conexao.executeQuery(st, sql.toString());
            ArrayList<ExameRequisicaoVO> exames = new ArrayList<ExameRequisicaoVO>();
            while (rs.next()) {
                ConvenioVO convenio = new ConvenioVO();
                convenio.setCodigo(rs.getInt("con_codigo"));
                UsuarioVO usuario = new UsuarioVO();
                usuario.setCodigo(rs.getString("usr_codigo"));
                FilialVO fil = new FilialVO();
                fil.setCodigo(rs.getInt("fil_codigo"));
                requisicao.setUsuario(usuario);
                requisicao.setConvenio(convenio);
                requisicao.setCodigo(rs.getInt("req_codigo"));
                requisicao.setFilial(fil);
                requisicao.setObservacao(rs.getString("req_obs"));
                ExameRequisicaoVO exameRequisicao = new ExameRequisicaoVO();
                ExameVO exame = new ExameVO();
                exame.setFilial(fil);
                exame.setCodigo(rs.getString("exa_codigo"));
                exame.setDescricao(rs.getString("exa_descricao"));
                MaterialColetaVO material = new MaterialColetaVO();
                material.setCodigo(rs.getInt("mco_codigo"));
                exameRequisicao.setFilial(fil);
                exameRequisicao.setRequisicao(rs.getInt("req_codigo"));
                exameRequisicao.setSituacao(rs.getString("exr_situacao"));
                exameRequisicao.setExame(exame);
                exameRequisicao.setMaterial(material);
                exameRequisicao.setCodAutorizacao(rs.getString("exr_codautorizacao"));
                if (rs.getBoolean("exr_solicitadotiss")) {
                    exameRequisicao.setSolicitadoTISS(rs.getBoolean("exr_solicitadotiss"));
                    exameRequisicao.setDataSolicitadoTISS(rs.getDate("exr_datasolicitadotiss"));
                }
                if (exame.getCodigo() == null) continue;
                exames.add(exameRequisicao);
            }
            requisicao.setExames(exames);
        }
        catch (Throwable throwable) {
            rs.close();
            Conexao.fecharStatement(st);
            throw throwable;
        }
        rs.close();
        Conexao.fecharStatement(st);
        return requisicao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean medicoCadastrado(MedicoVO medicoVO) throws SQLException {
        ResultSet rs = null;
        Statement st = Conexao.getStatement();
        boolean medicoCadastrado = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select med_crm ");
            buf.append(" from medico ");
            buf.append(" where fil_codigo = ").append(medicoVO.getFilial().getCodigo());
            buf.append(" and med_crm = ").append(StringUtil.textoDBEscape(medicoVO.getCrm().toString()));
            buf.append(" and med_uf = ").append(StringUtil.textoDBEscape(medicoVO.getUf().toString()));
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                medicoCadastrado = !Funcoes.textoVazio(rs.getString("med_crm"));
            }
        }
        catch (Throwable throwable) {
            rs.close();
            Conexao.fecharStatement(st);
            throw throwable;
        }
        rs.close();
        Conexao.fecharStatement(st);
        return medicoCadastrado;
    }

    public void salvarMedico(MedicoVO medicoVO) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append("insert into medico (fil_codigo, med_crm, med_nome, med_uf, med_conselho, med_abrev, cid_codigo) ");
        sql.append(" values ( ");
        sql.append(medicoVO.getFilial().getCodigo());
        sql.append(", ").append(this.getTextoSql(medicoVO.getCrm()));
        sql.append(", ").append(this.getTextoSql(medicoVO.getNome()));
        sql.append(", ").append(this.getTextoSql(medicoVO.getUf()));
        sql.append(", ").append(this.getTextoSql(medicoVO.getConselho()));
        sql.append(", ").append(this.getTextoSql("Dr."));
        sql.append(", ").append(this.getTextoSql(String.valueOf(ParametrosGerais.getCidCodigo())));
        sql.append(")");
        int qtd = Conexao.executeUpdate(medicoVO.getFilial().getCodigo().toString(), st, sql.toString(), true);
        if (qtd > 0) {
            Conexao.arquivaSQL();
            Conexao.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvenioVO pesquisarConvenioConfiguradoSinconecta() throws SQLException {
        StringBuilder sql = new StringBuilder();
        StringBuilder protocolo = new StringBuilder();
        protocolo.append("<").append("protocolo").append(">").append(ParametrosGerais.getProtocoloIntegracaoHospital().getNome()).append("</").append("protocolo").append(">");
        StringBuilder estacao = new StringBuilder();
        estacao.append("<").append("estacaoIntegradora").append(">").append(Variaveis.codigoEstacao).append("</").append("estacaoIntegradora").append(">");
        sql.append(" select con_codigo, con_integracaohospital, col_codigo, des_codigo from convenios ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and con_integracaohospital ilike '%").append(protocolo.toString()).append("%'");
        sql.append(" and con_integracaohospital ilike '%").append(estacao.toString()).append("%'");
        ConvenioVO convenioVO = new ConvenioVO();
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                convenioVO.setCodigo(rs.getInt("con_codigo"));
                convenioVO.setIntegracaoHospital(rs.getString("con_integracaohospital"));
                ColetaVO coleta = new ColetaVO();
                coleta.setCodigo(rs.getString("col_codigo"));
                convenioVO.setColeta(coleta);
                DestinoVO destino = new DestinoVO();
                destino.setCodigo(rs.getString("des_codigo"));
                convenioVO.setDestino(destino);
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return convenioVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacienteVO pesquisarPacientePorCpf(String cpf) throws SQLException {
        ResultSet rs = null;
        Statement st = Conexao.getStatement();
        PacienteVO pacienteVO = new PacienteVO();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select pac_codigo ");
            sql.append(" from paciente ");
            sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            sql.append(" and pac_cpf = ").append(StringUtil.textoDBEscape(cpf));
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                pacienteVO = new PacienteVO();
                pacienteVO.setCodigo(rs.getInt("pac_codigo"));
            }
        }
        catch (Throwable throwable) {
            rs.close();
            Conexao.fecharStatement(st);
            throw throwable;
        }
        rs.close();
        Conexao.fecharStatement(st);
        return pacienteVO;
    }

    public Integer salvarPaciente(PacienteVO paciente) throws SQLException {
        Integer sequencia = 0;
        if (paciente != null) {
            sequencia = this.getSequencia("paciente", paciente.getFilial().getCodigo().toString());
            StringBuilder buf = new StringBuilder();
            buf.append(" insert into paciente(");
            buf.append("fil_codigo, ");
            buf.append("pac_codigo, ");
            buf.append("pac_nome,  ");
            buf.append("pac_sexo, ");
            buf.append("pac_datanasc, ");
            buf.append("pac_nomesocial, ");
            buf.append("pac_cpf, ");
            buf.append("pac_fone, ");
            buf.append("pac_endereco, ");
            buf.append("pac_numeroendereco, ");
            buf.append("bai_codigo, ");
            buf.append("pac_complemento, ");
            buf.append("cid_codigo ");
            buf.append(")");
            buf.append(" values(");
            buf.append(paciente.getFilial().getCodigo()).append(", ");
            buf.append(sequencia).append(", ");
            buf.append(StringUtil.textoDBEscape(paciente.getNome())).append(", ");
            buf.append(StringUtil.textoDBEscape(paciente.getSexo())).append(", ");
            String dataNascimento = paciente.getDataNascimento() != null ? StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", paciente.getDataNascimento())) : "null";
            buf.append(dataNascimento).append(", ");
            buf.append(StringUtil.textoDBEscape(paciente.getNomeSocial())).append(",");
            buf.append(StringUtil.textoDBEscape(paciente.getCpf())).append(",");
            buf.append(StringUtil.textoDBEscape(paciente.getFone())).append(",");
            buf.append(StringUtil.textoDBEscape(paciente.getEndereco())).append(",");
            buf.append(StringUtil.textoDBEscape(paciente.getNumeroEndereco())).append(",");
            String codigoBairro = paciente.getBairro() != null ? StringUtil.textoDBEscape(paciente.getBairro().getCodigo()) : "null";
            buf.append(codigoBairro).append(",");
            buf.append(this.getTextoSql(paciente.getComplemento())).append(",");
            buf.append(paciente.getCidade().getCodigo());
            buf.append(" ) ");
            Statement st = Conexao.getStatement();
            int execute = Conexao.executeUpdate(paciente.getFilial().getCodigo().toString(), st, buf.toString());
            if (execute > 0) {
                Conexao.arquivaSQL();
                Conexao.fecharStatement(st);
            }
        }
        return sequencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Registro> pesquisarExames(String filial, String xmlConfiguracaoExame) throws Exception {
        ResultSet rs = null;
        Statement st = Conexao.getStatement();
        ArrayList<Registro> exames = new ArrayList<Registro>();
        String material = StringUtil.getValor(xmlConfiguracaoExame, "idMaterial");
        if (Funcoes.textoVazio(material)) {
            String idExame = StringUtil.getValor(xmlConfiguracaoExame, "idExame");
            xmlConfiguracaoExame = this.getXmlIdExame(idExame);
        }
        try {
            exames = new ArrayList();
            StringBuilder buf = new StringBuilder();
            buf.append(" SELECT a.exa_codigo as codigoExame, a.exa_descricao, c.mco_codigo as codigoMaterial ");
            buf.append(" FROM exames a  ");
            buf.append(" LEFT JOIN examematcoleta c ON a.fil_codigo = c.fil_codigo AND c.exa_codigo = a.exa_codigo ").append(Funcoes.textoVazio(material) ? " AND c.emc_default " : "");
            buf.append(" LEFT JOIN examematcoletahospital h ON a.fil_codigo = h.fil_codigo AND a.exa_codigo = h.exa_codigo AND c.mco_codigo = h.mco_codigo ");
            buf.append(" WHERE a.fil_codigo = ").append(filial);
            buf.append(" and h.emh_sistema = 'C'");
            buf.append(" and h.emh_xmlconfiguracao ilike '%").append(xmlConfiguracaoExame).append("%'");
            buf.append(" order by codigoExame ");
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                do {
                    ExameVO exameVO = (ExameVO)new ExameService().load(" where fil_codigo = " + filial + " and exa_codigo = '" + rs.getString("codigoExame") + "' ;").toArray()[0];
                    Registro registro = new Registro(rs);
                    registro.setValor("objetoExame", exameVO);
                    exames.add(registro);
                } while (rs.next());
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return exames;
    }

    private String getXmlIdExame(String idExame) {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(ConfiguradorExamesSinconecta.TAG_EXPORTAR_SINCONECTA);
        xml.escrever("idExame", idExame);
        return xml.getXML().replaceAll("\n", "").replaceAll(" ", "");
    }

    private String getTextoSql(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return "null";
        }
        return "'" + StringUtil.textoDB(texto) + "'";
    }

    public Integer getCodigoRequisicao(String filialPadrao) throws SQLException {
        return this.getSequencia("requisicao", filialPadrao);
    }

    private int getSequencia(String tabela, String filial) throws SQLException {
        HashMap<String, String> chaves = new HashMap<String, String>();
        chaves.put("Sequencia", tabela + "_" + filial + "_sequence");
        String comando = " select nextval('" + tabela + "_" + filial + "_sequence') as sequencia ";
        ResultSet rs = null;
        rs = Conexao.executeQuery(Conexao.getStatement(), comando);
        if (rs.next()) {
            return rs.getInt("sequencia");
        }
        return -1;
    }

    public String pesquisarCodigoPrazoPorExame(ExameVO exame, MaterialColetaVO material) throws SQLException {
        StringBuilder sql = new StringBuilder("");
        sql.append(" select prz_codigo from examematcoleta ");
        sql.append(" where fil_codigo = ").append(exame.getFilial().getCodigo());
        sql.append(" and exa_codigo = '").append(exame.getCodigo()).append("'");
        sql.append(" and mco_codigo = ").append(material.getCodigo());
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        String codPrazo = rs.next() ? rs.getString("prz_codigo") : "";
        rs.close();
        Conexao.fecharStatement(st);
        return codPrazo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inserirNovaRequisicao(RequisicaoVO requisicaoVO) throws SQLException {
        int execute = -1;
        Statement st = null;
        try {
            StringBuilder sql = new StringBuilder("");
            sql.append(" insert into requisicao(");
            sql.append("   fil_codigo ");
            sql.append("   ,req_codigo ");
            sql.append("   ,con_codigo ");
            sql.append("   ,med_crm ");
            sql.append("   ,med_conselho ");
            sql.append("   ,med_uf ");
            sql.append("   ,pac_codigo ");
            sql.append("   ,req_urgente ");
            sql.append("   ,req_avisarpaciente ");
            sql.append("   ,req_imprimirseparado ");
            sql.append("   ,req_obs ");
            sql.append("   ,req_totpago ");
            sql.append("   ,req_total ");
            sql.append("   ,req_vlrexames ");
            sql.append("   ,req_vlrmateriais ");
            sql.append("   ,req_data ");
            sql.append("   ,req_hora ");
            sql.append("   ,req_gestante ");
            sql.append("   ,req_neonato ");
            sql.append("   ,req_idade ");
            sql.append("   ,req_anomes ");
            sql.append("   ,req_desconto ");
            sql.append("   ,req_vlrdesconto ");
            sql.append("   ,req_acrescimo ");
            sql.append("   ,req_vlracrescimo ");
            sql.append("   ,req_telacoleta ");
            sql.append("   ,est_codigo ");
            sql.append("   ,usr_codigo ");
            sql.append("   ,req_datarequisicao ");
            sql.append("   ,usr_codabertura ");
            sql.append("   ,req_deveguia ");
            sql.append("   ,req_guia ");
            sql.append("   ,req_excluida ");
            sql.append("   ,req_dtfatura ");
            sql.append("   ,req_horafatura ");
            sql.append("   ,col_codigo ");
            sql.append("   ,des_codigo ");
            sql.append("   ,req_integracaohospital ");
            sql.append("   ,req_senhaweb ");
            sql.append("   ,req_dataguia ");
            sql.append("   ) ");
            sql.append("   values (").append(requisicaoVO.getFilial().getCodigo().toString());
            sql.append("   ,").append(requisicaoVO.getCodigo().toString());
            sql.append("   ,").append(requisicaoVO.getConvenio().getCodigo());
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getMedico().getCrm()));
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getMedico().getConselho()));
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getMedico().getUf()));
            sql.append("   ,").append(requisicaoVO.getPaciente().getCodigo());
            sql.append("   ,").append(requisicaoVO.getUrgente());
            sql.append("   ,false ");
            sql.append("   ,false ");
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getObservacao()));
            sql.append("   ,0 ");
            sql.append("   ,").append(requisicaoVO.getTotal());
            sql.append("   ,").append(requisicaoVO.getValorExames());
            sql.append("   ,").append(requisicaoVO.getValorMateriais());
            sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", new Date())));
            sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("HH:mm:ss", new Date())));
            sql.append("   ,").append(requisicaoVO.getGestante());
            sql.append("   ,false ");
            sql.append("   ,").append(requisicaoVO.getPaciente().getIdade() == null ? "0" : requisicaoVO.getPaciente().getIdade());
            sql.append("   ,").append(StringUtil.textoDBEscape("A"));
            sql.append("   ,0 ");
            sql.append("   ,0 ");
            sql.append("   ,0 ");
            sql.append("   ,0 ");
            sql.append("   ,false ");
            sql.append("   ,").append(requisicaoVO.getEstacao().getCodigo().toString());
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
            sql.append("   ,LOCALTIMESTAMP ");
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
            sql.append("   ,false ");
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getGuia()));
            sql.append("   ,false ");
            sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", new Date())));
            sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("HH:mm:ss", new Date())));
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getColeta().getCodigo()));
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getDestino().getCodigo()));
            sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getIntegracaoHospital()));
            sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.gerarSenhaWeb()));
            sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSSZ", requisicaoVO.getDataGuia())));
            sql.append("   ) ");
            st = Conexao.getStatement();
            execute = Conexao.executeUpdate(requisicaoVO.getFilial().getCodigo().toString(), st, sql.toString(), true);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return execute;
    }

    public int inserirExamesRequisicao(RequisicaoVO requisicaoVO, ExameRequisicaoVO exameRequisicao, Integer ordem) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into examerequisicao ");
        sql.append("   (fil_codigo ");
        sql.append("   ,req_codigo ");
        sql.append("   ,exa_codigo ");
        sql.append("   ,mco_codigo ");
        sql.append("   ,exr_dataetqcoleta ");
        sql.append("   ,exr_situacao ");
        sql.append("   ,exr_excluido ");
        sql.append("   ,exr_obs ");
        sql.append("   ,usr_codigo ");
        sql.append("   ,exr_data ");
        sql.append("   ,exr_vlrch ");
        sql.append("   ,exr_vlrbalcaoconvenio ");
        sql.append("   ,exr_vlrchexame ");
        sql.append("   ,exr_vlrexame ");
        sql.append("   ,exr_vlrmaterial ");
        sql.append("   ,exr_dataentregaprev ");
        sql.append("   ,exr_descricaomaterial ");
        sql.append("   ,exr_datacoletar ");
        sql.append("   ,usr_codcoletar ");
        sql.append("   ,met_codigo ");
        sql.append("   ,exr_volumediurese ");
        sql.append("   ,exr_codigoapoiado ");
        sql.append("   ,exr_datamaterial ");
        sql.append("   ,usr_codmaterial ");
        sql.append("   ,exr_autorizar ");
        sql.append("   ,exr_naofaturar ");
        sql.append("   ,usr_codnaofaturar ");
        sql.append("   ,exr_ordem ");
        sql.append("   ,usr_codguia ");
        sql.append("   ,exr_deveguia ");
        sql.append("   ,exr_dataguia ");
        sql.append("   ,exr_avisarentrega ");
        sql.append("   ,exr_custosimples ");
        sql.append("   ,exr_coletaincorreta ");
        sql.append("   ,exr_interfaciado ");
        sql.append("   ,exr_matexterno ");
        sql.append("   ,exr_urgente ");
        sql.append("   ,exr_codautorizacao ");
        sql.append("   ,exr_dataautorizacao ");
        sql.append("   ,exr_guia ");
        sql.append("   ,exr_solicitadotiss ");
        sql.append("   ,exr_datasolicitadotiss ");
        sql.append("   ) ");
        sql.append("   values (").append(exameRequisicao.getFilial().getCodigo());
        sql.append("   ,").append(requisicaoVO.getCodigo());
        sql.append("   ,").append(StringUtil.textoDBEscape(exameRequisicao.getExame().getCodigo()));
        sql.append("   ,").append(exameRequisicao.getMaterial().getCodigo());
        sql.append("   ,null ");
        sql.append("   ,").append(StringUtil.textoDBEscape("T"));
        sql.append("   ,false ");
        sql.append("   ,").append(StringUtil.textoDBEscape(exameRequisicao.getObservacao()));
        sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
        sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSSZ", exameRequisicao.getData())));
        sql.append("   ,").append(exameRequisicao.getValorCh());
        sql.append("   ,").append(exameRequisicao.getPercentualBalcao());
        sql.append("   ,").append(exameRequisicao.getValorChExame());
        sql.append("   ,").append(exameRequisicao.getValorExame());
        sql.append("   ,").append(exameRequisicao.getValorMaterial());
        sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSSZ", exameRequisicao.getDataEntregaPrevista())));
        sql.append("   ,").append(StringUtil.textoDBEscape(exameRequisicao.getMaterial().getDescricao()));
        sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSSZ", exameRequisicao.getDataColetar())));
        sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
        sql.append("   ,").append(exameRequisicao.getMetodologia().getCodigo());
        sql.append("   ,").append(exameRequisicao.getVolumeDiurese());
        sql.append("   ,'").append(exameRequisicao.getCodigoApoiado()).append("'");
        sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", exameRequisicao.getDataMaterial())));
        sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
        sql.append("   ,").append(exameRequisicao.getAutorizar());
        sql.append("   ,").append(exameRequisicao.getNaoFaturar());
        sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
        sql.append("   ,").append(ordem);
        sql.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
        sql.append("   ,").append(exameRequisicao.getDeveGuia());
        sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", exameRequisicao.getDataAutorizacao())));
        sql.append("   ,").append(exameRequisicao.getAvisarEntrega());
        sql.append("   ,").append(BigDecimal.ZERO);
        sql.append("   ,").append(Boolean.FALSE);
        sql.append("   ,").append(Boolean.FALSE);
        sql.append("   ,").append(Boolean.FALSE);
        sql.append("   ,").append(Boolean.FALSE);
        sql.append("   ,").append(StringUtil.textoDBEscape(exameRequisicao.getCodAutorizacao()));
        sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", exameRequisicao.getDataAutorizacao())));
        sql.append("   ,").append(StringUtil.textoDBEscape(exameRequisicao.getGuia()));
        sql.append("   ,").append(true);
        sql.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", exameRequisicao.getDataSolicitadoTISS())));
        sql.append("   ) ");
        int execute = -1;
        Statement st = Conexao.getStatement();
        execute = Conexao.executeUpdate(requisicaoVO.getFilial().getCodigo().toString(), st, sql.toString(), true);
        DBUtil.gravaLogSituacaoExameRequisicao(st, requisicaoVO.getFilial().getCodigo().toString(), "" + requisicaoVO.getCodigo(), exameRequisicao.getExame().getCodigo(), "" + exameRequisicao.getMaterial().getCodigo(), "T", true);
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
        return execute;
    }

    public void excluirExameRequisicao(ExameRequisicaoVO exameRequisicao) throws SQLException {
        String codFilial = exameRequisicao.getFilial().getCodigo().toString();
        StringBuilder sql = new StringBuilder(" delete from examerequisicao  ");
        sql.append("where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(exameRequisicao.getRequisicao());
        sql.append(" and exa_codigo = '").append(exameRequisicao.getExame().getCodigo()).append("'");
        sql.append(" and mco_codigo = ").append(exameRequisicao.getMaterial().getCodigo());
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codFilial, st, sql);
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
    }

    public String pesquisarUsuarioDoSetorPorExame(ExameRequisicaoVO exameRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder(" select s.usr_codigo ");
        sql.append(" from exames e ");
        sql.append(" join examesetor es on e.fil_codigo = es.fil_codigo and e.exa_codigo = es.exa_codigo and es.ese_default = true ");
        sql.append(" join setores s on es.fil_codigo = s.fil_codigo and es.set_codigo = s.set_codigo ");
        sql.append(" where e.fil_codigo = ").append(exameRequisicao.getFilial().getCodigo());
        sql.append(" and e.exa_codigo = '").append(exameRequisicao.getExame().getCodigo()).append("'");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        String codUsuario = rs.next() ? rs.getString("usr_codigo") : "";
        rs.close();
        Conexao.fecharStatement(st);
        return codUsuario;
    }

    public void atualizarObservacaoRequisicao(RequisicaoVO requisicaoVO) throws SQLException {
        StringBuilder sql = new StringBuilder(" update requisicao ");
        sql.append(" set req_obs = '").append(requisicaoVO.getObservacao()).append("'");
        sql.append(" where fil_codigo = ").append(requisicaoVO.getFilial().getCodigo());
        sql.append(" and req_codigo = ").append(requisicaoVO.getCodigo());
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(requisicaoVO.getFilial().getCodigo().toString(), st, sql.toString());
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
    }

    public List<Registro> recuperarLogExportaIntegracaoHospital() throws SQLException {
        ArrayList<Registro> logs = new ArrayList<Registro>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select * from exportaintegracaohospital ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and eih_exportado = false ");
        sql.append(" order by eih_codigo ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = ConexaoTemporaria.executeQuery(st, sql.toString());
        while (rs.next()) {
            String operacao = rs.getString("eih_operacao");
            if (!this.logContemProtocoloSinconecta(operacao)) continue;
            logs.add(new Registro(rs));
        }
        rs.close();
        ConexaoTemporaria.fecharStatement(st);
        return logs;
    }

    private boolean logContemProtocoloSinconecta(String operacao) {
        String protocolo;
        return !Funcoes.textoVazio(operacao) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(operacao, "NomeIntegracaoHospital", true).trim()) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.SINCONECTA.getNome());
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Registro recuperarDatasExameRequisicao(String codFilial, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        StringBuilder sql = new StringBuilder(" select ");
        sql.append("exr_datadigita as datadigitacao, ");
        sql.append("exr_dataassina as dataliberacao ");
        sql.append("from examerequisicao ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        rs = ConexaoTemporaria.executeQuery(st, sql.toString());
        Registro registro = new Registro();
        if (rs.next()) {
            registro.carregar(rs);
        }
        rs.close();
        ConexaoTemporaria.fecharStatement(st);
        return registro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarLogHospitalEnviarLaudo(String codFilial, String codLog, String situacao) {
        StringBuilder bufs = new StringBuilder();
        bufs.append("select fil_codigo, eih_codigo, eih_datahora, eih_operacao ");
        bufs.append("from exportaintegracaohospital where fil_codigo = ").append(codFilial);
        bufs.append("and eih_codigo = ").append(codLog);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, bufs.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (rs != null && rs.next()) {
                if (this.existeLogIntegracaoHospital(codLog, codFilial) <= 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" insert into  logexportaintegracaohospital(fil_codigo, eih_codigo,");
                    buf.append("lei_datahora, lei_situacao) values ('");
                    buf.append(codFilial).append("','");
                    buf.append(codLog).append("',");
                    buf.append("current_timestamp").append(",'");
                    buf.append(situacao).append("'");
                    st = ConexaoTemporaria.getStatement();
                    ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    ConexaoTemporaria.arquivaSQL();
                } else {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update logexportaintegracaohospital set ");
                    buf.append(" lei_situacao = '").append(situacao).append("', ");
                    buf.append(" lei_datahora = current_timestamp");
                    buf.append(" where ");
                    buf.append(" fil_codigo = ").append(codFilial);
                    buf.append(" and eih_codigo = ").append(codLog);
                    st = ConexaoTemporaria.getStatement();
                    ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    ConexaoTemporaria.arquivaSQL();
                }
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarLogHospital(String codFilial, String codLog, String retorno, String situacao) {
        StringBuilder bufs = new StringBuilder();
        bufs.append("select fil_codigo, eih_codigo, eih_datahora, eih_operacao ");
        bufs.append("from exportaintegracaohospital where fil_codigo = ").append(codFilial);
        bufs.append("and eih_codigo = ").append(codLog);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, bufs.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (rs != null && rs.next()) {
                if (this.existeLogIntegracaoHospital(codLog, codFilial) <= 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" insert into  logexportaintegracaohospital(fil_codigo, eih_codigo,");
                    buf.append("lei_datahora, lei_situacao, lei_retorno)values('");
                    buf.append(codFilial).append("','");
                    buf.append(codLog).append("',");
                    buf.append("current_timestamp").append(",'");
                    buf.append(situacao).append("','");
                    buf.append(retorno).append("')");
                    st = ConexaoTemporaria.getStatement();
                    ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    ConexaoTemporaria.arquivaSQL();
                } else {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update logexportaintegracaohospital set '");
                    buf.append(" lei_situacao = '").append(situacao).append("', ");
                    buf.append(" lei_retorno = '").append(retorno).append("', ");
                    buf.append(" lei_datahora = current_timestamp");
                    buf.append(" where ");
                    buf.append(" fil_codigo = ").append(codFilial);
                    buf.append(" and eih_codigo = ").append(codLog);
                    st = ConexaoTemporaria.getStatement();
                    ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    ConexaoTemporaria.arquivaSQL();
                }
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    public Integer existeLogIntegracaoHospital(String codLog, String codFilial) {
        String dataEnvio = Funcoes.getDataHora();
        StringBuilder buf = new StringBuilder();
        buf.append(" select lei_codigo from logexportaintegracaohospital ");
        buf.append("where eih_codigo = ");
        buf.append(codLog);
        buf.append(" and fil_codigo = ").append(codFilial);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            return rs.next() ? rs.getInt("lei_codigo") : 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void atualizarLogEnviadoComSucesso(String codFilial, String codLog) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" update exportaintegracaohospital set eih_exportado = true ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and eih_codigo = ").append(codLog);
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codFilial, st, sql.toString());
        sql.delete(0, sql.length());
        sql.append(" update logexportaintegracaohospital set lei_situacao = 'I' ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and eih_codigo = ").append(codLog);
        Statement statement = Conexao.getStatement();
        Conexao.executeUpdate(codFilial, st, sql.toString());
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvenioVO buscaConvenios(String filialPadrao, String idPlanoSaude, String codigoConvenio) throws SQLException {
        ResultSet rs = null;
        ConvenioVO convenioVO = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select con_codigo, con_integracaohospital, col_codigo, des_codigo  ");
            buf.append(" from convenios ");
            buf.append(" where fil_codigo = ").append(filialPadrao);
            if (!Funcoes.textoVazio(idPlanoSaude)) {
                buf.append(" and con_integracaohospital ilike '%").append(idPlanoSaude.trim()).append("%'");
            }
            if (!Funcoes.textoVazio(codigoConvenio)) {
                buf.append(" and con_codigo =").append(codigoConvenio.trim());
            }
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                convenioVO = new ConvenioVO();
                convenioVO.setCodigo(rs.getInt("con_codigo"));
                convenioVO.setIntegracaoHospital(rs.getString("con_integracaohospital"));
                ColetaVO coleta = new ColetaVO();
                coleta.setCodigo(rs.getString("col_codigo"));
                convenioVO.setColeta(coleta);
                DestinoVO destino = new DestinoVO();
                destino.setCodigo(rs.getString("des_codigo"));
                convenioVO.setDestino(destino);
            }
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return convenioVO;
    }

    public Boolean getSolicitacaoTiss(String filial, String requisicao, String exame, int material) {
        String dataEnvio = Funcoes.getDataHora();
        StringBuilder buf = new StringBuilder();
        buf.append(" select exr_solicitadotiss from examerequisicao ");
        buf.append("where req_codigo = ");
        buf.append(requisicao);
        buf.append(" and fil_codigo = ").append(filial);
        buf.append(" and exa_codigo = '").append(exame).append("'");
        buf.append(" and mco_codigo = ").append(material);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            return rs.next() ? rs.getBoolean("exr_solicitadotiss") : false;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getAutorizaocaoExame(String filial, String requisicao, String exame, int material) {
        String dataEnvio = Funcoes.getDataHora();
        StringBuilder buf = new StringBuilder();
        buf.append(" select exr_codautorizacao from examerequisicao ");
        buf.append("where req_codigo = ");
        buf.append(requisicao);
        buf.append(" and fil_codigo = ").append(filial);
        buf.append(" and exa_codigo = '").append(exame).append("'");
        buf.append(" and mco_codigo = ").append(material);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            return rs.next() ? rs.getString("exr_codautorizacao") : "";
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getRequisicaoGuia(String filial, String requisicao) {
        String dataEnvio = Funcoes.getDataHora();
        StringBuilder buf = new StringBuilder();
        buf.append(" select req_guia from requisicao ");
        buf.append("where req_codigo = ");
        buf.append(requisicao);
        buf.append(" and fil_codigo = ").append(filial);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            return rs.next() ? rs.getString("req_guia") : "";
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }
}

