/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.sinconecta;

import jalis.integracaohospitais.util.AbstractConfiguradorExamesIntegracaoHospital;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorExamesSinconecta
extends AbstractConfiguradorExamesIntegracaoHospital {
    private static String TITULO = "De-Para Exames Sinconecta";
    public static String TAG_EXPORTAR_SINCONECTA = "exportarSinconecta";
    public static String TAG_ID_EXAME = "idExame";
    public static String TAG_ID_MATERIAL = "idMaterial";
    private static final String TAG_CODREQ = "codReq";
    private TTextField textIdExame = new TTextField(20, 3);
    private TTextField textIdMaterial = new TTextField(20, 3);

    public static ConfiguradorExamesSinconecta novaInstancia(Window pai, String xmlConfiguracao, String xmlAssociacaoCampos) {
        return pai instanceof Frame ? new ConfiguradorExamesSinconecta((Frame)pai, xmlConfiguracao, xmlAssociacaoCampos) : new ConfiguradorExamesSinconecta((Dialog)pai, xmlConfiguracao, xmlAssociacaoCampos);
    }

    private ConfiguradorExamesSinconecta(Dialog pai, String xmlConfiguracao, String xmlAssociacaoCampos) {
        super(pai, TITULO, xmlConfiguracao, xmlAssociacaoCampos);
        this.construirTela();
    }

    private ConfiguradorExamesSinconecta(Frame pai, String xmlConfiguracao, String xmlAssociacaoCampos) {
        super(pai, TITULO, xmlConfiguracao, xmlAssociacaoCampos);
        this.construirTela();
    }

    private void construirTela() {
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.setSize(new Dimension(270, 190));
        ScreenUtil.centralizar(this);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new TitledBorder("Importa\u00e7\u00e3o"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)ComponenteFactory.novoJLabel("ID Exame", 'E', null, this.textIdExame), c);
        c.gridy = 2;
        panel.add((Component)ComponenteFactory.novoJLabel("ID Material", 'M', null, this.textIdMaterial), c);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 1;
        panel.add((Component)this.textIdExame, c);
        c.gridy = 3;
        c.weighty = 1.0;
        panel.add((Component)this.textIdMaterial, c);
        panel.setSize(new Dimension(450, 150));
        this.setSize(new Dimension(350, 200));
        this.carregarDados();
    }

    private void carregarDados() {
        String conteudo;
        if (!Funcoes.textoVazio(this.xmlIntegracaoHospital) && !Funcoes.textoVazio(conteudo = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_EXPORTAR_SINCONECTA))) {
            String idExame = StringUtil.getValor(conteudo, TAG_ID_EXAME);
            String idMaterial = StringUtil.getValor(conteudo, TAG_ID_MATERIAL);
            this.textIdExame.setText(idExame);
            this.textIdMaterial.setText(idMaterial);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonOK) && this.camposValidos()) {
            this.construirXml();
            this.ok = true;
            this.dispose();
        }
        if (e.getSource().equals(this.buttonCancelar)) {
            this.textIdExame.clear();
            this.ok = false;
            this.dispose();
        }
    }

    private boolean camposValidos() {
        if (Funcoes.textoVazio(this.textIdExame)) {
            Funcoes.mensagem(this, "O ID do Exame no Hospital deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textIdExame);
            return false;
        }
        if (Funcoes.textoVazio(this.textIdMaterial)) {
            Funcoes.mensagem(this, "O ID do Material no Hospital deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textIdExame);
            return false;
        }
        return true;
    }

    private void construirXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXPORTAR_SINCONECTA);
        xml.escrever(TAG_ID_EXAME, this.textIdExame.getText());
        xml.escrever(TAG_ID_MATERIAL, this.textIdMaterial.getText());
        try {
            xml.fechar(TAG_EXPORTAR_SINCONECTA);
        }
        catch (XMLStringBuilderException xMLStringBuilderException) {
            // empty catch block
        }
        this.xmlIntegracaoHospital = xml.getXML().replaceAll("\n", "").replaceAll(" ", "");
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (!Funcoes.textoVazio(this.xmlIntegracaoHospital)) {
            return this.xmlIntegracaoHospital;
        }
        this.construirXml();
        return this.xmlIntegracaoHospital;
    }

    @Override
    public String getXmlAssociacaoCampos() {
        return null;
    }
}

