/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.sinconecta;

import jalis.integracaohospitais.util.AbstractConfiguradorConveniosIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.service.configuracao.UsuarioService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorConvenioSinconecta
extends AbstractConfiguradorConveniosIntegracaoHospital {
    public static final String TAG_LINK_CONSULTA = "webServiceCadastro";
    public static final String TAG_LINK_ENVIO_RESULTADO = "webServiceSADT";
    public static final String TAG_LOGIN = "login";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_AVISO_EXCLUSAO = "avisoExclusao";
    public static final String TAG_AVISO_INCLUSAO = "avisoInclusao";
    public static final String TAG_USUARIO_EXCLUSAO = "usuarioExclusao";
    public static final String TAG_USUARIO_INCLUSAO = "usuarioInclusao";
    public static final String USUARIO_RESPONSAVEL_SETOR = "Respons\u00e1vel do Setor";
    private static final String TITULO = "Configurando Integra\u00e7\u00e3o Sinconecta";
    private TTextField txtEstacao = new TTextField(10, 1);
    private JLabel lblEstacaoDescricao = new JLabel();
    private JLabel lblEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JButton btnPesquisa = new JButton();
    private JLabel lblLinkConsulta = new JLabel("Link Consulta:");
    private TTextField txtLinkConsulta = new TTextField();
    private JLabel lblLinkEnvioReultados = new JLabel("Link Env. Resultados:");
    private TTextField txtLinkEnvioResultados = new TTextField();
    private JLabel lblLogin = new JLabel("Login:");
    private TTextField txtLogin = new TTextField();
    private JLabel labelSenha = new JLabel("Senha:");
    private TTextField txtSenha = new TTextField();
    private JCheckBox checkPedidoExclusaoExames = new JCheckBox("Avisar pedidos de Exclus\u00e3o de exames");
    private JCheckBox checkPedidoInclusaoExames = new JCheckBox("Avisar pedidos de Inclus\u00e3o de exames");
    private JComboBox<String> comboExclusaoExames = new JComboBox();
    private JComboBox<String> comboInclusaoExames = new JComboBox();

    public static AbstractConfiguradorConveniosIntegracaoHospital novaInstancia(Object pai, String xmlIntegracaoHospital) {
        return pai instanceof Dialog ? new ConfiguradorConvenioSinconecta((Dialog)pai, xmlIntegracaoHospital) : new ConfiguradorConvenioSinconecta((Frame)pai, xmlIntegracaoHospital);
    }

    private ConfiguradorConvenioSinconecta(Dialog pai, String xmlIntegracaoHospital) {
        super(pai, TITULO, xmlIntegracaoHospital);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.construirTela();
    }

    private ConfiguradorConvenioSinconecta(Frame pai, String xmlIntegracaoHospital) {
        super(pai, TITULO, xmlIntegracaoHospital);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.construirTela();
    }

    private void construirTela() {
        Funcoes.imagemPesquisa(this.btnPesquisa);
        this.setUsuarioPodeCancelar(false);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        ScreenUtil.setBorda(new Component[]{this.lblEstacaoDescricao}, new TitledBorder(""));
        this.dimensionarComponenets();
        JPanel panelPrincipal = this.getPanelCentral();
        JPanel painelNorte = this.construirPainelNorte();
        JPanel painelSul = this.construirpainelSul();
        panelPrincipal.setLayout(new BorderLayout());
        panelPrincipal.add((Component)painelNorte, "North");
        panelPrincipal.add((Component)painelSul, "Center");
        Funcoes.montaEnter((JComponent)panelPrincipal);
        this.setSize(new Dimension(545, 255));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.txtEstacao);
        this.adicionarEventos();
        this.carregarDadosXml();
    }

    private void dimensionarComponenets() {
        Dimension tamanhoCaixaTexto = new Dimension(390, 20);
        Dimension tamanhoBotao = new Dimension(30, 20);
        Dimension tamanhoCaixaTextoMenor = new Dimension(70, 20);
        this.txtEstacao.setMinimumSize(tamanhoCaixaTextoMenor);
        this.txtEstacao.setPreferredSize(tamanhoCaixaTextoMenor);
        this.lblEstacaoDescricao.setMinimumSize(new Dimension(287, 20));
        this.lblEstacaoDescricao.setPreferredSize(new Dimension(287, 20));
        this.txtLinkConsulta.setMinimumSize(tamanhoCaixaTexto);
        this.txtLinkConsulta.setPreferredSize(tamanhoCaixaTexto);
        this.txtLinkEnvioResultados.setMinimumSize(tamanhoCaixaTexto);
        this.txtLinkEnvioResultados.setPreferredSize(tamanhoCaixaTexto);
        this.txtLogin.setMinimumSize(tamanhoCaixaTexto);
        this.txtLogin.setPreferredSize(tamanhoCaixaTexto);
        this.txtSenha.setMinimumSize(tamanhoCaixaTexto);
        this.txtSenha.setPreferredSize(tamanhoCaixaTexto);
        this.btnPesquisa.setMinimumSize(tamanhoBotao);
        this.btnPesquisa.setPreferredSize(tamanhoBotao);
    }

    private JPanel construirPainelNorte() {
        JPanel painelNorte = new JPanel();
        painelNorte.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 0, 0);
        this.lblEstacao.setDisplayedMnemonic('o');
        this.lblEstacao.setLabelFor(this.txtEstacao);
        painelNorte.add((Component)this.lblEstacao, c);
        ++c.gridx;
        painelNorte.add((Component)this.txtEstacao, c);
        ++c.gridx;
        painelNorte.add((Component)this.btnPesquisa, c);
        ++c.gridx;
        c.gridwidth = 1;
        painelNorte.add((Component)this.lblEstacaoDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        painelNorte.add((Component)this.lblLinkConsulta, c);
        ++c.gridx;
        c.gridwidth = 8;
        painelNorte.add((Component)this.txtLinkConsulta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        painelNorte.add((Component)this.lblLinkEnvioReultados, c);
        ++c.gridx;
        c.gridwidth = 8;
        painelNorte.add((Component)this.txtLinkEnvioResultados, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        painelNorte.add((Component)this.lblLogin, c);
        ++c.gridx;
        c.gridwidth = 8;
        painelNorte.add((Component)this.txtLogin, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        painelNorte.add((Component)this.labelSenha, c);
        ++c.gridx;
        c.gridwidth = 9;
        painelNorte.add((Component)this.txtSenha, c);
        return painelNorte;
    }

    private JPanel construirpainelSul() {
        JPanel painelSul = new JPanel();
        GridLayout layoutSul = new GridLayout(0, 2);
        layoutSul.setVgap(5);
        painelSul.setLayout(layoutSul);
        this.comboExclusaoExames.setEnabled(false);
        this.comboInclusaoExames.setEnabled(false);
        painelSul.setBorder(new TitledBorder("Avisos"));
        painelSul.add(this.checkPedidoExclusaoExames);
        painelSul.add(this.comboExclusaoExames);
        painelSul.add(this.checkPedidoInclusaoExames);
        painelSul.add(this.comboInclusaoExames);
        return painelSul;
    }

    private void adicionarEventos() {
        this.btnPesquisa.addActionListener(event -> this.pesquisarEstacao());
        this.txtEstacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ConfiguradorConvenioSinconecta.this.pesquisarEstacaoPorCodigo(ConfiguradorConvenioSinconecta.this.txtEstacao.getText());
            }
        });
        this.txtEstacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfiguradorConvenioSinconecta.this.pesquisarEstacao();
                }
            }
        });
        this.checkPedidoExclusaoExames.addActionListener(event -> {
            JCheckBox check = (JCheckBox)event.getSource();
            if (check.isSelected()) {
                this.preencherComboBox(this.comboExclusaoExames, "");
                this.comboExclusaoExames.setEnabled(true);
            } else {
                this.comboExclusaoExames.setEnabled(false);
            }
        });
        this.checkPedidoInclusaoExames.addActionListener(event -> {
            JCheckBox check = (JCheckBox)event.getSource();
            if (check.isSelected()) {
                this.preencherComboBox(this.comboInclusaoExames, "");
                this.comboInclusaoExames.setEnabled(true);
            } else {
                this.comboInclusaoExames.setEnabled(false);
            }
        });
    }

    private void preencherComboBox(JComboBox<String> combo, String itemSelecionado) {
        UsuarioService service = new UsuarioService();
        try {
            String sql = " where usr_inativo = false";
            ArrayList usuarios = new ArrayList(service.loadVO(sql));
            List<String> codigos = usuarios.stream().map(u -> u.getCodigo()).sorted().collect(Collectors.toList());
            combo.addItem(USUARIO_RESPONSAVEL_SETOR);
            codigos.forEach(combo::addItem);
            if (!Funcoes.textoVazio(itemSelecionado)) {
                combo.setSelectedItem(itemSelecionado);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Erro ao buscar usu\u00e1rios.", e.getStackTrace());
        }
    }

    private void carregarDadosXml() {
        if (!Funcoes.textoVazio(this.xmlIntegracaoHospital)) {
            String codigoEstacao = StringUtil.getValor(this.xmlIntegracaoHospital, "estacaoIntegradora");
            String linkConsulta = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_LINK_CONSULTA);
            String linkEnvioResultados = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_LINK_ENVIO_RESULTADO);
            String login = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_LOGIN);
            String senha = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_SENHA);
            String t = Boolean.TRUE.toString().toLowerCase();
            String avisoExclusaoExames = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_AVISO_EXCLUSAO);
            String usuarioExclusaoExames = avisoExclusaoExames.equals(t) ? StringUtil.getValor(this.xmlIntegracaoHospital, TAG_USUARIO_EXCLUSAO) : "";
            this.preencheValoresUsuarioExclusao(usuarioExclusaoExames);
            String avisoInclusaoExames = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_AVISO_INCLUSAO);
            String usuarioInclusaoExames = avisoInclusaoExames.equals(t) ? StringUtil.getValor(this.xmlIntegracaoHospital, TAG_USUARIO_INCLUSAO) : "";
            this.preencheValoresUsuarioInclusao(usuarioInclusaoExames);
            if (!Funcoes.textoVazio(codigoEstacao)) {
                this.pesquisarEstacaoPorCodigo(codigoEstacao);
            }
            this.txtLinkConsulta.setText(!Funcoes.textoVazio(linkConsulta) ? linkConsulta : "");
            this.txtLinkEnvioResultados.setText(!Funcoes.textoVazio(linkEnvioResultados) ? linkEnvioResultados : "");
            this.txtLogin.setText(!Funcoes.textoVazio(login) ? login : "");
            this.txtSenha.setText(!Funcoes.textoVazio(senha) ? senha : "");
        }
    }

    private void preencheValoresUsuarioInclusao(String usuarioInclusaoExames) {
        if (!Funcoes.textoVazio(usuarioInclusaoExames)) {
            this.checkPedidoInclusaoExames.setSelected(true);
            this.preencherComboBox(this.comboInclusaoExames, usuarioInclusaoExames);
            this.comboInclusaoExames.setEnabled(true);
        }
    }

    private void preencheValoresUsuarioExclusao(String usuarioExclusaoExames) {
        if (!Funcoes.textoVazio(usuarioExclusaoExames)) {
            this.checkPedidoExclusaoExames.setSelected(true);
            this.preencherComboBox(this.comboExclusaoExames, usuarioExclusaoExames);
            this.comboExclusaoExames.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK && this.camposPreenchidos()) {
            this.ok = true;
            this.dispose();
        }
        if (e.getSource() == this.btnPesquisa) {
            this.pesquisarEstacao();
        }
        if (e.getSource() == this.buttonCancelar) {
            this.dispose();
        }
    }

    private boolean camposPreenchidos() {
        if (Funcoes.textoVazio(this.txtEstacao.getText()) || this.lblEstacaoDescricao.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.txtLinkConsulta)) {
            Funcoes.mensagem(this, "O Link para consultar as Solicita\u00e7\u00f5es do Hospital deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtLinkConsulta);
            return false;
        }
        if (Funcoes.textoVazio(this.txtLinkEnvioResultados)) {
            Funcoes.mensagem(this, "O Link para envio dos Resultados dos Exames deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtLinkEnvioResultados);
            return false;
        }
        if (Funcoes.textoVazio(this.txtLogin)) {
            Funcoes.mensagem(this, "O Login de autentica\u00e7\u00e3o do Laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtLogin);
            return false;
        }
        if (Funcoes.textoVazio(this.txtSenha)) {
            Funcoes.mensagem(this, "A Senha de autentica\u00e7\u00e3o do Laborat\u00f3rio deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtSenha);
            return false;
        }
        return true;
    }

    private void pesquisarEstacaoPorCodigo(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.txtEstacao.clear();
            this.lblEstacaoDescricao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                this.lblEstacaoDescricao.setText(estacaoVO.getDescricao());
                ScreenUtil.requisitarFoco(this.txtLinkConsulta);
            } else {
                this.lblEstacaoDescricao.setText("N\u00e3o cadastrado");
                ScreenUtil.requisitarFoco(this.txtEstacao);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Erro ao buscar esta\u00e7\u00e3o.", e.getStackTrace());
            this.txtEstacao.clear();
            this.lblEstacaoDescricao.setText("");
            ScreenUtil.requisitarFoco(this.txtEstacao);
        }
    }

    private void pesquisarEstacao() {
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        this.txtEstacao.clear();
        this.lblEstacaoDescricao.setText("");
        if (estacaoVO != null) {
            this.txtEstacao.setText(estacaoVO.getCodigo().toString());
            this.lblEstacaoDescricao.setText(estacaoVO.getDescricao());
        }
    }

    @Override
    public String getXmlIntegracaoHospital() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("xmlconveniohospital");
        xml.escrever("protocolo", ProtocoloIntegracaoHospital.SINCONECTA.getNome());
        xml.escrever("estacaoIntegradora", this.txtEstacao.getText());
        xml.escrever(TAG_LINK_CONSULTA, this.txtLinkConsulta.getText());
        xml.escrever(TAG_LINK_ENVIO_RESULTADO, this.txtLinkEnvioResultados.getText());
        xml.escrever(TAG_LOGIN, this.txtLogin.getText());
        xml.escrever(TAG_SENHA, this.txtSenha.getText());
        String t = Boolean.TRUE.toString().toLowerCase();
        String f = Boolean.FALSE.toString().toLowerCase();
        String avisoExclusao = this.checkPedidoExclusaoExames.isSelected() ? t : f;
        xml.escrever(TAG_AVISO_EXCLUSAO, avisoExclusao);
        String usuarioExclusao = avisoExclusao.equals(t) ? (String)this.comboExclusaoExames.getSelectedItem() : "";
        xml.escrever(TAG_USUARIO_EXCLUSAO, usuarioExclusao);
        String avisoInclusao = this.checkPedidoInclusaoExames.isSelected() ? t : f;
        xml.escrever(TAG_AVISO_INCLUSAO, avisoInclusao);
        String usuarioInclusao = avisoInclusao.equals(t) ? (String)this.comboInclusaoExames.getSelectedItem() : "";
        xml.escrever(TAG_USUARIO_INCLUSAO, usuarioInclusao);
        try {
            xml.fechar("xmlconveniohospital");
        }
        catch (XMLStringBuilderException xMLStringBuilderException) {
            // empty catch block
        }
        return xml.getXML().replaceAll("\n", "").replaceAll(" ", "");
    }
}

