/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.sigh;

import jalis.comum.ParametrosLocais;
import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalCliente;
import jalis.integracaohospitais.util.AbstractConfiguradorExamesIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ConfiguradorExamesSigh
extends AbstractConfiguradorExamesIntegracaoHospital {
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_DESCRICAO = 1;
    private static final int COLUNA_SELECAO = 2;
    public static final String TAG_EXAME_CODIGO_EXAME_DE_PARA_ANTIGO = "Codigo";
    private ModeloGridTable modelExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Sel."}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }
    };
    private JTable tableExames = null;
    private JScrollPane scrollExames = null;
    private TTextField textLocalizar = new TTextField(15, 3);
    private TTextField textExameSelecionado = new TTextField(15, 1);
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private JLabel labelExameSelecionado = new JLabel("Exame Selecionado:");
    private boolean dadosCarregados = false;
    private boolean flagAlteracao = false;

    public static ConfiguradorExamesSigh novaInstancia(Window pai, String xmlIntegracaoHospital) {
        if (pai instanceof Frame) {
            return new ConfiguradorExamesSigh((Frame)pai, xmlIntegracaoHospital);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorExamesSigh((Dialog)pai, xmlIntegracaoHospital);
        }
        return null;
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (this.getCodigoExameSelecionado() != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append("xmlexamehospital").append(">");
            buf.append("<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.SIGH.getNome()).append("</").append("protocolo").append(">");
            buf.append("<").append("codExame").append(">").append(this.getCodigoExameSelecionado()).append("</").append("codExame").append(">");
            buf.append("</").append("xmlexamehospital").append(">");
            return buf.toString();
        }
        return null;
    }

    public ConfiguradorExamesSigh(Frame pai, String xmlIntegracaoHospital) {
        super(pai, "Configura\u00e7\u00e3o para exames do Sigh", xmlIntegracaoHospital, null);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.montaTela();
    }

    public ConfiguradorExamesSigh(Dialog pai, String xmlIntegracaoHospital) {
        super(pai, "Configura\u00e7\u00e3o para exames do Sigh", xmlIntegracaoHospital, null);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.montaTela();
    }

    private void montaTela() {
        this.dadosCarregados = false;
        JPanel painelCentral = this.getPanelCentral();
        this.tableExames = new JTable(this.modelExames);
        this.scrollExames = new JScrollPane(this.tableExames);
        this.modelExames.setColumnSize(new int[]{60, 0, 25}, this.tableExames);
        this.tableExames.getTableHeader().addMouseListener(this.modelExames);
        this.textExameSelecionado.setMinimumSize(new Dimension(70, 20));
        this.textExameSelecionado.setPreferredSize(new Dimension(70, 20));
        this.textLocalizar.setMinimumSize(new Dimension(150, 20));
        this.textLocalizar.setPreferredSize(new Dimension(150, 200));
        this.carregarExames();
        if (this.xmlIntegracaoHospital != null) {
            String aux = StringUtil.getValor(this.xmlIntegracaoHospital, "xmlexamehospital");
            String codigo = StringUtil.getValor(aux, "codExame");
            if (Funcoes.textoVazio(codigo)) {
                codigo = StringUtil.getValor(aux, TAG_EXAME_CODIGO_EXAME_DE_PARA_ANTIGO);
            }
            if (!Funcoes.textoVazio(codigo)) {
                this.textExameSelecionado.setText(codigo);
            }
        }
        painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(5, 0, 0, 0);
        painelCentral.add((Component)this.labelLocalizar, c);
        ++c.gridx;
        c.gridwidth = 2;
        painelCentral.add((Component)this.textLocalizar, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 5;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        painelCentral.add((Component)this.scrollExames, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        painelCentral.add((Component)this.labelExameSelecionado, c);
        c.gridx += 2;
        c.gridwidth = 1;
        painelCentral.add((Component)this.textExameSelecionado, c);
        this.setResizable(false);
        if (this.dadosCarregados) {
            this.modelExames.ordenarColunaSemTrocarSentido(1);
            this.selecionarExame(this.xmlIntegracaoHospital);
            this.textExameSelecionado.setEnabled(false);
            ScreenUtil.requisitarFoco(this.textLocalizar);
            this.setSize(new Dimension(500, 315));
        } else {
            ++c.gridx;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 2;
            painelCentral.add((Component)new JLabel(), c);
            this.setTitle("Exame do Sigh");
            this.labelExameSelecionado.setText("C\u00f3digo do Exame:");
            ScreenUtil.requisitarFoco(this.textExameSelecionado);
            this.textExameSelecionado.setEnabled(true);
            this.labelLocalizar.setVisible(false);
            this.textLocalizar.setVisible(false);
            this.scrollExames.setVisible(false);
            this.setSize(new Dimension(200, 100));
        }
        ScreenUtil.centralizar(this);
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int pos = ConfiguradorExamesSigh.this.modelExames.localizarParcial(ConfiguradorExamesSigh.this.modelExames.getColunaOrdenacao(), ConfiguradorExamesSigh.this.textLocalizar.getText() + (Funcoes.textoVazio(String.valueOf(e.getKeyChar())) ? "" : String.valueOf(e.getKeyChar())));
                if (pos > -1) {
                    ConfiguradorExamesSigh.this.tableExames.setRowSelectionInterval(pos, pos);
                    ConfiguradorExamesSigh.this.tableExames.scrollRectToVisible(ConfiguradorExamesSigh.this.tableExames.getCellRect(pos, 0, true));
                }
            }
        });
        this.modelExames.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row;
                if (ConfiguradorExamesSigh.this.flagAlteracao) {
                    return;
                }
                if (e.getColumn() == 2 && (row = ConfiguradorExamesSigh.this.tableExames.getSelectedRow()) >= 0) {
                    boolean valor = (Boolean)ConfiguradorExamesSigh.this.modelExames.getValueAt(row, 2);
                    if (valor) {
                        ConfiguradorExamesSigh.this.textExameSelecionado.setText(ConfiguradorExamesSigh.this.modelExames.getValueAt(row, 0).toString());
                        for (int i = 0; i < ConfiguradorExamesSigh.this.modelExames.getRowCount(); ++i) {
                            if (i == row) continue;
                            ConfiguradorExamesSigh.this.flagAlteracao = true;
                            ConfiguradorExamesSigh.this.modelExames.setValueAt(false, i, 2);
                            ConfiguradorExamesSigh.this.flagAlteracao = false;
                        }
                    } else {
                        ConfiguradorExamesSigh.this.textExameSelecionado.clear();
                    }
                }
            }
        });
    }

    public Integer getCodigoExameSelecionado() {
        String valor = this.textExameSelecionado.getText();
        if (!Funcoes.textoVazio(valor)) {
            return Integer.parseInt(valor);
        }
        return null;
    }

    @Override
    public boolean acaoOk() {
        return true;
    }

    public void selecionarExame(String xml) {
        if (xml == null || Funcoes.textoVazio(xml)) {
            return;
        }
        String auxXml = StringUtil.getValor(xml, "xmlexamehospital");
        String codigo = StringUtil.getValor(auxXml, "codExame");
        if (Funcoes.textoVazio(codigo)) {
            codigo = StringUtil.getValor(auxXml, TAG_EXAME_CODIGO_EXAME_DE_PARA_ANTIGO);
        }
        if (Funcoes.textoVazio(codigo)) {
            return;
        }
        Integer codigoExame = Integer.parseInt(codigo);
        if (codigoExame != null) {
            for (int i = 0; i < this.modelExames.getRowCount(); ++i) {
                int aux = (Integer)this.modelExames.getValueAt(i, 0);
                if (codigoExame != aux) continue;
                this.tableExames.scrollRectToVisible(this.tableExames.getCellRect(i, 0, true));
                this.tableExames.getSelectionModel().setSelectionInterval(i, i);
                this.tableExames.setValueAt(true, i, 2);
                break;
            }
        }
    }

    private void carregarExames() {
        try {
            if (ParametrosLocais.getParametro("buscarDadosBaseHospital") != null && Integer.parseInt(ParametrosLocais.getParametro("buscarDadosBaseHospital")) == 1) {
                if (!ConexaoIntegracaoHospitalCliente.configuraConexao()) {
                    return;
                }
            } else {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select codigo_procedimento ");
            buf.append("       ,descr_proc ");
            buf.append("   from sigh.procedimentos ");
            buf.append("  order by descr_proc ");
            ResultSet rs = ConexaoIntegracaoHospitalCliente.executeQuery(ConexaoIntegracaoHospitalCliente.getStatement(), buf);
            while (rs.next()) {
                this.modelExames.addLine(new Object[]{rs.getInt("codigo_procedimento"), rs.getString("descr_proc"), false});
            }
            this.dadosCarregados = true;
        }
        catch (SQLException sqle) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a lista de exames dispon\u00edveis.", 2);
            return;
        }
        finally {
            ConexaoIntegracaoHospitalCliente.shutdown();
        }
    }

    @Override
    public String getXmlAssociacaoCampos() {
        return null;
    }
}

