/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.sigh;

import jalis.comum.ParametrosLocais;
import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalCliente;
import jalis.integracaohospitais.util.AbstractConfiguradorConveniosIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;

public class ConfiguradorConveniosSigh
extends AbstractConfiguradorConveniosIntegracaoHospital {
    private static final int COLUNA_CODIGO_CONVENIO = 0;
    private static final int COLUNA_DESCRICAO_CONVENIO = 1;
    private static final int COLUNA_CODIGO_CATEGORIA = 2;
    private static final int COLUNA_DESCRICAO_CATEGORIA = 3;
    private static final int COLUNA_SELECAO = 4;
    public static final String TAG_CONVENIO_SIGH_CATEGORIA = "categoria";
    public static final String TAG_CONVENIO_SALA_ATENDIMENTO = "salaDeAtendimento";
    public static final String TAG_CONVENIO_SITUACAO_ATENDIMETO = "situacaoAtendimento";
    public static final String TAG_CONVENIO_SIGH_AMBULATORIAL = "ambulatorial";
    public static final String TAG_CONVENIO_SIGH_COBRANCA = "cobranca";
    private Integer codigoCategoria;
    private Integer codigoConvenio;
    private Integer salaAtendimento;
    private Integer situacaoAtendimento;
    private boolean ambulatorial;
    private boolean cobranca;
    private ModeloGridTable modelConvenios = new ModeloGridTable(new String[]{"C\u00f3d.", "Fantasia Conv\u00eanio", "C\u00f3d.", "Categoria", "Sel."}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object o = e.getSource();
            if (o instanceof JTableHeader) {
                JTableHeader header = (JTableHeader)o;
                int col = header.getColumnModel().getColumnIndexAtX(e.getX());
                Rectangle rec = header.getHeaderRect(col);
                if (col == 0) {
                    rec.width -= 3;
                } else {
                    rec.grow(-3, 0);
                }
                if (rec.contains(e.getPoint())) {
                    if (col == 0 || col == 1) {
                        this.ordenarColunaAvancado(col, 3);
                    } else {
                        this.ordenarColuna(col);
                    }
                }
            }
        }
    };
    private JTable tableConvenios = null;
    private JScrollPane scrollConvenios = null;
    private TTextField textLocalizar = new TTextField(6, 3);
    private TTextField textConvenioSelecionado = new TTextField(6, 1);
    private TTextField textCategoriaSelecionada = new TTextField(6, 1);
    private TTextField textSalaAtendimento = new TTextField(6, 1);
    private TTextField textSituacaoAtentimento = new TTextField(6, 1);
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private JLabel labelConvenioSelecionado = new JLabel("Conv\u00eanio Selecionado:");
    private JLabel labelCategoriaSelecionada = new JLabel("Categoria Selecionada:");
    private JLabel labelSalaAtendimento = new JLabel("Sala Atendimento:");
    private JLabel labelSituacaoAtentimento = new JLabel("Situa\u00e7\u00e3o Atendimento:");
    private JCheckBox checkAmbulatorial = new JCheckBox("Gerar fia externa para atendimentos ambulatoriais");
    private JCheckBox checkCobrancaContaPaciente = new JCheckBox("N\u00e3o gerar cobran\u00e7a na conta do paciente");
    private boolean dadosCarregados = false;
    private boolean flagAlteracao = false;

    public static ConfiguradorConveniosSigh novaInstancia(Object pai, String xmlIntegracaoHospital) {
        if (pai instanceof Frame) {
            return new ConfiguradorConveniosSigh((Frame)pai, xmlIntegracaoHospital);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorConveniosSigh((Dialog)pai, xmlIntegracaoHospital);
        }
        return null;
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (this.getCodigoConvenioSelecionado() != null && this.getCodigoCategoriaSelecionada() != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append("xmlconveniohospital").append(">");
            buf.append("<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.SIGH.getNome()).append("</").append("protocolo").append(">");
            buf.append("<").append("codigo").append(">").append(this.getCodigoConvenioSelecionado()).append("</").append("codigo").append(">");
            buf.append("<").append(TAG_CONVENIO_SIGH_CATEGORIA).append(">").append(this.getCodigoCategoriaSelecionada()).append("</").append(TAG_CONVENIO_SIGH_CATEGORIA).append(">");
            buf.append("<").append(TAG_CONVENIO_SIGH_AMBULATORIAL).append(">").append(this.getAmbulatorial()).append("</").append(TAG_CONVENIO_SIGH_AMBULATORIAL).append(">");
            buf.append("<").append(TAG_CONVENIO_SALA_ATENDIMENTO).append(">").append(this.getSalaAtendimento()).append("</").append(TAG_CONVENIO_SALA_ATENDIMENTO).append(">");
            buf.append("<").append(TAG_CONVENIO_SITUACAO_ATENDIMETO).append(">").append(this.getSituacaoAtendimento()).append("</").append(TAG_CONVENIO_SITUACAO_ATENDIMETO).append(">");
            buf.append("<").append(TAG_CONVENIO_SIGH_COBRANCA).append(">").append(this.getCobranca()).append("</").append(TAG_CONVENIO_SIGH_COBRANCA).append(">");
            buf.append("</").append("xmlconveniohospital").append(">");
            return buf.toString();
        }
        return null;
    }

    public ConfiguradorConveniosSigh(Frame pai, String xmlIntegracaoHospital) {
        super(pai, "Configura\u00e7\u00e3o conv\u00eanios do Sigh", xmlIntegracaoHospital);
        if (!Funcoes.textoVazio(xmlIntegracaoHospital)) {
            String protocolo = StringUtil.getValor(xmlIntegracaoHospital, "protocolo");
            this.xmlIntegracaoHospital = !Funcoes.textoVazio(protocolo) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.SIGH.getNome()) ? xmlIntegracaoHospital : null;
        }
        this.montaTela();
    }

    public ConfiguradorConveniosSigh(Dialog pai, String xmlIntegracaoHospital) {
        super(pai, "Configura\u00e7\u00e3o conv\u00eanios do Sigh", xmlIntegracaoHospital);
        if (!Funcoes.textoVazio(xmlIntegracaoHospital)) {
            String protocolo = StringUtil.getValor(xmlIntegracaoHospital, "protocolo");
            this.xmlIntegracaoHospital = !Funcoes.textoVazio(protocolo) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.SIGH.getNome()) ? xmlIntegracaoHospital : null;
        }
        this.montaTela();
    }

    private void montaTela() {
        this.dadosCarregados = false;
        JPanel painelCentral = this.getPanelCentral();
        this.tableConvenios = new JTable(this.modelConvenios);
        this.scrollConvenios = new JScrollPane(this.tableConvenios);
        this.modelConvenios.setColumnSize(new int[]{55, 0, 55, 0, 25}, this.tableConvenios);
        this.tableConvenios.getTableHeader().addMouseListener(this.modelConvenios);
        this.textConvenioSelecionado.setMinimumSize(new Dimension(70, 20));
        this.textConvenioSelecionado.setPreferredSize(new Dimension(70, 20));
        this.textCategoriaSelecionada.setMinimumSize(new Dimension(70, 20));
        this.textCategoriaSelecionada.setPreferredSize(new Dimension(70, 20));
        this.textSalaAtendimento.setMinimumSize(new Dimension(70, 20));
        this.textSalaAtendimento.setPreferredSize(new Dimension(70, 20));
        this.textSituacaoAtentimento.setMinimumSize(new Dimension(70, 20));
        this.textSituacaoAtentimento.setPreferredSize(new Dimension(70, 20));
        this.textLocalizar.setMinimumSize(new Dimension(150, 20));
        this.textLocalizar.setPreferredSize(new Dimension(150, 200));
        this.carregarConvenios();
        if (this.xmlIntegracaoHospital != null) {
            String aux = StringUtil.getValor(this.xmlIntegracaoHospital, "xmlconveniohospital");
            this.textConvenioSelecionado.setText(StringUtil.getValor(aux, "codigo"));
            this.textCategoriaSelecionada.setText(StringUtil.getValor(aux, TAG_CONVENIO_SIGH_CATEGORIA));
            this.textSalaAtendimento.setText(StringUtil.getValor(aux, TAG_CONVENIO_SALA_ATENDIMENTO));
            this.textSituacaoAtentimento.setText(StringUtil.getValor(aux, TAG_CONVENIO_SITUACAO_ATENDIMETO));
            this.checkAmbulatorial.setSelected(StringUtil.getValor(aux, TAG_CONVENIO_SIGH_AMBULATORIAL).equalsIgnoreCase("true"));
            this.checkCobrancaContaPaciente.setSelected(StringUtil.getValor(aux, TAG_CONVENIO_SIGH_COBRANCA).equalsIgnoreCase("true"));
        }
        GridBagConstraints c = new GridBagConstraints();
        JPanel panelLocalizar = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 1);
        panelLocalizar.add((Component)this.labelLocalizar, c);
        ++c.gridx;
        panelLocalizar.add((Component)this.textLocalizar, c);
        JPanel panelSelecionados = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panelSelecionados.add((Component)this.labelConvenioSelecionado, c);
        ++c.gridx;
        panelSelecionados.add((Component)this.textConvenioSelecionado, c);
        ++c.gridx;
        c.insets = new Insets(1, 14, 0, 1);
        panelSelecionados.add((Component)this.labelCategoriaSelecionada, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 0, 0);
        panelSelecionados.add((Component)this.textCategoriaSelecionada, c);
        JPanel panelSighVersao3 = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        panelSighVersao3.add((Component)this.labelSalaAtendimento, c);
        ++c.gridx;
        c.insets = new Insets(0, this.dadosCarregados ? 23 : 16, 0, 0);
        panelSighVersao3.add((Component)this.textSalaAtendimento, c);
        ++c.gridx;
        c.insets = new Insets(0, this.dadosCarregados ? 20 : 15, 0, 0);
        panelSighVersao3.add((Component)this.labelSituacaoAtentimento, c);
        ++c.gridx;
        c.insets = new Insets(0, this.dadosCarregados ? 0 : 31, 0, 0);
        panelSighVersao3.add((Component)this.textSituacaoAtentimento, c);
        panelSighVersao3.setBorder(new TitledBorder("Vers\u00e3o 3"));
        c.insets = new Insets(0, 0, 0, 0);
        painelCentral.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        painelCentral.add((Component)panelLocalizar, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        painelCentral.add((Component)this.scrollConvenios, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        painelCentral.add((Component)panelSelecionados, c);
        ++c.gridy;
        painelCentral.add((Component)panelSighVersao3, c);
        ++c.gridy;
        painelCentral.add((Component)this.checkAmbulatorial, c);
        ++c.gridy;
        painelCentral.add((Component)this.checkCobrancaContaPaciente, c);
        this.setResizable(false);
        if (this.dadosCarregados) {
            this.modelConvenios.ordenarColunaSemTrocarSentido(1);
            this.selecionarConvenio(this.xmlIntegracaoHospital);
            this.textConvenioSelecionado.setEnabled(false);
            this.textCategoriaSelecionada.setEnabled(false);
            this.textSalaAtendimento.setEnabled(false);
            this.textSituacaoAtentimento.setEnabled(false);
            ScreenUtil.requisitarFoco(this.textLocalizar);
            this.setSize(new Dimension(600, 350));
        } else {
            ++c.gridx;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 2;
            painelCentral.add((Component)new JLabel(), c);
            this.setTitle("Conv\u00eanio do Sigh");
            this.labelConvenioSelecionado.setText("C\u00f3d. Conv\u00eanio:");
            this.labelCategoriaSelecionada.setText("C\u00f3d. Categoria:");
            this.labelSalaAtendimento.setText("Sala Atend.:");
            this.labelSituacaoAtentimento.setText("Sit. Atend.:");
            ScreenUtil.requisitarFoco(this.textConvenioSelecionado);
            if (this.xmlIntegracaoHospital != null && !Funcoes.textoVazio(this.xmlIntegracaoHospital)) {
                String auxXml = StringUtil.getValor(this.xmlIntegracaoHospital, "xmlconveniohospital");
                this.textConvenioSelecionado.setText(StringUtil.getValor(auxXml, "codigo"));
                this.textCategoriaSelecionada.setText(StringUtil.getValor(auxXml, TAG_CONVENIO_SIGH_CATEGORIA));
                this.textSalaAtendimento.setText(StringUtil.getValor(auxXml, TAG_CONVENIO_SALA_ATENDIMENTO));
                this.textSituacaoAtentimento.setText(StringUtil.getValor(auxXml, TAG_CONVENIO_SITUACAO_ATENDIMETO));
            }
            this.textConvenioSelecionado.setEnabled(true);
            this.textCategoriaSelecionada.setEnabled(true);
            this.textSalaAtendimento.setEnabled(true);
            this.textSituacaoAtentimento.setEnabled(true);
            panelLocalizar.setVisible(false);
            this.labelLocalizar.setVisible(false);
            this.textLocalizar.setVisible(false);
            this.scrollConvenios.setVisible(false);
            this.setSize(new Dimension(370, 200));
        }
        ScreenUtil.centralizar(this);
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int pos = ConfiguradorConveniosSigh.this.modelConvenios.localizarParcial(ConfiguradorConveniosSigh.this.modelConvenios.getColunaOrdenacao(), ConfiguradorConveniosSigh.this.textLocalizar.getText() + (Funcoes.textoVazio(String.valueOf(e.getKeyChar())) ? "" : String.valueOf(e.getKeyChar())));
                if (pos > -1) {
                    ConfiguradorConveniosSigh.this.tableConvenios.setRowSelectionInterval(pos, pos);
                    ConfiguradorConveniosSigh.this.tableConvenios.scrollRectToVisible(ConfiguradorConveniosSigh.this.tableConvenios.getCellRect(pos, 0, true));
                }
            }
        });
        this.modelConvenios.addTableModelListener(e -> {
            if (this.flagAlteracao) {
                return;
            }
            if (e.getColumn() == 4) {
                boolean valor;
                int row = this.tableConvenios.getSelectedRow();
                this.textConvenioSelecionado.setText(this.modelConvenios.getValueAt(row, 0).toString());
                this.textCategoriaSelecionada.setText(this.modelConvenios.getValueAt(row, 2).toString());
                if (row >= 0 && (valor = ((Boolean)this.modelConvenios.getValueAt(row, 4)).booleanValue())) {
                    for (int i = 0; i < this.modelConvenios.getRowCount(); ++i) {
                        if (i == row) continue;
                        this.flagAlteracao = true;
                        this.modelConvenios.setValueAt(false, i, 4);
                        this.flagAlteracao = false;
                    }
                }
            }
        });
    }

    private Integer getCodigoConvenioSelecionado() {
        String valor = this.textConvenioSelecionado.getText();
        if (!Funcoes.textoVazio(valor)) {
            this.codigoConvenio = Integer.parseInt(valor);
            return this.codigoConvenio;
        }
        return null;
    }

    private Integer getCodigoCategoriaSelecionada() {
        String valor = this.textCategoriaSelecionada.getText();
        if (!Funcoes.textoVazio(valor)) {
            this.codigoCategoria = Integer.parseInt(valor);
            return this.codigoCategoria;
        }
        return null;
    }

    @Override
    public boolean acaoOk() {
        Integer codigoConvenioSelecionado = this.getCodigoConvenioSelecionado();
        Integer codigoCategoriaSelecionado = this.getCodigoCategoriaSelecionada();
        this.salaAtendimento = !Funcoes.textoVazio(this.textSalaAtendimento.getText()) ? Integer.valueOf(Integer.parseInt(this.textSalaAtendimento.getText())) : null;
        this.situacaoAtendimento = !Funcoes.textoVazio(this.textSituacaoAtentimento.getText()) ? Integer.valueOf(Integer.parseInt(this.textSituacaoAtentimento.getText())) : null;
        this.ambulatorial = this.checkAmbulatorial.isSelected();
        this.cobranca = this.checkCobrancaContaPaciente.isSelected();
        if (codigoConvenioSelecionado == null && codigoCategoriaSelecionado != null) {
            Funcoes.mensagem(this, "Nenhum conv\u00eanio foi selecionado.", 1);
            return false;
        }
        if (codigoCategoriaSelecionado == null && codigoConvenioSelecionado != null) {
            Funcoes.mensagem(this, "Nenhuma categoria foi selecionada.", 1);
            return false;
        }
        return true;
    }

    public void selecionarConvenio(String xml) {
        if (xml == null || Funcoes.textoVazio(xml)) {
            return;
        }
        String auxXml = StringUtil.getValor(xml, "xmlconveniohospital");
        String codigoConvenioAux = StringUtil.getValor(auxXml, "codigo");
        String codigoCategoriaAux = StringUtil.getValor(auxXml, TAG_CONVENIO_SIGH_CATEGORIA);
        if (codigoConvenioAux == null || Funcoes.textoVazio(codigoConvenioAux) || codigoCategoriaAux == null || Funcoes.textoVazio(codigoCategoriaAux)) {
            return;
        }
        Integer codigoConvenioModel = Integer.parseInt(codigoConvenioAux);
        Integer codigoCategoriaModel = Integer.parseInt(codigoCategoriaAux);
        if (codigoConvenioModel != null && codigoCategoriaModel != null) {
            for (int i = 0; i < this.modelConvenios.getRowCount(); ++i) {
                int auxConv = (Integer)this.modelConvenios.getValueAt(i, 0);
                int auxCat = (Integer)this.modelConvenios.getValueAt(i, 2);
                if (codigoConvenioModel != auxConv || codigoCategoriaModel != auxCat) continue;
                this.tableConvenios.scrollRectToVisible(this.tableConvenios.getCellRect(i, 0, true));
                this.tableConvenios.getSelectionModel().setSelectionInterval(i, i);
                this.tableConvenios.setValueAt(true, i, 4);
                break;
            }
        }
    }

    private void carregarConvenios() {
        try {
            if (ParametrosLocais.getParametro("buscarDadosBaseHospital") != null && Integer.parseInt(ParametrosLocais.getParametro("buscarDadosBaseHospital")) == 1) {
                if (!ConexaoIntegracaoHospitalCliente.configuraConexao()) {
                    return;
                }
            } else {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select codigo_conv ");
            buf.append("       ,nm_fantasia ");
            buf.append("       ,codigo_categoria ");
            buf.append("       ,nm_categoria ");
            buf.append("   from sigh.v_cons_convenios_categorias_laboratorios ");
            buf.append("  order by nm_fantasia ");
            ResultSet rs = ConexaoIntegracaoHospitalCliente.executeQuery(ConexaoIntegracaoHospitalCliente.getStatement(), buf);
            while (rs.next()) {
                this.modelConvenios.addLine(new Object[]{rs.getInt("codigo_conv"), rs.getString("nm_fantasia"), rs.getInt("codigo_categoria"), rs.getString("nm_categoria"), false});
            }
            this.dadosCarregados = true;
        }
        catch (SQLException sqle) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a lista de conv\u00eanio e categorias dispon\u00edveis.", 2);
            return;
        }
        finally {
            ConexaoIntegracaoHospitalCliente.shutdown();
        }
    }

    public Integer getCodigoConvenio() {
        return this.codigoConvenio;
    }

    public Integer getCodigoCategoria() {
        return this.codigoCategoria;
    }

    public boolean getAmbulatorial() {
        return this.ambulatorial;
    }

    public boolean getCobranca() {
        return this.cobranca;
    }

    public Integer getSalaAtendimento() {
        return this.salaAtendimento;
    }

    public Integer getSituacaoAtendimento() {
        return this.situacaoAtendimento;
    }
}

