/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.salux.service;

import br.com.salux.www.services.ICadastroProxy;
import br.com.salux.www.services.ISADTProxy;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.DadosMaterialUtilizado;
import jalis.integracaohospitais.sistemas.salux.IntegracaoHospitalSalux;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.salux.ConfiguradorExamesSalux;
import jalis.integracaohospitais.util.salux.dao.SaluxDao;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.BairroVO;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.auxiliares.BairroService;
import jalis.service.cadastro.auxiliares.CidadeService;
import jalis.util.ConvenioUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sxservices.web.salux.Documento;
import sxservices.web.salux.Endereco;
import sxservices.web.salux.Laudo;
import sxservices.web.salux.Paciente;
import sxservices.web.salux.Profissional;
import sxservices.web.salux.SolicitacaoExame;
import sxservices.web.salux.SolicitacaoExameItem;
import sxservices.web.salux.Telefone;
import sxservices.web.salux.TpDocumento;
import sxservices.web.salux.TpFormatoLaudo;
import sxservices.web.salux.TpSituacaoLaudo;
import sxservices.web.salux.WsUsuario;

public class SaluxService {
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private final SaluxDao dao = new SaluxDao();
    private Integer codigoRequisicao;
    private XMLStringBuilder xmlErro;
    private IntegracaoHospitalSalux integracaoHospitalSalux;
    private static final String HINT_EXECUTANDO = "INTEGRANDO DADOS";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_LOGIN = "autentica\u00e7\u00e3o no sistema salux";
    private static final String PROCESSO_INSERIRPACIENTE = "inserindo paciente";
    private static final String PROCESSO_INSERIRPROFISSIONAL = "inserindo profissional";
    private static final String PROCESSO_INSERIRREQUISICAO = "inserindo requisi\u00e7\u00e3o";
    private static final String PROCESSO_INSERIREXAMEREQUISICAO = "inserindo EXAME";
    private static final String PROCESSO_ENVIAR_LAUDO = "enviando laudo";
    private static final String PROCESSO_ATUALIZAR_SITUACAO_LAUDO = "atualizando situacao laudo";
    private static final String TAG_INTEGRACAOHOSPITAL = "IntegracaoHospital";
    private static final String TAG_IDSOLICITACAO = "idSolicitacao";
    private static final String TAG_IDPROCEDIMENTO = "idProcedimento";
    private static final String TAG_SEQUENCIAL = "sequencial";
    private static final String TAG_FILIAL = "filial";
    private static final String TAG_CODREQ = "codReq";
    private static final String TAG_RETORNO = "retorno";
    private static final String TAG_CODEXA = "codExa";
    private static final String TAG_CODMAT = "codMat";
    private static final String TAG_XML_SALUX = "xmlSalux";
    private static final String TAG_PROTOCOLO = "protocolo";
    private static final String SITUACAO_ERROCONVENIO = "C";
    private static final String SITUACAO_ERROEXAME = "E";
    public static final String TAG_NOMEINTEGRACAOHOSPITAL = "NomeIntegracaoHospital";
    public static final String TIPO_OPERACAO_SALUX_COLETA_EXAME = "M";
    public static final String STATUS_INTEGRACAO_PENDENTE = "P";
    public static final String STATUS_INTEGRACAO_ENVIADO = "I";
    public static final String STATUS_INTEGRACAO_ERRO = "E";
    public static final String SITUACAO_EXAME_SALUX = "LA";
    public static final String RESULTADO_PRIMEIRA_CONFERENCIA = "L";
    public static final String RESULTADO_RETIFICADO = "A";

    public SaluxService() {
    }

    public SaluxService(IntegracaoHospitalSalux integracaoHospitalSalux) {
        this.integracaoHospitalSalux = integracaoHospitalSalux;
        this.xmlErro = new XMLStringBuilder();
    }

    public ExameRequisicaoVO getExames(String convenio, SolicitacaoExameItem solicitacaoExameItem) throws Exception {
        ExameRequisicaoVO exameRequisicaoVO = new ExameRequisicaoVO();
        String filial = Variaveis.filialPadrao;
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(ConfiguradorExamesSalux.TAG_EXPORTACAOSALUX);
        xml.abrir(ConfiguradorExamesSalux.TAG_IDEXAME);
        xml.escrever(String.valueOf(solicitacaoExameItem.getIdProcedimento()));
        xml.fechar(ConfiguradorExamesSalux.TAG_IDEXAME);
        xml.abrir(ConfiguradorExamesSalux.TAG_IDMATERIAL);
        xml.escrever(solicitacaoExameItem.getIdMaterialColeta().toString());
        xml.fechar(ConfiguradorExamesSalux.TAG_IDMATERIAL);
        xml.fechar(ConfiguradorExamesSalux.TAG_EXPORTACAOSALUX);
        ArrayList<Registro> listaExames = this.dao.pesquisarExames(filial, xml.toString());
        Statement st = Conexao.getStatement();
        DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, Integer.valueOf(convenio), st);
        for (Registro registro : listaExames) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.valueOf(filial));
            exameRequisicaoVO.setFilial(filialVO);
            ExameVO exame = new ExameVO();
            exame.setCodigo(registro.getString("codigoexame"));
            MaterialColetaVO material = new MaterialColetaVO();
            material.setCodigo(registro.getInt("codigomaterial"));
            exameRequisicaoVO.setExame(exame);
            exameRequisicaoVO.setMaterial(material);
            DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(filial, material.getCodigo(), st);
            DadosExames dadosExame = ExameUtil.getDadosExame(filial, exame.getCodigo(), dadosMaterial, Conexao.getStatement());
            ExameUtil.calculaPrecoExame(filial, dadosExame, dadosMaterial, dadosConvenio, false, true, false, null, null, (Integer)Integer.parseInt(dadosExame.getCodMetodo()), st);
            exameRequisicaoVO.setValorCh(dadosConvenio.getCH().doubleValue());
            exameRequisicaoVO.setValorExame(dadosExame.getValor().doubleValue());
            exameRequisicaoVO.setValorChExame(dadosExame.getValorCH().doubleValue());
            exameRequisicaoVO.setValorMaterial(this.getValorMaterial(dadosExame.getMatUtilizado()));
            exameRequisicaoVO.setData(new Date());
            exameRequisicaoVO.setDataColetar(new Date());
            exameRequisicaoVO.setDataEntregaPrevista(solicitacaoExameItem.getDataPrevisao().getTime());
            exameRequisicaoVO.setDataMaterial(new Date());
            exameRequisicaoVO.setPercentualBalcao(dadosConvenio.getPercentualBalcao());
            exameRequisicaoVO.setAutorizar(false);
            exameRequisicaoVO.setNaoFaturar(false);
            exameRequisicaoVO.setDeveGuia(false);
            exameRequisicaoVO.setAvisarEntrega(false);
            exameRequisicaoVO.setUrgente(false);
            exameRequisicaoVO.setCodigoApoiado("");
            exameRequisicaoVO.setVolumeDiurese(BigDecimal.ZERO.doubleValue());
            exameRequisicaoVO.setSequencialSalux(solicitacaoExameItem.getSequencia().toString());
            exameRequisicaoVO.setIdExameSalux(solicitacaoExameItem.getID());
            exameRequisicaoVO.setIdMaterialSalux(solicitacaoExameItem.getIdMaterialColeta().toString());
            exameRequisicaoVO.setIdProcedimentoSalux(solicitacaoExameItem.getIdProcedimento().toString());
            MetodologiaVO metodo = new MetodologiaVO();
            metodo.setCodigo(Integer.valueOf(dadosExame.getCodMetodo()));
            metodo.setDescricao(dadosExame.getDescricao());
            exameRequisicaoVO.setMetodologia(metodo);
        }
        return exameRequisicaoVO;
    }

    private Double getValorMaterial(ArrayList matUtilizado) {
        BigDecimal valorMaterial = BigDecimal.ZERO;
        for (int i = 0; i < matUtilizado.size(); ++i) {
            DadosMaterialUtilizado mat = (DadosMaterialUtilizado)matUtilizado.get(i);
            valorMaterial.add(mat.getValor());
        }
        return valorMaterial.doubleValue();
    }

    public PacienteVO pacienteCadastrado(String filialPadrao, Long id) throws SQLException {
        return this.dao.pacienteCadastrado(filialPadrao, id);
    }

    public Integer inserirPacienteJalis(String filialPadrao, PacienteVO pacienteJalis) throws IntegracaoHospitalException, SQLException {
        return this.dao.inserirPacienteJalis(filialPadrao, pacienteJalis);
    }

    public boolean medicoCadastrado(String filialPadrao, MedicoVO medico) throws SQLException {
        return this.dao.medicoCadastrado(filialPadrao, medico);
    }

    public void inserirMedicoJalis(String filialPadrao, MedicoVO medico) throws IntegracaoHospitalException, SQLException {
        this.dao.inserirMedicoJalis(filialPadrao, medico);
    }

    public Integer getCodigoRequisicao(String filialPadrao) throws IntegracaoHospitalException, SQLException {
        return this.dao.getCodigoRequisicao(filialPadrao);
    }

    public ConvenioVO buscaConvenios(String filialPadrao, Long idPlanoSaude) throws SQLException, XMLStringBuilderException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planoSaude>").append("<idPlano>");
        buf.append(idPlanoSaude.toString());
        buf.append("</idPlano>").append("</planoSaude>");
        return this.dao.buscaConvenios(filialPadrao, buf.toString(), "");
    }

    public void inserirRequisicaoJalis(RequisicaoVO requisicaoVO) throws IntegracaoHospitalException, SQLException {
        if (requisicaoVO != null) {
            this.dao.insereRequisicao(requisicaoVO);
        }
    }

    private CidadeVO buscaCidade(String cidade, String uf) throws Exception {
        CidadeVO cidadeVO = null;
        try {
            Set cidades = new CidadeService().loadVO(" where fil_codigo = " + Variaveis.filialPadrao + " and cid_nome = '" + cidade + "' and cid_uf = '" + uf + "'");
            if (cidade != null) {
                cidadeVO = (CidadeVO)(cidades != null && cidades.size() > 0 ? cidades.toArray()[0] : null);
            }
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel inserir a cidade do paciente!");
        }
        return cidadeVO;
    }

    private BairroVO buscaBairro(String bairro) throws Exception {
        BairroVO bairroVO = null;
        try {
            Set bairros = new BairroService().loadVO(" where fil_codigo = " + Variaveis.filialPadrao + " and bai_descricao = '" + bairro + "' ");
            if (bairros != null) {
                bairroVO = (BairroVO)(bairros != null && bairros.size() > 0 ? bairros.toArray()[0] : null);
            }
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel inserir o bairro do paciente!");
        }
        return bairroVO;
    }

    public PacienteVO pacienteSaluxToPacienteVO(Paciente paciente) throws Exception {
        PacienteVO pacienteJalis = new PacienteVO();
        if (paciente.getAltura() != null) {
            pacienteJalis.setAltura(paciente.getAltura().doubleValue());
        }
        if (paciente.getID() != null) {
            pacienteJalis.setCodigoApoiado(paciente.getID().toString());
        }
        if (!Funcoes.textoVazio(paciente.getNomeCivil())) {
            pacienteJalis.setNome(paciente.getNomeCivil());
        }
        if (!Funcoes.textoVazio(paciente.getNomeMae())) {
            pacienteJalis.setNomeMae(paciente.getNomeMae());
        }
        if (!Funcoes.textoVazio(paciente.getNomeSocial())) {
            pacienteJalis.setNomeSocial(paciente.getNomeSocial());
        }
        if (paciente.getPeso() != null) {
            pacienteJalis.setPeso(paciente.getPeso().doubleValue());
        }
        if (paciente.getSexo() != null) {
            pacienteJalis.setSexo(STATUS_INTEGRACAO_ENVIADO);
            if (paciente.getSexo().getValue().equals("Feminino")) {
                pacienteJalis.setSexo("F");
            } else if (paciente.getSexo().getValue().equals("Masculino")) {
                pacienteJalis.setSexo(TIPO_OPERACAO_SALUX_COLETA_EXAME);
            }
        }
        if (paciente.getDtNascimento() != null) {
            pacienteJalis.setDataNascimento(paciente.getDtNascimento().getTime());
        }
        if (paciente.getFatorRH() != null) {
            pacienteJalis.setFatorRH(paciente.getFatorRH().getValue());
        }
        if (paciente.getTipoSanguineo() != null) {
            pacienteJalis.setGrupoSanguineo(paciente.getTipoSanguineo().getValue());
        }
        if (paciente.getTelefones() != null) {
            this.inserirTelefones(pacienteJalis, paciente.getTelefones());
        }
        if (paciente.getEnderecos() != null) {
            this.inserirEndereco(pacienteJalis, paciente.getEnderecos());
        }
        if (paciente.getDocumentos() != null) {
            this.inserirDocumentos(pacienteJalis, paciente.getDocumentos());
        }
        return pacienteJalis;
    }

    private void inserirTelefones(PacienteVO pacienteJalis, Telefone[] telefones) {
        for (Telefone telefone : telefones) {
            String tel = String.valueOf(telefone.getDDD()) + telefone.getNumero();
            if (telefone.getCelular().booleanValue()) {
                pacienteJalis.setCelular(tel);
                continue;
            }
            if (telefone.getPrincipal().booleanValue()) {
                pacienteJalis.setFone(tel);
                continue;
            }
            if (!telefone.getFAX().booleanValue()) continue;
            pacienteJalis.setFax(tel);
        }
    }

    private void inserirDocumentos(PacienteVO pacienteJalis, Documento[] documentos) {
        for (Documento documento : documentos) {
            if (documento.getTipo().equals((Object)TpDocumento.RG)) {
                pacienteJalis.setRg(documento.getNumero());
                continue;
            }
            if (documento.getTipo().equals((Object)TpDocumento.CPF)) {
                pacienteJalis.setTipoPessoa("F");
                pacienteJalis.setCpf(documento.getNumero());
                continue;
            }
            if (documento.getTipo().equals((Object)TpDocumento.CNPJ)) {
                pacienteJalis.setTipoPessoa("J");
                pacienteJalis.setCNPJ(documento.getNumero());
                continue;
            }
            if (documento.getTipo().equals((Object)TpDocumento.IE)) {
                pacienteJalis.setIe(documento.getNumero());
                continue;
            }
            if (!documento.getTipo().equals((Object)TpDocumento.ANS)) continue;
            pacienteJalis.setCartaoSus(documento.getNumero());
        }
    }

    private void inserirEndereco(PacienteVO pacienteJalis, Endereco[] enderecos) throws Exception {
        for (Endereco endereco : enderecos) {
            if (!endereco.getPrincipal().booleanValue()) continue;
            pacienteJalis.setEndereco(endereco.getLogradouro());
            pacienteJalis.setBairro(this.buscaBairro(endereco.getBairro()));
            pacienteJalis.setNumeroEndereco(endereco.getNumero().toString());
            pacienteJalis.setCidade(this.buscaCidade(endereco.getCidade(), endereco.getUF()));
            pacienteJalis.setCep(endereco.getCEP().toString());
        }
    }

    public void inserirExameRequisicaoJalis(String string, RequisicaoVO requisicaoVO, ExameRequisicaoVO exameRequisicao, Integer ordem) throws SQLException {
        this.dao.inserirExameRequisicaoJalis(requisicaoVO.getFilial().getCodigo().toString(), requisicaoVO, exameRequisicao, ordem);
    }

    public void insereIntegracaoHospitalResultado(String filialPadrao, String tipoOperacao, String reqCodigo, String exaCodigo, String mcoCodigo, String idSolicitacao, String sequencial) throws SQLException, IntegracaoHospitalException, XMLStringBuilderException {
        String operacao = this.getOperacaoResultadoExame(filialPadrao, reqCodigo, exaCodigo, mcoCodigo, idSolicitacao, sequencial);
        Integer codigoLog = this.insereIntegracaoHospital(filialPadrao, tipoOperacao, operacao, reqCodigo, exaCodigo, mcoCodigo, null);
        this.dao.atualizarLogHospital(filialPadrao, codigoLog.toString(), operacao, STATUS_INTEGRACAO_PENDENTE);
    }

    public Integer insereIntegracaoHospital(String filialPadrao, String tipoOperacao, String operacao, String reqCodigo, String exaCodigo, String mcoCodigo, String erro) throws SQLException, IntegracaoHospitalException, XMLStringBuilderException {
        return this.dao.insereIntegracaoHospital(filialPadrao, tipoOperacao, operacao, reqCodigo, exaCodigo, mcoCodigo, erro);
    }

    public void atualizarLogExportacao(String filialPadrao, String retorno, String codigoLog, String situacao) throws SQLException, IntegracaoHospitalException {
        this.dao.atualizarLogHospital(filialPadrao, codigoLog, retorno, situacao);
    }

    public void consultarLogIntegracao(Long log, Integer filial) throws Exception {
        String idSolicitacao = this.dao.consultarLogInteggracao(log, filial);
        this.consultaIntegracaoHospitalPorId(idSolicitacao);
    }

    public SolicitacaoExame[] consultaIntegracaoHospitalPorId(String xmlRetorno) throws Exception {
        ISADTProxy isadt = new ISADTProxy();
        SolicitacaoExame solicitacaoExame = new SolicitacaoExame();
        String idPlanoSaude = StringUtil.getValor(xmlRetorno, "planoSaude");
        SolicitacaoExame[] solicitacoes = null;
        if (!Funcoes.textoVazio(idPlanoSaude)) {
            solicitacaoExame.setIdPlanoSaude(Long.valueOf(idPlanoSaude.trim()));
            ConvenioVO convenioVO = this.buscaConvenios(solicitacaoExame);
            if (convenioVO != null) {
                String id = StringUtil.getValor(xmlRetorno, TAG_IDSOLICITACAO);
                String xmlIntegracao = convenioVO.getIntegracaoHospital();
                WsUsuario wsUsuario = new WsUsuario(StringUtil.getValor(xmlIntegracao, "login"), StringUtil.getValor(xmlIntegracao, "senha"));
                solicitacoes = isadt.buscarSolicitacaoExame(wsUsuario, id);
                if (solicitacoes != null) {
                    for (SolicitacaoExame sol : solicitacoes) {
                        this.inserirRequisicao(wsUsuario, sol);
                    }
                }
            }
        }
        return solicitacoes;
    }

    public SolicitacaoExame[] consultaIntegracaoHospital(WsUsuario wsUsuario) throws Exception {
        ISADTProxy isadt = new ISADTProxy();
        Calendar cal = Calendar.getInstance();
        Calendar calInicial = this.getDataInicialConsulta();
        SolicitacaoExame[] solicitacoes = isadt.buscarSolicitacaoExamePeriodo(wsUsuario, calInicial, cal);
        this.debug(solicitacoes.length + " solicitacoes para processar");
        if (solicitacoes != null) {
            for (SolicitacaoExame solicitacaoExame : solicitacoes) {
                this.inserirRequisicao(wsUsuario, solicitacaoExame);
            }
            this.debug("concluiu processamento das solicitacoes");
        }
        return solicitacoes;
    }

    public Calendar getDataInicialConsulta() {
        LocalDate dataInicial = LocalDate.now().minus(Period.ofDays(10));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(dataInicial.getYear(), dataInicial.getMonthValue() - 1, dataInicial.getDayOfMonth());
        return calendar;
    }

    public void enviarIntegracaoHospital(WsUsuario wsUsuario) throws Exception {
        ISADTProxy isadt = new ISADTProxy();
        List<Registro> logs = this.dao.recuperarLogExportaIntegracaoHospital();
        this.debug("encontrados " + logs.size() + " logs para integracao");
        for (Registro log : logs) {
            Laudo laudo = this.logToLaudo(log);
            Integer retorno = 0;
            try {
                retorno = isadt.registrarLaudo(wsUsuario, laudo);
                this.processarRetornoRegistrarLaudo(wsUsuario, retorno, log);
            }
            catch (Exception e) {
                this.integracaoHospitalSalux.erros.errosProcesso.add(this.integracaoHospitalSalux.montaExcecao(null, PROCESSO_ENVIAR_LAUDO, e.getMessage(), null, null));
            }
        }
        this.debug("processo de envio de logs concluido");
    }

    private void processarRetornoRegistrarLaudo(WsUsuario wsUsuario, Integer retorno, Registro log) throws Exception {
        String operacao = log.getString("eih_operacao");
        String tipoOperacao = log.getString("eih_tipooperacao");
        String idSolicitacao = StringUtil.getValor(operacao, TAG_IDSOLICITACAO, true).trim();
        String sequencial = StringUtil.getValor(operacao, TAG_SEQUENCIAL, true).trim();
        String idProcedimento = StringUtil.getValor(operacao, TAG_IDPROCEDIMENTO, true).trim();
        String codLog = log.getString("eih_codigo");
        String codFilial = StringUtil.getValor(operacao, TAG_FILIAL, true).trim();
        try {
            if (retorno > 0 && tipoOperacao.equals(RESULTADO_PRIMEIRA_CONFERENCIA)) {
                ISADTProxy isadt = new ISADTProxy();
                String resposta = isadt.atualizarExameSituacao(wsUsuario, idSolicitacao.concat(this.padronizarSequencialExame(sequencial)), idProcedimento, SITUACAO_EXAME_SALUX);
                this.processarRespostaAtualizarExameSituacao(resposta, log);
            } else if (retorno > 0 && tipoOperacao.equals(RESULTADO_RETIFICADO)) {
                this.dao.atualizarLogEnviadoComSucesso(codFilial, codLog);
            } else {
                this.dao.atualizarLogHospital(codFilial, codLog, String.valueOf(retorno), "R");
            }
        }
        catch (Exception e) {
            this.integracaoHospitalSalux.erros.errosProcesso.add(this.integracaoHospitalSalux.montaExcecao(null, PROCESSO_ATUALIZAR_SITUACAO_LAUDO, e.getMessage(), null, null));
        }
    }

    private void processarRespostaAtualizarExameSituacao(String resposta, Registro log) throws SQLException {
        String operacao = log.getString("eih_operacao");
        String codLog = log.getString("eih_codigo");
        String codFilial = StringUtil.getValor(operacao, TAG_FILIAL, true).trim();
        if (resposta.equals("-1")) {
            this.dao.atualizarLogHospital(codFilial, codLog, resposta, "R");
        } else {
            this.dao.atualizarLogEnviadoComSucesso(codFilial, codLog);
        }
    }

    private Laudo logToLaudo(Registro log) throws Exception {
        Laudo laudo = new Laudo();
        String operacao = log.getString("eih_operacao");
        String codFilial = StringUtil.getValor(operacao, TAG_FILIAL, true).trim();
        String codRequisicao = StringUtil.getValor(operacao, TAG_CODREQ, true).trim();
        String codExame = StringUtil.getValor(operacao, TAG_CODEXA, true).trim();
        String codMaterial = StringUtil.getValor(operacao, TAG_CODMAT, true).trim();
        String idSolicitacao = StringUtil.getValor(operacao, TAG_IDSOLICITACAO, true).trim();
        String sequencial = StringUtil.getValor(operacao, TAG_SEQUENCIAL, true).trim();
        Registro datas = this.dao.recuperarDatasExameRequisicao(codFilial, codRequisicao, codExame, codMaterial);
        byte[] resultadoPDF = this.gerarResultadoPDF(codFilial, codRequisicao, codExame, codMaterial);
        laudo.setConteudo(resultadoPDF);
        laudo.setFormato(TpFormatoLaudo.PDF);
        laudo.setDataDigitacao(this.dateToCalendar(datas.getDate("datadigitacao")));
        laudo.setDataLiberacao(this.dateToCalendar(datas.getDate("dataliberacao")));
        laudo.setDataEmissao(this.dateToCalendar(new Date()));
        String versao = "01";
        TpSituacaoLaudo situacao = TpSituacaoLaudo.LiberadoDefinitivo;
        if (log.getString("eih_tipooperacao").equalsIgnoreCase(RESULTADO_RETIFICADO)) {
            laudo.setDataRetificacao(this.dateToCalendar(datas.getDate("datadigitacao")));
            versao = "02";
            situacao = TpSituacaoLaudo.Retificado;
        }
        laudo.setID(idSolicitacao.concat(this.padronizarSequencialExame(sequencial)));
        laudo.setSequencia(Integer.valueOf(versao));
        laudo.setSituacao(situacao);
        return laudo;
    }

    private byte[] gerarResultadoPDF(String codFilial, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(null, null, codFilial, codRequisicao, true, true, null, new String[]{codExame}, new String[]{codMaterial}, true, null, true, true, null, false, "", true, false);
        return retorno.getResultadoPdfWeb();
    }

    private Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    private PacienteVO buscarPaciente(WsUsuario wsUsuario, SolicitacaoExame solicitacaoExame) {
        ICadastroProxy iCadastro = new ICadastroProxy();
        PacienteVO pacienteJalis = null;
        try {
            Paciente[] pacientes;
            Paciente[] pacienteArray = pacientes = iCadastro.buscarDadosPaciente(wsUsuario, solicitacaoExame.getIdPaciente());
            int n = pacienteArray.length;
            int n2 = 0;
            if (n2 < n) {
                Paciente paciente = pacienteArray[n2];
                pacienteJalis = this.inserirPaciente(paciente);
            }
        }
        catch (RemoteException e) {
            this.integracaoHospitalSalux.erros.errosProcesso.add(this.integracaoHospitalSalux.montaExcecao(null, PROCESSO_INSERIRPACIENTE, e.getMessage(), null, null));
        }
        return pacienteJalis;
    }

    private PacienteVO inserirPaciente(Paciente paciente) {
        PacienteVO pacienteJalis = null;
        try {
            if (paciente != null && (pacienteJalis = this.pacienteCadastrado(Variaveis.filialPadrao, paciente.getID())) == null) {
                pacienteJalis = this.inserirPacienteJalis(paciente);
                return pacienteJalis;
            }
        }
        catch (Exception e) {
            this.integracaoHospitalSalux.erros.errosProcesso.add(this.integracaoHospitalSalux.montaExcecao(null, PROCESSO_INSERIRPACIENTE, e.getMessage(), null, null));
        }
        return pacienteJalis;
    }

    private PacienteVO inserirPacienteJalis(Paciente paciente) throws Exception {
        PacienteVO pacienteJalis = this.pacienteSaluxToPacienteVO(paciente);
        pacienteJalis.setCodigo(this.inserirPacienteJalis(Variaveis.filialPadrao, pacienteJalis));
        return pacienteJalis;
    }

    private void inserirRequisicao(WsUsuario wsUsuario, SolicitacaoExame solicitacaoExame) throws Exception {
        RequisicaoVO requisicaoVO = this.dao.pesquisarRequisicao(Variaveis.filialPadrao, solicitacaoExame.getID());
        if (!this.novaRequisicaoCadastrada(requisicaoVO, wsUsuario, solicitacaoExame)) {
            this.adicionarExamesNaRequisicao(requisicaoVO, solicitacaoExame);
        }
    }

    private void adicionarExamesNaRequisicao(RequisicaoVO requisicaoVO, SolicitacaoExame solicitacaoExame) throws Exception {
        this.debug("atualizando exames nas requisicoes");
        this.codigoRequisicao = requisicaoVO.getCodigo();
        SolicitacaoExameItem solicitacaoExameErro = new SolicitacaoExameItem();
        try {
            ArrayList<ExameRequisicaoVO> examesSolicitacaoSalux = new ArrayList<ExameRequisicaoVO>();
            SolicitacaoExameItem[] solicitacaoExameItemArray = solicitacaoExame.getExames();
            int n = solicitacaoExameItemArray.length;
            for (int i = 0; i < n; ++i) {
                SolicitacaoExameItem solicitacaoExameItem;
                solicitacaoExameErro = solicitacaoExameItem = solicitacaoExameItemArray[i];
                ExameRequisicaoVO exameJalis = this.getExames(this.integracaoHospitalSalux.getCodigoConvenio(), solicitacaoExameItem);
                if (exameJalis.getSequencialSalux() != null) {
                    examesSolicitacaoSalux.add(exameJalis);
                    continue;
                }
                this.adicionarExameLog(solicitacaoExameItem, solicitacaoExame.getID());
            }
            ArrayList<ExameRequisicaoVO> examesParaAdicionarNaRequisicao = this.getExamesParaAdicionarNaRequisicao(requisicaoVO.getExames(), examesSolicitacaoSalux);
            examesParaAdicionarNaRequisicao.forEach(exame -> requisicaoVO.getExames().add((ExameRequisicaoVO)exame));
            if (examesParaAdicionarNaRequisicao.size() > 0) {
                this.inserirExameRequisicao(requisicaoVO);
            }
        }
        catch (Exception e) {
            this.adicionarExameLog(solicitacaoExameErro, solicitacaoExame.getID());
        }
    }

    private boolean novaRequisicaoCadastrada(RequisicaoVO requisicaoVO, WsUsuario wsUsuario, SolicitacaoExame solicitacaoExame) throws Exception {
        boolean cadastrada = false;
        if (requisicaoVO.getCodigo() == null) {
            cadastrada = true;
            try {
                this.debug("inserindo novas requisicoes");
                requisicaoVO = this.construirRequisicao(wsUsuario, solicitacaoExame);
                this.inserirRequisicaoJalis(requisicaoVO);
                this.inserirExameRequisicao(requisicaoVO);
            }
            catch (Exception e) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", Variaveis.filialPadrao);
                this.integracaoHospitalSalux.erros.errosProcesso.add(this.integracaoHospitalSalux.montaExcecao(null, PROCESSO_INSERIRREQUISICAO, e.getMessage(), chaves, null, Variaveis.filialPadrao, null));
            }
        }
        return cadastrada;
    }

    private ArrayList<ExameRequisicaoVO> getExamesParaAdicionarNaRequisicao(ArrayList<ExameRequisicaoVO> examesAdicionados, ArrayList<ExameRequisicaoVO> examesSolicitacaoSalux) {
        ArrayList<ExameRequisicaoVO> examesParaAdicionarNaRequisicao = new ArrayList<ExameRequisicaoVO>();
        examesSolicitacaoSalux.forEach(exameSolSalux -> examesParaAdicionarNaRequisicao.add((ExameRequisicaoVO)exameSolSalux));
        if (examesAdicionados.isEmpty()) {
            return examesParaAdicionarNaRequisicao;
        }
        for (ExameRequisicaoVO exameSolicitacaoSalux : examesSolicitacaoSalux) {
            for (ExameRequisicaoVO exameAdicionado : examesAdicionados) {
                FilialVO filialAdicionada = exameAdicionado.getFilial();
                FilialVO filialSolicitacaoSalux = exameSolicitacaoSalux.getFilial();
                ExameVO exmAdicionado = exameAdicionado.getExame();
                ExameVO exmSolicitacaoSalux = exameSolicitacaoSalux.getExame();
                MaterialColetaVO matAdicionado = exameAdicionado.getMaterial();
                MaterialColetaVO matSolicitacaoSalux = exameSolicitacaoSalux.getMaterial();
                if (!filialAdicionada.getCodigo().equals(filialSolicitacaoSalux.getCodigo()) || !exmAdicionado.getCodigo().equals(exmSolicitacaoSalux.getCodigo()) || !matAdicionado.getCodigo().equals(matSolicitacaoSalux.getCodigo())) continue;
                examesParaAdicionarNaRequisicao.removeIf(exame -> exame.getExame().getCodigo().equals(exameSolicitacaoSalux.getExame().getCodigo()) && exame.getMaterial().getCodigo().equals(exameSolicitacaoSalux.getMaterial().getCodigo()));
            }
        }
        return examesParaAdicionarNaRequisicao;
    }

    private RequisicaoVO construirRequisicao(WsUsuario wsUsuario, SolicitacaoExame solicitacaoExame) throws Exception {
        RequisicaoVO requisicaoVO = new RequisicaoVO();
        this.codigoRequisicao = this.getCodigoRequisicao(Variaveis.filialPadrao);
        requisicaoVO.setConvenio(this.buscaConvenios(solicitacaoExame));
        requisicaoVO.setPaciente(this.buscarPaciente(wsUsuario, solicitacaoExame));
        requisicaoVO.setMedico(this.buscaMedico(wsUsuario, solicitacaoExame.getIdProfissional()));
        requisicaoVO.setExames(this.converterSolicitacaoExameSaluxParaExameRequisicaoVO(solicitacaoExame));
        requisicaoVO.setUrgente(solicitacaoExame.getUrgencia() != null && solicitacaoExame.getUrgencia() != false);
        requisicaoVO.setColeta(requisicaoVO.getConvenio().getColeta());
        requisicaoVO.setDestino(requisicaoVO.getConvenio().getDestino());
        requisicaoVO.setIdSolicitacaoSalux(solicitacaoExame.getID());
        requisicaoVO.setIntegracaoHospital(this.getXmlIntegracaoHospital(solicitacaoExame.getID()));
        EstacaoVO estacao = new EstacaoVO();
        estacao.setCodigo(Integer.valueOf(Variaveis.codigoEstacao));
        estacao.setDescricao(Variaveis.nomeEstacao);
        requisicaoVO.setEstacao(estacao);
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        requisicaoVO.setUsuario(usuario);
        requisicaoVO.setUsuarioAbertura(usuario);
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
        requisicaoVO.setFilial(filial);
        requisicaoVO.setCodigo(this.codigoRequisicao);
        return requisicaoVO;
    }

    private String getXmlIntegracaoHospital(String idSolicitacao) throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_XML_SALUX);
        xml.abrir(TAG_PROTOCOLO);
        xml.escrever(ProtocoloIntegracaoHospital.SALUX.getNome());
        xml.fechar(TAG_PROTOCOLO);
        xml.abrir(TAG_IDSOLICITACAO);
        xml.escrever(idSolicitacao);
        xml.fechar(TAG_IDSOLICITACAO);
        xml.fechar(TAG_XML_SALUX);
        return xml.getXML().replaceAll("\n", "").replaceAll(" ", "");
    }

    private void inserirExameRequisicao(RequisicaoVO requisicaoVO) {
        if (requisicaoVO.getExames() == null || requisicaoVO.getExames().isEmpty()) {
            requisicaoVO.setExames(new ArrayList<ExameRequisicaoVO>());
        }
        Integer ordem = requisicaoVO.getExames().isEmpty() ? 0 : requisicaoVO.getExames().size();
        for (ExameRequisicaoVO exameRequisicao : requisicaoVO.getExames()) {
            try {
                this.inserirExameRequisicaoJalis(requisicaoVO.getFilial().getCodigo().toString(), requisicaoVO, exameRequisicao, ordem);
                Integer n = ordem;
                Integer n2 = ordem = Integer.valueOf(ordem + 1);
                Integer codigoLog = this.insereIntegracaoHospital(Variaveis.filialPadrao, TIPO_OPERACAO_SALUX_COLETA_EXAME, "E", requisicaoVO.getCodigo().toString(), exameRequisicao.getExame().getCodigo(), exameRequisicao.getMaterial().getCodigo().toString(), this.xmlErro.toString());
                this.atualizarLogExportacao(Variaveis.filialPadrao, this.xmlErro.toString(), codigoLog.toString(), TIPO_OPERACAO_SALUX_COLETA_EXAME);
            }
            catch (IntegracaoHospitalException | XMLStringBuilderException | SQLException e) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", Variaveis.filialPadrao);
                this.integracaoHospitalSalux.erros.errosProcesso.add(this.integracaoHospitalSalux.montaExcecao(null, PROCESSO_INSERIRREQUISICAO, e.getMessage(), chaves, null, Variaveis.filialPadrao, null));
            }
        }
    }

    private ConvenioVO buscaConvenios(SolicitacaoExame solicitacaoExame) throws Exception {
        ConvenioVO convenioVO = this.buscaConvenios(Variaveis.filialPadrao, solicitacaoExame.getIdPlanoSaude());
        if (convenioVO == null) {
            this.xmlErro = new XMLStringBuilder();
            this.xmlErro.abrir(TAG_INTEGRACAOHOSPITAL);
            this.xmlErro.abrir(TAG_NOMEINTEGRACAOHOSPITAL);
            this.xmlErro.escrever("Salux");
            this.xmlErro.fechar(TAG_NOMEINTEGRACAOHOSPITAL);
            this.xmlErro.abrir(TAG_IDSOLICITACAO);
            this.xmlErro.escrever(solicitacaoExame.getID());
            this.xmlErro.fechar(TAG_IDSOLICITACAO);
            this.xmlErro.abrir("planoSaude");
            this.xmlErro.escrever(solicitacaoExame.getIdPlanoSaude().toString());
            this.xmlErro.fechar("planoSaude");
            this.xmlErro.abrir(TAG_RETORNO);
            this.xmlErro.escrever("O idPlanoSaude solicitado pelo Hospital, n\u00e3o possui um Conv\u00eanio correspondente configurado no Jalis.");
            this.xmlErro.fechar(TAG_RETORNO);
            this.xmlErro.fechar(TAG_INTEGRACAOHOSPITAL);
            Integer codigoLog = this.insereIntegracaoHospital(Variaveis.filialPadrao, TIPO_OPERACAO_SALUX_COLETA_EXAME, "E", "", "", "", this.xmlErro.toString());
            this.atualizarLogExportacao(Variaveis.filialPadrao, this.xmlErro.toString(), codigoLog.toString(), SITUACAO_ERROCONVENIO);
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", Variaveis.filialPadrao);
            chaves.put("Codigo Log", codigoLog);
            if (this.integracaoHospitalSalux != null) {
                this.integracaoHospitalSalux.erros.errosProcesso.add(this.integracaoHospitalSalux.montaExcecao(null, PROCESSO_INSERIRREQUISICAO, "O idPlanoSaude solicitado pelo Hospital, n\u00e3o possui um Conv\u00eanio correspondente configurado no Jalis.", chaves, null, Variaveis.filialPadrao, (long)codigoLog));
            }
            throw new Exception("O idPlanoSaude solicitado pelo Hospital, n\u00e3o possui um Conv\u00eanio correspondente configurado no Jalis." + solicitacaoExame.getIdPlanoSaude().toString());
        }
        return convenioVO;
    }

    private ArrayList<ExameRequisicaoVO> converterSolicitacaoExameSaluxParaExameRequisicaoVO(SolicitacaoExame solicitacaoExame) throws Exception {
        ArrayList<ExameRequisicaoVO> listaExames = new ArrayList<ExameRequisicaoVO>();
        for (SolicitacaoExameItem solicitacaoExameItem : solicitacaoExame.getExames()) {
            ExameRequisicaoVO exameJalis = this.getExames(this.integracaoHospitalSalux.getCodigoConvenio(), solicitacaoExameItem);
            if (exameJalis.getSequencialSalux() != null) {
                listaExames.add(exameJalis);
                continue;
            }
            this.adicionarExameLog(solicitacaoExameItem, solicitacaoExame.getID());
        }
        return listaExames;
    }

    private void adicionarExameLog(SolicitacaoExameItem solicitacaoExameItem, String idSolicitacao) throws Exception {
        this.xmlErro = new XMLStringBuilder();
        this.xmlErro.abrir(TAG_INTEGRACAOHOSPITAL);
        this.xmlErro.abrir(TAG_NOMEINTEGRACAOHOSPITAL);
        this.xmlErro.escrever("Salux");
        this.xmlErro.fechar(TAG_NOMEINTEGRACAOHOSPITAL);
        this.xmlErro.abrir(TAG_IDSOLICITACAO);
        this.xmlErro.escrever(idSolicitacao);
        this.xmlErro.fechar(TAG_IDSOLICITACAO);
        this.xmlErro.abrir(TAG_FILIAL);
        this.xmlErro.escrever(Variaveis.filialPadrao);
        this.xmlErro.fechar(TAG_FILIAL);
        this.xmlErro.abrir(TAG_CODREQ);
        this.xmlErro.escrever(this.codigoRequisicao.toString());
        this.xmlErro.fechar(TAG_CODREQ);
        this.xmlErro.abrir("Exame");
        this.xmlErro.abrir("idExame");
        this.xmlErro.escrever(solicitacaoExameItem.getIdProcedimento().toString());
        this.xmlErro.fechar("idExame");
        this.xmlErro.abrir("idMaterial");
        this.xmlErro.escrever(solicitacaoExameItem.getIdMaterialColeta().toString());
        this.xmlErro.fechar("idMaterial");
        this.xmlErro.abrir(TAG_SEQUENCIAL);
        this.xmlErro.escrever(solicitacaoExameItem.getSequencia().toString());
        this.xmlErro.fechar(TAG_SEQUENCIAL);
        this.xmlErro.abrir(TAG_IDPROCEDIMENTO);
        this.xmlErro.escrever(solicitacaoExameItem.getIdProcedimento().toString());
        this.xmlErro.fechar(TAG_IDPROCEDIMENTO);
        this.xmlErro.fechar("Exame");
        this.xmlErro.abrir(TAG_RETORNO);
        this.xmlErro.escrever("O idExame/idMaterial solicitado pelo Hospital, n\u00e3o possui exame correspondente configurado no Jalis.");
        this.xmlErro.fechar(TAG_RETORNO);
        this.xmlErro.fechar(TAG_INTEGRACAOHOSPITAL);
        Integer codigoLog = this.insereIntegracaoHospital(Variaveis.filialPadrao, TIPO_OPERACAO_SALUX_COLETA_EXAME, "E", "", "", "", this.xmlErro.toString());
        this.atualizarLogExportacao(Variaveis.filialPadrao, this.xmlErro.toString(), codigoLog.toString(), "E");
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", Variaveis.filialPadrao);
        chaves.put("Requisi\u00e7\u00e3o", this.codigoRequisicao);
        chaves.put("Codigo Log", codigoLog);
        this.integracaoHospitalSalux.erros.errosProcesso.add(this.integracaoHospitalSalux.montaExcecao(null, PROCESSO_INSERIREXAMEREQUISICAO, this.xmlErro.toString(), chaves, null, Variaveis.filialPadrao, (long)codigoLog));
    }

    private MedicoVO buscaMedico(WsUsuario wsUsario, Long idProfissional) throws IntegracaoHospitalException {
        ICadastroProxy iCadastro = new ICadastroProxy();
        MedicoVO medico = null;
        try {
            Profissional profissional;
            Profissional[] profissionais;
            Profissional[] profissionalArray = profissionais = iCadastro.buscarDadosProfissional(wsUsario, idProfissional);
            int n = profissionalArray.length;
            int n2 = 0;
            if (n2 < n && !this.medicoCadastrado(Variaveis.filialPadrao, medico = this.inserirProfissional(profissional = profissionalArray[n2]))) {
                this.inserirMedicoJalis(Variaveis.filialPadrao, medico);
            }
        }
        catch (RemoteException | SQLException e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", Variaveis.filialPadrao);
            chaves.put("Requisi\u00e7\u00e3o", this.codigoRequisicao);
            this.integracaoHospitalSalux.erros.errosProcesso.add(this.integracaoHospitalSalux.montaExcecao(null, PROCESSO_INSERIRPROFISSIONAL, e.getMessage(), null, null));
        }
        return medico;
    }

    private MedicoVO inserirProfissional(Profissional profissional) {
        MedicoVO medico = new MedicoVO();
        medico.setNome(profissional.getNome());
        for (Documento documento : profissional.getDocumentos()) {
            if (!documento.getTipo().equals((Object)TpDocumento.ConselhoClasse)) continue;
            medico.setConselho(documento.getEmissor());
            medico.setCrm(documento.getNumero());
            medico.setUf(documento.getUF());
        }
        return medico;
    }

    public boolean registrarColeta(String codigoConvenio, String codRequisicao, String idSolicitacao, String sequencialExame) throws Exception {
        ConvenioVO convenioVO;
        boolean coleta = false;
        ISADTProxy isadt = new ISADTProxy();
        if (!Funcoes.textoVazio(codigoConvenio) && (convenioVO = this.dao.buscaConvenios(Variaveis.filialPadrao, "", codigoConvenio)) != null) {
            String xmlIntegracao = convenioVO.getIntegracaoHospital();
            WsUsuario wsUsuario = new WsUsuario(StringUtil.getValor(xmlIntegracao, "login"), StringUtil.getValor(xmlIntegracao, "senha"));
            try {
                isadt.registrarColetaInicio(wsUsuario, idSolicitacao.concat(this.padronizarSequencialExame(sequencialExame)));
                coleta = true;
            }
            catch (Exception e) {
                coleta = false;
            }
        }
        return coleta;
    }

    public boolean registrarColetaFim(String codigoConvenio, String codRequisicao, String idSolicitacao, String sequencialExame) throws Exception {
        ConvenioVO convenioVO;
        boolean coleta = false;
        ISADTProxy isadt = new ISADTProxy();
        if (!Funcoes.textoVazio(codigoConvenio) && (convenioVO = this.dao.buscaConvenios(Variaveis.filialPadrao, "", codigoConvenio)) != null) {
            String xmlIntegracao = convenioVO.getIntegracaoHospital();
            WsUsuario wsUsuario = new WsUsuario(StringUtil.getValor(xmlIntegracao, "login"), StringUtil.getValor(xmlIntegracao, "senha"));
            try {
                isadt.registrarColetaFim(wsUsuario, idSolicitacao.concat(this.padronizarSequencialExame(sequencialExame)));
                coleta = true;
            }
            catch (Exception e) {
                throw new Exception("Falha ao enviar o t\u00e9rmino da coleta - ".concat(e.getMessage()));
            }
        }
        return coleta;
    }

    public boolean registrarRecoleta(String codigoConvenio, String codRequisicao, String idSolicitacao, String sequencialExame) throws Exception {
        ConvenioVO convenioVO;
        boolean reColeta = false;
        ISADTProxy isadt = new ISADTProxy();
        if (!Funcoes.textoVazio(codigoConvenio) && (convenioVO = this.dao.buscaConvenios(Variaveis.filialPadrao, "", codigoConvenio)) != null) {
            String xmlIntegracao = convenioVO.getIntegracaoHospital();
            WsUsuario wsUsuario = new WsUsuario(StringUtil.getValor(xmlIntegracao, "login"), StringUtil.getValor(xmlIntegracao, "senha"));
            try {
                isadt.registrarReColeta(wsUsuario, idSolicitacao.concat(this.padronizarSequencialExame(sequencialExame)));
                reColeta = true;
            }
            catch (Exception e) {
                throw new Exception("Falha ao enviar recoleta - ".concat(e.getMessage()));
            }
        }
        return reColeta;
    }

    public boolean convenioIntegradoSalux(String codigoFilial, String codigoConvenio) throws SQLException {
        ConvenioVO convenioVO = new ConvenioVO();
        if (!Funcoes.textoVazio(codigoConvenio)) {
            convenioVO = this.dao.buscaConvenios(codigoFilial, "", codigoConvenio);
        }
        return convenioVO.getIntegracaoHospital() != null && convenioVO.getIntegracaoHospital().contains("SALUX");
    }

    public boolean resultadoRetificado(String codigoFilial, String codigoRequisicao, String codigoExame, String codigomaterialColetado) {
        return !Funcoes.textoVazio(this.dao.getHashFromExameRequisicaoHash(codigoFilial, codigoRequisicao, codigoExame, codigomaterialColetado));
    }

    private String getOperacaoResultadoExame(String codFilial, String codRequisicao, String codExame, String codMaterial, String idSolicitacao, String sequencial) throws XMLStringBuilderException {
        XMLStringBuilder operacao = new XMLStringBuilder();
        operacao.abrir(TAG_INTEGRACAOHOSPITAL);
        operacao.abrir(TAG_NOMEINTEGRACAOHOSPITAL);
        operacao.escrever(ProtocoloIntegracaoHospital.SALUX.getNome());
        operacao.fechar(TAG_NOMEINTEGRACAOHOSPITAL);
        operacao.abrir(TAG_FILIAL);
        operacao.escrever(codFilial);
        operacao.fechar(TAG_FILIAL);
        operacao.abrir(TAG_CODREQ);
        operacao.escrever(codRequisicao);
        operacao.fechar(TAG_CODREQ);
        operacao.abrir(TAG_CODEXA);
        operacao.escrever(codExame);
        operacao.fechar(TAG_CODEXA);
        operacao.abrir(TAG_CODMAT);
        operacao.escrever(codMaterial);
        operacao.fechar(TAG_CODMAT);
        operacao.abrir(TAG_IDSOLICITACAO);
        operacao.escrever(idSolicitacao);
        operacao.fechar(TAG_IDSOLICITACAO);
        operacao.abrir(TAG_SEQUENCIAL);
        operacao.escrever(sequencial);
        operacao.fechar(TAG_SEQUENCIAL);
        operacao.abrir(TAG_IDPROCEDIMENTO);
        operacao.escrever(this.getIdProcedimentoSalux(codFilial, codExame, codMaterial));
        operacao.fechar(TAG_IDPROCEDIMENTO);
        operacao.fechar(TAG_INTEGRACAOHOSPITAL);
        return operacao.getXML().replaceAll("\n", "").replaceAll(" ", "");
    }

    public String getIdProcedimentoSalux(String codFilial, String codExame, String codMaterial) {
        return this.dao.getIdProcedimento(codFilial, codExame, codMaterial);
    }

    public String getIdSolicitacaoSalux(String codFilial, String codRequisicao) {
        return this.dao.getIdSolicitacao(codFilial, codRequisicao);
    }

    public Integer getSequencialExame(String codFilial, String codRequisicao, String codExame, String codMaterial) {
        return this.dao.getSequencialExame(codFilial, codRequisicao, codExame, codMaterial);
    }

    public void atualizarDataInicioColeta(boolean coletasIniciadas, String codRequisicao, String idSolicitacao) throws SQLException {
        if (coletasIniciadas) {
            this.dao.atualizarDataInicioColeta(Variaveis.filialPadrao, codRequisicao, idSolicitacao);
        }
    }

    public boolean exameTemRecoleta(String codFilial, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        return this.dao.exameTemRecoleta(codFilial, codRequisicao, codExame, codMaterial);
    }

    private String padronizarSequencialExame(String sequencialExame) {
        return sequencialExame.length() < 2 ? "0".concat(sequencialExame) : sequencialExame;
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }
}

