/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.salux.dao;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.ColetaVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.DestinoVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilderException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SaluxDao {
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final String PROCESSO_GERAR_SEQUENCIA = "gerando sequencia";
    public static final String STATUS_INTEGRACAO_PENDENTE = "P";
    public static final String STATUS_INTEGRACAO_ENVIADO = "I";
    public static final String STATUS_INTEGRACAO_ERRO = "E";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Registro> pesquisarExames(String filial, String exameHospital) throws Exception {
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        ArrayList<Registro> exames = null;
        try {
            exames = new ArrayList<Registro>();
            StringBuilder buf = new StringBuilder();
            buf.append(" SELECT a.exa_codigo as codigoExame, ");
            buf.append("  a.exa_descricao, c.mco_codigo as codigoMaterial ");
            buf.append(" FROM exames a  ");
            buf.append(" LEFT JOIN examematcoleta c  ");
            buf.append(" ON a.fil_codigo = c.fil_codigo  ");
            buf.append(" AND c.exa_codigo = a.exa_codigo ");
            buf.append(" AND c.emc_default ");
            buf.append(" WHERE a.fil_codigo = ").append(filial);
            buf.append(" and c.emc_xmlintegrahospital ilike '%").append(exameHospital).append("%'");
            buf.append(" order by codigoExame ");
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                do {
                    ExameVO exameVO = (ExameVO)new ExameService().load(" where fil_codigo = " + filial + " and exa_codigo = '" + rs.getString("codigoExame") + "' ;").toArray()[0];
                    Registro registro = new Registro(rs);
                    registro.setValor("objetoExame", exameVO);
                    exames.add(registro);
                } while (rs.next());
            }
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return exames;
    }

    private static String getTextoSql(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return "null";
        }
        return "'" + StringUtil.textoDB(texto) + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacienteVO pacienteCadastrado(String filialPadrao, Long id) throws SQLException {
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        PacienteVO pacienteVO = null;
        try {
            rs = null;
            StringBuilder buf = new StringBuilder();
            buf.append(" select pac_codigoapoiado, pac_codigo ");
            buf.append(" from paciente ");
            buf.append(" where fil_codigo = ").append(filialPadrao);
            buf.append(" and pac_codigoapoiado = ").append(StringUtil.textoDBEscape(id.toString()));
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                pacienteVO = new PacienteVO();
                pacienteVO.setCodigo(rs.getInt("pac_codigo"));
            }
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return pacienteVO;
    }

    public Integer inserirPacienteJalis(String filialPadrao, PacienteVO pacienteJalis) throws IntegracaoHospitalException, SQLException {
        Integer sequencia = 0;
        if (pacienteJalis != null) {
            sequencia = this.getSequencia("paciente", filialPadrao);
            StringBuilder buf = new StringBuilder();
            buf.append(" insert into paciente(");
            buf.append("fil_codigo, ");
            buf.append("pac_codigo, ");
            buf.append("pac_nome,  ");
            buf.append("pac_sexo, ");
            buf.append("pac_altura, ");
            buf.append("pac_peso, ");
            buf.append("pac_datanasc, ");
            buf.append("pac_codigoapoiado, ");
            buf.append("pac_nomesocial, ");
            buf.append("pac_mae, ");
            buf.append("pac_fatorrh, ");
            buf.append("pac_grpsangue, ");
            buf.append("pac_cpf, ");
            buf.append("pac_rg, ");
            buf.append("pac_dadoclinico, ");
            buf.append("pac_fone, ");
            buf.append("pac_celular, ");
            buf.append("pac_fax, ");
            buf.append("pac_endereco ");
            buf.append(")");
            buf.append(" values(");
            buf.append(filialPadrao).append(", ");
            buf.append(sequencia).append(", ");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getNome())).append(", ");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getSexo())).append(", ");
            buf.append(pacienteJalis.getAltura()).append(", ");
            buf.append(pacienteJalis.getPeso()).append(", ");
            buf.append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", pacienteJalis.getDataNascimento()))).append(", ");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getCodigoApoiado())).append(", ");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getNomeSocial())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getNomeMae())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getFatorRH())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getGrupoSanguineo())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getCpf())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getRg())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getDadosClinicos())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getFone())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getCelular())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getFax())).append(",");
            buf.append(StringUtil.textoDBEscape(pacienteJalis.getEndereco()));
            buf.append(" ) ");
            Conexao.executeUpdate(filialPadrao, Conexao.getStatement(), buf.toString());
        }
        return sequencia;
    }

    private int getSequencia(String tabela, String filial) throws IntegracaoHospitalException, SQLException {
        HashMap<String, String> chaves = new HashMap<String, String>();
        chaves.put("Sequencia", tabela + "_" + filial + "_sequence");
        String comando = " select nextval('" + tabela + "_" + filial + "_sequence') as sequencia ";
        ResultSet rs = null;
        rs = Conexao.executeQuery(Conexao.getStatement(), comando);
        if (rs.next()) {
            return rs.getInt("sequencia");
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean medicoCadastrado(String filialPadrao, MedicoVO medico) throws SQLException {
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        boolean medicoCadastrado = false;
        try {
            rs = null;
            StringBuilder buf = new StringBuilder();
            buf.append(" select med_crm ");
            buf.append(" from medico ");
            buf.append(" where fil_codigo = ").append(filialPadrao);
            buf.append(" and med_crm = ").append(StringUtil.textoDBEscape(medico.getCrm().toString()));
            buf.append(" and med_uf = ").append(StringUtil.textoDBEscape(medico.getUf().toString()));
            buf.append(" and med_conselho = ").append(StringUtil.textoDBEscape(medico.getConselho().toString()));
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                medicoCadastrado = !Funcoes.textoVazio(rs.getString("med_crm"));
            }
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return medicoCadastrado;
    }

    public boolean inserirMedicoJalis(String filialPadrao, MedicoVO medico) throws IntegracaoHospitalException, SQLException {
        Statement st = ConexaoTemporaria.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("insert into medico (fil_codigo, med_crm, med_nome, med_uf, med_conselho) ");
        buf.append(" values ( ");
        buf.append(filialPadrao);
        buf.append(", ").append(SaluxDao.getTextoSql(medico.getCrm()));
        buf.append(", ").append(SaluxDao.getTextoSql(medico.getNome()));
        buf.append(", ").append(SaluxDao.getTextoSql(medico.getUf()));
        buf.append(", ").append(SaluxDao.getTextoSql(medico.getConselho()));
        buf.append(")");
        int qtd = ConexaoTemporaria.executeUpdate(filialPadrao, st, buf.toString(), true);
        if (qtd > 0) {
            ConexaoTemporaria.arquivaSQL();
            ConexaoTemporaria.fecharStatement(st);
            return true;
        }
        return false;
    }

    public Integer getCodigoRequisicao(String filialPadrao) throws IntegracaoHospitalException, SQLException {
        return this.getSequencia("requisicao", filialPadrao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insereRequisicao(RequisicaoVO requisicaoVO) throws IntegracaoHospitalException, SQLException {
        int sequencia = -1;
        Statement st = null;
        try {
            StringBuilder buf = new StringBuilder("");
            buf.append(" insert into requisicao(");
            buf.append("   fil_codigo ");
            buf.append("   ,req_codigo ");
            buf.append("   ,con_codigo ");
            buf.append("   ,med_crm ");
            buf.append("   ,med_conselho ");
            buf.append("   ,med_uf ");
            buf.append("   ,pac_codigo ");
            buf.append("   ,req_urgente ");
            buf.append("   ,req_avisarpaciente ");
            buf.append("   ,req_imprimirseparado ");
            buf.append("   ,req_obs ");
            buf.append("   ,req_totpago ");
            buf.append("   ,req_total ");
            buf.append("   ,req_vlrexames ");
            buf.append("   ,req_vlrmateriais ");
            buf.append("   ,req_data ");
            buf.append("   ,req_hora ");
            buf.append("   ,req_gestante ");
            buf.append("   ,req_neonato ");
            buf.append("   ,req_idade ");
            buf.append("   ,req_anomes ");
            buf.append("   ,req_desconto ");
            buf.append("   ,req_vlrdesconto ");
            buf.append("   ,req_acrescimo ");
            buf.append("   ,req_vlracrescimo ");
            buf.append("   ,req_telacoleta ");
            buf.append("   ,est_codigo ");
            buf.append("   ,usr_codigo ");
            buf.append("   ,req_datarequisicao ");
            buf.append("   ,usr_codabertura ");
            buf.append("   ,req_deveguia ");
            buf.append("   ,req_guia ");
            buf.append("   ,req_excluida ");
            buf.append("   ,req_dtfatura ");
            buf.append("   ,req_horafatura ");
            buf.append("   ,col_codigo ");
            buf.append("   ,des_codigo ");
            buf.append("   ,req_integracaohospital ");
            buf.append("   ,req_senhaweb ");
            buf.append("   ,req_codigoapoiado ");
            buf.append("   ,req_idsolicitacaosalux ");
            buf.append("   ) ");
            buf.append("   values (").append(requisicaoVO.getFilial().getCodigo().toString());
            buf.append("   ,").append(requisicaoVO.getCodigo().toString());
            buf.append("   ,").append(requisicaoVO.getConvenio().getCodigo());
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getMedico().getCrm()));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getMedico().getConselho()));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getMedico().getUf()));
            buf.append("   ,").append(requisicaoVO.getPaciente().getCodigo());
            buf.append("   ,").append(requisicaoVO.getUrgente());
            buf.append("   ,false ");
            buf.append("   ,false ");
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getObservacao()));
            buf.append("   ,0 ");
            buf.append("   ,").append(requisicaoVO.getTotal());
            buf.append("   ,").append(requisicaoVO.getValorExames());
            buf.append("   ,").append(requisicaoVO.getValorMateriais());
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", new Date())));
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("HH:mm:ss", new Date())));
            buf.append("   ,").append(requisicaoVO.getGestante());
            buf.append("   ,false ");
            buf.append("   ,").append(requisicaoVO.getPaciente().getIdade() == null ? "0" : requisicaoVO.getPaciente().getIdade());
            buf.append("   ,").append(StringUtil.textoDBEscape("A"));
            buf.append("   ,0 ");
            buf.append("   ,0 ");
            buf.append("   ,0 ");
            buf.append("   ,0 ");
            buf.append("   ,false ");
            buf.append("   ,").append(requisicaoVO.getEstacao().getCodigo().toString());
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
            buf.append("   ,LOCALTIMESTAMP ");
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
            buf.append("   ,false ");
            buf.append("   ,null ");
            buf.append("   ,false ");
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", new Date())));
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("HH:mm:ss", new Date())));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getColeta().getCodigo()));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getDestino().getCodigo()));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getIntegracaoHospital()));
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.gerarSenhaWeb()));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getCodigoApoiado()));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getIdSolicitacaoSalux()));
            buf.append("   ) ");
            st = Conexao.getStatement();
            Conexao.executeUpdate(requisicaoVO.getFilial().getCodigo().toString(), st, buf.toString(), true);
            Conexao.arquivaSQL();
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return sequencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inserirExameRequisicaoJalis(String filialPadrao, RequisicaoVO requisicaoVO, ExameRequisicaoVO exameRequisicao, Integer ordem) throws SQLException {
        Statement st = null;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" insert into examerequisicao ");
            buf.append("   (fil_codigo ");
            buf.append("   ,req_codigo ");
            buf.append("   ,exa_codigo ");
            buf.append("   ,mco_codigo ");
            buf.append("   ,exr_dataetqcoleta ");
            buf.append("   ,exr_situacao ");
            buf.append("   ,exr_excluido ");
            buf.append("   ,exr_obs ");
            buf.append("   ,usr_codigo ");
            buf.append("   ,exr_data ");
            buf.append("   ,exr_vlrch ");
            buf.append("   ,exr_vlrbalcaoconvenio ");
            buf.append("   ,exr_vlrchexame ");
            buf.append("   ,exr_vlrexame ");
            buf.append("   ,exr_vlrmaterial ");
            buf.append("   ,exr_dataentregaprev ");
            buf.append("   ,exr_descricaomaterial ");
            buf.append("   ,exr_datacoletar ");
            buf.append("   ,usr_codcoletar ");
            buf.append("   ,met_codigo ");
            buf.append("   ,exr_volumediurese ");
            buf.append("   ,exr_codigoapoiado ");
            buf.append("   ,exr_datamaterial ");
            buf.append("   ,usr_codmaterial ");
            buf.append("   ,exr_autorizar ");
            buf.append("   ,exr_naofaturar ");
            buf.append("   ,usr_codnaofaturar ");
            buf.append("   ,exr_ordem ");
            buf.append("   ,usr_codguia ");
            buf.append("   ,exr_deveguia ");
            buf.append("   ,exr_dataguia ");
            buf.append("   ,exr_avisarentrega ");
            buf.append("   ,exr_custosimples ");
            buf.append("   ,exr_solicitadotiss ");
            buf.append("   ,exr_coletaincorreta ");
            buf.append("   ,exr_interfaciado ");
            buf.append("   ,exr_matexterno ");
            buf.append("   ,exr_urgente ");
            buf.append("   ,exr_sequencialsalux ");
            buf.append("   ) ");
            buf.append("   values (").append(exameRequisicao.getFilial().getCodigo());
            buf.append("   ,").append(requisicaoVO.getCodigo());
            buf.append("   ,").append(StringUtil.textoDBEscape(exameRequisicao.getExame().getCodigo()));
            buf.append("   ,").append(exameRequisicao.getMaterial().getCodigo());
            buf.append("   ,null ");
            buf.append("   ,").append(StringUtil.textoDBEscape("T"));
            buf.append("   ,false ");
            buf.append("   ,").append(StringUtil.textoDBEscape(exameRequisicao.getObservacao()));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSSZ", exameRequisicao.getData())));
            buf.append("   ,").append(exameRequisicao.getValorCh());
            buf.append("   ,").append(exameRequisicao.getPercentualBalcao());
            buf.append("   ,").append(exameRequisicao.getValorChExame());
            buf.append("   ,").append(exameRequisicao.getValorExame());
            buf.append("   ,").append(exameRequisicao.getValorMaterial());
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSSZ", exameRequisicao.getDataEntregaPrevista())));
            buf.append("   ,").append(StringUtil.textoDBEscape(exameRequisicao.getMaterial().getDescricao()));
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSSZ", exameRequisicao.getDataColetar())));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
            buf.append("   ,").append(exameRequisicao.getMetodologia().getCodigo());
            buf.append("   ,").append(exameRequisicao.getVolumeDiurese());
            buf.append("   ,'").append(exameRequisicao.getCodigoApoiado()).append("'");
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", exameRequisicao.getDataMaterial())));
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
            buf.append("   ,").append(exameRequisicao.getAutorizar());
            buf.append("   ,").append(exameRequisicao.getNaoFaturar());
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
            buf.append("   ,").append(ordem);
            buf.append("   ,").append(StringUtil.textoDBEscape(requisicaoVO.getUsuario().getCodigo()));
            buf.append("   ,").append(exameRequisicao.getDeveGuia());
            buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSSZ", new Date())));
            buf.append("   ,").append(exameRequisicao.getAvisarEntrega());
            buf.append("   ,").append(BigDecimal.ZERO);
            buf.append("   ,").append(Boolean.FALSE);
            buf.append("   ,").append(Boolean.FALSE);
            buf.append("   ,").append(Boolean.FALSE);
            buf.append("   ,").append(Boolean.FALSE);
            buf.append("   ,").append(Boolean.FALSE);
            buf.append("   ,").append(exameRequisicao.getSequencialSalux());
            buf.append("   ) ");
            st = ConexaoTemporaria.getStatement();
            ConexaoTemporaria.executeUpdate(requisicaoVO.getFilial().getCodigo().toString(), st, buf.toString(), true);
            DBUtil.gravaLogSituacaoExameRequisicao(st, filialPadrao, "" + requisicaoVO.getCodigo(), exameRequisicao.getExame().getCodigo(), "" + exameRequisicao.getMaterial().getCodigo(), "T", true);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (Throwable throwable) {
            ConexaoTemporaria.fecharStatement(st);
            throw throwable;
        }
        ConexaoTemporaria.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvenioVO buscaConvenios(String filialPadrao, String idPlanoSaude, String codigoConvenio) throws SQLException {
        ResultSet rs = null;
        ConvenioVO convenioVO = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select con_codigo, con_integracaohospital, col_codigo, des_codigo  ");
            buf.append(" from convenios ");
            buf.append(" where fil_codigo = ").append(filialPadrao);
            if (!Funcoes.textoVazio(idPlanoSaude)) {
                buf.append(" and con_integracaohospital ilike '%").append(idPlanoSaude.trim()).append("%'");
            }
            if (!Funcoes.textoVazio(codigoConvenio)) {
                buf.append(" and con_codigo =").append(codigoConvenio.trim());
            }
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                convenioVO = new ConvenioVO();
                convenioVO.setCodigo(rs.getInt("con_codigo"));
                convenioVO.setIntegracaoHospital(rs.getString("con_integracaohospital"));
                ColetaVO coleta = new ColetaVO();
                coleta.setCodigo(rs.getString("col_codigo"));
                convenioVO.setColeta(coleta);
                DestinoVO destino = new DestinoVO();
                destino.setCodigo(rs.getString("des_codigo"));
                convenioVO.setDestino(destino);
            }
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return convenioVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequisicaoVO pesquisarRequisicao(String filial, String idSolicitacaoSalux) throws SQLException {
        ResultSet rs = null;
        RequisicaoVO requisicao = new RequisicaoVO();
        try {
            Statement st = Conexao.getStatement();
            StringBuilder sql = new StringBuilder(" select ");
            sql.append(" r.fil_codigo, r.req_codigo, er.exa_codigo, er.mco_codigo, r.con_codigo, e.exa_descricao, r.usr_codigo ");
            sql.append(" from requisicao r ");
            sql.append(" left join examerequisicao er on r.fil_codigo = er.fil_codigo and r.req_codigo = er.req_codigo ");
            sql.append(" left join exames e on r.fil_codigo = e.fil_codigo and er.exa_codigo = e.exa_codigo ");
            sql.append(" where r.fil_codigo = ").append(filial);
            sql.append(" and r.req_idsolicitacaosalux = '").append(idSolicitacaoSalux.trim()).append("'");
            rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
            ArrayList<ExameRequisicaoVO> exames = new ArrayList<ExameRequisicaoVO>();
            while (rs.next()) {
                ConvenioVO convenio = new ConvenioVO();
                convenio.setCodigo(rs.getInt("con_codigo"));
                UsuarioVO usuario = new UsuarioVO();
                usuario.setCodigo(rs.getString("usr_codigo"));
                FilialVO fil = new FilialVO();
                fil.setCodigo(rs.getInt("fil_codigo"));
                requisicao.setUsuario(usuario);
                requisicao.setConvenio(convenio);
                requisicao.setCodigo(rs.getInt("req_codigo"));
                requisicao.setFilial(fil);
                ExameRequisicaoVO exameRequisicao = new ExameRequisicaoVO();
                ExameVO exame = new ExameVO();
                exame.setFilial(fil);
                exame.setCodigo(rs.getString("exa_codigo"));
                exame.setDescricao(rs.getString("exa_descricao"));
                MaterialColetaVO material = new MaterialColetaVO();
                material.setCodigo(rs.getInt("mco_codigo"));
                exameRequisicao.setFilial(fil);
                exameRequisicao.setRequisicao(rs.getInt("req_codigo"));
                exameRequisicao.setExame(exame);
                exameRequisicao.setMaterial(material);
                if (exame.getCodigo() == null) continue;
                exames.add(exameRequisicao);
            }
            requisicao.setExames(exames);
        }
        finally {
            rs.close();
            Conexao.anulaSQL();
        }
        return requisicao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer insereIntegracaoHospital(String filial, String tipoOperacao, String operacao, String reqCodigo, String exaCodigo, String mcoCodigo, String retorno) throws XMLStringBuilderException, SQLException {
        StringBuilder bufs = new StringBuilder();
        bufs.append("select nextval('exportaintegracaohospital_").append(Integer.parseInt(filial)).append("_sequence') ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        Integer codigo = 0;
        try {
            if (st != null) {
                rs = st.executeQuery(bufs.toString());
                rs.next();
                codigo = rs.getInt("nextval");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaohospital ");
        buf.append("            (fil_codigo, eih_codigo, eih_datahora, eih_operacao, eih_tipooperacao, req_codigo, exa_codigo, mco_codigo, eih_exportado) ");
        buf.append("     values (").append(filial);
        buf.append(" , ").append(codigo);
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(operacao).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , ").append(Funcoes.textoVazio(reqCodigo) ? "null" : reqCodigo).append(" ");
        buf.append(" , '").append(exaCodigo).append("' ");
        buf.append(" , ").append(Funcoes.textoVazio(mcoCodigo) ? "null" : mcoCodigo).append(" ");
        buf.append(" , false) ");
        st = ConexaoTemporaria.getStatement();
        try {
            ConexaoTemporaria.executeUpdate(filial, st, buf);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return codigo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer getSequenceIntegracaoHospital(String filial) {
        StringBuilder bufs = new StringBuilder();
        bufs.append("select nextval('exportaintegracaohospital_").append(Integer.parseInt(filial)).append("_sequence') ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        Integer codigo = 0;
        try {
            rs = st.executeQuery(bufs.toString());
            rs.next();
            codigo = rs.getInt("nextval");
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e1.getMessage(), e1.getStackTrace());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ConexaoTemporaria.fecharStatement(st);
        }
        return codigo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarLogHospital(String codFilial, String codLog, String retorno, String situacao) {
        StringBuilder bufs = new StringBuilder();
        bufs.append("select fil_codigo, eih_codigo, eih_datahora, eih_operacao ");
        bufs.append("from exportaintegracaohospital where fil_codigo = ").append(codFilial);
        bufs.append("and eih_codigo = ").append(codLog);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, bufs.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (rs != null && rs.next()) {
                if (this.existeLogIntegracaoHospital(codLog, codFilial) <= 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" insert into  logexportaintegracaohospital(fil_codigo, eih_codigo,");
                    buf.append("lei_datahora, lei_situacao, lei_retorno)values('");
                    buf.append(codFilial).append("','");
                    buf.append(codLog).append("',");
                    buf.append("current_timestamp").append(",'");
                    buf.append(situacao).append("','");
                    buf.append(retorno).append("')");
                    st = ConexaoTemporaria.getStatement();
                    ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    ConexaoTemporaria.arquivaSQL();
                } else {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update logexportaintegracaohospital set '");
                    buf.append(" lei_situacao = '").append(situacao).append("', ");
                    buf.append(" lei_retorno = '").append(retorno).append("', ");
                    buf.append(" lei_datahora = current_timestamp");
                    buf.append(" where ");
                    buf.append(" fil_codigo = ").append(codFilial);
                    buf.append(" and eih_codigo = ").append(codLog);
                    st = ConexaoTemporaria.getStatement();
                    ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    ConexaoTemporaria.arquivaSQL();
                }
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private Integer existeLogIntegracaoHospital(String codLog, String codFilial) {
        String dataEnvio = Funcoes.getDataHora();
        StringBuilder buf = new StringBuilder();
        buf.append(" select lei_codigo from logexportaintegracaohospital ");
        buf.append("where eih_codigo = ");
        buf.append(codLog);
        buf.append(" and fil_codigo = ").append(codFilial);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            return rs.next() ? rs.getInt("lei_codigo") : 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String consultarLogInteggracao(Long log, Integer filial) {
        String codigoSolicitacao = "";
        StringBuilder buf = new StringBuilder();
        buf.append(" select lei_retorno from logexportaintegracaohospital ");
        buf.append("where eih_codigo = ");
        buf.append(log);
        buf.append(" and fil_codigo = ").append(filial);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                codigoSolicitacao = rs.getString("lei_retorno");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return codigoSolicitacao;
    }

    public String getHashFromExameRequisicaoHash(String codigoFilial, String codigoRequisicao, String codigoExame, String codigomaterialColetado) {
        String hash = "";
        StringBuilder sql = new StringBuilder();
        sql.append("select exh_hash from examerequisicaohash ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codigoFilial);
        sql.append(" and req_codigo = ").append(codigoRequisicao);
        sql.append(" and exa_codigo = '").append(codigoExame).append("'");
        sql.append(" and mco_codigo = ").append(codigomaterialColetado);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, sql.toString());
            if (rs.next()) {
                hash = rs.getString("exh_hash");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public String getIdProcedimento(String codFilial, String codExame, String codMaterial) {
        String idProcedimento = "";
        StringBuilder sql = new StringBuilder();
        sql.append("select emc_xmlintegrahospital from examematcoleta ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, sql.toString());
            if (rs.next()) {
                idProcedimento = StringUtil.getValor(rs.getString("emc_xmlintegrahospital"), "idExame");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idProcedimento.trim();
    }

    public String getIdSolicitacao(String codFilial, String codRequisicao) {
        String idSolicitacao = "";
        StringBuilder sql = new StringBuilder();
        sql.append("select req_idsolicitacaosalux from requisicao ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, sql.toString());
            if (rs.next()) {
                idSolicitacao = rs.getString("req_idsolicitacaosalux");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idSolicitacao.trim();
    }

    public Integer getSequencialExame(String codFilial, String codRequisicao, String codExame, String codMaterial) {
        Integer sequencialExame = 0;
        StringBuilder sql = new StringBuilder();
        sql.append("select exr_sequencialSalux from examerequisicao  ");
        sql.append(" where ");
        sql.append(" exr_excluido = false  ");
        sql.append(" and fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, sql.toString());
            if (rs.next()) {
                sequencialExame = rs.getInt("exr_sequencialSalux");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sequencialExame;
    }

    public List<Registro> recuperarLogExportaIntegracaoHospital() throws SQLException {
        ArrayList<Registro> logs = new ArrayList<Registro>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select * from exportaintegracaohospital ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and eih_exportado = false ");
        sql.append(" order by eih_codigo ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = ConexaoTemporaria.executeQuery(st, sql.toString());
        while (rs.next()) {
            String operacao = rs.getString("eih_operacao");
            if (!this.logContemProtocoloSalux(operacao)) continue;
            logs.add(new Registro(rs));
        }
        rs.close();
        ConexaoTemporaria.fecharStatement(st);
        return logs;
    }

    private boolean logContemProtocoloSalux(String operacao) {
        String protocolo;
        return !Funcoes.textoVazio(operacao) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(operacao, "NomeIntegracaoHospital", true).trim()) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.SALUX.getNome());
    }

    public Registro recuperarDatasExameRequisicao(String codFilial, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        StringBuilder sql = new StringBuilder(" select ");
        sql.append("exr_datadigita as datadigitacao, ");
        sql.append("exr_dataassina as dataliberacao ");
        sql.append("from examerequisicao ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        rs = ConexaoTemporaria.executeQuery(st, sql.toString());
        Registro registro = new Registro();
        if (rs.next()) {
            registro.carregar(rs);
        }
        rs.close();
        ConexaoTemporaria.fecharStatement(st);
        return registro;
    }

    public void atualizarLogEnviadoComSucesso(String codFilial, String codLog) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" update exportaintegracaohospital set eih_exportado = true ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and eih_codigo = ").append(codLog);
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codFilial, st, sql.toString());
        sql.delete(0, sql.length());
        sql.append(" update logexportaintegracaohospital set lei_situacao = 'I' ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and eih_codigo = ").append(codLog);
        Statement statement = Conexao.getStatement();
        Conexao.executeUpdate(codFilial, st, sql.toString());
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(statement);
    }

    public void atualizarDataInicioColeta(String codFilial, String codRequisicao, String idSolicitacao) throws SQLException {
        StringBuilder sql = new StringBuilder(" update requisicao set req_datainiciocoletasalux = current_timestamp ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and req_idsolicitacaosalux = '").append(idSolicitacao).append("'");
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codFilial, st, sql.toString());
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
    }

    public boolean exameTemRecoleta(String codFilial, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        StringBuilder sql = new StringBuilder(" select ");
        sql.append("req_codigo ");
        sql.append("from examerequisicaosituacoes ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        sql.append(" and ers_situacao = 'R'");
        sql.append(" limit 1 ");
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        rs = ConexaoTemporaria.executeQuery(st, sql.toString());
        if (rs.next()) {
            return true;
        }
        rs.close();
        ConexaoTemporaria.fecharStatement(st);
        return false;
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }
}

