/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.salux;

import jalis.integracaohospitais.util.AbstractConfiguradorExamesIntegracaoHospital;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorExamesSalux
extends AbstractConfiguradorExamesIntegracaoHospital
implements WindowListener {
    public static String TAG_EXPORTACAOSALUX = "exportarSalux";
    public static String TAG_IDEXAME = "idExame";
    public static String TAG_IDMATERIAL = "idMaterial";
    private JPanel panelImportacao = new JPanel();
    private JLabel labelIdExame = new JLabel("ID Exame:");
    private JLabel labelIdMaterial = new JLabel("ID Material:");
    private TTextField textIdExame = new TTextField(255, 3);
    private TTextField textIdMaterial = new TTextField(6, 3);
    private String xmlIntegracaoHospital = "";

    public static ConfiguradorExamesSalux novaInstancia(Window pai, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        if (pai instanceof Frame) {
            return new ConfiguradorExamesSalux((Frame)pai, "Associando campos de resultados - SALUX", xmlIntegracaoHospital, xmlAssociacaoCampos);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorExamesSalux((Dialog)pai, "Associando campos de resultados - SALUX", xmlIntegracaoHospital, xmlAssociacaoCampos);
        }
        return null;
    }

    public ConfiguradorExamesSalux(Dialog pai, String titulo, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        super(pai, titulo, xmlIntegracaoHospital, xmlAssociacaoCampos);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.montaTela();
        this.carregarDados();
    }

    public ConfiguradorExamesSalux(Frame pai, String titulo, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        super(pai, titulo, xmlIntegracaoHospital, xmlAssociacaoCampos);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.montaTela();
    }

    private void carregarDados() {
        if (!Funcoes.textoVazio(this.xmlIntegracaoHospital)) {
            String idExame = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_IDEXAME);
            String idMaterial = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_IDMATERIAL);
            this.textIdExame.setText(idExame.trim());
            this.textIdMaterial.setText(idMaterial.trim());
        }
    }

    private void montaTela() {
        this.panelImportacao.setLayout(new GridBagLayout());
        this.panelImportacao.setBorder(new TitledBorder("Importa\u00e7\u00e3o"));
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.setSize(new Dimension(350, 130));
        ScreenUtil.centralizar(this);
        this.textIdExame.setMinimumSize(new Dimension(150, 20));
        this.textIdExame.setPreferredSize(new Dimension(150, 20));
        this.textIdMaterial.setMinimumSize(new Dimension(150, 20));
        this.textIdMaterial.setPreferredSize(new Dimension(150, 20));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelImportacao.add((Component)this.labelIdExame, c);
        ++c.gridx;
        this.panelImportacao.add((Component)this.labelIdMaterial, c);
        c.gridx = 0;
        ++c.gridy;
        this.panelImportacao.add((Component)this.textIdExame, c);
        ++c.gridx;
        this.panelImportacao.add((Component)this.textIdMaterial, c);
        ++c.gridx;
        this.panelImportacao.add((Component)new JPanel(), c);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.panelImportacao, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK && this.validaCampos()) {
            this.dispose();
            this.ok = true;
        } else if (e.getSource() == this.buttonCancelar) {
            this.textIdExame.clear();
            this.textIdMaterial.clear();
            this.ok = false;
            this.dispose();
        }
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textIdExame)) {
            Funcoes.mensagem(this, "O ID do Exame do Hospital deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textIdExame);
            return false;
        }
        if (Funcoes.textoVazio(this.textIdMaterial)) {
            Funcoes.mensagem(this, "O ID do Material do Hospital deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textIdMaterial);
            return false;
        }
        return true;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (Funcoes.textoVazio(this.textIdExame) && Funcoes.textoVazio(this.textIdMaterial)) {
            return this.xmlIntegracaoHospital;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_EXPORTACAOSALUX);
            xml.abrir(TAG_IDEXAME);
            xml.escrever(this.textIdExame.getText().trim());
            xml.fechar(TAG_IDEXAME);
            xml.abrir(TAG_IDMATERIAL);
            xml.escrever(this.textIdMaterial.getText().trim());
            xml.fechar(TAG_IDMATERIAL);
            xml.fechar(TAG_EXPORTACAOSALUX);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Erro ao gerar XML.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        return xml.toString();
    }

    @Override
    public String getXmlAssociacaoCampos() {
        return null;
    }
}

