/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.salux;

import jalis.integracaohospitais.util.AbstractConfiguradorConveniosIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class ConfiguradorConvenioSalux
extends AbstractConfiguradorConveniosIntegracaoHospital {
    private static final String TITULO = "Configurando integra\u00e7\u00e3o SALUX";
    private TTextField textEstacao = new TTextField(10, 1);
    private JLabel lblEstacaoDescricao = new JLabel();
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JButton buttonPesquisa = new JButton();
    private JLabel labelWebService = new JLabel("WebService Cadastro:");
    private TTextField textWebService = new TTextField();
    private JLabel labelWebServiceSadt = new JLabel("WebService SADT:");
    private TTextField textWebServiceSadt = new TTextField();
    private TTextField textLogin = new TTextField();
    private JLabel labelLogin = new JLabel("Login:");
    private TTextField textSenha = new TTextField();
    private JLabel labelSenha = new JLabel("Senha:");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"ID Plano"});
    private JTable tableConvenio = new JTable(this.modelo);
    private JScrollPane scrollConvenio = new JScrollPane(this.tableConvenio);
    private JButton buttonOkConv = ComponenteFactory.novoJButton("OK", 'O', this);
    private JLabel lblIdPlanoHospital = new JLabel("ID Plano Hospital:");
    private TTextField textId = new TTextField(3, 1);
    public static final String TAG_ESTACAOINTEGRADORA = "estacaoIntegradora";
    public static final String TAG_WEBSERVICECADASTRO = "webServiceCadastro";
    public static final String TAG_WEBSERVICESADT = "webServiceSADT";
    public static final String TAG_LOGIN = "login";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_CONVENIOS = "convenios";
    public static final String TAG_CONVENIO = "convenio";
    public static final String TAG_PLANOSAUDE = "planoSaude";
    public static final String TAG_IDPLANO = "idPlano";
    private String codigoConvenio;

    public static AbstractConfiguradorConveniosIntegracaoHospital novaInstancia(Object pai, String xmlIntegracaoHospital) {
        if (pai instanceof Frame) {
            return new ConfiguradorConvenioSalux((Frame)pai, TITULO, xmlIntegracaoHospital);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorConvenioSalux((Dialog)pai, TITULO, xmlIntegracaoHospital);
        }
        return null;
    }

    public ConfiguradorConvenioSalux(Frame pai, String titulo, String xmlIntegracaoHospital) {
        super(pai, titulo, xmlIntegracaoHospital);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.montaTela();
    }

    public ConfiguradorConvenioSalux(Dialog pai, String titulo, String xmlIntegracaoHospital) {
        super(pai, titulo, xmlIntegracaoHospital);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.montaTela();
    }

    private void montaTela() {
        JPanel panelPrincipal = this.getPanelCentral();
        JPanel panelNorte = new JPanel();
        JPanel panelSul = new JPanel(new BorderLayout());
        panelNorte.setLayout(new GridBagLayout());
        Funcoes.imagemPesquisa(this.buttonPesquisa);
        this.setUsuarioPodeCancelar(false);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        ScreenUtil.setBorda(new Component[]{this.lblEstacaoDescricao}, new TitledBorder(""));
        Funcoes.montaEnter((JComponent)panelPrincipal);
        Dimension tamanhoCaixaTexto = new Dimension(390, 20);
        Dimension tamanhoBotao = new Dimension(30, 20);
        Dimension tamanhoCaixaTextoMenor = new Dimension(70, 20);
        this.textEstacao.setMinimumSize(tamanhoCaixaTextoMenor);
        this.textEstacao.setPreferredSize(tamanhoCaixaTextoMenor);
        this.lblEstacaoDescricao.setMinimumSize(new Dimension(287, 20));
        this.lblEstacaoDescricao.setPreferredSize(new Dimension(287, 20));
        this.textWebService.setMinimumSize(tamanhoCaixaTexto);
        this.textWebService.setPreferredSize(tamanhoCaixaTexto);
        this.textWebServiceSadt.setMinimumSize(tamanhoCaixaTexto);
        this.textWebServiceSadt.setPreferredSize(tamanhoCaixaTexto);
        this.textLogin.setMinimumSize(tamanhoCaixaTexto);
        this.textLogin.setPreferredSize(tamanhoCaixaTexto);
        this.textSenha.setMinimumSize(tamanhoCaixaTexto);
        this.textSenha.setPreferredSize(tamanhoCaixaTexto);
        this.textId.setPreferredSize(tamanhoCaixaTextoMenor);
        this.textId.setMinimumSize(tamanhoCaixaTextoMenor);
        this.buttonPesquisa.setMinimumSize(tamanhoBotao);
        this.buttonPesquisa.setPreferredSize(tamanhoBotao);
        this.buttonOkConv.setMinimumSize(new Dimension(40, 20));
        this.buttonOkConv.setPreferredSize(new Dimension(40, 20));
        panelNorte.setSize(new Dimension(550, 320));
        this.modelo.setColumnSize(new int[]{0}, this.tableConvenio);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 0, 0);
        this.labelEstacao.setDisplayedMnemonic('o');
        this.labelEstacao.setLabelFor(this.textEstacao);
        panelNorte.add((Component)this.labelEstacao, c);
        ++c.gridx;
        panelNorte.add((Component)this.textEstacao, c);
        ++c.gridx;
        panelNorte.add((Component)this.buttonPesquisa, c);
        ++c.gridx;
        c.gridwidth = 1;
        panelNorte.add((Component)this.lblEstacaoDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        panelNorte.add((Component)this.labelWebService, c);
        ++c.gridx;
        c.gridwidth = 8;
        panelNorte.add((Component)this.textWebService, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        panelNorte.add((Component)this.labelWebServiceSadt, c);
        ++c.gridx;
        c.gridwidth = 8;
        panelNorte.add((Component)this.textWebServiceSadt, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        panelNorte.add((Component)this.labelLogin, c);
        ++c.gridx;
        c.gridwidth = 8;
        panelNorte.add((Component)this.textLogin, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        panelNorte.add((Component)this.labelSenha, c);
        ++c.gridx;
        c.gridwidth = 9;
        panelNorte.add((Component)this.textSenha, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panelNorte.add((Component)this.lblIdPlanoHospital, c);
        ++c.gridx;
        c.gridwidth = 8;
        panelNorte.add((Component)this.textId, c);
        ++c.gridx;
        c.gridwidth = 2;
        panelNorte.add((Component)this.buttonOkConv, c);
        panelPrincipal.setLayout(new BorderLayout());
        panelPrincipal.add((Component)panelNorte, "North");
        panelSul.add((Component)this.scrollConvenio, "Center");
        panelPrincipal.add((Component)panelSul, "Center");
        this.setSize(new Dimension(550, 320));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textEstacao);
        this.buttonOkConv.addActionListener(this);
        this.carregarDados();
        this.carregarEventos();
    }

    private void carregarEventos() {
        this.buttonPesquisa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorConvenioSalux.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                ConfiguradorConvenioSalux.this.textEstacao.clear();
                ConfiguradorConvenioSalux.this.lblEstacaoDescricao.setText("");
                if (estacaoVO != null) {
                    ConfiguradorConvenioSalux.this.textEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorConvenioSalux.this.lblEstacaoDescricao.setText(estacaoVO.getDescricao());
                }
            }
        });
        this.textEstacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(ConfiguradorConvenioSalux.this.textEstacao.getText())) {
                    ConfiguradorConvenioSalux.this.buscaEstacao(ConfiguradorConvenioSalux.this.textEstacao.getText());
                }
            }
        });
        this.tableConvenio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ConfiguradorConvenioSalux.this.tableConvenio.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(ConfiguradorConvenioSalux.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    int posicao = ConfiguradorConvenioSalux.this.tableConvenio.getSelectedRow();
                    ConfiguradorConvenioSalux.this.modelo.removeLine(posicao);
                }
            }
        });
        this.textEstacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfiguradorConvenioSalux.this.pesquisaEstacao();
                }
            }
        });
    }

    private void carregarDados() {
        if (!Funcoes.textoVazio(this.xmlIntegracaoHospital)) {
            String estacao = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_ESTACAOINTEGRADORA);
            String webService = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_WEBSERVICECADASTRO);
            String webServiceSadt = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_WEBSERVICESADT);
            String login = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_LOGIN);
            String senha = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_SENHA);
            String convenios = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_CONVENIOS);
            String[] planoSaude = StringUtil.getValores(convenios, TAG_PLANOSAUDE);
            if (!Funcoes.textoVazio(estacao)) {
                this.textEstacao.setText(estacao);
                this.buscaEstacao(estacao);
            }
            if (!Funcoes.textoVazio(webService)) {
                this.textWebService.setText(webService);
            }
            if (!Funcoes.textoVazio(webServiceSadt)) {
                this.textWebServiceSadt.setText(webServiceSadt);
            }
            if (!Funcoes.textoVazio(login)) {
                this.textLogin.setText(login);
            }
            if (!Funcoes.textoVazio(senha)) {
                this.textSenha.setText(senha);
            }
            for (String plano : planoSaude) {
                String plan = StringUtil.getValor(plano, TAG_IDPLANO);
                this.modelo.addLine(new String[]{plan});
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK && this.validaCampos()) {
            this.ok = true;
            this.dispose();
        }
        if (e.getSource() == this.buttonPesquisa) {
            EstacaoService estacaoService = new EstacaoService();
            EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
            this.textEstacao.clear();
            this.lblEstacaoDescricao.setText("");
            if (estacaoVO != null) {
                this.textEstacao.setText(estacaoVO.getCodigo().toString());
                this.lblEstacaoDescricao.setText(estacaoVO.getDescricao());
            }
        }
        if (e.getSource() == this.buttonCancelar) {
            this.dispose();
        }
        if (e.getSource() == this.buttonOkConv) {
            this.adicionarPlanoSaude();
        }
    }

    private void adicionarPlanoSaude() {
        if (!Funcoes.textoVazio(this.textId)) {
            boolean encontrado = false;
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                String idPlano = (String)this.modelo.getValueAt(i, 0);
                if (!idPlano.equals(this.textId.getText())) continue;
                encontrado = true;
                break;
            }
            if (!encontrado) {
                this.modelo.addLine(new Object[]{this.textId.getText()});
            }
            this.textId.clear();
            ScreenUtil.requisitarFoco(this.textId);
        }
    }

    private void pesquisaEstacao() {
        this.textEstacao.clear();
        this.lblEstacaoDescricao.setText("");
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.textEstacao.setText(estacaoVO.getCodigo().toString());
            this.lblEstacaoDescricao.setText(estacaoVO.getDescricao());
        }
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.textEstacao.clear();
            this.lblEstacaoDescricao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.textEstacao.setText(estacaoVO.getCodigo().toString());
                this.lblEstacaoDescricao.setText(estacaoVO.getDescricao());
                ScreenUtil.requisitarFoco(this.textWebService);
            } else {
                this.lblEstacaoDescricao.setText("N\u00e3o cadastrado");
                ScreenUtil.requisitarFoco(this.textEstacao);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Erro ao buscar esta\u00e7\u00e3o.", e.getStackTrace());
            this.textEstacao.clear();
            this.lblEstacaoDescricao.setText("");
            ScreenUtil.requisitarFoco(this.textEstacao);
        }
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textEstacao.getText()) || this.lblEstacaoDescricao.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.textLogin.getText())) {
            Funcoes.mensagem(this, "O Login de acesso do Laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textLogin);
            return false;
        }
        if (Funcoes.textoVazio(this.textSenha.getText())) {
            Funcoes.mensagem(this, "A Senha de acesso do Laborat\u00f3rio deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.textWebService.getText())) {
            Funcoes.mensagem(this, "O endere\u00e7o do WebService Cadastros deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textWebService);
            return false;
        }
        if (Funcoes.textoVazio(this.textWebServiceSadt.getText())) {
            Funcoes.mensagem(this, "O endere\u00e7o do WebService SADT deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textWebServiceSadt);
            return false;
        }
        return true;
    }

    public Integer getCodigoConvenio() {
        return 0;
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (this.getCodigoConvenio() != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append("xmlconveniohospital").append(">");
            buf.append("<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.SALUX.getNome()).append("</").append("protocolo").append(">");
            buf.append("<").append(TAG_ESTACAOINTEGRADORA).append(">").append(this.textEstacao.getText()).append("</").append(TAG_ESTACAOINTEGRADORA).append(">");
            buf.append("<").append(TAG_WEBSERVICECADASTRO).append(">").append(this.textWebService.getText()).append("</").append(TAG_WEBSERVICECADASTRO).append(">");
            buf.append("<").append(TAG_WEBSERVICESADT).append(">").append(this.textWebServiceSadt.getText()).append("</").append(TAG_WEBSERVICESADT).append(">");
            buf.append("<").append(TAG_LOGIN).append(">").append(this.textLogin.getText()).append("</").append(TAG_LOGIN).append(">");
            buf.append("<").append(TAG_CONVENIO).append(">").append("").append("</").append(TAG_CONVENIO).append(">");
            buf.append("<").append(TAG_SENHA).append(">").append(this.textSenha.getText()).append("</").append(TAG_SENHA).append(">");
            buf.append("<").append(TAG_CONVENIOS).append(">");
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                String codigoPlano = (String)this.modelo.getValueAt(i, 0);
                buf.append("<").append(TAG_PLANOSAUDE).append(">");
                buf.append("<").append(TAG_IDPLANO).append(">").append(codigoPlano).append("</").append(TAG_IDPLANO).append(">");
                buf.append("</").append(TAG_PLANOSAUDE).append(">");
            }
            buf.append("</").append(TAG_CONVENIOS).append(">");
            buf.append("</").append("xmlconveniohospital").append(">");
            return buf.toString();
        }
        return null;
    }

    public void setCodigoConvenio(String codigoConvenio) {
        this.codigoConvenio = codigoConvenio;
    }
}

