/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.mv;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.integracaohospitais.DadosIntegracaoHospitalBean;
import jalis.model.utils.ThreadDaoException;
import jalis.service.integracaohospitais.DadosIntegracaoHospitalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class JanelaAssociacaoGermes
extends AbstractDialogoOKCancelar {
    private static final int COLUNA_GERME = 0;
    private static final int COLUNA_CODIGO_MV = 1;
    private JLabel labelGermeDescricao = new JLabel("Descri\u00e7\u00e3o germe");
    private JLabel labelGermeCodigoMV = new JLabel("C\u00f3digo MV");
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private TTextField textGermeDescricao = new TTextField(300, 3);
    private TTextField textGermeCodigoMV = new TTextField(4, 1);
    private TTextField textLocalizar = new TTextField(50, 3);
    private JButton buttonOkAssociacao = new JButton("OK");
    private ModeloGridTable modeloAssoaciacao = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o Germe", "C\u00f3digo MV"});
    private JTable tableAssociacao = new JTable(this.modeloAssoaciacao);
    private JScrollPane scrollAssociacao = new JScrollPane(this.tableAssociacao);
    private JPanel panelPesquisa = new JPanel(new BorderLayout());
    private int linhaEdicao = -1;

    public static JanelaAssociacaoGermes novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new JanelaAssociacaoGermes((Dialog)pai);
        }
        if (pai instanceof Frame) {
            return new JanelaAssociacaoGermes((Frame)pai);
        }
        return null;
    }

    public JanelaAssociacaoGermes(Dialog pai) {
        super(pai, "Associando germes");
        this.montaTela();
        this.carregarDados();
    }

    public JanelaAssociacaoGermes(Frame pai) {
        super(pai, "Associando germes");
        this.montaTela();
        this.carregarDados();
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        Dimension d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelGermeDescricao.setLabelFor(this.textGermeDescricao);
        this.labelGermeDescricao.setDisplayedMnemonic('D');
        panelCentral.add((Component)this.labelGermeDescricao, c);
        ++c.gridx;
        this.labelGermeCodigoMV.setLabelFor(this.textGermeCodigoMV);
        this.labelGermeCodigoMV.setDisplayedMnemonic('M');
        panelCentral.add((Component)this.labelGermeCodigoMV, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.textGermeDescricao.setPreferredSize(d);
        this.textGermeDescricao.setMinimumSize(d);
        panelCentral.add((Component)this.textGermeDescricao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        d = new Dimension(80, 20);
        this.textGermeCodigoMV.setPreferredSize(d);
        d = new Dimension(80, 20);
        this.textGermeCodigoMV.setMinimumSize(d);
        panelCentral.add((Component)this.textGermeCodigoMV, c);
        ++c.gridx;
        d = new Dimension(40, 20);
        this.buttonOkAssociacao.setMinimumSize(d);
        this.buttonOkAssociacao.setPreferredSize(d);
        this.buttonOkAssociacao.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkAssociacao.addActionListener(this);
        this.buttonOkAssociacao.setMnemonic('K');
        panelCentral.add((Component)this.buttonOkAssociacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.modeloAssoaciacao.setColumnSize(new int[]{0, 80}, this.tableAssociacao);
        d = new Dimension(20, 120);
        this.scrollAssociacao.setMinimumSize(d);
        d = new Dimension(20, 120);
        this.scrollAssociacao.setPreferredSize(d);
        this.tableAssociacao.getTableHeader().addMouseListener(this.modeloAssoaciacao);
        this.modeloAssoaciacao.ordenarColuna(0);
        panelCentral.add((Component)this.scrollAssociacao, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        panelCentral.add((Component)this.panelPesquisa, c);
        this.panelPesquisa.add((Component)this.labelLocalizar, "West");
        d = new Dimension(20, 20);
        this.textLocalizar.setMinimumSize(d);
        this.textLocalizar.setPreferredSize(d);
        this.panelPesquisa.add((Component)this.textLocalizar, "Center");
        this.setSize(500, 350);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.montaListeners();
        this.getBotaoOK().setText("Salvar");
        this.getBotaoOK().setMnemonic('S');
        ((JComponent)this.getContentPane()).getActionMap().remove("escape");
        ScreenUtil.requisitarFoco(this.textGermeDescricao);
        Funcoes.montaEnter((JComponent)panelCentral);
    }

    private void montaListeners() {
        this.tableAssociacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && JanelaAssociacaoGermes.this.tableAssociacao.getSelectedRow() > -1 && Funcoes.mensagem(JanelaAssociacaoGermes.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    JanelaAssociacaoGermes.this.modeloAssoaciacao.removeLine(JanelaAssociacaoGermes.this.tableAssociacao.getSelectedRow());
                } else if (e.getKeyCode() == 32 && JanelaAssociacaoGermes.this.tableAssociacao.getSelectedRow() > -1) {
                    JanelaAssociacaoGermes.this.linhaEdicao = JanelaAssociacaoGermes.this.tableAssociacao.getSelectedRow();
                    JanelaAssociacaoGermes.this.textGermeDescricao.setText(JanelaAssociacaoGermes.this.modeloAssoaciacao.getValueAt(JanelaAssociacaoGermes.this.linhaEdicao, 0).toString());
                    JanelaAssociacaoGermes.this.textGermeCodigoMV.setText(JanelaAssociacaoGermes.this.modeloAssoaciacao.getValueAt(JanelaAssociacaoGermes.this.linhaEdicao, 1).toString());
                    ScreenUtil.requisitarFoco(JanelaAssociacaoGermes.this.textGermeDescricao);
                }
            }
        });
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int linha = JanelaAssociacaoGermes.this.modeloAssoaciacao.localizarParcial(JanelaAssociacaoGermes.this.modeloAssoaciacao.getColunaOrdenacao(), JanelaAssociacaoGermes.this.textLocalizar.getText());
                if (linha != -1) {
                    JanelaAssociacaoGermes.this.tableAssociacao.getSelectionModel().setSelectionInterval(linha, linha);
                    JanelaAssociacaoGermes.this.tableAssociacao.scrollRectToVisible(JanelaAssociacaoGermes.this.tableAssociacao.getCellRect(linha, 0, false));
                }
            }
        });
    }

    private void carregarDados() {
        ArrayList<DadosIntegracaoHospitalBean> listaDados = null;
        try {
            listaDados = new DadosIntegracaoHospitalService().getBeans("G");
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados das associa\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
        if (listaDados != null) {
            for (DadosIntegracaoHospitalBean dados : listaDados) {
                String xml = dados.getConfiguracao();
                if (Funcoes.textoVazio(xml)) continue;
                String germe = StringUtil.getValor(xml, "assocgerme", true);
                String codigoMV = StringUtil.getValor(xml, "assocmv", true);
                this.modeloAssoaciacao.addLine(new Object[]{germe, codigoMV});
            }
        }
        this.modeloAssoaciacao.ordenarColunaSemTrocarSentido(this.modeloAssoaciacao.getColunaOrdenacao());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getBotaoOK()) {
            this.salvar();
            this.dispose();
        } else if (e.getSource() == this.buttonOkAssociacao) {
            this.adicionaAssociacao();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionaAssociacao() {
        String germe = this.textGermeDescricao.getText();
        String codigoMV = this.textGermeCodigoMV.getText();
        if (Funcoes.textoVazio(germe)) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o do germe deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textGermeDescricao);
            return;
        }
        if (Funcoes.textoVazio(codigoMV)) {
            Funcoes.mensagem(this, "O c\u00f3digo do MV do germe deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textGermeCodigoMV);
            return;
        }
        for (int i = 0; i < this.modeloAssoaciacao.getRowCount(); ++i) {
            if (!this.modeloAssoaciacao.getValueAt(i, 0).toString().equalsIgnoreCase(germe)) continue;
            Funcoes.mensagem(this, "O germe j\u00e1 foi associado.", 2);
            return;
        }
        if (this.linhaEdicao > -1) {
            this.modeloAssoaciacao.setValueAt(this.textGermeDescricao.getText(), this.linhaEdicao, 0);
            this.modeloAssoaciacao.setValueAt(this.textGermeCodigoMV.getText(), this.linhaEdicao, 1);
        } else {
            this.modeloAssoaciacao.addLine(new Object[]{germe, codigoMV});
        }
        this.textGermeDescricao.clear();
        this.textGermeCodigoMV.clear();
        this.linhaEdicao = -1;
        this.modeloAssoaciacao.ordenarColunaSemTrocarSentido(this.modeloAssoaciacao.getColunaOrdenacao());
        ScreenUtil.requisitarFoco(this.textGermeDescricao);
    }

    private void salvar() {
        DadosIntegracaoHospitalService service = new DadosIntegracaoHospitalService();
        try {
            service.removerAssociacoes("G");
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel remover as associa\u00e7\u00f5es antigas.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        for (int i = 0; i < this.modeloAssoaciacao.getRowCount(); ++i) {
            String nomeGerme = this.modeloAssoaciacao.getValueAt(i, 0).toString();
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("assoc");
            xml.escrever("assocgerme", nomeGerme);
            xml.escrever("assocmv", this.modeloAssoaciacao.getValueAt(i, 1).toString());
            try {
                xml.fechar("assoc");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar xml de associa\u00e7\u00e3o de germes.\n" + e.getMessage(), e.getStackTrace());
            }
            DadosIntegracaoHospitalBean bean = new DadosIntegracaoHospitalBean();
            bean.setCodigo(null);
            bean.setTipo("G");
            bean.setDescricao(nomeGerme);
            bean.setConfiguracao(xml.getXML());
            try {
                service.insert(bean, null, Variaveis.filialPadrao, null);
                continue;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel inserir associa\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar associa\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }
}

