/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.mv;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.integracaohospitais.DadosIntegracaoHospitalBean;
import jalis.model.utils.ThreadDaoException;
import jalis.service.integracaohospitais.DadosIntegracaoHospitalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class JanelaAssociacaoColonias
extends AbstractDialogoOKCancelar {
    private static final int COLUNA_COLONIA = 0;
    private static final int COLUNA_CODIGO_MV = 1;
    private JLabel labelColoniaDescricao = new JLabel("Descri\u00e7\u00e3o col\u00f4nia");
    private JLabel labelColoniaCodigoMV = new JLabel("C\u00f3digo MV");
    private TTextField textColoniaDescricao = new TTextField(50, 3);
    private TTextField textColoniaCodigoMV = new TTextField(4, 1);
    private JButton buttonOkAssociacao = new JButton("OK");
    private ModeloGridTable modeloAssoaciacao = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o Col\u00f4nia", "C\u00f3digo MV"});
    private JTable tableAssociacao = new JTable(this.modeloAssoaciacao);
    private JScrollPane scrollAssociacao = new JScrollPane(this.tableAssociacao);
    private int linhaEdicao = -1;

    public static JanelaAssociacaoColonias novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new JanelaAssociacaoColonias((Dialog)pai);
        }
        if (pai instanceof Frame) {
            return new JanelaAssociacaoColonias((Frame)pai);
        }
        return null;
    }

    public JanelaAssociacaoColonias(Dialog pai) {
        super(pai, "Associando col\u00f4nias");
        this.montaTela();
        this.carregarDados();
    }

    public JanelaAssociacaoColonias(Frame pai) {
        super(pai, "Associando col\u00f4nias");
        this.montaTela();
        this.carregarDados();
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        Dimension d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCentral.add((Component)this.labelColoniaDescricao, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelColoniaCodigoMV, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.textColoniaDescricao.setPreferredSize(d);
        this.textColoniaDescricao.setMinimumSize(d);
        panelCentral.add((Component)this.textColoniaDescricao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        d = new Dimension(80, 20);
        this.textColoniaCodigoMV.setPreferredSize(d);
        d = new Dimension(80, 20);
        this.textColoniaCodigoMV.setMinimumSize(d);
        panelCentral.add((Component)this.textColoniaCodigoMV, c);
        ++c.gridx;
        d = new Dimension(40, 20);
        this.buttonOkAssociacao.setMinimumSize(d);
        this.buttonOkAssociacao.setPreferredSize(d);
        this.buttonOkAssociacao.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkAssociacao.addActionListener(this);
        this.buttonOkAssociacao.setMnemonic('K');
        panelCentral.add((Component)this.buttonOkAssociacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.modeloAssoaciacao.setColumnSize(new int[]{0, 80}, this.tableAssociacao);
        d = new Dimension(20, 120);
        this.scrollAssociacao.setMinimumSize(d);
        d = new Dimension(20, 120);
        this.scrollAssociacao.setPreferredSize(d);
        panelCentral.add((Component)this.scrollAssociacao, c);
        this.tableAssociacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && JanelaAssociacaoColonias.this.tableAssociacao.getSelectedRow() > -1 && Funcoes.mensagem(JanelaAssociacaoColonias.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    JanelaAssociacaoColonias.this.modeloAssoaciacao.removeLine(JanelaAssociacaoColonias.this.tableAssociacao.getSelectedRow());
                } else if (e.getKeyCode() == 32 && JanelaAssociacaoColonias.this.tableAssociacao.getSelectedRow() > -1) {
                    JanelaAssociacaoColonias.this.linhaEdicao = JanelaAssociacaoColonias.this.tableAssociacao.getSelectedRow();
                    JanelaAssociacaoColonias.this.textColoniaDescricao.setText(JanelaAssociacaoColonias.this.modeloAssoaciacao.getValueAt(JanelaAssociacaoColonias.this.linhaEdicao, 0).toString());
                    JanelaAssociacaoColonias.this.textColoniaCodigoMV.setText(JanelaAssociacaoColonias.this.modeloAssoaciacao.getValueAt(JanelaAssociacaoColonias.this.linhaEdicao, 1).toString());
                    ScreenUtil.requisitarFoco(JanelaAssociacaoColonias.this.textColoniaDescricao);
                }
            }
        });
        this.setSize(350, 350);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.getBotaoOK().setText("Salvar");
        this.getBotaoOK().setMnemonic('S');
        ((JComponent)this.getContentPane()).getActionMap().remove("escape");
        ScreenUtil.requisitarFoco(this.textColoniaDescricao);
        Funcoes.montaEnter((JComponent)panelCentral);
    }

    private void carregarDados() {
        ArrayList<DadosIntegracaoHospitalBean> listaDados = null;
        try {
            listaDados = new DadosIntegracaoHospitalService().getBeans("C");
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados das associa\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
        if (listaDados != null) {
            for (DadosIntegracaoHospitalBean dados : listaDados) {
                String xml = dados.getConfiguracao();
                if (Funcoes.textoVazio(xml)) continue;
                String colonia = StringUtil.getValor(xml, "assocnomecol", true);
                String codigoMV = StringUtil.getValor(xml, "assocmv", true);
                this.modeloAssoaciacao.addLine(new Object[]{colonia, codigoMV});
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getBotaoOK()) {
            this.salvar();
            this.dispose();
        } else if (e.getSource() == this.buttonOkAssociacao) {
            this.adicionaAssociacao();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionaAssociacao() {
        String colonia = this.textColoniaDescricao.getText();
        String codigoMV = this.textColoniaCodigoMV.getText();
        if (Funcoes.textoVazio(colonia)) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o da col\u00f4nia deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textColoniaDescricao);
            return;
        }
        if (Funcoes.textoVazio(codigoMV)) {
            Funcoes.mensagem(this, "O c\u00f3digo do MV da col\u00f4nia deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textColoniaCodigoMV);
            return;
        }
        for (int i = 0; i < this.modeloAssoaciacao.getRowCount(); ++i) {
            if (!this.modeloAssoaciacao.getValueAt(i, 0).toString().equalsIgnoreCase(colonia)) continue;
            Funcoes.mensagem(this, "A col\u00f4nia j\u00e1 foi associada.", 2);
            return;
        }
        if (this.linhaEdicao > -1) {
            this.modeloAssoaciacao.setValueAt(this.textColoniaDescricao.getText(), this.linhaEdicao, 0);
            this.modeloAssoaciacao.setValueAt(this.textColoniaCodigoMV.getText(), this.linhaEdicao, 1);
        } else {
            this.modeloAssoaciacao.addLine(new Object[]{colonia, codigoMV});
        }
        this.textColoniaDescricao.clear();
        this.textColoniaCodigoMV.clear();
        ScreenUtil.requisitarFoco(this.textColoniaDescricao);
    }

    private void salvar() {
        DadosIntegracaoHospitalService service = new DadosIntegracaoHospitalService();
        try {
            service.removerAssociacoes("C");
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel remover as associa\u00e7\u00f5es antigas.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        for (int i = 0; i < this.modeloAssoaciacao.getRowCount(); ++i) {
            String descricaoColonia = this.modeloAssoaciacao.getValueAt(i, 0).toString();
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("assoc");
            xml.escrever("assocnomecol", descricaoColonia);
            xml.escrever("assocmv", this.modeloAssoaciacao.getValueAt(i, 1).toString());
            try {
                xml.fechar("assoc");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar xml de associa\u00e7\u00e3o de col\u00f4nias.\n" + e.getMessage(), e.getStackTrace());
            }
            DadosIntegracaoHospitalBean bean = new DadosIntegracaoHospitalBean();
            bean.setCodigo(null);
            bean.setTipo("C");
            bean.setDescricao(descricaoColonia);
            bean.setConfiguracao(xml.getXML());
            try {
                service.insert(bean, null, Variaveis.filialPadrao, null);
                continue;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel inserir associa\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar associa\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }
}

