/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.mv;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.sistemas.mv.IntegracaoHospitalMV;
import jalis.integracaohospitais.util.AbstractConfiguradorExamesIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.mv.JanelaAssociacaoColonias;
import jalis.integracaohospitais.util.mv.JanelaAssociacaoGermes;
import jalis.integracaohospitais.util.mv.JanelaAssociacaoMedicamentos;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ConfiguradorExamesMV
extends AbstractConfiguradorExamesIntegracaoHospital
implements WindowListener {
    private static final Color COR_ERRO = Color.RED;
    private static final Color COR_OK = Color.BLACK;
    public static final String TAG_LISTA_VALOR = "listavalor";
    public static final String TAG_LISTA_CAMPO = "listacampo";
    public static final String TAG_LISTA_GERME = "listagerme";
    public static final String TAG_LISTA_ANTIMICROBIANO = "listaanti";
    public static final String TAG_TIPO_RESULTADO = "tipo";
    public static final String TAG_VALOR = "valor";
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_GERME = "germe";
    public static final String TAG_ANTIMICROBIANO = "antimicrobiano";
    public static final String TAG_VALOR_DESCRICAO = "valdesc";
    public static final String TAG_VALOR_VERSAO = "valversao";
    public static final String TAG_VALOR_ORDEM = "valordem";
    public static final String TAG_CAMPO_JALIS = "jalis";
    public static final String TAG_CAMPO_HOSPITAL = "hosp";
    public static final String TAG_GERME_CONTAGEM_COLONIAS = "germecolonias";
    public static final String TAG_GERME_JALIS = "germejalis";
    public static final String TAG_GERME_VERSAO = "germeversao";
    public static final String TAG_GERME_ORDEM = "germeordem";
    public static final String TAG_GERME_RESULTADO_GERAL = "germeresultgeral";
    public static final String TAG_GERME_OBSERVACAO_GERAL = "germeobsgeral";
    public static final String TAG_ANTIMICROBIANO_JALIS = "antijalis";
    public static final String TAG_ANTIMICROBIANO_RESULTADO = "antiresult";
    public static final String TAG_ASSOCIACAO_GERME = "assoc";
    public static final String TAG_ASSOCIACAO_GERME_NOME = "assocgerme";
    public static final String TAG_ASSOCIACAO_GERME_CODIGO_MV = "assocmv";
    public static final String TAG_ASSOCIACAO_MEDICAMENTO = "assocmed";
    public static final String TAG_ASSOCIACAO_MEDICAMENTO_NOME = "assocnomemed";
    public static final String TAG_ASSOCIACAO_MEDICAMENTO_CODIGO_MV = "assocmedmv";
    public static final String TAG_ASSOCIACAO_COLONIA = "assoc";
    public static final String TAG_ASSOCIACAO_COLONIA_NOME = "assocnomecol";
    public static final String TAG_ASSOCIACAO_COLONIA_CODIGO_MV = "assocmv";
    private final int COLUNA_VALOR_DESCRICAO = 0;
    private final int COLUNA_VALOR_VERSAO = 1;
    private final int COLUNA_VALOR_ORDEM = 2;
    private final int COLUNA_VALOR_OBJETO = 3;
    private final int COLUNA_CAMPO_JALIS = 0;
    private final int COLUNA_CAMPO_MV = 1;
    private final int COLUNA_CAMPO_ERRO = 2;
    private final int COLUNA_CAMPO_OBJETO = 3;
    private final int COLUNA_ANTI_JALIS = 0;
    private final int COLUNA_ANTI_RESULTADO = 1;
    private final int COLUNA_ANTI_ERRO_JALIS = 2;
    private final int COLUNA_ANTI_ERRO_RESULTADO = 3;
    private JLabel labelTipoExame = new JLabel("Tipo de exame:");
    private JLabel labelValorDescricao = new JLabel("Descri\u00e7\u00e3o valor");
    private JLabel labelValorVersao = new JLabel("Vers\u00e3o");
    private JLabel labelValorOrdem = new JLabel("Ordem");
    private JLabel labelGermeCampoJalis = new JLabel("Descri\u00e7\u00e3o do germe:");
    private JLabel labelCampoMV = new JLabel("Campo do MV");
    private JLabel labelCodigoExameMV = new JLabel("C\u00f3digo exame MV:");
    private JLabel labelCodigoMaterialMV = new JLabel("C\u00f3digo material MV:");
    private JLabel labelGermeContagemColonias = new JLabel("Contagem de col\u00f4nias:");
    private JLabel labelGermeResultadoGeral = new JLabel("Resultado Geral:");
    private JLabel labelGermeObservacaoGeral = new JLabel("Observa\u00e7\u00e3o Geral:");
    private JLabel labelAntimicrobiano = new JLabel("Antimicrobiano");
    private JLabel labelAntimicrobianoResultado = new JLabel("Resultado");
    private JLabel labelGermeVersao = new JLabel("Vers\u00e3o:");
    private JLabel labelGermeOrdem = new JLabel("Ordem:");
    private JLabel labelCampoJalis = new JLabel("Campo Jalis");
    private JComboBox comboTipoExame = new JComboBox<TipoExame>(TipoExame.values());
    private JComboBox comboCampoJalis = new JComboBox();
    private JComboBox comboCampoMV = new JComboBox<CampoResultadoSADT>(CampoResultadoSADT.values());
    private JComboBox comboGermeContagemColonias = new JComboBox();
    private JComboBox comboGermeResultadoGeral = new JComboBox();
    private JComboBox comboGermeObservacaoGeral = new JComboBox();
    private JComboBox comboAntimicrobiano = new JComboBox();
    private JComboBox comboAntimicrobianoResultado = new JComboBox();
    private JComboBox comboGermeJalis = new JComboBox();
    private JButton buttonOkValores = new JButton("OK");
    private JButton buttonOkCampos = new JButton("OK");
    private JButton buttonOkAntimicrobianos = new JButton("OK");
    private JButton buttonAssociarGermes = new JButton("Germes");
    private JButton buttonAssociarMedicamentos = new JButton("Medicamentos");
    private JButton buttonAssociarColonias = new JButton("Col\u00f4nias");
    private TTextField textValorDescricao = new TTextField(30, 3);
    private TTextField textValorVersao = new TTextField(4, 1);
    private TTextField textValorOrdem = new TTextField(4, 1);
    private TTextField textCodigoExameMV = new TTextField(10, 3);
    private TTextField textCodigoMaterialMV = new TTextField(10, 3);
    private TTextField textGermeVersao = new TTextField(4, 1);
    private TTextField textGermeOrdem = new TTextField(4, 1);
    private ModeloGridTable modeloValores = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o Valor", "Vers\u00e3o", "Ordem"});
    private JTable tableValores = new JTable(this.modeloValores);
    private JScrollPane scrollValores = new JScrollPane(this.tableValores);
    private ModeloGridTable modeloCampos = new ModeloGridTable(new String[]{"Campo Jalis", "Campo MV"});
    private JTable tableCampos = new JTable(this.modeloCampos);
    private JScrollPane scrollCampos = new JScrollPane(this.tableCampos);
    private ModeloGridTable modeloAntimicrobiano = new ModeloGridTable(new String[]{"Antimicrobiano", "Resultado"});
    private JTable tableAntimicrobiano = new JTable(this.modeloAntimicrobiano);
    private JScrollPane scrollAntimicrobiano = new JScrollPane(this.tableAntimicrobiano);
    private JPanel panelConfiguracaoLaudo = new JPanel(new BorderLayout());
    private JPanel panelValores = new JPanel(new GridBagLayout());
    private JPanel panelCampos = new JPanel(new GridBagLayout());
    private JPanel panelGermes = new JPanel(new GridBagLayout());
    private JPanel panelGeralGerme = new JPanel(new GridBagLayout());
    private JPanel panelAntimicrobianos = new JPanel(new GridBagLayout());
    private int editandoLinhaValor = -1;
    private int editandoLinhaGerme = -1;
    private int editandoLinhaAntimicrobiano = -1;
    private ConfiguracaoCampoSadt objetoEdicaoCampo = null;
    private String xmlAssociacaoGermes = null;
    private String xmlAssociacaoMedicamento = null;
    private String codigoExameJalis = null;
    private Integer codigoMaterialJalis = null;

    public static ConfiguradorExamesMV novaInstancia(Window pai, String xmlIntegracaoHospital, String xmlAssociacaoCampos, String codigoExameJalis, Integer codigoMaterialJalis) {
        if (pai instanceof Frame) {
            return new ConfiguradorExamesMV((Frame)pai, "Configura\u00e7\u00e3o para exames do MV", xmlIntegracaoHospital, xmlAssociacaoCampos, codigoExameJalis, codigoMaterialJalis);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorExamesMV((Dialog)pai, "Configura\u00e7\u00e3o para exames do MV", xmlIntegracaoHospital, xmlAssociacaoCampos, codigoExameJalis, codigoMaterialJalis);
        }
        return null;
    }

    public ConfiguradorExamesMV(Dialog pai, String titulo, String xmlIntegracaoHospital, String xmlAssociacaoCampos, String codigoExameJalis, Integer codigoMaterialJalis) {
        super(pai, titulo, xmlIntegracaoHospital, xmlAssociacaoCampos);
        this.codigoExameJalis = codigoExameJalis;
        this.codigoMaterialJalis = codigoMaterialJalis;
        this.montaTela();
    }

    public ConfiguradorExamesMV(Frame pai, String titulo, String xmlIntegracaoHospital, String xmlAssociacaoCampos, String codigoExameJalis, Integer codigoMaterialJalis) {
        super(pai, titulo, xmlIntegracaoHospital, xmlAssociacaoCampos);
        this.codigoExameJalis = codigoExameJalis;
        this.codigoMaterialJalis = codigoMaterialJalis;
        this.montaTela();
    }

    public void setCamposLaudo(String[] campos) {
        if (campos != null) {
            ArrayList<String> listaCampos = new ArrayList<String>();
            for (int i = 0; i < campos.length; ++i) {
                listaCampos.add(campos[i]);
            }
            Collections.sort(listaCampos);
            this.comboGermeContagemColonias.addItem("");
            this.comboGermeResultadoGeral.addItem("");
            this.comboGermeObservacaoGeral.addItem("");
            for (String campo : listaCampos) {
                this.comboCampoJalis.addItem(campo);
                this.comboGermeContagemColonias.addItem(campo);
                this.comboGermeResultadoGeral.addItem(campo);
                this.comboGermeObservacaoGeral.addItem(campo);
                this.comboAntimicrobiano.addItem(campo);
                this.comboAntimicrobianoResultado.addItem(campo);
                this.comboGermeJalis.addItem(campo);
            }
        }
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (!Funcoes.textoVazio(this.textCodigoExameMV)) {
            XMLStringBuilder xml = new XMLStringBuilder();
            try {
                xml.abrir("xmlexamehospital");
                xml.escrever("protocolo", ProtocoloIntegracaoHospital.MV.getNome());
                xml.escrever("codExame", this.textCodigoExameMV.getText());
                xml.escrever("codMaterial", this.textCodigoMaterialMV.getText());
                xml.fechar("xmlexamehospital");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
                return null;
            }
            return xml.getXML();
        }
        return null;
    }

    @Override
    public String getXmlAssociacaoCampos() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("xmlassociacaocampos");
            xml.escrever("protocolo", ProtocoloIntegracaoHospital.MV.getNome());
            xml.escrever(TAG_TIPO_RESULTADO, ((TipoExame)((Object)this.comboTipoExame.getSelectedItem())).codigo);
            if (this.comboTipoExame.getSelectedItem() == TipoExame.CULTURA_SADT) {
                xml.escrever(TAG_GERME_OBSERVACAO_GERAL, this.comboGermeObservacaoGeral.getSelectedItem().toString());
                xml.escrever(TAG_GERME_RESULTADO_GERAL, this.comboGermeResultadoGeral.getSelectedItem().toString());
                xml.abrir(TAG_LISTA_GERME);
                xml.abrir(TAG_GERME);
                xml.escrever(TAG_GERME_JALIS, this.comboGermeJalis.getSelectedItem().toString());
                xml.escrever(TAG_GERME_VERSAO, this.textGermeVersao.getText());
                xml.escrever(TAG_GERME_ORDEM, this.textGermeOrdem.getText());
                xml.escrever(TAG_GERME_CONTAGEM_COLONIAS, this.comboGermeContagemColonias.getSelectedItem().toString());
                xml.fechar(TAG_GERME);
                xml.fechar(TAG_LISTA_GERME);
                xml.abrir(TAG_LISTA_ANTIMICROBIANO);
                for (int i = 0; i < this.modeloAntimicrobiano.getRowCount(); ++i) {
                    xml.abrir(TAG_ANTIMICROBIANO);
                    xml.escrever(TAG_ANTIMICROBIANO_JALIS, this.modeloAntimicrobiano.getValueAt(i, 0).toString());
                    xml.escrever(TAG_ANTIMICROBIANO_RESULTADO, this.modeloAntimicrobiano.getValueAt(i, 1).toString());
                    xml.fechar(TAG_ANTIMICROBIANO);
                }
                xml.fechar(TAG_LISTA_ANTIMICROBIANO);
            } else {
                xml.abrir(TAG_LISTA_VALOR);
                for (int i = 0; i < this.modeloValores.getRowCount(); ++i) {
                    xml.abrir(TAG_VALOR);
                    xml.escrever(TAG_VALOR_DESCRICAO, this.modeloValores.getValueAt(i, 0).toString());
                    xml.escrever(TAG_VALOR_VERSAO, this.modeloValores.getValueAt(i, 1).toString());
                    xml.escrever(TAG_VALOR_ORDEM, this.modeloValores.getValueAt(i, 2).toString());
                    ArrayList lista = (ArrayList)this.modeloValores.getValueAt(i, 3);
                    if (lista != null && !lista.isEmpty()) {
                        xml.abrir(TAG_LISTA_CAMPO);
                        for (Object campo : lista) {
                            xml.abrir(TAG_CAMPO);
                            ConfiguracaoCampoSadt aux = (ConfiguracaoCampoSadt)campo;
                            xml.escrever(TAG_CAMPO_JALIS, aux.campoJalis);
                            xml.escrever(TAG_CAMPO_HOSPITAL, "" + aux.campoMV.getCodigo());
                            xml.fechar(TAG_CAMPO);
                        }
                        xml.fechar(TAG_LISTA_CAMPO);
                    }
                    xml.fechar(TAG_VALOR);
                }
                xml.fechar(TAG_LISTA_VALOR);
            }
            xml.fechar("xmlassociacaocampos");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new BorderLayout());
        JPanel panelCodigo = new JPanel(new GridBagLayout());
        JPanel panelLegenda = new JPanel(new GridBagLayout());
        JPanel panelTipoExame = new JPanel(new FlowLayout(0));
        panelCentral.add((Component)panelCodigo, "North");
        panelCentral.add((Component)this.panelConfiguracaoLaudo, "Center");
        panelCentral.add((Component)panelLegenda, "South");
        Dimension d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelCodigoExameMV.setDisplayedMnemonic('V');
        this.labelCodigoExameMV.setLabelFor(this.textCodigoExameMV);
        panelCodigo.add((Component)this.labelCodigoExameMV, c);
        ++c.gridx;
        d = new Dimension(100, 20);
        this.textCodigoExameMV.setPreferredSize(d);
        this.textCodigoExameMV.setMinimumSize(d);
        panelCodigo.add((Component)this.textCodigoExameMV, c);
        ++c.gridx;
        c.insets = new Insets(5, 20, 1, 1);
        this.labelCodigoMaterialMV.setDisplayedMnemonic('g');
        this.labelCodigoMaterialMV.setLabelFor(this.textCodigoMaterialMV);
        panelCodigo.add((Component)this.labelCodigoMaterialMV, c);
        ++c.gridx;
        c.insets = new Insets(5, 1, 1, 1);
        d = new Dimension(100, 20);
        this.textCodigoMaterialMV.setPreferredSize(d);
        this.textCodigoMaterialMV.setMinimumSize(d);
        panelCodigo.add((Component)this.textCodigoMaterialMV, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelCodigo.add((Component)new JLabel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        this.labelTipoExame.setDisplayedMnemonic('T');
        this.labelTipoExame.setLabelFor(this.comboTipoExame);
        panelTipoExame.add(this.labelTipoExame);
        d = new Dimension(140, 20);
        this.comboTipoExame.setPreferredSize(d);
        this.comboTipoExame.setMinimumSize(d);
        panelTipoExame.add(this.comboTipoExame);
        panelCodigo.add((Component)panelTipoExame, c);
        this.panelConfiguracaoLaudo.setBorder(new TitledBorder("Configura\u00e7\u00e3o do laudo"));
        this.montaLegenda(panelLegenda);
        this.comboTipoExame.setSelectedIndex(-1);
        this.montaListeners();
        this.comboTipoExame.setSelectedIndex(0);
        this.tableCampos.setDefaultRenderer(Object.class, new RendererCampos());
        this.tableAntimicrobiano.setDefaultRenderer(Object.class, new RendererAntimicrobianos());
        this.montaPanelValores();
        this.montaPanelCampos();
        this.montaPanelGeralGerme();
        this.montaPanelGermes();
        this.montaPanelAntimicrobianos();
        this.montaPanelBotoes();
        this.setSize(570, 500);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        ((JComponent)this.getContentPane()).getActionMap().remove("escape");
        ScreenUtil.requisitarFoco(this.textCodigoExameMV);
        Funcoes.montaEnter((JComponent)panelCentral);
    }

    private void montaPanelBotoes() {
        JPanel panelBotoesEsquerda = this.getPanelBotoesEsquerda();
        this.buttonAssociarGermes.setMnemonic('e');
        this.buttonAssociarMedicamentos.setMnemonic('m');
        this.buttonAssociarColonias.setMnemonic('l');
        panelBotoesEsquerda.add(this.buttonAssociarGermes);
        panelBotoesEsquerda.add(this.buttonAssociarMedicamentos);
        panelBotoesEsquerda.add(this.buttonAssociarColonias);
    }

    private void montaPanelCampos() {
        Dimension d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 1, 1, 1);
        this.labelCampoJalis.setDisplayedMnemonic('A');
        this.labelCampoJalis.setLabelFor(this.comboCampoJalis);
        this.panelCampos.add((Component)this.labelCampoJalis, c);
        ++c.gridx;
        this.labelCampoMV.setDisplayedMnemonic('s');
        this.labelCampoMV.setLabelFor(this.comboCampoMV);
        this.panelCampos.add((Component)this.labelCampoMV, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 1, 1);
        d = new Dimension(150, 20);
        this.comboCampoJalis.setPreferredSize(d);
        this.comboCampoJalis.setMinimumSize(d);
        this.panelCampos.add((Component)this.comboCampoJalis, c);
        ++c.gridx;
        d = new Dimension(250, 20);
        this.comboCampoMV.setPreferredSize(d);
        this.comboCampoMV.setMinimumSize(d);
        this.panelCampos.add((Component)this.comboCampoMV, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        d = new Dimension(40, 20);
        this.buttonOkCampos.setMinimumSize(d);
        this.buttonOkCampos.setPreferredSize(d);
        this.buttonOkCampos.setMargin(new Insets(1, 1, 1, 1));
        this.panelCampos.add((Component)this.buttonOkCampos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.modeloCampos.setColumnSize(new int[]{0, 0}, this.tableCampos);
        d = new Dimension(20, 120);
        this.scrollCampos.setMinimumSize(d);
        d = new Dimension(20, 120);
        this.scrollCampos.setPreferredSize(d);
        this.panelCampos.add((Component)this.scrollCampos, c);
    }

    private void montaPanelValores() {
        Dimension d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelValores.add((Component)this.labelValorDescricao, c);
        ++c.gridx;
        this.panelValores.add((Component)this.labelValorVersao, c);
        ++c.gridx;
        this.panelValores.add((Component)this.labelValorOrdem, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelValores.add((Component)this.textValorDescricao, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        d = new Dimension(80, 20);
        this.textValorVersao.setMinimumSize(d);
        this.textValorVersao.setPreferredSize(d);
        this.panelValores.add((Component)this.textValorVersao, c);
        ++c.gridx;
        d = new Dimension(80, 20);
        this.textValorOrdem.setMinimumSize(d);
        this.textValorOrdem.setPreferredSize(d);
        this.panelValores.add((Component)this.textValorOrdem, c);
        ++c.gridx;
        d = new Dimension(40, 20);
        this.buttonOkValores.setMinimumSize(d);
        this.buttonOkValores.setPreferredSize(d);
        this.buttonOkValores.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkValores.setMnemonic('K');
        this.panelValores.add((Component)this.buttonOkValores, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.modeloValores.setColumnSize(new int[]{0, 80, 80}, this.tableValores);
        d = new Dimension(20, 120);
        this.scrollValores.setMinimumSize(d);
        d = new Dimension(20, 120);
        this.scrollValores.setPreferredSize(d);
        this.panelValores.add((Component)this.scrollValores, c);
    }

    private void montaPanelGermes() {
        this.panelGermes.setBorder(new TitledBorder("Dados do germe"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelGermes.add((Component)this.labelGermeCampoJalis, c);
        ++c.gridx;
        this.comboGermeJalis.setPreferredSize(new Dimension(150, 20));
        this.comboGermeJalis.setMinimumSize(new Dimension(150, 20));
        this.panelGermes.add((Component)this.comboGermeJalis, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        this.panelGermes.add((Component)this.labelGermeVersao, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 0, 0);
        this.textGermeVersao.setPreferredSize(new Dimension(80, 20));
        this.textGermeVersao.setMinimumSize(new Dimension(80, 20));
        this.panelGermes.add((Component)this.textGermeVersao, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 0, 0);
        this.panelGermes.add((Component)this.labelGermeContagemColonias, c);
        ++c.gridx;
        this.comboGermeContagemColonias.setPreferredSize(new Dimension(150, 20));
        this.comboGermeContagemColonias.setMinimumSize(new Dimension(150, 20));
        this.panelGermes.add((Component)this.comboGermeContagemColonias, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        this.panelGermes.add((Component)this.labelGermeOrdem, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 0, 0);
        this.textGermeOrdem.setPreferredSize(new Dimension(80, 20));
        this.textGermeOrdem.setMinimumSize(new Dimension(80, 20));
        this.panelGermes.add((Component)this.textGermeOrdem, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelGermes.add((Component)new JLabel(), c);
    }

    private void montaPanelGeralGerme() {
        this.panelGeralGerme.setBorder(new TitledBorder("Dados gerais do resultado"));
        Object d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelGermeResultadoGeral.setLabelFor(this.comboGermeResultadoGeral);
        this.labelGermeResultadoGeral.setDisplayedMnemonic('R');
        this.panelGeralGerme.add((Component)this.labelGermeResultadoGeral, c);
        ++c.gridx;
        this.comboGermeResultadoGeral.setPreferredSize(new Dimension(150, 20));
        this.comboGermeResultadoGeral.setMinimumSize(new Dimension(150, 20));
        this.panelGeralGerme.add((Component)this.comboGermeResultadoGeral, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        this.labelGermeObservacaoGeral.setLabelFor(this.comboGermeObservacaoGeral);
        this.labelGermeObservacaoGeral.setDisplayedMnemonic('b');
        this.panelGeralGerme.add((Component)this.labelGermeObservacaoGeral, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 0, 0);
        this.comboGermeObservacaoGeral.setPreferredSize(new Dimension(150, 20));
        this.comboGermeObservacaoGeral.setMinimumSize(new Dimension(150, 20));
        this.panelGeralGerme.add((Component)this.comboGermeObservacaoGeral, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelGeralGerme.add((Component)new JLabel(), c);
    }

    private void montaPanelAntimicrobianos() {
        this.panelAntimicrobianos.setBorder(new TitledBorder("Dados dos antimicrobianos"));
        Dimension d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelAntimicrobianos.add((Component)this.labelAntimicrobiano, c);
        ++c.gridx;
        this.panelAntimicrobianos.add((Component)this.labelAntimicrobianoResultado, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        d = new Dimension(150, 20);
        this.comboAntimicrobiano.setMinimumSize(d);
        this.comboAntimicrobiano.setPreferredSize(d);
        this.panelAntimicrobianos.add((Component)this.comboAntimicrobiano, c);
        ++c.gridx;
        d = new Dimension(150, 20);
        this.comboAntimicrobianoResultado.setMinimumSize(d);
        this.comboAntimicrobianoResultado.setPreferredSize(d);
        this.panelAntimicrobianos.add((Component)this.comboAntimicrobianoResultado, c);
        ++c.gridx;
        d = new Dimension(40, 20);
        this.buttonOkAntimicrobianos.setMinimumSize(d);
        this.buttonOkAntimicrobianos.setPreferredSize(d);
        this.buttonOkAntimicrobianos.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkAntimicrobianos.setMnemonic('K');
        this.panelAntimicrobianos.add((Component)this.buttonOkAntimicrobianos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.modeloAntimicrobiano.setColumnSize(new int[]{0, 80, 120}, this.tableAntimicrobiano);
        d = new Dimension(20, 120);
        this.scrollAntimicrobiano.setMinimumSize(d);
        d = new Dimension(20, 120);
        this.scrollAntimicrobiano.setPreferredSize(d);
        this.panelAntimicrobianos.add((Component)this.scrollAntimicrobiano, c);
    }

    private void montaLegenda(JPanel panelLegenda) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel aux = new JPanel();
        aux.setPreferredSize(new Dimension(10, 10));
        aux.setBackground(COR_ERRO);
        aux.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        panelLegenda.add((Component)aux, c);
        JLabel lblLegenda = new JLabel("Campo removido do laudo");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        panelLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelLegenda.add((Component)new JLabel(), c);
    }

    private void montaListeners() {
        this.addWindowListener(this);
        this.comboTipoExame.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TipoExame aux = (TipoExame)((Object)ConfiguradorExamesMV.this.comboTipoExame.getSelectedItem());
                    ConfiguradorExamesMV.this.panelConfiguracaoLaudo.removeAll();
                    ConfiguradorExamesMV.this.panelConfiguracaoLaudo.revalidate();
                    ConfiguradorExamesMV.this.panelConfiguracaoLaudo.repaint();
                    if (aux == TipoExame.SADT) {
                        ConfiguradorExamesMV.this.panelConfiguracaoLaudo.setLayout(new BorderLayout());
                        ConfiguradorExamesMV.this.panelConfiguracaoLaudo.add((Component)ConfiguradorExamesMV.this.panelValores, "North");
                        ConfiguradorExamesMV.this.panelConfiguracaoLaudo.add((Component)ConfiguradorExamesMV.this.panelCampos, "Center");
                        ConfiguradorExamesMV.this.buttonAssociarGermes.setVisible(false);
                        ConfiguradorExamesMV.this.buttonAssociarMedicamentos.setVisible(false);
                        ConfiguradorExamesMV.this.buttonAssociarColonias.setVisible(false);
                    } else {
                        ConfiguradorExamesMV.this.panelConfiguracaoLaudo.setLayout(new GridBagLayout());
                        GridBagConstraints c = new GridBagConstraints();
                        c.anchor = 17;
                        c.fill = 1;
                        c.gridheight = 1;
                        c.gridwidth = 1;
                        c.gridx = 0;
                        c.gridy = 0;
                        c.weightx = 1.0;
                        c.weighty = 0.0;
                        ConfiguradorExamesMV.this.panelConfiguracaoLaudo.add((Component)ConfiguradorExamesMV.this.panelGeralGerme, c);
                        ++c.gridy;
                        ConfiguradorExamesMV.this.panelConfiguracaoLaudo.add((Component)ConfiguradorExamesMV.this.panelGermes, c);
                        ++c.gridy;
                        c.weighty = 1.0;
                        ConfiguradorExamesMV.this.panelConfiguracaoLaudo.add((Component)ConfiguradorExamesMV.this.panelAntimicrobianos, c);
                        ConfiguradorExamesMV.this.buttonAssociarGermes.setVisible(true);
                        ConfiguradorExamesMV.this.buttonAssociarMedicamentos.setVisible(true);
                        ConfiguradorExamesMV.this.buttonAssociarColonias.setVisible(true);
                    }
                    ConfiguradorExamesMV.this.panelConfiguracaoLaudo.revalidate();
                    ConfiguradorExamesMV.this.panelConfiguracaoLaudo.repaint();
                }
            }
        });
        this.tableCampos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorExamesMV.this.tableCampos.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorExamesMV.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    Object aux = ConfiguradorExamesMV.this.modeloCampos.getValueAt(ConfiguradorExamesMV.this.tableCampos.getSelectedRow(), 3);
                    ConfiguradorExamesMV.this.modeloCampos.removeLine(ConfiguradorExamesMV.this.tableCampos.getSelectedRow());
                    ArrayList lista = (ArrayList)ConfiguradorExamesMV.this.modeloValores.getValueAt(ConfiguradorExamesMV.this.tableValores.getSelectedRow(), 3);
                    lista.remove(aux);
                } else if (e.getKeyCode() == 32 && ConfiguradorExamesMV.this.tableCampos.getSelectedRow() > -1) {
                    ConfiguradorExamesMV.this.objetoEdicaoCampo = (ConfiguracaoCampoSadt)ConfiguradorExamesMV.this.modeloCampos.getValueAt(ConfiguradorExamesMV.this.tableCampos.getSelectedRow(), 3);
                    ConfiguradorExamesMV.this.comboCampoJalis.setSelectedItem(ConfiguradorExamesMV.this.objetoEdicaoCampo.campoJalis);
                    ConfiguradorExamesMV.this.comboCampoMV.setSelectedItem((Object)ConfiguradorExamesMV.this.objetoEdicaoCampo.campoMV);
                    ScreenUtil.requisitarFoco(ConfiguradorExamesMV.this.comboCampoJalis);
                }
            }
        });
        this.tableValores.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorExamesMV.this.tableValores.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorExamesMV.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfiguradorExamesMV.this.modeloValores.removeLine(ConfiguradorExamesMV.this.tableValores.getSelectedRow());
                    ConfiguradorExamesMV.this.modeloCampos.clear();
                } else if (e.getKeyCode() == 32 && ConfiguradorExamesMV.this.tableValores.getSelectedRow() > -1) {
                    ConfiguradorExamesMV.this.editandoLinhaValor = ConfiguradorExamesMV.this.tableValores.getSelectedRow();
                    ConfiguradorExamesMV.this.textValorDescricao.setText(ConfiguradorExamesMV.this.modeloValores.getValueAt(ConfiguradorExamesMV.this.editandoLinhaValor, 0).toString());
                    ConfiguradorExamesMV.this.textValorVersao.setText(ConfiguradorExamesMV.this.modeloValores.getValueAt(ConfiguradorExamesMV.this.editandoLinhaValor, 1).toString());
                    ConfiguradorExamesMV.this.textValorOrdem.setText(ConfiguradorExamesMV.this.modeloValores.getValueAt(ConfiguradorExamesMV.this.editandoLinhaValor, 2).toString());
                    ScreenUtil.requisitarFoco(ConfiguradorExamesMV.this.textValorDescricao);
                }
            }
        });
        this.tableAntimicrobiano.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorExamesMV.this.tableAntimicrobiano.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorExamesMV.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfiguradorExamesMV.this.modeloAntimicrobiano.removeLine(ConfiguradorExamesMV.this.tableAntimicrobiano.getSelectedRow());
                } else if (e.getKeyCode() == 32 && ConfiguradorExamesMV.this.tableAntimicrobiano.getSelectedRow() > -1) {
                    int row = ConfiguradorExamesMV.this.tableAntimicrobiano.getSelectedRow();
                    ConfiguradorExamesMV.this.editandoLinhaAntimicrobiano = row;
                    ConfiguradorExamesMV.this.comboAntimicrobiano.setSelectedItem(ConfiguradorExamesMV.this.modeloAntimicrobiano.getValueAt(row, 0).toString());
                    ConfiguradorExamesMV.this.comboAntimicrobianoResultado.setSelectedItem(ConfiguradorExamesMV.this.modeloAntimicrobiano.getValueAt(row, 1).toString());
                    ScreenUtil.requisitarFoco(ConfiguradorExamesMV.this.comboAntimicrobiano);
                }
            }
        });
        this.buttonOkCampos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorExamesMV.this.adicionaAssociacao();
            }
        });
        this.buttonOkValores.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorExamesMV.this.adicionaValor();
            }
        });
        this.tableValores.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfiguradorExamesMV.this.preencheDadosCampos();
                ConfiguradorExamesMV.this.controlaCampos();
            }
        });
        this.buttonOkAntimicrobianos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorExamesMV.this.adicionaAntimicrobiano();
            }
        });
        this.buttonAssociarGermes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaAssociacaoGermes janela = JanelaAssociacaoGermes.novaInstancia(ConfiguradorExamesMV.this);
                janela.setVisible(true);
            }
        });
        this.buttonAssociarMedicamentos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaAssociacaoMedicamentos janela = JanelaAssociacaoMedicamentos.novaInstancia(ConfiguradorExamesMV.this);
                janela.setVisible(true);
            }
        });
        this.buttonAssociarColonias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaAssociacaoColonias janela = JanelaAssociacaoColonias.novaInstancia(ConfiguradorExamesMV.this);
                janela.setVisible(true);
            }
        });
    }

    private void adicionaAntimicrobiano() {
        String descricao = this.comboAntimicrobiano.getSelectedItem().toString();
        String resultado = this.comboAntimicrobianoResultado.getSelectedItem().toString();
        if (this.editandoLinhaAntimicrobiano > -1) {
            this.modeloAntimicrobiano.setValueAt(descricao, this.editandoLinhaAntimicrobiano, 0);
            this.modeloAntimicrobiano.setValueAt(resultado, this.editandoLinhaAntimicrobiano, 1);
            this.modeloAntimicrobiano.setValueAt(false, this.editandoLinhaAntimicrobiano, 2);
            this.modeloAntimicrobiano.setValueAt(false, this.editandoLinhaAntimicrobiano, 3);
            this.editandoLinhaAntimicrobiano = -1;
        } else {
            this.modeloAntimicrobiano.addLine(new Object[]{descricao, resultado, false, false});
        }
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.comboAntimicrobiano);
    }

    private void preencheDadosCampos() {
        int row = this.tableValores.getSelectedRow();
        if (row > -1) {
            this.modeloCampos.clear();
            ArrayList lista = (ArrayList)this.modeloValores.getValueAt(row, 3);
            if (lista != null) {
                for (ConfiguracaoCampoSadt campo : lista) {
                    this.modeloCampos.addLine(new Object[]{campo.campoJalis, campo.campoMV, campo.erro, campo});
                }
            }
        } else {
            this.modeloCampos.clear();
        }
    }

    private void adicionaValor() {
        if (Funcoes.textoVazio(this.textValorDescricao)) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o do valor deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textValorDescricao);
            return;
        }
        if (Funcoes.textoVazio(this.textValorVersao)) {
            Funcoes.mensagem(this, "A vers\u00e3o do valor deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textValorVersao);
            return;
        }
        if (Funcoes.textoVazio(this.textValorOrdem)) {
            Funcoes.mensagem(this, "A ordem do valor deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textValorOrdem);
            return;
        }
        String valor = this.textValorDescricao.getText();
        String versao = this.textValorVersao.getText();
        String ordem = this.textValorOrdem.getText();
        if (this.editandoLinhaValor > -1) {
            this.modeloValores.setValueAt(valor, this.editandoLinhaValor, 0);
            this.modeloValores.setValueAt(versao, this.editandoLinhaValor, 1);
            this.modeloValores.setValueAt(ordem, this.editandoLinhaValor, 2);
            this.editandoLinhaValor = -1;
        } else {
            for (int i = 0; i < this.modeloValores.getRowCount(); ++i) {
                if (!this.modeloValores.getValueAt(i, 0).toString().equalsIgnoreCase(valor)) continue;
                Funcoes.mensagem(this, "O valor j\u00e1 foi inserido.", 2);
                return;
            }
            this.modeloValores.addLine(new Object[]{valor, versao, ordem, new ArrayList()});
        }
        this.textValorDescricao.clear();
        this.textValorVersao.clear();
        this.textValorOrdem.clear();
        ScreenUtil.requisitarFoco(this.textValorDescricao);
    }

    private void adicionaAssociacao() {
        if (this.objetoEdicaoCampo != null) {
            int pos = -1;
            for (int i = 0; i < this.modeloCampos.getRowCount(); ++i) {
                if (this.modeloCampos.getValueAt(i, 3) != this.objetoEdicaoCampo) continue;
                pos = i;
                break;
            }
            this.modeloCampos.setValueAt(this.comboCampoJalis.getSelectedItem().toString(), pos, 0);
            this.modeloCampos.setValueAt(this.comboCampoMV.getSelectedItem(), pos, 1);
            this.modeloCampos.setValueAt(false, pos, 2);
            this.objetoEdicaoCampo.campoJalis = this.comboCampoJalis.getSelectedItem().toString();
            this.objetoEdicaoCampo.campoMV = (CampoResultadoSADT)((Object)this.comboCampoMV.getSelectedItem());
            this.objetoEdicaoCampo.erro = false;
            this.objetoEdicaoCampo = null;
        } else {
            ArrayList lista = (ArrayList)this.modeloValores.getValueAt(this.tableValores.getSelectedRow(), 3);
            ConfiguracaoCampoSadt campo = new ConfiguracaoCampoSadt(this.comboCampoJalis.getSelectedItem().toString(), (CampoResultadoSADT)((Object)this.comboCampoMV.getSelectedItem()));
            this.modeloCampos.addLine(new Object[]{this.comboCampoJalis.getSelectedItem().toString(), this.comboCampoMV.getSelectedItem(), false, campo});
            lista.add(campo);
        }
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.comboCampoJalis);
    }

    private void controlaCampos() {
        if (this.modeloValores.getRowCount() > 0 || this.modeloAntimicrobiano.getRowCount() > 0) {
            this.comboTipoExame.setEnabled(false);
        } else {
            this.comboTipoExame.setEnabled(true);
        }
        boolean enabled = this.tableValores.getSelectedRow() > -1;
        this.comboCampoJalis.setEnabled(enabled);
        this.comboCampoMV.setEnabled(enabled);
        this.buttonOkCampos.setEnabled(enabled);
    }

    public void carregaDados() {
        String protocolo;
        if (!Funcoes.textoVazio(this.xmlIntegracaoHospital) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(this.xmlIntegracaoHospital, "protocolo")) && protocolo.equals(ProtocoloIntegracaoHospital.MV.getNome())) {
            String codigoExame = StringUtil.getValor(this.xmlIntegracaoHospital, "codExame");
            String codigoMaterial = StringUtil.getValor(this.xmlIntegracaoHospital, "codMaterial");
            if (!Funcoes.textoVazio(codigoExame)) {
                this.textCodigoExameMV.setText(codigoExame);
            }
            if (!Funcoes.textoVazio(codigoMaterial)) {
                this.textCodigoMaterialMV.setText(codigoMaterial);
            }
        }
        if (!Funcoes.textoVazio(this.xmlAssociacaoCampos)) {
            this.xmlAssociacaoCampos = StringUtil.getValor(this.xmlAssociacaoCampos, "xmlassociacaocampos");
            if (!Funcoes.textoVazio(this.xmlAssociacaoCampos)) {
                protocolo = StringUtil.getValor(this.xmlAssociacaoCampos, "protocolo");
                String tipoResultadoAux = StringUtil.getValor(this.xmlAssociacaoCampos, TAG_TIPO_RESULTADO);
                TipoExame tipoResultado = TipoExame.getTipoExame(tipoResultadoAux);
                if (tipoResultado != null) {
                    this.comboTipoExame.setSelectedItem((Object)tipoResultado);
                } else {
                    this.comboTipoExame.setSelectedItem((Object)TipoExame.SADT);
                }
                if (!Funcoes.textoVazio(protocolo) && protocolo.equals(ProtocoloIntegracaoHospital.MV.getNome())) {
                    this.preencheDadosCampos(this.xmlAssociacaoCampos, tipoResultado);
                }
            }
        }
        this.controlaCampos();
    }

    private void preencheDadosCampos(String xml, TipoExame tipoExame) {
        block11: {
            String[] antimicrobianos;
            int j;
            block12: {
                if (Funcoes.textoVazio(xml) || tipoExame == null) break block11;
                if (tipoExame != TipoExame.SADT) break block12;
                String[] valores = StringUtil.getValores(xml, TAG_VALOR);
                if (valores == null) break block11;
                for (String valor : valores) {
                    String descricao = StringUtil.getValor(valor, TAG_VALOR_DESCRICAO);
                    String versao = StringUtil.getValor(valor, TAG_VALOR_VERSAO);
                    String ordem = StringUtil.getValor(valor, TAG_VALOR_ORDEM);
                    String[] campos = StringUtil.getValores(valor, TAG_CAMPO);
                    ArrayList<ConfiguracaoCampoSadt> lista = new ArrayList<ConfiguracaoCampoSadt>();
                    if (campos != null) {
                        for (String campo : campos) {
                            String campoJalis = StringUtil.getValor(campo, TAG_CAMPO_JALIS);
                            String campoMV = StringUtil.getValor(campo, TAG_CAMPO_HOSPITAL);
                            if (Funcoes.textoVazio(campoMV) || !Funcoes.isNumeric(campoMV)) continue;
                            boolean campoExiste = false;
                            for (int j2 = 0; j2 < this.comboCampoJalis.getItemCount(); ++j2) {
                                if (!this.comboCampoJalis.getItemAt(j2).toString().equalsIgnoreCase(campoJalis)) continue;
                                campoExiste = true;
                                break;
                            }
                            CampoResultadoSADT campoAux = CampoResultadoSADT.getCampoResultado(Integer.parseInt(campoMV));
                            ConfiguracaoCampoSadt conf = new ConfiguracaoCampoSadt(campoJalis, campoAux);
                            conf.erro = !campoExiste;
                            lista.add(conf);
                        }
                    }
                    this.modeloValores.addLine(new Object[]{descricao, versao, ordem, lista});
                }
                break block11;
            }
            String resultadoGermeGeral = StringUtil.getValor(xml, TAG_GERME_RESULTADO_GERAL);
            String observacaoGermeGeral = StringUtil.getValor(xml, TAG_GERME_OBSERVACAO_GERAL);
            this.comboGermeResultadoGeral.setSelectedItem(resultadoGermeGeral);
            this.comboGermeObservacaoGeral.setSelectedItem(observacaoGermeGeral);
            String[] germes = StringUtil.getValores(xml, TAG_GERME);
            if (germes != null) {
                for (String germe : germes) {
                    String jalis = StringUtil.getValor(germe, TAG_GERME_JALIS);
                    String versao = StringUtil.getValor(germe, TAG_GERME_VERSAO);
                    String ordem = StringUtil.getValor(germe, TAG_GERME_ORDEM);
                    String contagemColonias = StringUtil.getValor(germe, TAG_GERME_CONTAGEM_COLONIAS);
                    for (j = 0; j < this.comboCampoJalis.getItemCount() && !this.comboCampoJalis.getItemAt(j).toString().equalsIgnoreCase(jalis); ++j) {
                    }
                    this.comboGermeJalis.setSelectedItem(jalis);
                    this.comboGermeContagemColonias.setSelectedItem(contagemColonias);
                    this.textGermeVersao.setText(versao);
                    this.textGermeOrdem.setText(ordem);
                }
            }
            if ((antimicrobianos = StringUtil.getValores(xml, TAG_ANTIMICROBIANO)) != null) {
                for (String antimicrobiano : antimicrobianos) {
                    String jalis = StringUtil.getValor(antimicrobiano, TAG_ANTIMICROBIANO_JALIS);
                    String resultado = StringUtil.getValor(antimicrobiano, TAG_ANTIMICROBIANO_RESULTADO);
                    boolean campoExisteCampoJalis = false;
                    for (j = 0; j < this.comboCampoJalis.getItemCount(); ++j) {
                        if (!this.comboCampoJalis.getItemAt(j).toString().equalsIgnoreCase(jalis)) continue;
                        campoExisteCampoJalis = true;
                        break;
                    }
                    boolean campoExisteResultado = false;
                    for (int j3 = 0; j3 < this.comboCampoJalis.getItemCount(); ++j3) {
                        if (!this.comboCampoJalis.getItemAt(j3).toString().equalsIgnoreCase(resultado)) continue;
                        campoExisteResultado = true;
                        break;
                    }
                    this.modeloAntimicrobiano.addLine(new Object[]{jalis, resultado, !campoExisteCampoJalis, !campoExisteResultado});
                }
            }
        }
    }

    @Override
    protected boolean acaoOk() {
        String codigoExame = this.textCodigoExameMV.getText();
        String codigoMaterial = this.textCodigoMaterialMV.getText();
        if (Funcoes.textoVazio(codigoExame) && !Funcoes.textoVazio(codigoMaterial)) {
            Funcoes.mensagem(this, "O c\u00f3digo MV do exame deve ser preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoExameMV);
            return false;
        }
        if (Funcoes.textoVazio(codigoMaterial) && !Funcoes.textoVazio(codigoExame)) {
            Funcoes.mensagem(this, "O c\u00f3digo MV do material deve ser preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoMaterialMV);
            return false;
        }
        HashMap<String, Integer> examesAssociados = this.buscaExamesAssociadosMV(codigoExame, codigoMaterial);
        if (examesAssociados != null && examesAssociados.size() > 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("J\u00e1 h\u00e1 exames do jalis associados com o c\u00f3digo MV = ").append(codigoExame).append(" e material MV = ").append(codigoMaterial).append(":\n");
            for (String codExameAux : examesAssociados.keySet()) {
                Integer codMaterialAux = examesAssociados.get(codExameAux);
                if (Funcoes.textoVazio(codExameAux) || codMaterialAux == null) continue;
                msg.append("Exame: ").append(codExameAux).append(", material: ").append(codMaterialAux).append(".\n");
            }
            msg.append("N\u00e3o \u00e9 poss\u00edvel associar mais de um exame/material do jalis com o mesmo c\u00f3digo de exame e material do MV.");
            Funcoes.mensagem(this, msg.toString(), 2);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HashMap<String, Integer> buscaExamesAssociadosMV(String codigoExame, String codigoMaterial) {
        block7: {
            HashMap<String, Integer> hashMap;
            Statement st;
            block6: {
                StringBuilder buf = new StringBuilder();
                buf.append(" select exa_codigo as exame ");
                buf.append("       ,mco_codigo as material ");
                buf.append("   from examematcoleta ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and not (exa_codigo = ").append(StringUtil.textoDBEscape(this.codigoExameJalis));
                buf.append("             and mco_codigo = ").append(this.codigoMaterialJalis).append(") ");
                buf.append("    and emc_xmlintegrahospital ilike ").append(StringUtil.textoDBEscape("%<codExame>" + codigoExame + "</" + "codExame" + ">%"));
                buf.append("    and emc_xmlintegrahospital ilike ").append(StringUtil.textoDBEscape("%<codMaterial>" + codigoMaterial + "</" + "codMaterial" + ">%"));
                buf.append("    and emc_xmlintegrahospital ilike ").append(StringUtil.textoDBEscape("%<protocolo>" + IntegracaoHospitalMV.getNomeIntegracaoHospital() + "</" + "protocolo" + ">%"));
                st = Conexao.getStatement();
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                HashMap<String, Integer> listaExames = new HashMap<String, Integer>();
                if (rs.next()) {
                    listaExames.put(rs.getString("exame"), rs.getInt("material"));
                }
                if (listaExames.size() <= 0) break block6;
                HashMap<String, Integer> hashMap2 = listaExames;
                Conexao.fecharStatement(st);
                return hashMap2;
            }
            try {
                hashMap = null;
            }
            catch (Exception exception) {
                Conexao.fecharStatement(st);
                break block7;
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            Conexao.fecharStatement(st);
            return hashMap;
        }
        return null;
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.comboCampoJalis.getItemCount() == 0) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 campos do laudo para serem configurados.", 2);
        }
    }

    @Override
    @Deprecated
    public void windowClosing(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowClosed(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowIconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowActivated(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeactivated(WindowEvent e) {
    }

    private class ConfiguracaoCampoSadt {
        private String campoJalis = null;
        private CampoResultadoSADT campoMV = null;
        private boolean erro = false;

        public ConfiguracaoCampoSadt(String campoJalis, CampoResultadoSADT campoMV) {
            this.campoJalis = campoJalis;
            this.campoMV = campoMV;
        }

        public String getCampoJalis() {
            return this.campoJalis;
        }

        public CampoResultadoSADT getCampoMV() {
            return this.campoMV;
        }

        public boolean getErro() {
            return this.erro;
        }

        public void setErro(boolean erro) {
            this.erro = erro;
        }
    }

    private class RendererAntimicrobianos
    extends DefaultTableCellRenderer {
        private RendererAntimicrobianos() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp != null && row > -1 && column == 0) {
                boolean erro = (Boolean)table.getModel().getValueAt(row, 2);
                if (erro) {
                    comp.setForeground(COR_ERRO);
                } else {
                    comp.setForeground(COR_OK);
                }
            } else if (comp != null && row > -1 && column == 1) {
                boolean erro = (Boolean)table.getModel().getValueAt(row, 3);
                if (erro) {
                    comp.setForeground(COR_ERRO);
                } else {
                    comp.setForeground(COR_OK);
                }
            } else if (comp != null) {
                comp.setForeground(COR_OK);
            }
            return comp;
        }
    }

    private class RendererCampos
    extends DefaultTableCellRenderer {
        private RendererCampos() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp != null && row > -1 && row == 0) {
                boolean erroCampo = (Boolean)table.getModel().getValueAt(row, 2);
                if (erroCampo) {
                    comp.setForeground(COR_ERRO);
                } else {
                    comp.setForeground(COR_OK);
                }
            } else if (comp != null) {
                comp.setForeground(COR_OK);
            }
            return comp;
        }
    }

    public static enum CampoResultadoSADT {
        ABSOLUTO_ABSURDO_VALOR_INICIO(1, "Absoluto Absurdo - Valor In\u00edcio", "valorInicio"),
        ABSOLUTO_ABSURDO_VALOR_FIM(2, "Absoluto Absurdo - Valor Fim", "valorFim"),
        ABSOLUTO_LIMITE_VALOR_INICIO(4, "Absoluto Limite - Valor In\u00edcio", "valorInicio"),
        ABSOLUTO_LIMITE_VALOR_FIM(5, "Absoluto Limite - Valor Fim", "valorFim"),
        ABSOLUTO_NORMAL_VALOR_INICIO(7, "Absoluto Normal - Valor In\u00edcio", "valorInicio"),
        ABSOLUTO_NORMAL_VALOR_FIM(8, "Absoluto Normal - Valor Fim", "valorFim"),
        PERCENTUAL_ABSURDO_VALOR_INICIO(12, "Percentual Absurdo - Valor In\u00edcio", "valorInicio"),
        PERCENTUAL_ABSURDO_VALOR_FIM(13, "Percentual Absurdo - Valor Fim", "valorFim"),
        PERCENTUAL_LIMITE_VALOR_INICIO(15, "Percentual Limite - Valor In\u00edcio", "valorInicio"),
        PERCENTUAL_LIMITE_VALOR_FIM(16, "Percentual Limite - Valor Fim", "valorFim"),
        PERCENTUAL_NORMAL_VALOR_INICIO(18, "Percentual Normal - Valor In\u00edcio", "valorInicio"),
        PERCENTUAL_NORMAL_VALOR_FIM(19, "Percentual Normal - Valor Fim", "valorFim"),
        RESULTADO_EXAME(20, "Resultado Exame", "resultadoExame"),
        UNIDADE_REFERENCIA(21, "Unidade Refer\u00eancia", "unidadeReferencia"),
        OBSERVACAO(23, "Observa\u00e7\u00e3o", "obs");

        int codigo = -1;
        String descricao = null;
        String tag = null;

        private CampoResultadoSADT(int codigo, String descricao, String tag) {
            this.codigo = codigo;
            this.descricao = descricao;
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }

        public String toString() {
            return this.descricao;
        }

        public int getCodigo() {
            return this.codigo;
        }

        public static CampoResultadoSADT getCampoResultado(Integer codigo) {
            CampoResultadoSADT[] campos = CampoResultadoSADT.values();
            for (int i = 0; i < campos.length; ++i) {
                if (campos[i].codigo != codigo) continue;
                return campos[i];
            }
            return null;
        }
    }

    public static enum TipoExame {
        CULTURA_SADT("C", "Cultura SADT"),
        SADT("S", "SADT");

        String codigo = null;
        String descricao = null;

        private TipoExame(String codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String getCodigo() {
            return this.codigo;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String toString() {
            return this.descricao;
        }

        public static TipoExame getTipoExame(String codigo) {
            TipoExame[] tipos = TipoExame.values();
            for (int i = 0; i < tipos.length; ++i) {
                if (!tipos[i].getCodigo().equalsIgnoreCase(codigo)) continue;
                return tipos[i];
            }
            return null;
        }
    }
}

