/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.mv;

import jalis.integracaohospitais.util.AbstractConfiguradorConveniosIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorConveniosMV
extends AbstractConfiguradorConveniosIntegracaoHospital {
    JLabel labelCodigo = new JLabel("C\u00f3digo MV:");
    TTextField textCodigo = new TTextField(3, 1);
    JCheckBox checkIgnorar = new JCheckBox("N\u00e3o integrar resultado");

    public static ConfiguradorConveniosMV novaInstancia(Object pai, String xmlIntegracaoHospital) {
        if (pai instanceof Frame) {
            return new ConfiguradorConveniosMV((Frame)pai, "Configura\u00e7\u00e3o MV", xmlIntegracaoHospital);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorConveniosMV((Dialog)pai, "Configura\u00e7\u00e3o MV", xmlIntegracaoHospital);
        }
        return null;
    }

    public ConfiguradorConveniosMV(Dialog pai, String titulo, String xmlIntegracaoHospital) {
        super(pai, titulo, xmlIntegracaoHospital);
        if (!Funcoes.textoVazio(xmlIntegracaoHospital)) {
            String protocolo = StringUtil.getValor(xmlIntegracaoHospital, "protocolo");
            this.xmlIntegracaoHospital = !Funcoes.textoVazio(protocolo) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.MV.getNome()) ? xmlIntegracaoHospital : null;
        }
        this.montaTela();
    }

    public ConfiguradorConveniosMV(Frame pai, String titulo, String xmlIntegracaoHospital) {
        super(pai, titulo, xmlIntegracaoHospital);
        if (!Funcoes.textoVazio(xmlIntegracaoHospital)) {
            String protocolo = StringUtil.getValor(xmlIntegracaoHospital, "protocolo");
            this.xmlIntegracaoHospital = !Funcoes.textoVazio(protocolo) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.MV.getNome()) ? xmlIntegracaoHospital : null;
        }
        this.montaTela();
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelCodigo.setDisplayedMnemonic('V');
        this.labelCodigo.setLabelFor(this.textCodigo);
        panelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        Dimension d = new Dimension(70, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        panelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        panelCentral.add((Component)this.checkIgnorar, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        panelCentral.add((Component)new JLabel(), c);
        panelCentral.setBorder(new TitledBorder(""));
        this.setSize(185, 130);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        Funcoes.montaEnter((JComponent)panelCentral);
        ScreenUtil.requisitarFoco(this.textCodigo);
        this.carregaDados();
    }

    private void carregaDados() {
        if (Funcoes.textoVazio(this.xmlIntegracaoHospital)) {
            return;
        }
        String protocolo = StringUtil.getValor(this.xmlIntegracaoHospital, "protocolo");
        if (protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.MV.getNome())) {
            String codigo = StringUtil.getValor(this.xmlIntegracaoHospital, "codigo");
            this.textCodigo.setText(codigo);
            Boolean ignorarResultado = StringUtil.getBoolean(this.xmlIntegracaoHospital, "ignorarResultado");
            if (ignorarResultado != null && ignorarResultado.booleanValue()) {
                this.checkIgnorar.setSelected(true);
            }
        } else {
            this.xmlIntegracaoHospital = null;
        }
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (!Funcoes.textoVazio(this.textCodigo)) {
            XMLStringBuilder xml = new XMLStringBuilder();
            try {
                xml.abrir("xmlconveniohospital");
                xml.escrever("protocolo", ProtocoloIntegracaoHospital.MV.getNome());
                xml.escrever("codigo", this.textCodigo.getText());
                xml.escrever("ignorarResultado", String.valueOf(this.checkIgnorar.isSelected()));
                xml.fechar("xmlconveniohospital");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
                return null;
            }
            return xml.getXML();
        }
        return null;
    }

    public String getCodigoConvenio() {
        return this.textCodigo.getText();
    }

    public Boolean isIgnorarResultado() {
        return this.checkIgnorar.isSelected();
    }
}

