/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.ghosp;

import jalis.integracaohospitais.util.AbstractConfiguradorExamesIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.cadastro.ExameMatCol;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.Collator;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorExamesGHosp
extends AbstractConfiguradorExamesIntegracaoHospital
implements WindowListener {
    public static final String TAG_EXAME_XML_LISTA_ITENS = "listaitens";
    public static final String TAG_EXAME_XML_ITEM = "item";
    public static final String TAG_EXAME_XML_DESCRICAO = "descricao";
    public static final String TAG_EXAME_XML_VARIAVEL = "variavel";
    public static final String TAG_EXAME_XML_VALOR_RESULTADO = "valorresultado";
    public static final String TAG_EXAME_XML_UNIDADE = "unidade";
    private TTextField textDescricao = new TTextField(100);
    private JComboBox comboValorResultado = new JComboBox();
    private JComboBox comboUnidadeMedida = new JComboBox();
    private TTextField textVariavel = new TTextField(50);
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o");
    private JLabel labelVariavel = new JLabel("Vari\u00e1vel");
    private JLabel labelValorResultado = new JLabel("Valor do resultado");
    private JLabel labelUnidadeMedida = new JLabel("Unidade de medida");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o", "Vari\u00e1vel", "Valor do resultado", "Unidade de medida"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private JButton buttonOK = new JButton("OK");
    private JButton buttonPesquisaUnidadeMedida = new JButton();
    private JButton buttonPesquisaResultado = new JButton();
    private static final int COLUNA_DESCRICAO = 0;
    private static final int COLUNA_VARIAVEL = 1;
    private static final int COLUNA_VALOR_RESULTADO = 2;
    private static final int COLUNA_UNIDADE_MEDIDA = 3;
    private ExameMatCol exameMatColeta = null;
    private String[] camposLaudo = null;
    private int linhaEdicao = -1;

    public static ConfiguradorExamesGHosp novaInstancia(Window pai, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        if (pai instanceof Frame) {
            return new ConfiguradorExamesGHosp((Frame)pai, "Associando campos de resultados - G-HOSP", xmlIntegracaoHospital, xmlAssociacaoCampos);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorExamesGHosp((Dialog)pai, "Associando campos de resultados - G-HOSP", xmlIntegracaoHospital, xmlAssociacaoCampos);
        }
        return null;
    }

    public ConfiguradorExamesGHosp(Dialog pai, String titulo, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        super(pai, titulo, xmlIntegracaoHospital, xmlAssociacaoCampos);
        this.montaTela();
    }

    public ConfiguradorExamesGHosp(Frame pai, String titulo, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        super(pai, titulo, xmlIntegracaoHospital, xmlAssociacaoCampos);
        this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        this.montaTela();
    }

    private void montaTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.setSize(new Dimension(700, 500));
        ScreenUtil.centralizar(this);
        this.buttonPesquisaResultado.setFocusable(false);
        this.buttonPesquisaUnidadeMedida.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.labelDescricao.setDisplayedMnemonic('D');
        this.getPanelCentral().add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.labelValorResultado.setLabelFor(this.textVariavel);
        this.labelValorResultado.setDisplayedMnemonic('V');
        this.getPanelCentral().add((Component)this.labelVariavel, c);
        ++c.gridx;
        this.labelValorResultado.setLabelFor(this.comboValorResultado);
        this.labelValorResultado.setDisplayedMnemonic('V');
        this.getPanelCentral().add((Component)this.labelValorResultado, c);
        c.gridx += 2;
        this.labelUnidadeMedida.setLabelFor(this.comboUnidadeMedida);
        this.labelUnidadeMedida.setDisplayedMnemonic('U');
        this.getPanelCentral().add((Component)this.labelUnidadeMedida, c);
        c.gridy += 3;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.textDescricao.setPreferredSize(new Dimension(180, 20));
        this.textDescricao.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.textDescricao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.textVariavel.setPreferredSize(new Dimension(130, 20));
        this.textVariavel.setMinimumSize(new Dimension(130, 20));
        this.getPanelCentral().add((Component)this.textVariavel, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.comboValorResultado.setPreferredSize(new Dimension(130, 20));
        this.comboValorResultado.setMinimumSize(new Dimension(130, 20));
        this.getPanelCentral().add((Component)this.comboValorResultado, c);
        ++c.gridx;
        this.buttonPesquisaResultado.setPreferredSize(new Dimension(40, 20));
        this.buttonPesquisaResultado.setMinimumSize(new Dimension(30, 20));
        this.buttonPesquisaResultado.setMargin(new Insets(1, 1, 1, 1));
        Funcoes.imagemPesquisa(this.buttonPesquisaResultado);
        this.getPanelCentral().add((Component)this.buttonPesquisaResultado, c);
        ++c.gridx;
        this.comboUnidadeMedida.setPreferredSize(new Dimension(130, 20));
        this.comboUnidadeMedida.setMinimumSize(new Dimension(130, 20));
        this.getPanelCentral().add((Component)this.comboUnidadeMedida, c);
        ++c.gridx;
        this.buttonPesquisaUnidadeMedida.setPreferredSize(new Dimension(40, 20));
        this.buttonPesquisaUnidadeMedida.setMinimumSize(new Dimension(30, 20));
        this.buttonPesquisaUnidadeMedida.setMargin(new Insets(1, 1, 1, 1));
        Funcoes.imagemPesquisa(this.buttonPesquisaUnidadeMedida);
        this.getPanelCentral().add((Component)this.buttonPesquisaUnidadeMedida, c);
        ++c.gridx;
        this.buttonOK.setPreferredSize(new Dimension(30, 20));
        this.buttonOK.setMinimumSize(new Dimension(30, 20));
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOK.setMnemonic('K');
        this.getPanelCentral().add((Component)this.buttonOK, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getPanelCentral().add((Component)this.scroll, c);
        this.modelo.setColumnSize(new int[]{0, 70, 150, 140}, this.table);
        this.montaListeners();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    private void montaListeners() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linha = ConfiguradorExamesGHosp.this.table.getSelectedRow();
                if (linha > -1) {
                    if (e.getKeyCode() == 32) {
                        ConfiguradorExamesGHosp.this.modificaLinha(linha);
                    } else if (e.getKeyCode() == 127) {
                        ConfiguradorExamesGHosp.this.removeLinha(linha);
                    }
                }
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorExamesGHosp.this.adicionaAssociacao();
            }
        });
        this.buttonPesquisaUnidadeMedida.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorExamesGHosp.this.configuraCampoUnidadeMedida();
            }
        });
        this.buttonPesquisaResultado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorExamesGHosp.this.configuraCampoResultado();
            }
        });
    }

    private void preencheCombosCamposLaudo() {
        if (this.camposLaudo == null) {
            return;
        }
        Arrays.sort(this.camposLaudo, Collator.getInstance());
        this.comboUnidadeMedida.addItem("");
        this.comboUnidadeMedida.setEditable(true);
        this.comboValorResultado.addItem("");
        for (String campo : this.camposLaudo) {
            this.comboUnidadeMedida.addItem(campo);
            this.comboValorResultado.addItem(campo);
        }
    }

    private void adicionaAssociacao() {
        if (this.validaCamposAdicao()) {
            String campoValorResultado = null;
            String campoUnidadeMedida = null;
            if (this.comboValorResultado.getSelectedItem() != null) {
                campoValorResultado = this.comboValorResultado.getSelectedItem().toString();
            }
            if (this.comboUnidadeMedida.getSelectedItem() != null) {
                campoUnidadeMedida = this.comboUnidadeMedida.getSelectedItem().toString();
            }
            if (this.linhaEdicao > -1) {
                this.modelo.setValueAt(this.textDescricao.getText(), this.linhaEdicao, 0);
                this.modelo.setValueAt(this.textVariavel.getText(), this.linhaEdicao, 1);
                this.modelo.setValueAt(campoUnidadeMedida, this.linhaEdicao, 3);
                this.modelo.setValueAt(campoValorResultado, this.linhaEdicao, 2);
            } else {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    if (!this.modelo.getValueAt(i, 0).toString().equalsIgnoreCase(this.textDescricao.getText())) continue;
                    Funcoes.mensagem(this, "A descri\u00e7\u00e3o j\u00e1 existe.\nUtilize outra descri\u00e7\u00e3o.", 2);
                    ScreenUtil.requisitarFoco(this.textDescricao);
                    return;
                }
                this.modelo.addLine(new Object[]{this.textDescricao.getText(), this.textVariavel.getText(), campoValorResultado, campoUnidadeMedida});
                this.textDescricao.clear();
                this.comboValorResultado.setSelectedItem("");
                this.comboUnidadeMedida.setSelectedItem("");
                this.textVariavel.setText("");
                this.linhaEdicao = -1;
                ScreenUtil.requisitarFoco(this.textDescricao);
            }
        }
    }

    private boolean validaCamposAdicao() {
        if (Funcoes.textoVazio(this.textDescricao)) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (Funcoes.textoVazio(this.textVariavel)) {
            Funcoes.mensagem(this, "A vari\u00e1vel deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textVariavel);
            return false;
        }
        if (this.comboValorResultado.getSelectedItem() == null || Funcoes.textoVazio(this.comboValorResultado.getSelectedItem().toString())) {
            Funcoes.mensagem(this, "O valor do resultado deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.comboValorResultado);
            return false;
        }
        if (this.comboUnidadeMedida.getSelectedItem() == null || Funcoes.textoVazio(this.comboUnidadeMedida.getSelectedItem().toString())) {
            Funcoes.mensagem(this, "A unidade de medida deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.comboUnidadeMedida);
            return false;
        }
        return true;
    }

    private void modificaLinha(int linha) {
        this.linhaEdicao = linha;
        this.textDescricao.setText(this.modelo.getValueAt(linha, 0).toString());
        this.textVariavel.setText(this.modelo.getValueAt(linha, 1).toString());
        this.comboValorResultado.setSelectedItem(this.modelo.getValueAt(linha, 2));
        this.comboUnidadeMedida.setSelectedItem(this.modelo.getValueAt(linha, 3));
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    private void removeLinha(int linha) {
        int resposta = Funcoes.mensagem(this, "Deseja remover a linha de associa\u00e7\u00e3o?", 4, true);
        if (resposta == 0) {
            this.modelo.removeLine(linha);
        }
    }

    private void configuraCampoUnidadeMedida() {
        String propriedadeCampoNomeUnidade = this.exameMatColeta.configuraAssociaCamposDeResultado();
        for (String campo : this.camposLaudo) {
            if (!campo.equalsIgnoreCase(propriedadeCampoNomeUnidade)) continue;
            this.comboUnidadeMedida.setSelectedItem(campo);
        }
    }

    private void configuraCampoResultado() {
        String propriedadeCampoNomeUnidade = this.exameMatColeta.configuraAssociaCamposDeResultado();
        for (String campo : this.camposLaudo) {
            if (!campo.equalsIgnoreCase(propriedadeCampoNomeUnidade)) continue;
            this.comboValorResultado.setSelectedItem(campo);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (this.modelo.getRowCount() > 0) {
            XMLStringBuilder xml = new XMLStringBuilder();
            try {
                if (this.modelo.getRowCount() > 0) {
                    xml.abrir("xmlexamehospital");
                    xml.escrever("protocolo", ProtocoloIntegracaoHospital.G_HOSP.getNome());
                    xml.escrever(this.getXmlAssociacaoCampos());
                    xml.fechar("xmlexamehospital");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
                return null;
            }
            return xml.getXML();
        }
        return null;
    }

    @Override
    public String getXmlAssociacaoCampos() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("xmlassociacaocampos");
            xml.abrir(TAG_EXAME_XML_LISTA_ITENS);
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                xml.abrir(TAG_EXAME_XML_ITEM);
                xml.escrever(TAG_EXAME_XML_DESCRICAO, this.modelo.getValueAt(i, 0).toString());
                xml.escrever(TAG_EXAME_XML_VARIAVEL, this.modelo.getValueAt(i, 1).toString());
                xml.escrever(TAG_EXAME_XML_VALOR_RESULTADO, this.modelo.getValueAt(i, 2).toString());
                xml.escrever(TAG_EXAME_XML_UNIDADE, this.modelo.getValueAt(i, 3).toString());
                xml.fechar(TAG_EXAME_XML_ITEM);
            }
            xml.fechar(TAG_EXAME_XML_LISTA_ITENS);
            xml.fechar("xmlassociacaocampos");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    public void setCamposLaudo(String[] camposResultado) {
        this.camposLaudo = camposResultado;
        this.preencheCombosCamposLaudo();
    }

    public void carregaDados() {
        String protocolo;
        if (!Funcoes.textoVazio(this.xmlIntegracaoHospital) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(this.xmlIntegracaoHospital, "protocolo")) && protocolo.equals(ProtocoloIntegracaoHospital.G_HOSP.getNome())) {
            String listaItens = StringUtil.getValor(this.xmlIntegracaoHospital, TAG_EXAME_XML_LISTA_ITENS);
            String[] itens = listaItens.split("<item>");
            for (int i = 0; i < itens.length; ++i) {
                String linha = itens[i];
                if (Funcoes.textoVazio(linha)) continue;
                String descricao = StringUtil.getValor(linha, TAG_EXAME_XML_DESCRICAO);
                String variavel = StringUtil.getValor(linha, TAG_EXAME_XML_VARIAVEL);
                String campoValorResultado = StringUtil.getValor(linha, TAG_EXAME_XML_VALOR_RESULTADO);
                String campoUnidadeMedida = StringUtil.getValor(linha, TAG_EXAME_XML_UNIDADE);
                if (Funcoes.textoVazio(descricao) || Funcoes.textoVazio(variavel) || Funcoes.textoVazio(campoValorResultado) || Funcoes.textoVazio(campoUnidadeMedida)) continue;
                this.modelo.addLine(new Object[]{descricao, variavel, campoValorResultado, campoUnidadeMedida});
            }
        }
        if (!Funcoes.textoVazio(this.xmlAssociacaoCampos)) {
            this.xmlAssociacaoCampos = StringUtil.getValor(this.xmlAssociacaoCampos, "xmlassociacaocampos", true);
        }
    }

    public String[] getCamposLaudo() {
        return this.camposLaudo;
    }

    public ExameMatCol getExameMatColeta() {
        return this.exameMatColeta;
    }

    public void setExameMatColeta(ExameMatCol exameMatColeta) {
        this.exameMatColeta = exameMatColeta;
    }
}

