/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util.ghosp;

import jalis.integracaohospitais.util.AbstractConfiguradorConveniosIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfiguradorConvenioGHosp
extends AbstractConfiguradorConveniosIntegracaoHospital {
    private TTextField textConvenio = new TTextField(6, 1);
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");

    public static ConfiguradorConvenioGHosp novaInstancia(Object pai, String xmlIntegracaoHospital) {
        if (pai instanceof Frame) {
            return new ConfiguradorConvenioGHosp((Frame)pai, xmlIntegracaoHospital);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorConvenioGHosp((Dialog)pai, xmlIntegracaoHospital);
        }
        return null;
    }

    public ConfiguradorConvenioGHosp(Dialog pai, String xmlIntegracaoHospital) {
        super(pai, "Configura\u00e7\u00e3o conv\u00eanios do G-Hosp", xmlIntegracaoHospital);
        String protocolo;
        if (!Funcoes.textoVazio(xmlIntegracaoHospital) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(xmlIntegracaoHospital, "protocolo")) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.G_HOSP.getNome())) {
            this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        }
        this.montaTela();
    }

    public ConfiguradorConvenioGHosp(Frame pai, String xmlIntegracaoHospital) {
        super(pai, "Configura\u00e7\u00e3o conv\u00eanios do G-Hosp", xmlIntegracaoHospital);
        String protocolo;
        if (!Funcoes.textoVazio(xmlIntegracaoHospital) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(xmlIntegracaoHospital, "protocolo")) && protocolo.equalsIgnoreCase(ProtocoloIntegracaoHospital.G_HOSP.getNome())) {
            this.xmlIntegracaoHospital = xmlIntegracaoHospital;
        }
        this.montaTela();
    }

    private void montaTela() {
        JPanel painelCentral = this.getPanelCentral();
        painelCentral.setLayout(new GridBagLayout());
        this.textConvenio.setMinimumSize(new Dimension(100, 20));
        this.textConvenio.setPreferredSize(new Dimension(100, 20));
        if (this.xmlIntegracaoHospital != null) {
            String aux = StringUtil.getValor(this.xmlIntegracaoHospital, "xmlconveniohospital");
            String codigoConvenio = StringUtil.getValor(aux, "codigo");
            this.textConvenio.setText(codigoConvenio);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.insets = new Insets(1, 5, 0, 0);
        this.labelConvenio.setDisplayedMnemonic('o');
        this.labelConvenio.setLabelFor(this.textConvenio);
        painelCentral.add((Component)this.labelConvenio, c);
        ++c.gridx;
        painelCentral.add((Component)this.textConvenio, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        painelCentral.add((Component)new JLabel(), c);
        this.setResizable(false);
        this.setSize(new Dimension(305, 110));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textConvenio);
    }

    public Integer getCodigoConvenio() {
        String valor = this.textConvenio.getText();
        if (!Funcoes.textoVazio(valor)) {
            return Integer.parseInt(valor);
        }
        return null;
    }

    @Override
    public String getXmlIntegracaoHospital() {
        if (this.getCodigoConvenio() != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append("xmlconveniohospital").append(">");
            buf.append("<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.G_HOSP.getNome()).append("</").append("protocolo").append(">");
            buf.append("<").append("codigo").append(">").append(this.getCodigoConvenio()).append("</").append("codigo").append(">");
            buf.append("</").append("xmlconveniohospital").append(">");
            return buf.toString();
        }
        return null;
    }
}

