/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util;

import jalis.util.Funcoes;
import java.util.Date;

public class TipoIdade {
    public static final String TIPO_ANO = "A";
    public static final String TIPO_MES = "M";
    public static final String TIPO_DIA = "D";
    private String tipoIdade = null;
    private Integer quantidade = null;

    public TipoIdade(String dataNascimento, String dataBase) {
        if (dataNascimento.length() > 0 && dataBase.length() > 0) {
            Date dataNascimentoAux = Funcoes.getData("yyyy-MM-dd", dataNascimento);
            Date dataBaseAux = Funcoes.getData("yyyy-MM-dd", dataBase);
            if (dataNascimentoAux != null && dataBaseAux != null) {
                int difAno = Funcoes.yearsBetween(dataNascimentoAux, dataBaseAux);
                int difMes = Funcoes.monthBetween(dataNascimentoAux, dataBaseAux);
                int difDia = Funcoes.daysBetween(dataNascimentoAux, dataBaseAux);
                if (difAno > 0) {
                    this.quantidade = difAno;
                    this.tipoIdade = TIPO_ANO;
                } else if (difMes > 0) {
                    this.quantidade = difMes;
                    this.tipoIdade = TIPO_MES;
                } else {
                    this.quantidade = difDia;
                    this.tipoIdade = TIPO_DIA;
                }
            }
        }
    }

    public String getTipoIdade() {
        return this.tipoIdade;
    }

    public Integer getQuantidade() {
        return this.quantidade;
    }
}

