/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util;

import jalis.comum.Variaveis;
import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalServidor;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.sistemas.IntegracaoHospital;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh;
import jalis.integracaohospitais.sistemas.tasy.IntegracaoHospitalTasyBanco;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.IntegracaoHospitalListener;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.configuracao.UsuarioMensagemBean;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.cadastro.auxiliares.UsuarioMensagemService;
import jalis.service.configuracao.UsuarioService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.util.Date;

public class TimerIntegracaoHospital
extends Thread {
    private static boolean parar = false;
    private static boolean aguardar = false;
    private static boolean isExecutando = false;
    private boolean mostrarIcones = true;
    private String tempoIntegracaoHospital = "";
    private IntegracaoHospital integracaoHospital = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private static DadosErrosIntegracaoHospital erros = null;
    private IntegracaoHospitalListener listener = null;

    public TimerIntegracaoHospital(String tempoIntegracaoHospital, IntegracaoHospital integracaoHospital, IntegracaoHospitalListener listener, String url, String user, String password) {
        super("Thread - IntegracaoHospital");
        this.setPriority(1);
        this.tempoIntegracaoHospital = tempoIntegracaoHospital;
        this.integracaoHospital = integracaoHospital;
        this.url = url;
        this.user = user;
        this.password = password;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!parar) {
            try {
                if (aguardar) continue;
                this.fireIntegracaoIniciada();
                if (!ConexaoIntegracaoHospitalServidor.getConnected() && this.integracaoHospital.getConectarBanco()) {
                    if (this.integracaoHospital instanceof IntegracaoHospitalTasyBanco) {
                        ConexaoIntegracaoHospitalServidor.configuraConexaoIntegracaoHospitalServidor("jdbc:oracle:thin:@" + this.url, this.user, this.password);
                    } else {
                        ConexaoIntegracaoHospitalServidor.configuraConexaoIntegracaoHospitalServidor("jdbc:postgresql://" + this.url, this.user, this.password);
                    }
                }
                erros = null;
                if (!this.integracaoHospital.isConexaoOK()) {
                    throw new Exception("N\u00e3o foi poss\u00edvel conectar-se ao hospital.");
                }
                erros = this.integracaoHospital.integrarHospital();
                StringBuilder bufProcesso = new StringBuilder();
                StringBuilder bufHospital = new StringBuilder();
                StringBuilder bufJalis = new StringBuilder();
                if (erros != null && erros.haErros()) {
                    String erro = "<html>";
                    erro = erro + "<font color = 'red'><b>Clique para visualizar a janela de erros</b></font><br>";
                    if (TimerIntegracaoHospital.erros.errosProcesso != null && TimerIntegracaoHospital.erros.errosProcesso.size() > 0) {
                        bufProcesso.append("<b>-- ").append(TimerIntegracaoHospital.erros.errosProcesso.size()).append(" erro(s) ao processar --</b><br>");
                        for (Exception exception : TimerIntegracaoHospital.erros.errosProcesso) {
                            if (exception instanceof IntegracaoHospitalException) {
                                bufProcesso.append(((IntegracaoHospitalException)exception).getMensagemErro()).append("<br>");
                                continue;
                            }
                            bufProcesso.append(exception.getMessage()).append("<br>");
                        }
                    }
                    erro = erro + bufProcesso.toString();
                    if (TimerIntegracaoHospital.erros.errosHospital != null && !TimerIntegracaoHospital.erros.errosHospital.isEmpty()) {
                        bufHospital.append("<b>-- ").append(TimerIntegracaoHospital.erros.errosHospital.size()).append(" erro(s) integrando (HOSPITAL -> JALIS) --</b><br>");
                        for (Exception exception : TimerIntegracaoHospital.erros.errosHospital) {
                            if (exception instanceof IntegracaoHospitalException) {
                                bufHospital.append(((IntegracaoHospitalException)exception).getMensagemErro()).append("<br>");
                                continue;
                            }
                            bufHospital.append(exception.getMessage()).append("<br>");
                        }
                    }
                    erro = erro + bufHospital.toString();
                    if (TimerIntegracaoHospital.erros.errosJalis != null && TimerIntegracaoHospital.erros.errosJalis.size() > 0) {
                        bufJalis.append("<b>-- Erro integrando (JALIS -> HOSPITAL) --</b><br>");
                        for (Exception exception : TimerIntegracaoHospital.erros.errosJalis) {
                            if (exception instanceof IntegracaoHospitalException) {
                                bufJalis.append(((IntegracaoHospitalException)exception).getMensagemErro()).append("<br>");
                                continue;
                            }
                            bufJalis.append(exception.getMessage()).append("<br>");
                        }
                    }
                    erro = erro + bufJalis.toString();
                    erro = erro + "</html>";
                    Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_ERRO);
                    Laboratorio.setHintIntegracaoHospital(erro);
                    String erroSemHtml = bufProcesso.toString() + bufHospital.toString() + bufJalis.toString();
                    erroSemHtml = erroSemHtml.replaceAll("<br>", "\n");
                    erroSemHtml = erroSemHtml.replaceAll("<b>", "");
                    erroSemHtml = erroSemHtml.replaceAll("</b>", "");
                    erroSemHtml = StringUtil.removerTags(erroSemHtml);
                    this.enviaMensagemUsuarioErro(this.integracaoHospital, erroSemHtml);
                    this.enviaEmailUsuarioErro(this.integracaoHospital, erroSemHtml);
                    continue;
                }
                Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_PARADO);
                Laboratorio.setHintIntegracaoHospital(null);
            }
            catch (Exception ex) {
                if (!this.mostrarIcones) continue;
                Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_ERRO);
                String erro = "<html>";
                erro = erro + "<b>-- Falha de conex\u00e3o/comunica\u00e7\u00e3o --</b><br>";
                erro = erro + ex.getMessage();
                erro = erro + "</html>";
                Laboratorio.setHintIntegracaoHospital(erro);
                this.geraLogErro(ex);
                String erroSemHtml = erro.replaceAll("<br>", "\n");
                erroSemHtml = erroSemHtml.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "");
                this.enviaMensagemUsuarioErro(this.integracaoHospital, erroSemHtml);
                this.enviaEmailUsuarioErro(this.integracaoHospital, erroSemHtml);
            }
            finally {
                this.fireIntegracaoFinalizada();
                try {
                    if (Funcoes.isNumeric(this.tempoIntegracaoHospital) && Integer.parseInt(this.tempoIntegracaoHospital) > 0) {
                        TimerIntegracaoHospital.sleep(Integer.parseInt(this.tempoIntegracaoHospital) * 60000);
                        continue;
                    }
                    TimerIntegracaoHospital.sleep(60000L);
                }
                catch (Exception exception) {}
            }
        }
        if (this.integracaoHospital != null) {
            this.integracaoHospital.fecharConexoes();
        }
    }

    private void geraLogErro(Exception e) {
        StringBuilder erroPilha = new StringBuilder();
        for (StackTraceElement st : e.getStackTrace()) {
            erroPilha.append(String.format("%s %s.%s(%s) ", st.getFileName(), st.getClassName(), st.getMethodName(), st.getLineNumber())).append("\n");
        }
        try {
            StringUtil.escreverArquivoTexto(this.nomeArquivoErro(), erroPilha.toString());
        }
        catch (Exception e1) {
            Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel armazenar o log de comunica\u00e7\u00e3o.\nMensagem: " + e1.getMessage(), 1);
        }
    }

    private String nomeArquivoErro() {
        Date dt = new Date();
        StringBuilder nome = new StringBuilder();
        nome.append(System.getProperty("user.home"));
        nome.append("/ErroIntegracaoHospital_");
        nome.append(Funcoes.formataData("yyyyMMdd_HHmmss", dt));
        nome.append(".log");
        return nome.toString();
    }

    private void fireIntegracaoFinalizada() {
        if (this.listener != null) {
            this.listener.integracaoFinalizada();
        }
        isExecutando = false;
    }

    private void fireIntegracaoIniciada() {
        if (this.listener != null) {
            this.listener.integracaoIniciada();
        }
        isExecutando = true;
    }

    public static boolean isExecutando() {
        return isExecutando;
    }

    private void enviaEmailUsuarioErro(IntegracaoHospital integracaoHospital, String mensagemErro) {
        String xml;
        if (integracaoHospital instanceof IntegracaoHospitalSigh && (xml = integracaoHospital.getXML()) != null && !Funcoes.textoVazio(xml)) {
            String[] emails;
            String emailErro = StringUtil.getValor(xml, "EmailErro");
            emailErro = StringUtil.removeEspacosDuplicados(emailErro);
            if ((emailErro = emailErro.replaceAll(",", "#").replaceAll(" ", "#").replaceAll(";", "#")) == null || Funcoes.textoVazio(emailErro)) {
                return;
            }
            for (String email : emails = emailErro.split("#")) {
                ErrorLogger.enviarEmail(email.trim(), mensagemErro, "Erro - integra\u00e7\u00e3o com hospital");
            }
        }
    }

    private void enviaMensagemUsuarioErro(IntegracaoHospital integracaoHospital, String mensagemErro) {
        String xml;
        if (integracaoHospital instanceof IntegracaoHospitalSigh && (xml = integracaoHospital.getXML()) != null && !Funcoes.textoVazio(xml)) {
            String codUsuarioErro = StringUtil.getValor(xml, "UsuarioErro");
            if (codUsuarioErro == null || Funcoes.textoVazio(codUsuarioErro)) {
                return;
            }
            for (String user : codUsuarioErro.split(";")) {
                UsuarioVO usuarioErro = null;
                try {
                    usuarioErro = (UsuarioVO)new UsuarioService().getVO(Variaveis.filialPadrao, user);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel identificar o usu\u00e1rio de erro - Integra\u00e7\u00e3o hospital.\n" + e.getMessage(), e.getStackTrace());
                }
                UsuarioVO remetente = null;
                try {
                    remetente = (UsuarioVO)new UsuarioService().getVO(Variaveis.filialPadrao, Variaveis.login);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel identificar o usu\u00e1rio remetente - Integra\u00e7\u00e3o hospital.\n" + e.getMessage(), e.getStackTrace());
                }
                UsuarioMensagemBean mensagem = new UsuarioMensagemBean();
                mensagem.setConfirmarLeitura(false);
                mensagem.setAvisada(false);
                mensagem.setDataHora(new Date());
                mensagem.setDestino(usuarioErro);
                mensagem.setOrigem(remetente);
                mensagem.setAssunto("Erro - integra\u00e7\u00e3o com hospital");
                mensagem.setMensagem(mensagemErro);
                try {
                    new UsuarioMensagemService().insert(mensagem, null, null, null);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar mensagem - Integra\u00e7\u00e3o hospital.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    public void parar() {
        parar = true;
        if (this.integracaoHospital != null) {
            this.integracaoHospital.fecharConexoes();
        }
    }

    public void setMostrarIcones(boolean b) {
        this.mostrarIcones = b;
    }

    public static void setAguardar(boolean aguardar) {
        TimerIntegracaoHospital.aguardar = aguardar;
    }

    public static DadosErrosIntegracaoHospital getErrosIntegracaoHospital() {
        return erros;
    }
}

