/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.ErrosIntegracaoHospital;
import jalis.integracaohospitais.util.ExameRender;
import jalis.integracaohospitais.util.FabricaIntegracaoHospital;
import jalis.integracaohospitais.util.ObjetoOperacaoSigh;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.FilialService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class ReenviarInformacaoSigh
extends AbstractDialogoOKCancelar {
    private SteppedComboBox comboBoxOperacao = new SteppedComboBox();
    private JLabel labelFilial = new JLabel("Filial: ");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o: ");
    private TTextField textFieldFilial = new TTextField(12, 1);
    private TTextField textFieldRequisicao = new TTextField(12, 1);
    private JLabel labelDescFilial = new JLabel();
    private JLabel labelDescRequisicao = new JLabel();
    private static ReenviarInformacaoSigh intanciaTela = null;
    private String xmlConfig = null;
    private IntegracaoHospitalSigh integracaoSig;
    private ModeloGridTable modExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Cod. Mat.", "Material", "#"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    };
    private JTable tableExame = new JTable(){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 4;
        }
    };
    private JButton buttonBuscaFilial = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonBuscaReq = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JPanel panelExames = new JPanel();
    private JScrollPane scrollExames = new JScrollPane();

    public ReenviarInformacaoSigh(ErrosIntegracaoHospital.JanelaErrosIntegracaoHospital janelaErrosIntegracaoHospital, String titulo) {
        super((Dialog)janelaErrosIntegracaoHospital, titulo);
        this.getBotaoOK().setText("Reenviar");
        this.getBotaoOK().setMnemonic('R');
        this.setLocationRelativeTo(janelaErrosIntegracaoHospital);
        this.setResizable(false);
        this.scrollExames.setViewportView(this.tableExame);
        this.tableExame.setModel(this.modExame);
        this.tableExame.setDefaultRenderer(Object.class, new ExameRender());
        this.tableExame.setEnabled(true);
        this.modExame.setColumnSize(new int[]{100, 0, 100, 200, 20}, this.tableExame);
        this.panelExames.setLayout(new GridBagLayout());
        this.panelExames.setBorder(new TitledBorder("Exames"));
        JPanel panelOperacao = new JPanel();
        panelOperacao.setLayout(new GridBagLayout());
        panelOperacao.setBorder(new TitledBorder("Opera\u00e7\u00f5es"));
        GridBagConstraints cop = new GridBagConstraints();
        cop.gridx = 0;
        cop.gridy = 0;
        cop.anchor = 17;
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        GridBagConstraints crequisicao = new GridBagConstraints();
        crequisicao.gridx = 0;
        crequisicao.gridy = 0;
        crequisicao.anchor = 17;
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 0;
        c3.gridy = 0;
        c3.anchor = 17;
        c3.fill = 1;
        c3.weightx = 1.0;
        c3.weighty = 1.0;
        JPanel panelRequisicao = new JPanel();
        panelRequisicao.setLayout(new GridBagLayout());
        panelRequisicao.setBorder(new TitledBorder("Requisi\u00e7\u00e3o"));
        this.comboBoxOperacao.setPreferredSize(new Dimension(170, 20));
        this.comboBoxOperacao.setMinimumSize(new Dimension(170, 20));
        this.comboBoxOperacao.addItem(new ObjetoOperacaoSigh("C", "Cancelar requisi\u00e7\u00e3o"));
        this.comboBoxOperacao.addItem(new ObjetoOperacaoSigh("I", "Inserir conta"));
        this.comboBoxOperacao.addItem(new ObjetoOperacaoSigh("R", "Remover conta"));
        this.comboBoxOperacao.addItem(new ObjetoOperacaoSigh("O", "Enviar resultado"));
        cop.fill = 13;
        cop.weightx = 0.0;
        cop.gridx = 0;
        panelOperacao.add((Component)this.comboBoxOperacao, cop);
        ++cop.gridx;
        cop.fill = 2;
        cop.weightx = 1.0;
        panelOperacao.add((Component)new JLabel(), cop);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        panel.add((Component)panelOperacao, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)panelRequisicao, c);
        panelRequisicao.add((Component)this.labelFilial, crequisicao);
        ++crequisicao.gridx;
        this.textFieldFilial.setPreferredSize(new Dimension(100, 20));
        this.textFieldFilial.setMinimumSize(new Dimension(100, 20));
        panelRequisicao.add((Component)this.textFieldFilial, crequisicao);
        ++crequisicao.gridx;
        this.buttonBuscaFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaFilial.setMinimumSize(new Dimension(20, 20));
        panelRequisicao.add((Component)this.buttonBuscaFilial, crequisicao);
        ++crequisicao.gridx;
        this.labelDescFilial.setBorder(new TitledBorder(""));
        this.labelDescFilial.setPreferredSize(new Dimension(700, 20));
        this.labelDescFilial.setMinimumSize(new Dimension(150, 20));
        crequisicao.fill = 2;
        crequisicao.weightx = 1.0;
        crequisicao.insets = new Insets(0, 1, 0, 0);
        panelRequisicao.add((Component)this.labelDescFilial, crequisicao);
        crequisicao.gridx = 0;
        crequisicao.gridy = 1;
        crequisicao.fill = 17;
        crequisicao.weightx = 0.0;
        crequisicao.insets = new Insets(0, 0, 0, 0);
        panelRequisicao.add((Component)this.labelRequisicao, crequisicao);
        ++crequisicao.gridx;
        this.textFieldRequisicao.setPreferredSize(new Dimension(100, 20));
        this.textFieldRequisicao.setMinimumSize(new Dimension(100, 20));
        panelRequisicao.add((Component)this.textFieldRequisicao, crequisicao);
        ++crequisicao.gridx;
        this.buttonBuscaReq.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaReq.setMinimumSize(new Dimension(20, 20));
        panelRequisicao.add((Component)this.buttonBuscaReq, crequisicao);
        ++crequisicao.gridx;
        this.labelDescRequisicao.setBorder(new TitledBorder(""));
        this.labelDescRequisicao.setPreferredSize(new Dimension(150, 20));
        this.labelDescRequisicao.setMinimumSize(new Dimension(150, 20));
        crequisicao.fill = 2;
        crequisicao.weightx = 1.0;
        crequisicao.insets = new Insets(0, 1, 0, 0);
        panelRequisicao.add((Component)this.labelDescRequisicao, crequisicao);
        this.panelExames.setPreferredSize(new Dimension(10, 200));
        this.panelExames.add((Component)this.scrollExames, c3);
        ++crequisicao.gridy;
        crequisicao.gridx = 0;
        crequisicao.weighty = 1.0;
        crequisicao.weightx = 1.0;
        crequisicao.gridwidth = 4;
        crequisicao.fill = 1;
        panelRequisicao.add((Component)this.panelExames, crequisicao);
        this.setUsuarioPodeCancelar(false);
        this.listener();
        this.desabilitar();
        this.processaCampos();
        ScreenUtil.requisitarFoco(this.comboBoxOperacao);
        this.pack();
        ScreenUtil.centralizar(this);
        intanciaTela = this;
        this.processaConfiguracao();
    }

    private void processaConfiguracao() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select est_integracaohospital ");
        buf.append("       ,est_xmlhospital ");
        buf.append("   from estacoes ");
        buf.append("  where est_codigo = ").append(Variaveis.codigoEstacao);
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next() && rs.getBoolean("est_integracaohospital") && !Funcoes.textoVazio(rs.getString("est_xmlhospital"))) {
                String configuracao = rs.getString("est_xmlhospital");
                this.integracaoSig = (IntegracaoHospitalSigh)FabricaIntegracaoHospital.novaIntegracaoHospital(ProtocoloIntegracaoHospital.SIGH, configuracao);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel iniciar a Integra\u00e7\u00e3o com o hospital. " + e.getMessage(), e.getStackTrace());
        }
    }

    public static ReenviarInformacaoSigh getIntanciaTela() {
        return intanciaTela;
    }

    public SteppedComboBox getComboBoxOperacao() {
        return this.comboBoxOperacao;
    }

    private void desabilitar() {
        this.labelDescFilial.setEnabled(false);
        this.labelDescRequisicao.setEnabled(false);
        this.textFieldFilial.setEnabled(false);
        this.textFieldRequisicao.setEnabled(false);
        this.buttonBuscaFilial.setEnabled(false);
        this.buttonBuscaReq.setEnabled(false);
        this.modExame.clear();
        this.tableExame.setEnabled(false);
    }

    private void listener() {
        this.buttonBuscaReq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReenviarInformacaoSigh.this.pesquisaRequisicao();
            }
        });
        this.buttonBuscaFilial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReenviarInformacaoSigh.this.pesquisaFilial();
            }
        });
        this.comboBoxOperacao.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReenviarInformacaoSigh.this.limpar();
                ReenviarInformacaoSigh.this.desabilitar();
                if (e.getStateChange() == 1) {
                    ReenviarInformacaoSigh.this.processaCampos();
                }
            }
        });
        this.textFieldFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block5: {
                    ReenviarInformacaoSigh.this.modExame.clear();
                    ReenviarInformacaoSigh.this.textFieldRequisicao.setText("");
                    ReenviarInformacaoSigh.this.labelDescRequisicao.setText("");
                    if (!Funcoes.textoVazio(ReenviarInformacaoSigh.this.textFieldFilial.getText())) {
                        FilialService filialService = new FilialService();
                        try {
                            FilialBean filialBean = (FilialBean)filialService.get(ReenviarInformacaoSigh.this.textFieldFilial.getText());
                            if (filialBean != null) {
                                ReenviarInformacaoSigh.this.labelDescFilial.setText(filialBean.getDescricao());
                                ReenviarInformacaoSigh.this.textFieldFilial.setText(filialBean.getCodigo().toString());
                                break block5;
                            }
                            ReenviarInformacaoSigh.this.textFieldFilial.setText("");
                            ReenviarInformacaoSigh.this.labelDescFilial.setText("");
                        }
                        catch (Exception e1) {
                            ErrorLogger.mostraMensagem(ReenviarInformacaoSigh.getIntanciaTela(), "Filial n\u00e3o identificada", e1.getStackTrace());
                        }
                    } else {
                        ReenviarInformacaoSigh.this.textFieldFilial.setText("");
                        ReenviarInformacaoSigh.this.labelDescFilial.setText("");
                    }
                }
            }
        });
        this.textFieldFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ReenviarInformacaoSigh.this.pesquisaFilial();
                }
            }
        });
        this.textFieldRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block8: {
                    if (Funcoes.textoVazio(ReenviarInformacaoSigh.this.textFieldFilial.getText()) && !Funcoes.textoVazio(ReenviarInformacaoSigh.this.textFieldRequisicao.getText())) {
                        Funcoes.mensagem(ReenviarInformacaoSigh.getIntanciaTela(), "Informe a filial.", 2);
                        ScreenUtil.requisitarFoco(ReenviarInformacaoSigh.this.textFieldFilial);
                        return;
                    }
                    if (!Funcoes.textoVazio(ReenviarInformacaoSigh.this.textFieldRequisicao.getText()) && ReenviarInformacaoSigh.this.adiciona()) {
                        RequisicaoService requisicaoService = new RequisicaoService();
                        HashMap<String, Object> chaves = new HashMap<String, Object>();
                        chaves.put("fil_codigo", ReenviarInformacaoSigh.this.textFieldFilial.getText());
                        chaves.put("req_codigo", ReenviarInformacaoSigh.this.textFieldRequisicao.getText());
                        try {
                            RequisicaoVO requisicaoVO = (RequisicaoVO)requisicaoService.getVO(chaves);
                            if (requisicaoVO != null) {
                                ReenviarInformacaoSigh.this.textFieldRequisicao.setText(requisicaoVO.getCodigo().toString());
                                ReenviarInformacaoSigh.this.labelDescRequisicao.setText(requisicaoVO.getPaciente().getNome());
                                ReenviarInformacaoSigh.this.addExamesModelo(requisicaoVO);
                                break block8;
                            }
                            ReenviarInformacaoSigh.this.modExame.clear();
                            ReenviarInformacaoSigh.this.textFieldRequisicao.setText("");
                            ReenviarInformacaoSigh.this.labelDescRequisicao.setText("Requisi\u00e7\u00e3o n\u00e3o localizada ou n\u00e3o relacionada ao Sigh");
                        }
                        catch (ThreadDaoException e1) {
                            ErrorLogger.mostraMensagem(ReenviarInformacaoSigh.getIntanciaTela(), "Requsi\u00e7\u00e3o n\u00e3o identificada", e1.getStackTrace());
                        }
                    } else {
                        if (Funcoes.textoVazio(ReenviarInformacaoSigh.this.textFieldRequisicao.getText())) {
                            ReenviarInformacaoSigh.this.labelDescRequisicao.setText("");
                        } else {
                            ReenviarInformacaoSigh.this.labelDescRequisicao.setText("Requisi\u00e7\u00e3o n\u00e3o localizada ou n\u00e3o relacionada ao Sigh");
                        }
                        ReenviarInformacaoSigh.this.textFieldRequisicao.setText("");
                        ReenviarInformacaoSigh.this.modExame.clear();
                    }
                }
            }
        });
        this.textFieldRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ReenviarInformacaoSigh.this.pesquisaRequisicao();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean adiciona() {
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select (a.req_codigo > 0) as adiciona from requisicao a inner join convenios d on d.fil_codigo = a.fil_codigo and d.con_codigo = a.con_codigo ");
            sql.append(" where a.fil_codigo = ").append(this.textFieldFilial.getText());
            sql.append(" and a.req_codigo = ").append(this.textFieldRequisicao.getText());
            sql.append(this.getCondicao());
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                boolean bl = rs.getBoolean("adiciona");
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel consultar requisi\u00e7\u00e3o para adicionar", e.getStackTrace());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    private void addExamesModelo(RequisicaoVO requisicaoVO) {
        boolean liberaTable;
        ObjetoOperacaoSigh operacao = (ObjetoOperacaoSigh)this.comboBoxOperacao.getSelectedItem();
        boolean bl = liberaTable = operacao.getOperacao().equalsIgnoreCase("C") || operacao.getOperacao().equalsIgnoreCase("T");
        if (liberaTable) {
            this.tableExame.setEnabled(false);
        } else {
            this.tableExame.setEnabled(true);
        }
        this.modExame.clear();
        for (ExameRequisicaoVO exame : requisicaoVO.getExames()) {
            this.modExame.addLine(new Object[]{exame.getExame().getCodigo(), exame.getExame().getDescricao(), exame.getMaterial().getAbreviatura(), exame.getMaterial().getDescricao(), Boolean.TRUE, exame});
        }
    }

    private void pesquisaFilial() {
        this.modExame.clear();
        Hashtable filial = Pesquisas.filial(ReenviarInformacaoSigh.getIntanciaTela(), false);
        if (filial != null) {
            this.labelDescFilial.setText(filial.get("fil_descricao").toString());
            this.textFieldFilial.setText(filial.get("fil_codigo").toString());
            ScreenUtil.requisitarFoco(this.textFieldFilial);
        } else {
            this.labelDescFilial.setText("");
            this.textFieldFilial.setText("");
        }
    }

    private void pesquisaRequisicao() {
        if (Funcoes.textoVazio(this.textFieldFilial.getText())) {
            Funcoes.mensagem(ReenviarInformacaoSigh.getIntanciaTela(), "Informe a filial.", 2);
            ScreenUtil.requisitarFoco(this.textFieldFilial);
            return;
        }
        Hashtable requisicao = Pesquisas.requisicao(ReenviarInformacaoSigh.getIntanciaTela(), this.textFieldFilial.getText(), false, false, null, null, null, false, false, this.getCondicao());
        if (requisicao != null) {
            this.labelDescRequisicao.setText(requisicao.get("pac_nome").toString());
            this.textFieldRequisicao.setText(requisicao.get("req_codigo").toString());
            ScreenUtil.requisitarFoco(this.textFieldRequisicao);
            RequisicaoService requisicaoService = new RequisicaoService();
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", this.textFieldFilial.getText());
            chaves.put("req_codigo", this.textFieldRequisicao.getText());
            try {
                RequisicaoVO requisicaoVO = (RequisicaoVO)requisicaoService.getVO(chaves);
                if (requisicaoVO != null) {
                    this.textFieldRequisicao.setText(requisicaoVO.getCodigo().toString());
                    this.labelDescRequisicao.setText(requisicaoVO.getPaciente().getNome());
                    this.addExamesModelo(requisicaoVO);
                }
            }
            catch (ThreadDaoException e1) {
                ErrorLogger.mostraMensagem(ReenviarInformacaoSigh.getIntanciaTela(), "N\u00e3o foi poss\u00edvel buscar requisi\u00e7\u00e3o", e1.getStackTrace());
            }
        } else {
            this.labelDescRequisicao.setText("");
            this.textFieldRequisicao.setText("");
            this.modExame.clear();
        }
    }

    private String getCondicao() {
        StringBuilder sql = new StringBuilder();
        ObjetoOperacaoSigh operacao = (ObjetoOperacaoSigh)this.comboBoxOperacao.getSelectedItem();
        if (operacao.getOperacao().equalsIgnoreCase("C")) {
            return "";
        }
        if (operacao.getOperacao().equalsIgnoreCase("O")) {
            sql.append(" AND a.req_integracaohospital is not null and a.req_integracaohospital <> '' ");
        } else if (operacao.getOperacao().equalsIgnoreCase("R") || operacao.getOperacao().equalsIgnoreCase("I")) {
            sql.append(" AND upper(d.con_integracaohospital) like upper('%<cobranca>false</cobranca>%') ");
        } else if (operacao.getOperacao().equalsIgnoreCase("T")) {
            // empty if block
        }
        return sql.toString();
    }

    private void processaCampos() {
        if (this.comboBoxOperacao.getSelectedIndex() == -1) {
            return;
        }
        ObjetoOperacaoSigh operacao = (ObjetoOperacaoSigh)this.comboBoxOperacao.getSelectedItem();
        if (operacao.getOperacao().equalsIgnoreCase("C") || operacao.getOperacao().equalsIgnoreCase("T")) {
            this.labelDescFilial.setEnabled(true);
            this.labelDescRequisicao.setEnabled(true);
            this.textFieldFilial.setEnabled(true);
            this.textFieldRequisicao.setEnabled(true);
            this.buttonBuscaFilial.setEnabled(true);
            this.buttonBuscaReq.setEnabled(true);
            this.modExame.clear();
            this.panelExames.setVisible(false);
        } else {
            this.labelDescFilial.setEnabled(true);
            this.labelDescRequisicao.setEnabled(true);
            this.textFieldFilial.setEnabled(true);
            this.textFieldRequisicao.setEnabled(true);
            this.buttonBuscaFilial.setEnabled(true);
            this.buttonBuscaReq.setEnabled(true);
            this.panelExames.setVisible(true);
            this.modExame.clear();
            this.tableExame.setEnabled(true);
        }
        this.pack();
    }

    private void limpar() {
        this.labelDescFilial.setText("");
        this.labelDescRequisicao.setText("");
        this.textFieldFilial.setText("");
        this.textFieldRequisicao.setText("");
        this.modExame.clear();
        this.desabilitar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            try {
                this.reenviar();
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.arquivaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel reenviar dados", ex.getStackTrace());
            }
        } else {
            Object o = e.getSource();
            if (o == this.buttonCancelar) {
                this.acaoCancelar();
                this.dispose();
            }
        }
    }

    private void reenviar() throws Exception {
        DadosErrosIntegracaoHospital errosEncontrados = new DadosErrosIntegracaoHospital();
        if (this.validar()) {
            boolean processado = false;
            ObjetoOperacaoSigh operacao = (ObjetoOperacaoSigh)this.comboBoxOperacao.getSelectedItem();
            if (operacao.getOperacao().equalsIgnoreCase("C")) {
                processado = this.integracaoSig.cancelaRequisicao(this.textFieldFilial.getText(), this.textFieldRequisicao.getText());
            } else if (!operacao.getOperacao().equalsIgnoreCase("T")) {
                if (operacao.getOperacao().equalsIgnoreCase("I")) {
                    for (int i = 0; i < this.modExame.getRowCount(); ++i) {
                        boolean inserirExame = (Boolean)this.modExame.getValueAt(i, 4);
                        if (!inserirExame) continue;
                        ExameRequisicaoVO exame = (ExameRequisicaoVO)this.modExame.getValueAt(i, 5);
                        processado = this.integracaoSig.insereExamePaciente(this.textFieldFilial.getText(), this.textFieldRequisicao.getText(), exame.getExame().getCodigo(), exame.getMaterial().getCodigo().toString(), errosEncontrados);
                    }
                } else if (operacao.getOperacao().equalsIgnoreCase("R")) {
                    for (int i = 0; i < this.modExame.getRowCount(); ++i) {
                        boolean inserirExame = (Boolean)this.modExame.getValueAt(i, 4);
                        if (!inserirExame) continue;
                        ExameRequisicaoVO exame = (ExameRequisicaoVO)this.modExame.getValueAt(i, 5);
                        processado = this.integracaoSig.excluiExame(this.textFieldFilial.getText(), this.textFieldRequisicao.getText(), exame.getExame().getCodigo(), exame.getMaterial().getCodigo().toString(), errosEncontrados);
                    }
                } else if (operacao.getOperacao().equalsIgnoreCase("O")) {
                    for (int i = 0; i < this.modExame.getRowCount(); ++i) {
                        boolean inserirExame = (Boolean)this.modExame.getValueAt(i, 4);
                        if (!inserirExame) continue;
                        ExameRequisicaoVO exame = (ExameRequisicaoVO)this.modExame.getValueAt(i, 5);
                        processado = this.integracaoSig.setResultadoExameRequisicao(this.textFieldFilial.getText(), this.textFieldRequisicao.getText(), exame.getExame().getCodigo(), exame.getMaterial().getCodigo().toString(), errosEncontrados);
                    }
                }
            }
            if (processado) {
                this.limpar();
                this.comboBoxOperacao.setSelectedIndex(0);
                this.processaCampos();
                ScreenUtil.requisitarFoco(this.comboBoxOperacao);
                Funcoes.mensagem(this, "Envio processado corretamente.", 2);
            } else {
                Funcoes.mensagem(this, "N\u00e3o foi possivel processar o envio.", 1);
            }
        }
    }

    private boolean validar() {
        if (Funcoes.textoVazio(this.textFieldFilial.getText())) {
            Funcoes.mensagem(this, "Informe a filial", 2);
            ScreenUtil.requisitarFoco(this.textFieldFilial);
            return false;
        }
        if (Funcoes.textoVazio(this.textFieldRequisicao.getText())) {
            Funcoes.mensagem(this, "Informe a requisi\u00e7\u00e3o", 2);
            ScreenUtil.requisitarFoco(this.textFieldRequisicao);
            return false;
        }
        ObjetoOperacaoSigh operacao = (ObjetoOperacaoSigh)this.comboBoxOperacao.getSelectedItem();
        if (!operacao.getOperacao().equalsIgnoreCase("C") && !operacao.getOperacao().equalsIgnoreCase("T")) {
            boolean exameNaoSelecionado = false;
            for (int i = 0; i < this.modExame.getRowCount(); ++i) {
                boolean select = (Boolean)this.modExame.getValueAt(i, 4);
                if (!select) continue;
                exameNaoSelecionado = true;
                break;
            }
            if (!exameNaoSelecionado) {
                Funcoes.mensagem(this, "Exames devem ser selecionados.", 2);
                ScreenUtil.requisitarFoco(this.tableExame);
                return false;
            }
        }
        return true;
    }

    public String obterExame() {
        return "'" + this.textFieldRequisicao.getText() + "'";
    }
}

