/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.resultados.IntegracaoIDSSaude;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class JanelaIntegracaoIDSErros
extends JDialog
implements ActionListener {
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_REQUISICAO = 1;
    private final int COLUNA_DATA = 2;
    private final int COLUNA_USUARIO = 3;
    private final int COLUNA_EXAME = 4;
    private final int COLUNA_MATERIAL = 5;
    private final int COLUNA_EXPORTADO = 6;
    private final int COLUNA_MENSAGEM = 7;
    private final int COLUNA_OBJETO = 8;
    private JLabel labelLocalizar = new JLabel("Requisi\u00e7\u00e3o:");
    private TTextField textLocalizar = new TTextField();
    private JPanel panelLogs = new JPanel(new GridBagLayout());
    private JPanel panelExcecao = new JPanel(new BorderLayout());
    private JPanel panelPilhaExcecao = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JButton buttonMarcarComoExportado = new JButton("Marcar como corrigido");
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonLocalizar = new JButton("Enviar");
    private JCheckBox checkMostrarEnviados = new JCheckBox("Somente enviados");
    private ModeloGridTable modeloLogs = new ModeloGridTable(new String[]{"Fil.", "Req.", "Data", "Usu\u00e1rio", "Exame", "Mat.", "#"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 6) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            return columnIndex == 6;
        }
    };
    private JTable tableLogs = new JTable(this.modeloLogs);
    private JScrollPane scrollLogs = new JScrollPane(this.tableLogs);
    private JTextPane textPaneExcecao = new JTextPane();
    private JScrollPane scrollExcecao = new JScrollPane(this.textPaneExcecao);
    private JTextPane textPanePilhaExcecao = new JTextPane();
    private JScrollPane scrollPilhaExcecao = new JScrollPane(this.textPanePilhaExcecao);
    private PreparedStatement prstMarcarExportado = null;
    private boolean podeMarcarExportado = false;

    public JanelaIntegracaoIDSErros(Frame pai, String titulo) {
        super(pai);
        this.setTitle(titulo);
        this.setModal(true);
        this.montaTela();
        this.carregaDados(false);
        StringBuilder buf = new StringBuilder();
        buf.append(" update logids ");
        buf.append("    set ids_exportado = true ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and ids_codigo = ? ");
        this.prstMarcarExportado = Conexao.getPreparedStatement(buf.toString());
    }

    private void carregaDados(boolean isEnviados) {
        this.modeloLogs.clear();
        StringBuilder buf = new StringBuilder();
        buf.append("select * from logids");
        buf.append(" where ");
        if (isEnviados) {
            buf.append(" ids_mensagem ilike '%Resultado Importado%' ");
            buf.append(" and ids_exportado ");
        } else {
            buf.append(" not ids_exportado ");
        }
        buf.append(" order by ids_datahora, fil_codigo, req_codigo desc");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                Registro reg = new Registro(rs);
                this.modeloLogs.addLine(new Object[]{reg.getValor("fil_codigo"), reg.getValor("req_codigo"), Funcoes.formataData(reg.getDate("ids_datahora")), reg.getValor("usr_codigo"), reg.getValor("exa_codigo"), reg.getValor("mco_codigo"), reg.getValor("Mensagem"), Boolean.FALSE, reg});
            }
            if (this.modeloLogs.getRowCount() > 0) {
                this.modeloLogs.ordenarColunaSemTrocarSentido(1);
                this.tableLogs.getSelectionModel().setSelectionInterval(0, 0);
            }
            rs.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e2o foi poss\u00edvel carregar os logs.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reenviarExames(Registro log, String requisicao) {
        StringBuilder buf = new StringBuilder();
        buf.append("select req.fil_codigo, ");
        buf.append("       req.req_codigo, ");
        buf.append("       req.req_xmlagendamentoids, ");
        buf.append("       req.con_codigo, ");
        buf.append("       req.req_anomes, ");
        buf.append("       req.req_idade, ");
        buf.append("       req.req_codigoapoiado, ");
        buf.append("       req.des_codigo, ");
        buf.append("       exr.exa_codigo, ");
        buf.append("       exr.mco_codigo, ");
        buf.append("       exr.met_codigo, ");
        buf.append("       err.ert_resultado as exr_resultado ");
        buf.append("  from examerequisicao exr ");
        buf.append("  join examerequisicaoresultado err on exr.fil_codigo = err.fil_codigo and exr.req_codigo = err.req_codigo and exr.exa_codigo = err.exa_codigo and exr.mco_codigo = err.mco_codigo");
        buf.append("  join requisicao req on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append(" where ");
        if (log != null) {
            buf.append("   req.fil_codigo = ").append(log.getString("fil_codigo"));
            buf.append("   and req.req_codigo = ").append(log.getString("req_codigo"));
            buf.append("   and exr.exa_codigo = ").append(StringUtil.textoDBEscape(log.getString("exa_codigo")));
            buf.append("   and exr.mco_codigo = ").append(log.getString("mco_codigo"));
        } else {
            buf.append("   req.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and req.req_codigo = ").append(requisicao.trim());
            buf.append("   and (req.req_xmlagendamentoids is not null and req.req_xmlagendamentoids <> '') ");
        }
        buf.append("   and exr.exr_situacao in('").append("C").append("', '").append("I").append("', '").append("E").append("') ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            ArrayList<Registro> listaExames = new ArrayList<Registro>();
            if (rs.next()) {
                String layout = ExameUtil.getCodigoLayout(rs.getString("fil_codigo"), rs.getString("con_codigo"), rs.getString("des_codigo"));
                do {
                    Registro reg = new Registro(rs);
                    reg.setValor("codigoLayout", layout);
                    listaExames.add(reg.clone());
                } while (rs.next());
            }
            rs.close();
            for (Registro reg : listaExames) {
                IntegracaoIDSSaude.inserirLog(st, reg.getInt("fil_codigo"), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "", "");
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e2o foi poss\u00edvel carregar os logs.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void montaPanelLogs() {
        this.panelLogs.setBorder(new TitledBorder("Logs"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        this.panelLogs.add((Component)this.scrollLogs, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.labelLocalizar.setDisplayedMnemonic('o');
        this.labelLocalizar.setLabelFor(this.textLocalizar);
        this.panelLogs.add((Component)this.labelLocalizar, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textLocalizar.setPreferredSize(new Dimension(20, 20));
        this.textLocalizar.setMinimumSize(new Dimension(20, 20));
        this.panelLogs.add((Component)this.textLocalizar, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonLocalizar.setMnemonic('L');
        this.buttonLocalizar.setPreferredSize(new Dimension(100, 20));
        this.buttonLocalizar.setMinimumSize(new Dimension(100, 20));
        this.buttonLocalizar.setMargin(new Insets(1, 1, 1, 1));
        this.buttonLocalizar.addActionListener(this);
        this.panelLogs.add((Component)this.buttonLocalizar, c);
        this.modeloLogs.setColumnSize(new int[]{40, 100, 100, 70, 0, 40, 40}, this.tableLogs);
        this.tableLogs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = JanelaIntegracaoIDSErros.this.tableLogs.getSelectedRow();
                if (row > -1) {
                    Object obj;
                    Object object = obj = JanelaIntegracaoIDSErros.this.modeloLogs != null && JanelaIntegracaoIDSErros.this.modeloLogs.getRowCount() > 0 ? JanelaIntegracaoIDSErros.this.modeloLogs.getValueAt(row, 8) : null;
                    if (obj != null) {
                        Registro reg = (Registro)obj;
                        JanelaIntegracaoIDSErros.this.textPaneExcecao.setText(reg.getString("ids_mensagem"));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JanelaIntegracaoIDSErros.this.textPaneExcecao.scrollRectToVisible(new Rectangle(0, 0));
                                JanelaIntegracaoIDSErros.this.textPanePilhaExcecao.scrollRectToVisible(new Rectangle(0, 0));
                            }
                        });
                    }
                }
            }
        });
        this.tableLogs.setDefaultRenderer(Object.class, new LogRenderer());
    }

    private void montaTela() {
        JPanel panelCentral = (JPanel)this.getContentPane();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.4;
        panelCentral.add((Component)this.panelLogs, c);
        ++c.gridy;
        c.weighty = 0.4;
        panelCentral.add((Component)this.panelExcecao, c);
        ++c.gridy;
        c.weighty = 0.0;
        panelCentral.add((Component)this.panelBotoes, c);
        this.montaPanelLogs();
        this.montaPanelExcecao();
        this.montaPanelBotoes();
        this.setSize(500, 500);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }

    private void montaPanelExcecao() {
        this.panelExcecao.setBorder(new TitledBorder("Mensagem"));
        this.panelExcecao.add(this.scrollExcecao);
        this.textPaneExcecao.setEditable(false);
    }

    private void montaPanelBotoes() {
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        this.panelBotoes.add((Component)panelEsquerda, "West");
        this.panelBotoes.add((Component)panelDireita, "East");
        panelEsquerda.add(this.buttonMarcarComoExportado);
        panelEsquerda.add(this.checkMostrarEnviados);
        panelDireita.add(this.buttonFechar);
        this.buttonMarcarComoExportado.setMnemonic('E');
        this.buttonMarcarComoExportado.addActionListener(this);
        this.buttonFechar.setMnemonic('F');
        this.buttonFechar.addActionListener(this);
        this.buttonMarcarComoExportado.setEnabled(true);
        this.checkMostrarEnviados.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonMarcarComoExportado) {
            this.marcarComoExportado();
        } else if (e.getSource() == this.buttonLocalizar) {
            if (!Funcoes.textoVazio(this.textLocalizar.getText())) {
                this.reenviarExames(null, this.textLocalizar.getText());
            } else {
                for (int i = this.modeloLogs.getRowCount() - 1; i >= 0; --i) {
                    Object exportado = this.modeloLogs.getValueAt(i, 6);
                    String exame = this.modeloLogs.getValueAt(i, 4).toString();
                    if (exportado == null || !((Boolean)exportado).booleanValue()) continue;
                    Registro reg = (Registro)this.modeloLogs.getValueAt(i, 8);
                    this.reenviarExames(reg, null);
                }
                this.carregaDados(false);
            }
        } else if (e.getSource() == this.checkMostrarEnviados) {
            if (this.checkMostrarEnviados.isSelected()) {
                this.carregaDados(true);
                this.buttonMarcarComoExportado.setEnabled(false);
            } else {
                this.carregaDados(false);
                this.buttonMarcarComoExportado.setEnabled(true);
            }
        }
    }

    private void marcarComoExportado() {
        for (int i = this.modeloLogs.getRowCount() - 1; i >= 0; --i) {
            Registro reg;
            Object exportado = this.modeloLogs.getValueAt(i, 6);
            if (exportado == null || !((Boolean)exportado).booleanValue() || (reg = (Registro)this.modeloLogs.getValueAt(i, 8)) == null) continue;
            try {
                this.prstMarcarExportado.setInt(1, reg.getInt("fil_codigo"));
                this.prstMarcarExportado.setInt(2, reg.getInt("ids_codigo"));
                int qtde = this.prstMarcarExportado.executeUpdate();
                if (qtde == 0) {
                    throw new Exception("O log n\u00e3o foi atualizado. Filial = " + reg.getString("fil_codigo") + ", log = " + reg.getString("ids_codigo"));
                }
                Conexao.arquivaSQL();
                this.modeloLogs.removeLine(i);
                this.textPaneExcecao.setText("");
                continue;
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel marcar o log como exportado.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        int row = this.tableLogs.getRowCount();
        if (row > -1) {
            this.tableLogs.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void localizar() {
        int row;
        if (Funcoes.textoVazio(this.textLocalizar)) {
            return;
        }
        String textoLocalizar = this.textLocalizar.getText();
        for (int i = row = this.tableLogs.getSelectedRow() + 1; i < this.modeloLogs.getRowCount(); ++i) {
            String req = this.modeloLogs.getValueAt(i, 1).toString();
            if (Funcoes.textoVazio(req) || !req.equalsIgnoreCase(textoLocalizar)) continue;
            this.tableLogs.getSelectionModel().setSelectionInterval(i, i);
            this.tableLogs.scrollRectToVisible(this.tableLogs.getCellRect(i, 0, false));
            break;
        }
    }

    class LogRenderer
    extends JTextArea
    implements TableCellRenderer {
        public LogRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
            if (table.getRowHeight(row) != this.getPreferredSize().height) {
                table.setRowHeight(row, this.getPreferredSize().height);
            }
            if (isSelected) {
                this.setBackground((Color)UIManager.get("Table.selectionBackground"));
                this.setForeground((Color)UIManager.get("Table.selectionForeground"));
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }
}

