/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util;

import jalis.util.Funcoes;
import java.util.ArrayList;

public class IntegracaoHospitalException
extends Exception {
    Integer filial = null;
    String requisicao = null;
    Long log = null;
    String tipo = null;
    String xmlOperacao = null;
    String xmlLog = null;
    String mensagemErro = "";
    String nomeProcesso = "";
    String identificador = "";
    String stackTraceRetornado = "";

    public IntegracaoHospitalException(Exception excecao, Integer filial, Long log, String tipo, String mensagemErro, String xmlOperacao, String xmlLog, String nomeProcesso, String identificador) {
        this(excecao, filial, log, tipo, mensagemErro, xmlOperacao, xmlLog);
        this.nomeProcesso = nomeProcesso;
        this.identificador = identificador;
    }

    public IntegracaoHospitalException(String mensagemErro) {
        this.mensagemErro = mensagemErro;
    }

    public IntegracaoHospitalException(Exception excecao, Integer filial, Long log, String tipo, String mensagemErro, String xmlOperacao, String xmlLog) {
        super(excecao);
        this.log = log;
        this.xmlOperacao = xmlOperacao;
        this.xmlLog = xmlLog;
        this.mensagemErro = Funcoes.textoVazio(mensagemErro) ? "" : mensagemErro;
        this.filial = filial;
        this.tipo = tipo;
    }

    public IntegracaoHospitalException(Exception excecao, Integer filial, String requisicao, Long log, String tipo, String mensagemErro, String xmlOperacao, String xmlLog) {
        super(excecao);
        this.log = log;
        this.xmlOperacao = xmlOperacao;
        this.xmlLog = xmlLog;
        this.mensagemErro = Funcoes.textoVazio(mensagemErro) ? "" : mensagemErro;
        this.filial = filial;
        this.requisicao = requisicao;
        this.tipo = tipo;
    }

    public Long getLog() {
        return this.log;
    }

    public String getRequisicao() {
        return this.requisicao;
    }

    public String getXmlOperacao() {
        return this.xmlOperacao;
    }

    public String getXmlLog() {
        return this.xmlLog;
    }

    public Integer getFilial() {
        return this.filial;
    }

    public String getTipo() {
        return this.tipo;
    }

    public String getMensagemErro() {
        return this.mensagemErro;
    }

    public void setXMLOperacao(String xmlOperacao) {
        this.xmlOperacao = xmlOperacao;
    }

    public void setXMLLog(String xmlLog) {
        this.xmlLog = xmlLog;
    }

    public void setXML(ArrayList<String> xml) {
        if (xml != null) {
            StringBuilder buf = new StringBuilder();
            for (String aux : xml) {
                if (!Funcoes.textoVazio(buf.toString())) {
                    buf.append("\n\n");
                }
                buf.append(aux);
            }
            this.xmlOperacao = buf.toString();
        }
    }

    public String getNomeProcesso() {
        return this.nomeProcesso;
    }

    public void setNomeProcesso(String nomeProcesso) {
        this.nomeProcesso = nomeProcesso;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public void setFilial(Integer filial) {
        this.filial = filial;
    }

    public void setLog(Long log) {
        this.log = log;
    }

    @Override
    public String getMessage() {
        return this.mensagemErro;
    }

    @Override
    public String toString() {
        return this.mensagemErro;
    }

    public void setMensagemErro(String mensagemErro) {
        this.mensagemErro = mensagemErro;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setStackTraceRetornado(String stackTrace) {
        this.stackTraceRetornado = stackTrace;
    }

    public String getStackTraceRetornado() {
        return this.stackTraceRetornado;
    }
}

