/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util;

import jalis.integracaohospitais.sistemas.IntegracaoHospital;
import jalis.integracaohospitais.sistemas.ghosp.IntegracaoHospitalGHosp;
import jalis.integracaohospitais.sistemas.mv.IntegracaoHospitalMV;
import jalis.integracaohospitais.sistemas.salux.IntegracaoHospitalSalux;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh2;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh3;
import jalis.integracaohospitais.sistemas.sinconecta.IntegracaoHospitalSinconecta;
import jalis.integracaohospitais.sistemas.tasy.FabricaHospitalTasy;
import jalis.integracaohospitais.sistemas.wareline.IntegracaoHospitalWareline;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.util.Funcoes;
import jalis.util.StringUtil;

public class FabricaIntegracaoHospital {
    public static IntegracaoHospital novaIntegracaoHospital(ProtocoloIntegracaoHospital protocolo, String xml) {
        switch (protocolo) {
            case SIGH: {
                return FabricaIntegracaoHospital.integracaoHospitalSigh(xml);
            }
            case MV: {
                return new IntegracaoHospitalMV(xml);
            }
            case TASY: {
                return FabricaHospitalTasy.novaIntegracao(xml);
            }
            case WARELINE: {
                return new IntegracaoHospitalWareline(xml);
            }
            case G_HOSP: {
                return new IntegracaoHospitalGHosp(xml);
            }
            case SALUX: {
                return new IntegracaoHospitalSalux(xml);
            }
            case SINCONECTA: {
                return new IntegracaoHospitalSinconecta(xml);
            }
        }
        return null;
    }

    private static IntegracaoHospital integracaoHospitalSigh(String xml) {
        if (!Funcoes.textoVazio(xml) && StringUtil.getValor(xml, "versao").equals(IntegracaoHospitalSigh.Versao.VERSAO_2.getCodigo().toString())) {
            return new IntegracaoHospitalSigh2(xml);
        }
        if (!Funcoes.textoVazio(xml) && StringUtil.getValor(xml, "versao").equals(IntegracaoHospitalSigh.Versao.VERSAO_3.getCodigo().toString())) {
            return new IntegracaoHospitalSigh3(xml);
        }
        return new IntegracaoHospitalSigh(xml);
    }
}

